#=head1 NAME

C<Parse::LexEvent> - Gnrateur d'analyseurs lexicaux vnementiels (1.00 alpha)

#=head1 SYNOPSIS

  use Parse::LexEvent;
  
  sub string {
    print $_[0]->name, ": $_[1]\n";
  }
  sub comment {
    print $_[0]->name, ": $_[1]\n";
  }
  sub remainder {
    print $_[0]->name, ": $_[1]\n";
  }
  
  $lexer = Parse::LexEvent
    ->new()->configure(
  		   From => \*DATA,
  		   Tokens => 
  		     [
  		      Type => 'Simple', Name => 'ccomment', Handler => 'comment',
		             Regex => '//.*\n',
  		      Type => 'Delimited', Name => 'comment', Handler => 'comment', 
		             Start => '/[*]', End => '[*]/',
  		      Type => 'Quoted', Name => 'squotes', Handler => 'string', Quote => qq!\'!,
  		      Type => 'Quoted', Name => 'dquotes', Handler => 'string', Quote => qq!\"!,
  		      Type => 'Simple', Name => 'remainder', 
		             Regex => '(?s:[^/\'\"]+)', ReadMore => 1,
  		     ]
  		  )->parse();
  __END__
  /* 
    C comment 
  */
  // C++ comment
  var d = "string in double quotes";
  var s = 'string in single quotes';
  var i = 10;
  var y = 100;


#=head1 DESCRIPTION

C<Parse::LexEvent> gnre des analyseurs lexicaux  la manire de
C<Parse::Lex>, mais les analyseurs gnrs mettent un vnement 
l'issue de la reconnaissance de chacun des tokens. Cet vnement
correspond  l'appel d'une procdure qui porte le nom du token. Il est
possible de donner un nom diffrent  cette procdure en utilisant le
paramtre C<Handler> lors de la dfinition d'un token.

Une application utilisatrice de C<Parse::LexEvent> doit dfinir les
procdures requises. Ces procdures reoivent l'objet token en premier
paramtre et la chane de caractres reconnue en second.

C<Parse::LexEvent> hrite de C<Parse::ALex> et possde toutes les
mthodes dcrites dans la documentation de la classe C<Parse::Lex> 
l'exception des mthodes C<analyze()>, C<every()> C<next()>, et
C<nextis()>.

#=head2 Methodes

#=over 4

#=item parse()

Cette mthode lance l'analyse des donnes spcifies par C<from()>.

#=back

#=head1 EXAMPLES

cparser.pl - Cet analyseur reconnat trois types de structure : des
commentaires C ou C++, des chanes entre guillemets et le reste. Il
emet un vnement spcifique  chacune.  On peut l'utiliser, par
exemple, pour analyser des programmes C, C++ ou Javascript.

#=head1 SEE ALSO

C<Parse::Lex>, C<Parse::Token>.

#=head1 AUTHOR

Philippe Verdret.

#=head1 COPYRIGHT

Copyright (c) 1999 Philippe Verdret. All rights reserved.  This module
is free software; you can redistribute it and/or modify it under the
same terms as Perl itself.
