use warnings;
use strict;
use utf8;
use FindBin '$Bin';
use Test::More;
my $builder = Test::More->builder;
binmode $builder->output,         ":utf8";
binmode $builder->failure_output, ":utf8";
binmode $builder->todo_output,    ":utf8";
binmode STDOUT, ":encoding(utf8)";
binmode STDERR, ":encoding(utf8)";
use Image::PNG;
my $png = Image::PNG->new ();
$png->read ("$Bin/with-text.png");
my $im = $png->interlacing_method ();
is ($im, 'none', "Got 'none' for interlacing method");
my $pngi = Image::PNG->new ();
$pngi->read ("$Bin/gray-gradient.interlaced.png");
my $imi = $pngi->interlacing_method ();
is ($imi, 'adam7', "Got 'adam7' for interlacing method");
done_testing ();
