#
# Mail/Salsa/Template.pm
# Last Modification: Fri Jun 18 14:30:48 WEST 2004
#
# Copyright (c) 2004 Henrique Dias <hdias@aesbuc.pt>. All rights reserved.
# This module is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
package Mail::Salsa::Template;

use 5.008000;
use strict;
use warnings;

require Exporter;
use AutoLoader qw(AUTOLOAD);

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use Mail::Salsa::Template ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.

our %EXPORT_TAGS = ( 'all' => [ qw() ] );
our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
our @EXPORT = qw();

our $VERSION = '0.01';

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $self  = {
		'lang'  => "en",
		'label' => "",
		'outfh' => undef,
		'infh'  => undef,
		@_,
	};
	bless ($self, $class);
	$self->init();
	return($self);
}

sub init {
	my $self = shift;

	my $label = $self->{'label'};
	for(0..1) {
		my $lang = uc($self->{'lang'});
		my $module = "use Mail::Salsa::Lang::$lang qw(insidefh);\n";
		eval($module);
		($@) ? ($self->{'lang'} = "en") : last;
	}
	$self->{'infh'} = insidefh();
	return();
}

sub filehandle {
	my $self = shift;
	$self->{'outfh'} = shift;
	return();
}

sub label {
	my $self = shift;
	$self->{'label'} = shift;
	return();
}

sub replace {
	my $self = shift;
	my $vars = {@_};

	my $label = $self->{'label'};
	my $infh = $self->{'infh'};
	my $outfh = $self->{'outfh'};

	my $evalcode = "";
	for my $key (keys(%{$vars})) {
		my $val = $vars->{$key};
		$val =~ s/\@/\\@/g;
		$evalcode .= "s{\\\$$key\\b}{$val}g;\n";
	}
	my $msg = 0;
	while(<$infh>) {
		if($msg) {
			last if(/^\<\/template\>[\n\r]+/);
			eval($evalcode);
			print $outfh $_;
			next;
		}
		$msg = 1 if(/^\< *template +name=\"$label\" *\>[\n\r]+/);
	}
	return();
}

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

Mail::Salsa::Template - Perl extension for blah blah blah

=head1 SYNOPSIS

  use Mail::Salsa::Template;

  my $tpl = Mail::Salsa::Template->new(
    lang  => "en",
    label => "MYLABEL",
    outfh => \*STDOUT
  );
  $tpl->filehandle(\*SENDMAIL);
  $tpl->label("OTHERLABEL");
  $tpl->replace(
    dog => "au",
    cat => "miau",
  );

=head1 DESCRIPTION

Stub documentation for Mail::Salsa, created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head2 EXPORT

None by default.



=head1 SEE ALSO

Mention other useful documentation such as the documentation of
related modules or operating system documentation (such as man pages
in UNIX), or any relevant external documentation such as RFCs or
standards.

If you have a mailing list set up for your module, mention it here.

If you have a web site set up for your module, mention it here.

=head1 AUTHOR

Henrique M. Ribeiro Dias, E<lt>hdias@aesbuc.pt@E<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2004 by Henrique M. Ribeiro Dias

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.2 or,
at your option, any later version of Perl 5 you may have available.


=cut
