/* IPHandler.c
 * This file is part of the LaBrea package
 *
 * Copyright (C) 2001, 2002 Tom Liston <tliston@premmag.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

static void __inline IPHandler(u_char* client_data, const struct pcap_pkthdr* pcpkt, u_char* link) {
  /* externs */
  extern bpf_u_int32 base, randqueue1[];
  extern u_char *exclusion, *sha;
  extern u_int nkotbcount, addresses;
  extern int newthisminute, Pflag, currentrand1, dlsize, datalog, currentrand2;
  extern int oflag, Oflag, fflag, aflag, currentbandwidth, pflag, star;
  extern struct kotb *nkotbstart;
  extern struct ignore_ip *ignorelist;
  extern unsigned char ignoreport[8192];
  extern struct libnet_link_int *plnk;
  extern short throttlesize;
  extern char *dev, mybuffer[], strstar[];
  extern char format1[], format2[], msg1[], msg2[], msg3[], msg4[], msg4a[];
  extern char msg5[], msg6[], format8[], format9[], strlf[];
  extern unsigned long randqueue2[RANDSIZE2];
  extern unsigned char mask[8];
  /* locals */
  u_char proto, *ip_protobegin, *ptr = ((u_char*)link) + dlsize, forgetit = 0, bwuse = 0;
  u_char flags, type, code, responsetype = 0;
  char src_addr[20], dst_addr[20], tnow[60], *msgptr = NULL;
  u_long ip_src, ip_dst, seq, ack, ack_out;
  u_int offset, i, j, boolLinuxWinProbe = 0;
  time_t current = 0;
  short windowsize;
  u_short ipsize, headersize, sport = 0, dport = 0, ipid, tlength, portoffset, leftover;
  struct kotb *nkotb = nkotbstart, *tempnkotb;
  struct ignore_ip *iip = ignorelist;

  /* source ip address - offset 12 */
  ip_src = *(u_long*)(ptr + 12);
  /* now, we want to run our list of source IPs that   */
  /* we're supposed to ignore... if we find it, on the */
  /* list, then return without doing anything...       */
  while(iip) {
    if(iip->ip == ip_src)
      return;
    iip = iip->next;
  }
  /* find out the embedded protocol type of the packet */
  /* protocol - offset 9 */
  proto = *(u_char*)(ptr + 9);
  /* dest IP - offset 16  */
  ip_dst = *(u_long*)(ptr + 16);
  /* is the destination one of our "home" IPs? */
  offset = htonl(ip_dst) - base;
  /* play it safe: check to see that      */
  /* this isn't an excluded address...    */
  /* it shouldn"t ever get here if it is  */
  if((offset > 0) && (offset < addresses)) {
    if(exclusion[offset] == IP_EXCLUDE)
      return;
  }
  /* ip header size - double words*/
  ipsize = (*(u_char*)ptr) & 0xF;
  ipsize *= 4;
  /* get a pointer to the imbedded protocol info */
  ip_protobegin = ptr + ipsize;
  /* tcp header size - double words */
  headersize = ipsize + ((*(u_char*)(ip_protobegin + 12)) & 0xF0) / 4;
  /* before we do anything, we want to see if this  */
  /* packet is destined for one of our "new kids"   */
  /* (a machine that recently announced itself w/a  */
  /* gratuitous arp). if it is, we need to route it */
  if(nkotbcount > 0) {
    /* current time */
    current = time(NULL);
    while(nkotb != NULL) {
      if(ip_dst == nkotb->ip) {
        /* this packet should be forwarded */
        /* stuff in the "correct" MAC */
        for(i = 0; i < 6; i++)
          link[i] = nkotb->mac[i];
        /* fire it back out */
        libnet_write_link_layer(plnk, dev, link, ntohs(*(u_short*)(ptr + 2)) + dlsize);
        /* reset the cull time, because obviously SOMEONE ain't got a clue */
        nkotb->time = current + CULLTIME;
        /* after we're done checking others for culling, go home... */
        forgetit = 1;
      }
      /* cull out those seeing no activity w/in CULLTIME */
      if(nkotb->time <= current) {
        tempnkotb = nkotb->next;
        killNKOTB(nkotb);
        nkotb = tempnkotb;
      } else
        nkotb = nkotb->next;
    }
  }
  /* if this was a packet that we're just sending on... return */
  if(forgetit)
    return;
  /* switch on the protocol */
  switch(proto) {
    case IPPROTO_TCP:
      /********************************************/
      /* this is a TCP packet... first, let's get */
      /* together some information that we will   */
      /* need to make up a reply packet...        */
      /********************************************/
      /* flags - offset 13 of the TCP packet      */
      flags = (*(u_char*)(ip_protobegin + 13));
      /* source port - offset 0 of the TCP packet */
      sport = ntohs(*(u_short*)ip_protobegin);
      /* dest port -  offset 2 of the TCP packet  */
      dport = ntohs(*(u_short*)(ip_protobegin + 2));
      /* seq and ack numbers inbound */
      seq = ntohl(*(u_long*)(ip_protobegin + 4));
      ack = ntohl(*(u_long*)(ip_protobegin + 8));
      /*************************************************/
      /* Special code to handle funky Linux win probes */
      /*************************************************/
      /* We're going to "encode" the remote sequence   */
      /* number that we should be seeing on the first  */
      /* inbound window probe - we use this encoded    */
      /* value as *our* sequence number... when we get */
      /* an inbound packet that could be a win probe   */
      /* we'll "decode" the ack... if it matches the   */
      /* sequence number, then it's a win probe...     */
      /* This is one of those cool hacks that no one   */
      /* else is ever going to understand. Oh well...  */
      /*************************************************/
      ack_out = (seq + throttlesize);
      ack_out ^= randqueue2[currentrand2];
      ack_out ^= ((sport << 16) + dport);
      ack_out ^= ip_src;
      ack_out--;
      currentrand2++;
      if(currentrand2 == RANDSIZE2)
        currentrand2 = 0;
      /* the IPID we'll use in our reply packet   */
      ipid = (short)randqueue1[currentrand1];
      currentrand1++;
      if(currentrand1 == RANDSIZE1)
        currentrand1 = 0;
      /* now, we want to check our list of port numbers that */
      /* we're supposed to ignore... if we find it on the    */
      /* list, then return without doing anything...         */
      portoffset = dport / 8;
      leftover = dport % 8;
      if(ignoreport[portoffset] & mask[leftover]) {
        if(fflag)
          return;
        else {
          seq++;
          ack = ack_out;
          flags = TH_RST | TH_ACK;
          windowsize = throttlesize;
          msgptr = 0;
          goto sendit;
        }
      }
      /* a packet w/SYN only set -- we reply w/a SYN/ACK */
      if((flags & TH_SYN) && ((flags & TH_ACK) == 0)) {
        /* if we're persist only, and we're at our limit */
        if((Pflag) && (newthisminute == 0))
          return;
        /* this will be our ack # (ack = inbound seq + 1)*/
        seq++;
        /* this will be our seq # (random seq #)         */
        ack = ack_out;
        /* send a SYN/ACK packet                         */
        flags = TH_SYN | TH_ACK;
        /* throttle down the window to our throttlesize  */
        windowsize = throttlesize;
        msgptr = msg1;
        goto sendit;
      } else {
        /* if the inbound packet is a SYN/ACK, reply w/a RST */
        if((flags & TH_SYN) && (flags & TH_ACK)) {
          if(aflag)
            return;
          /* this will be our ack # (ack = inbound seq + 1)*/
          seq++;
          /* this will be our seq # (random seq #)         */
          ack = ack_out;
          /* send a RST packet                             */
          flags = TH_RST;
          /* throttle down the window to our throttlesize  */
          windowsize = throttlesize;
          msgptr = msg5;
          goto sendit;
        } else {
          /* an ACK packet */
          if((pflag) && (flags & TH_ACK)) {
            /* total length of the packet */
            tlength = ntohs(*(u_short*)(ptr + 2));
            /* the 1st data packet. they're sending a packet   */
            /* that is a header plus our throttle size...      */
            if(tlength == (headersize + throttlesize)) {
              /* if we've already added all of the connections */
              /* that we can during this minute, then ignore   */
              /* this packet. this should allow us to ease up  */
              /* toward maximum bw... even when we're being    */
              /* hammered by inbound connects                  */
              if(!newthisminute)
                return;
              /* this will be our ack # (ack = inbound seq + throttlesize)*/
              seq += throttlesize;
              /* note: we'll use ack as our seq... it remains unchanged   */
              /* send an ACK packet                                       */
              flags = TH_ACK;
              /* lay the trap... throttle down the window to 0 - persist  */
              windowsize = 0;
              msgptr = msg3;
              /* bump our used bandwidth                                  */
              bwuse = 80 + throttlesize;
              /* lower possible new connects by 1...                      */
              newthisminute--;
              goto sendit;
            } else {
              /* check for oddball Linux winprobe     */
              /* decode the ack and see if it matches */
              /* the inbound sequence number... if it */
              /* does, then it's a win probe          */
              ack_out = ack;
              ack_out ^= ip_src;
              ack_out ^= ((sport << 16) + dport);
              for(i = 0; i < RANDSIZE2; i++) {
                if((ack_out ^ randqueue2[i]) == seq)
                  boolLinuxWinProbe = 1;
              }
              if((tlength == (headersize + 1)) || boolLinuxWinProbe) {
                /* we'll send back syn = inbound ack */
                /* and ack = inbound syn...          */
                /* set the ACK flag...               */
                flags = TH_ACK;
                /* tell 'em to keep waiting          */
                windowsize = 0;
                if(boolLinuxWinProbe) {
                  msgptr = msg4a;
                  bwuse = 80;
                } else {
                  msgptr = msg4;
                  bwuse = 81;
                }
                goto sendit;
              } else {
                /* we ignore everything else, but (optionally) log the */
                /* fact that we saw activity...                        */
                msgptr = msg2;
                goto logit;
              }
            }
          }
        }
      }
      break;
    case IPPROTO_ICMP:
      /* hmmm... ICMP packet... */
      if(aflag)
        return;
      /* what KIND of packet?? */
      type = *(u_char*)(ip_protobegin);
      code = *(u_char*)(ip_protobegin + 1);
      if((type == 8) && (code == 0)) {
        /* an echo request! PING! */
        tlength = ntohs(*(u_short*)(ptr + 2));
        for(i = 0; i < 6; i++) {
          j = i + 6;
          /* move the source MAC to destination MAC in the ether header */
          *(link + i) = *(link + j);
          /* stuff our MAC in as the source */
          *(link + j) = sha[i];
        }
        libnet_build_ip((u_short)(tlength - ipsize), 0, htons(150), 0, 255, IPPROTO_ICMP, ip_dst, ip_src, NULL, 0, ptr);
        /* change to an echo reply */
        *(u_char*)ip_protobegin = (u_char)0;
        libnet_do_checksum(ptr, IPPROTO_IP, ipsize);
        libnet_do_checksum(ptr, IPPROTO_ICMP, tlength - ipsize);
        /* ping! Ping! PING! */
        libnet_write_link_layer(plnk, dev, link, tlength + dlsize);
        responsetype = 1;
        goto logit;
      }
      break;
  }
  return;
  sendit:
  /* ETHERNET SPECIFIC */
  /* let's build us an outbound TCP packet... right over top of our inbound packet */
  for(i = 0; i < 6; i++) {
    j = i + 6;
    /* move the source MAC to destination MAC in the ether header */
    *(link + i) = *(link + j);
    /* stuff our MAC in as the source */
    *(link + j) = sha[i];
  }
  /* build the ip packet */
  libnet_build_ip(20, 0, ipid, 0, 255, IPPROTO_TCP, ip_dst, ip_src, NULL, 0, ptr);
  libnet_build_tcp(dport, sport, ack, seq, flags, windowsize, 0, NULL, 0, ip_protobegin);
  libnet_do_checksum(ptr, IPPROTO_IP, 20);
  libnet_do_checksum(ptr, IPPROTO_TCP, 20);
  libnet_write_link_layer(plnk, dev, link, 40 + dlsize);
  logit:
  if(!msgptr)
    return;
  currentbandwidth += bwuse;
  if(((datalog == 1) && (bwuse)) || !datalog)
    return;
  sprintf(src_addr, format1, (ip_src & 0xFF),((ip_src & 0xFF00) >> 8),
          ((ip_src & 0xFF0000) >> 16),((ip_src & 0xFF000000) >> 24));
  sprintf(dst_addr, format1, (ip_dst & 0xFF),((ip_dst & 0xFF00) >> 8),
          ((ip_dst & 0xFF0000) >> 16),((ip_dst & 0xFF000000) >> 24));
  if(responsetype)
    sprintf(mybuffer, msg6, src_addr, dst_addr);
  else
    sprintf(mybuffer, format2, msgptr, src_addr, sport, dst_addr, dport);
  if(star) {
    strcat(mybuffer, strstar);
    star = 0;
  } else {
    star = 1;
  }
  if(oflag) {
    if(!current)
      current = time(NULL);
    if(Oflag)
      printf(format8, current, mybuffer);
    else {
      strncpy(tnow, ctime(&current), 50);
      strtok(tnow, strlf);
      printf(format9, tnow, mybuffer);
    }
  } else
    syslog(LOGTYPE, mybuffer);
}

