# Generated by default/object.tt
package Paws::ACM::ExpiryEventsConfiguration;
  use Moose;
  has DaysBeforeExpiry => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ACM::ExpiryEventsConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ACM::ExpiryEventsConfiguration object:

  $service_obj->Method(Att1 => { DaysBeforeExpiry => $value, ..., DaysBeforeExpiry => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ACM::ExpiryEventsConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->DaysBeforeExpiry

=head1 DESCRIPTION

Object containing expiration events options associated with an AWS
account.

=head1 ATTRIBUTES


=head2 DaysBeforeExpiry => Int

Specifies the number of days prior to certificate expiration when ACM
starts generating C<EventBridge> events. ACM sends one event per day
per certificate until the certificate expires. By default, accounts
receive events starting 45 days before certificate expiration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ACM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

