package Google::Ads::AdWords::v201406::AdSpecListSearchParameter;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/o/v201406' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201406::SearchParameter);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %SearchParameter__Type_of :ATTR(:get<SearchParameter__Type>);
my %adSpecs_of :ATTR(:get<adSpecs>);

__PACKAGE__->_factory(
    [ qw(        SearchParameter__Type
        adSpecs

    ) ],
    {
        'SearchParameter__Type' => \%SearchParameter__Type_of,
        'adSpecs' => \%adSpecs_of,
    },
    {
        'SearchParameter__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'adSpecs' => 'Google::Ads::AdWords::v201406::AdSpec',
    },
    {

        'SearchParameter__Type' => 'SearchParameter.Type',
        'adSpecs' => 'adSpecs',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201406::AdSpecListSearchParameter

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AdSpecListSearchParameter from the namespace https://adwords.google.com/api/adwords/o/v201406.

A {@link SearchParameter} for {@code PLACEMENT} {@link IdeaType}s used to filter the results by the list of {@link AdSpec}s. See {@link AdSpec} documentation for details on available options. <p>This element is supported by following {@link IdeaType}s: PLACEMENT. <p>This element is supported by following {@link RequestType}s: IDEAS, STATS. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * adSpecs




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

