unit class Curlie::Response;

use JSON::Fast;
use LibCurl::Easy:ver<1.5>;
use Log::Async;

has $.lce handles <statusline content success>;
has %!status;
method headers { $!lce.receiveheaders }
method raw-headers { $!lce.raw-headers };
method json {
  return Nil unless self.content && self.content.chars > 0;
  from-json(self.content);
}
method status {
  self.parse-status<status>
}
method parse-status {
  %!status = %( <http-version status status-reason> Z=> self.statusline.split(' ') ) unless %!status;
  %!status;
}
method gist {
    self.raw-headers
  ~ self.lce.buf.decode
}
method raw-content {
  self.lce.buf;
}
method Str {
  self.statusline
}
