package Locales::DB::Territory::gv;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::gv::VERSION = '0.09';

$Locales::DB::Territory::gv::cldr_version = '2.0';

%Locales::DB::Territory::gv::code_to_name = (
    '001' => 'World',
    '002' => 'Africa',
    '003' => "North\ America",
    '005' => "South\ America",
    '009' => 'Oceania',
    '011' => "Western\ Africa",
    '013' => "Central\ America",
    '014' => "Eastern\ Africa",
    '015' => "Northern\ Africa",
    '017' => "Middle\ Africa",
    '018' => "Southern\ Africa",
    '019' => 'Americas',
    '021' => "Northern\ America",
    '029' => 'Caribbean',
    '030' => "Eastern\ Asia",
    '034' => "Southern\ Asia",
    '035' => "South\-Eastern\ Asia",
    '039' => "Southern\ Europe",
    '053' => "Australia\ and\ New\ Zealand",
    '054' => 'Melanesia',
    '057' => "Micronesian\ Region",
    '061' => 'Polynesia',
    '062' => "South\-Central\ Asia",
    142   => 'Asia',
    143   => "Central\ Asia",
    145   => "Western\ Asia",
    150   => 'Europe',
    151   => "Eastern\ Europe",
    154   => "Northern\ Europe",
    155   => "Western\ Europe",
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => "Latin\ America",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ Island",
    'ad'  => 'Andorra',
    'ae'  => "United\ Arab\ Emirates",
    'af'  => 'Afghanistan',
    'ag'  => "Antigua\ and\ Barbuda",
    'ai'  => 'Anguilla',
    'al'  => 'Albania',
    'am'  => 'Armenia',
    'an'  => "Netherlands\ Antilles",
    'ao'  => 'Angola',
    'aq'  => 'Antarctica',
    'ar'  => 'Argentina',
    'as'  => "American\ Samoa",
    'at'  => 'Austria',
    'au'  => 'Australia',
    'aw'  => 'Aruba',
    'ax'  => "\Ã\land\ Islands",
    'az'  => 'Azerbaijan',
    'ba'  => "Bosnia\ and\ Herzegovina",
    'bb'  => 'Barbados',
    'bd'  => 'Bangladesh',
    'be'  => 'Belgium',
    'bf'  => "Burkina\ Faso",
    'bg'  => 'Bulgaria',
    'bh'  => 'Bahrain',
    'bi'  => 'Burundi',
    'bj'  => 'Benin',
    'bl'  => "Saint\ Barth\Ã\©lemy",
    'bm'  => 'Bermuda',
    'bn'  => 'Brunei',
    'bo'  => 'Bolivia',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Brazil',
    'bs'  => 'Bahamas',
    'bt'  => 'Bhutan',
    'bv'  => "Bouvet\ Island",
    'bw'  => 'Botswana',
    'by'  => 'Belarus',
    'bz'  => 'Belize',
    'ca'  => 'Canada',
    'cc'  => "Cocos\ \[Keeling\]\ Islands",
    'cd'  => "Congo\ \[DRC\]",
    'cf'  => "Central\ African\ Republic",
    'cg'  => "Congo\ \[Republic\]",
    'ch'  => 'Switzerland',
    'ci'  => "Ivory\ Coast",
    'ck'  => "Cook\ Islands",
    'cl'  => 'Chile',
    'cm'  => 'Cameroon',
    'cn'  => 'China',
    'co'  => 'Colombia',
    'cp'  => "Clipperton\ Island",
    'cr'  => "Costa\ Rica",
    'cs'  => "Serbia\ and\ Montenegro",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Cuba',
    'cv'  => "Cape\ Verde",
    'cx'  => "Christmas\ Island",
    'cy'  => 'Cyprus',
    'cz'  => "Czech\ Republic",
    'dd'  => "East\ Germany",
    'de'  => 'Germany',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Djibouti',
    'dk'  => 'Denmark',
    'dm'  => 'Dominica',
    'do'  => "Dominican\ Republic",
    'dz'  => 'Algeria',
    'ea'  => "Ceuta\ and\ Melilla",
    'ec'  => 'Ecuador',
    'ee'  => 'Estonia',
    'eg'  => 'Egypt',
    'eh'  => "Western\ Sahara",
    'er'  => 'Eritrea',
    'es'  => 'Spain',
    'et'  => 'Ethiopia',
    'eu'  => "European\ Union",
    'fi'  => 'Finland',
    'fj'  => 'Fiji',
    'fk'  => "Falkland\ Islands\ \[Islas\ Malvinas\]",
    'fm'  => 'Micronesia',
    'fo'  => "Faroe\ Islands",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'France',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Gabon',
    'gb'  => "Rywvaneth\ Unys",
    'gd'  => 'Grenada',
    'ge'  => 'Georgia',
    'gf'  => "French\ Guiana",
    'gg'  => 'Guernsey',
    'gh'  => 'Ghana',
    'gi'  => 'Gibraltar',
    'gl'  => 'Greenland',
    'gm'  => 'Gambia',
    'gn'  => 'Guinea',
    'gp'  => 'Guadeloupe',
    'gq'  => "Equatorial\ Guinea",
    'gr'  => 'Greece',
    'gs'  => "South\ Georgia\ and\ the\ South\ Sandwich\ Islands",
    'gt'  => 'Guatemala',
    'gu'  => 'Guam',
    'gw'  => "Guinea\-Bissau",
    'gy'  => 'Guyana',
    'hk'  => "Hong\ Kong",
    'hm'  => "Heard\ Island\ and\ McDonald\ Islands",
    'hn'  => 'Honduras',
    'hr'  => 'Croatia',
    'ht'  => 'Haiti',
    'hu'  => 'Hungary',
    'ic'  => "Canary\ Islands",
    'id'  => 'Indonesia',
    'ie'  => 'Ireland',
    'il'  => 'Israel',
    'im'  => "Isle\ of\ Man",
    'in'  => 'India',
    'io'  => "British\ Indian\ Ocean\ Territory",
    'iq'  => 'Iraq',
    'ir'  => 'Iran',
    'is'  => 'Iceland',
    'it'  => 'Italy',
    'je'  => 'Jersey',
    'jm'  => 'Jamaica',
    'jo'  => 'Jordan',
    'jp'  => 'Japan',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Kenya',
    'kg'  => 'Kyrgyzstan',
    'kh'  => 'Cambodia',
    'ki'  => 'Kiribati',
    'km'  => 'Comoros',
    'kn'  => "Saint\ Kitts\ and\ Nevis",
    'kp'  => "North\ Korea",
    'kr'  => "South\ Korea",
    'kw'  => 'Kuwait',
    'ky'  => "Cayman\ Islands",
    'kz'  => 'Kazakhstan',
    'la'  => 'Laos',
    'lb'  => 'Lebanon',
    'lc'  => "Saint\ Lucia",
    'li'  => 'Liechtenstein',
    'lk'  => "Sri\ Lanka",
    'lr'  => 'Liberia',
    'ls'  => 'Lesotho',
    'lt'  => 'Lithuania',
    'lu'  => 'Luxembourg',
    'lv'  => 'Latvia',
    'ly'  => 'Libya',
    'ma'  => 'Morocco',
    'mc'  => 'Monaco',
    'md'  => 'Moldova',
    'me'  => 'Montenegro',
    'mf'  => "Saint\ Martin",
    'mg'  => 'Madagascar',
    'mh'  => "Marshall\ Islands",
    'mi'  => "Midway\ Islands",
    'mk'  => "Macedonia\ \[FYROM\]",
    'ml'  => 'Mali',
    'mm'  => "Myanmar\ \[Burma\]",
    'mn'  => 'Mongolia',
    'mo'  => 'Macau',
    'mp'  => "Northern\ Mariana\ Islands",
    'mq'  => 'Martinique',
    'mr'  => 'Mauritania',
    'ms'  => 'Montserrat',
    'mt'  => 'Malta',
    'mu'  => 'Mauritius',
    'mv'  => 'Maldives',
    'mw'  => 'Malawi',
    'mx'  => 'Mexico',
    'my'  => 'Malaysia',
    'mz'  => 'Mozambique',
    'na'  => 'Namibia',
    'nc'  => "New\ Caledonia",
    'ne'  => 'Niger',
    'nf'  => "Norfolk\ Island",
    'ng'  => 'Nigeria',
    'ni'  => 'Nicaragua',
    'nl'  => 'Netherlands',
    'no'  => 'Norway',
    'np'  => 'Nepal',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => "New\ Zealand",
    'om'  => 'Oman',
    'pa'  => 'Panama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Peru',
    'pf'  => "French\ Polynesia",
    'pg'  => "Papua\ New\ Guinea",
    'ph'  => 'Philippines',
    'pk'  => 'Pakistan',
    'pl'  => 'Poland',
    'pm'  => "Saint\ Pierre\ and\ Miquelon",
    'pn'  => "Pitcairn\ Islands",
    'pr'  => "Puerto\ Rico",
    'ps'  => "Palestinian\ Territories",
    'pt'  => 'Portugal',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Paraguay',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Qatar',
    'qo'  => "Outlying\ Oceania",
    're'  => "R\Ã\©union",
    'ro'  => 'Romania',
    'rs'  => 'Serbia',
    'ru'  => 'Russia',
    'rw'  => 'Rwanda',
    'sa'  => "Saudi\ Arabia",
    'sb'  => "Solomon\ Islands",
    'sc'  => 'Seychelles',
    'sd'  => 'Sudan',
    'se'  => 'Sweden',
    'sg'  => 'Singapore',
    'sh'  => "Saint\ Helena",
    'si'  => 'Slovenia',
    'sj'  => "Svalbard\ and\ Jan\ Mayen",
    'sk'  => 'Slovakia',
    'sl'  => "Sierra\ Leone",
    'sm'  => "San\ Marino",
    'sn'  => 'Senegal',
    'so'  => 'Somalia',
    'sr'  => 'Suriname',
    'st'  => "S\Ã\£o\ Tom\Ã\©\ and\ Pr\Ã\­ncipe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "El\ Salvador",
    'sy'  => 'Syria',
    'sz'  => 'Swaziland',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Turks\ and\ Caicos\ Islands",
    'td'  => 'Chad',
    'tf'  => "French\ Southern\ Territories",
    'tg'  => 'Togo',
    'th'  => 'Thailand',
    'tj'  => 'Tajikistan',
    'tk'  => 'Tokelau',
    'tl'  => "East\ Timor",
    'tm'  => 'Turkmenistan',
    'tn'  => 'Tunisia',
    'to'  => 'Tonga',
    'tr'  => 'Turkey',
    'tt'  => "Trinidad\ and\ Tobago",
    'tv'  => 'Tuvalu',
    'tw'  => 'Taiwan',
    'tz'  => 'Tanzania',
    'ua'  => 'Ukraine',
    'ug'  => 'Uganda',
    'um'  => "U\.S\.\ Minor\ Outlying\ Islands",
    'us'  => "United\ States",
    'uy'  => 'Uruguay',
    'uz'  => 'Uzbekistan',
    'va'  => "Vatican\ City",
    'vc'  => "Saint\ Vincent\ and\ the\ Grenadines",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuela',
    'vg'  => "British\ Virgin\ Islands",
    'vi'  => "U\.S\.\ Virgin\ Islands",
    'vn'  => 'Vietnam',
    'vu'  => 'Vanuatu',
    'wf'  => "Wallis\ and\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Yemen',
    'yt'  => 'Mayotte',
    'za'  => "South\ Africa",
    'zm'  => 'Zambia',
    'zw'  => 'Zimbabwe',
    'zz'  => "Unknown\ Region",
);

%Locales::DB::Territory::gv::name_to_code = (
    'afghanistan'                               => 'af',
    'africa'                                    => '002',
    'albania'                                   => 'al',
    'algeria'                                   => 'dz',
    'americansamoa'                             => 'as',
    'americas'                                  => '019',
    'andorra'                                   => 'ad',
    'angola'                                    => 'ao',
    'anguilla'                                  => 'ai',
    'antarctica'                                => 'aq',
    'antiguaandbarbuda'                         => 'ag',
    'argentina'                                 => 'ar',
    'armenia'                                   => 'am',
    'aruba'                                     => 'aw',
    'ascensionisland'                           => 'ac',
    'asia'                                      => 142,
    'australia'                                 => 'au',
    'australiaandnewzealand'                    => '053',
    'austria'                                   => 'at',
    'azerbaijan'                                => 'az',
    'bahamas'                                   => 'bs',
    'bahrain'                                   => 'bh',
    'bangladesh'                                => 'bd',
    'barbados'                                  => 'bb',
    'belarus'                                   => 'by',
    'belgium'                                   => 'be',
    'belize'                                    => 'bz',
    'benin'                                     => 'bj',
    'bermuda'                                   => 'bm',
    'bhutan'                                    => 'bt',
    'bolivia'                                   => 'bo',
    'bosniaandherzegovina'                      => 'ba',
    'botswana'                                  => 'bw',
    'bouvetisland'                              => 'bv',
    'brazil'                                    => 'br',
    'britishantarcticterritory'                 => 'bq',
    'britishindianoceanterritory'               => 'io',
    'britishvirginislands'                      => 'vg',
    'brunei'                                    => 'bn',
    'bulgaria'                                  => 'bg',
    'burkinafaso'                               => 'bf',
    'burundi'                                   => 'bi',
    'cambodia'                                  => 'kh',
    'cameroon'                                  => 'cm',
    'canada'                                    => 'ca',
    'canaryislands'                             => 'ic',
    'cantonandenderburyislands'                 => 'ct',
    'capeverde'                                 => 'cv',
    'caribbean'                                 => '029',
    'caymanislands'                             => 'ky',
    'centralafricanrepublic'                    => 'cf',
    'centralamerica'                            => '013',
    'centralasia'                               => 143,
    'ceutaandmelilla'                           => 'ea',
    'chad'                                      => 'td',
    'channelislands'                            => 830,
    'chile'                                     => 'cl',
    'china'                                     => 'cn',
    'christmasisland'                           => 'cx',
    'clippertonisland'                          => 'cp',
    'cocoskeelingislands'                       => 'cc',
    'colombia'                                  => 'co',
    'commonwealthofindependentstates'           => 172,
    'comoros'                                   => 'km',
    'congodrc'                                  => 'cd',
    'congorepublic'                             => 'cg',
    'cookislands'                               => 'ck',
    'costarica'                                 => 'cr',
    'croatia'                                   => 'hr',
    'cuba'                                      => 'cu',
    'cyprus'                                    => 'cy',
    'czechoslovakia'                            => 200,
    'czechrepublic'                             => 'cz',
    'denmark'                                   => 'dk',
    'diegogarcia'                               => 'dg',
    'djibouti'                                  => 'dj',
    'dominica'                                  => 'dm',
    'dominicanrepublic'                         => 'do',
    'dronningmaudland'                          => 'nq',
    'easternafrica'                             => '014',
    'easternasia'                               => '030',
    'easterneurope'                             => 151,
    'eastgermany'                               => 'dd',
    'easttimor'                                 => 'tl',
    'ecuador'                                   => 'ec',
    'egypt'                                     => 'eg',
    'elsalvador'                                => 'sv',
    'equatorialguinea'                          => 'gq',
    'eritrea'                                   => 'er',
    'estonia'                                   => 'ee',
    'ethiopia'                                  => 'et',
    'europe'                                    => 150,
    'europeanunion'                             => 'eu',
    'falklandislandsislasmalvinas'              => 'fk',
    'faroeislands'                              => 'fo',
    'fiji'                                      => 'fj',
    'finland'                                   => 'fi',
    'france'                                    => 'fr',
    'frenchguiana'                              => 'gf',
    'frenchpolynesia'                           => 'pf',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'frenchsouthernterritories'                 => 'tf',
    'gabon'                                     => 'ga',
    'gambia'                                    => 'gm',
    'georgia'                                   => 'ge',
    'germany'                                   => 'de',
    'ghana'                                     => 'gh',
    'gibraltar'                                 => 'gi',
    'greece'                                    => 'gr',
    'greenland'                                 => 'gl',
    'grenada'                                   => 'gd',
    'guadeloupe'                                => 'gp',
    'guam'                                      => 'gu',
    'guatemala'                                 => 'gt',
    'guernsey'                                  => 'gg',
    'guinea'                                    => 'gn',
    'guineabissau'                              => 'gw',
    'guyana'                                    => 'gy',
    'haiti'                                     => 'ht',
    'heardislandandmcdonaldislands'             => 'hm',
    'honduras'                                  => 'hn',
    'hongkong'                                  => 'hk',
    'hungary'                                   => 'hu',
    'iceland'                                   => 'is',
    'india'                                     => 'in',
    'indonesia'                                 => 'id',
    'iran'                                      => 'ir',
    'iraq'                                      => 'iq',
    'ireland'                                   => 'ie',
    'isleofman'                                 => 'im',
    'israel'                                    => 'il',
    'italy'                                     => 'it',
    'ivorycoast'                                => 'ci',
    'jamaica'                                   => 'jm',
    'japan'                                     => 'jp',
    'jersey'                                    => 'je',
    'johnstonisland'                            => 'jt',
    'jordan'                                    => 'jo',
    'kazakhstan'                                => 'kz',
    'kenya'                                     => 'ke',
    'kiribati'                                  => 'ki',
    'kuwait'                                    => 'kw',
    'kyrgyzstan'                                => 'kg',
    'laos'                                      => 'la',
    'latinamerica'                              => 419,
    'latvia'                                    => 'lv',
    'lebanon'                                   => 'lb',
    'lesotho'                                   => 'ls',
    'liberia'                                   => 'lr',
    'libya'                                     => 'ly',
    'liechtenstein'                             => 'li',
    'lithuania'                                 => 'lt',
    'luxembourg'                                => 'lu',
    'macau'                                     => 'mo',
    'macedoniafyrom'                            => 'mk',
    'madagascar'                                => 'mg',
    'malawi'                                    => 'mw',
    'malaysia'                                  => 'my',
    'maldives'                                  => 'mv',
    'mali'                                      => 'ml',
    'malta'                                     => 'mt',
    'marshallislands'                           => 'mh',
    'martinique'                                => 'mq',
    'mauritania'                                => 'mr',
    'mauritius'                                 => 'mu',
    'mayotte'                                   => 'yt',
    'melanesia'                                 => '054',
    'metropolitanfrance'                        => 'fx',
    'mexico'                                    => 'mx',
    'micronesia'                                => 'fm',
    'micronesianregion'                         => '057',
    'middleafrica'                              => '017',
    'midwayislands'                             => 'mi',
    'moldova'                                   => 'md',
    'monaco'                                    => 'mc',
    'mongolia'                                  => 'mn',
    'montenegro'                                => 'me',
    'montserrat'                                => 'ms',
    'morocco'                                   => 'ma',
    'mozambique'                                => 'mz',
    'myanmarburma'                              => 'mm',
    'namibia'                                   => 'na',
    'nauru'                                     => 'nr',
    'nepal'                                     => 'np',
    'netherlands'                               => 'nl',
    'netherlandsantilles'                       => 'an',
    'neutralzone'                               => 'nt',
    'newcaledonia'                              => 'nc',
    'newzealand'                                => 'nz',
    'nicaragua'                                 => 'ni',
    'niger'                                     => 'ne',
    'nigeria'                                   => 'ng',
    'niue'                                      => 'nu',
    'norfolkisland'                             => 'nf',
    'northamerica'                              => '003',
    'northernafrica'                            => '015',
    'northernamerica'                           => '021',
    'northerneurope'                            => 154,
    'northernmarianaislands'                    => 'mp',
    'northkorea'                                => 'kp',
    'northvietnam'                              => 'vd',
    'norway'                                    => 'no',
    'oceania'                                   => '009',
    'oman'                                      => 'om',
    'outlyingoceania'                           => 'qo',
    'pacificislandstrustterritory'              => 'pc',
    'pakistan'                                  => 'pk',
    'palau'                                     => 'pw',
    'palestinianterritories'                    => 'ps',
    'panama'                                    => 'pa',
    'panamacanalzone'                           => 'pz',
    'papuanewguinea'                            => 'pg',
    'paraguay'                                  => 'py',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'peru'                                      => 'pe',
    'philippines'                               => 'ph',
    'pitcairnislands'                           => 'pn',
    'poland'                                    => 'pl',
    'polynesia'                                 => '061',
    'portugal'                                  => 'pt',
    'puertorico'                                => 'pr',
    'qatar'                                     => 'qa',
    'romania'                                   => 'ro',
    'russia'                                    => 'ru',
    'rwanda'                                    => 'rw',
    'rywvanethunys'                             => 'gb',
    "r\Ã\©union"                              => 're',
    "saintbarth\Ã\©lemy"                      => 'bl',
    'sainthelena'                               => 'sh',
    'saintkittsandnevis'                        => 'kn',
    'saintlucia'                                => 'lc',
    'saintmartin'                               => 'mf',
    'saintpierreandmiquelon'                    => 'pm',
    'saintvincentandthegrenadines'              => 'vc',
    'samoa'                                     => 'ws',
    'sanmarino'                                 => 'sm',
    'saudiarabia'                               => 'sa',
    'senegal'                                   => 'sn',
    'serbia'                                    => 'rs',
    'serbiaandmontenegro'                       => 'cs',
    'seychelles'                                => 'sc',
    'sierraleone'                               => 'sl',
    'singapore'                                 => 'sg',
    'slovakia'                                  => 'sk',
    'slovenia'                                  => 'si',
    'solomonislands'                            => 'sb',
    'somalia'                                   => 'so',
    'southafrica'                               => 'za',
    'southamerica'                              => '005',
    'southcentralasia'                          => '062',
    'southeasternasia'                          => '035',
    'southernafrica'                            => '018',
    'southernasia'                              => '034',
    'southerneurope'                            => '039',
    'southgeorgiaandthesouthsandwichislands'    => 'gs',
    'southkorea'                                => 'kr',
    'spain'                                     => 'es',
    'srilanka'                                  => 'lk',
    'sudan'                                     => 'sd',
    'suriname'                                  => 'sr',
    'svalbardandjanmayen'                       => 'sj',
    'swaziland'                                 => 'sz',
    'sweden'                                    => 'se',
    'switzerland'                               => 'ch',
    'syria'                                     => 'sy',
    "s\Ã\£otom\Ã\©andpr\Ã\­ncipe"         => 'st',
    'taiwan'                                    => 'tw',
    'tajikistan'                                => 'tj',
    'tanzania'                                  => 'tz',
    'thailand'                                  => 'th',
    'togo'                                      => 'tg',
    'tokelau'                                   => 'tk',
    'tonga'                                     => 'to',
    'trinidadandtobago'                         => 'tt',
    'tristandacunha'                            => 'ta',
    'tunisia'                                   => 'tn',
    'turkey'                                    => 'tr',
    'turkmenistan'                              => 'tm',
    'turksandcaicosislands'                     => 'tc',
    'tuvalu'                                    => 'tv',
    "u\.s\.minoroutlyingislands"                => 'um',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    "u\.s\.virginislands"                       => 'vi',
    'uganda'                                    => 'ug',
    'ukraine'                                   => 'ua',
    'unionofsovietsocialistrepublics'           => 'su',
    'unitedarabemirates'                        => 'ae',
    'unitedstates'                              => 'us',
    'unknownregion'                             => 'zz',
    'uruguay'                                   => 'uy',
    'uzbekistan'                                => 'uz',
    'vanuatu'                                   => 'vu',
    'vaticancity'                               => 'va',
    'venezuela'                                 => 've',
    'vietnam'                                   => 'vn',
    'wakeisland'                                => 'wk',
    'wallisandfutuna'                           => 'wf',
    'westernafrica'                             => '011',
    'westernasia'                               => 145,
    'westerneurope'                             => 155,
    'westernsahara'                             => 'eh',
    'world'                                     => '001',
    'yemen'                                     => 'ye',
    'zambia'                                    => 'zm',
    'zimbabwe'                                  => 'zw',
    "\Ã\landislands"                         => 'ax',
);

1;

