#!/usr/bin/perl

package eBay::API::XML::DataType::BestOfferArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BestOfferArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BestOfferArrayType

=head1 DESCRIPTION

A collection of Best Offers. Empty if there are no best offers.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BestOfferArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::BestOfferType;


my @gaProperties = ( [ 'BestOffer', 'ns:BestOfferType', '1'
	     ,'eBay::API::XML::DataType::BestOfferType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBestOffer()

A container of details about a best offer.

#    Argument: reference to an array  
                      of 'ns:BestOfferType'

=cut

sub setBestOffer {
  my $self = shift;
  $self->{'BestOffer'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getBestOffer()

  Calls: RespondToBestOffer
  Returned: Always

  Calls: GetBestOffers
  Returned: Always
  Details: DetailLevel: none, ReturnAll

#    Returns: reference to an array  
                      of 'ns:BestOfferType'

=cut

sub getBestOffer {
  my $self = shift;
  return $self->_getDataTypeArray('BestOffer');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
