#!/usr/bin/perl

package eBay::API::XML::Call::GetExpressWishList;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetExpressWishList.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetExpressWishList

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetExpressWishList inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetExpressWishList::GetExpressWishListRequestType;
use eBay::API::XML::Call::GetExpressWishList::GetExpressWishListResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetExpressWishList';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetExpressWishList::GetExpressWishListRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetExpressWishList::GetExpressWishListResponseType';
}

#
# input properties
#

=head2 setFirstName()

User first name. Can be used in combination with LastName. Will be ignored if either UserID or
WishListID is included in the request.

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setFirstName {
   my $self   = shift;
   my $sFirstName = shift;
   $self->getRequestDataType()->setFirstName($sFirstName);
}

=head2 setLastName()

User last name. Can be used in combination with FirstName. Will be ignored if either UserID or
WishListID is included in the request.

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setLastName {
   my $self   = shift;
   my $sLastName = shift;
   $self->getRequestDataType()->setLastName($sLastName);
}

=head2 setPagination()

Contains the data that control the pagination of items or products in any returned wish list.

  RequiredInput: No
#    Argument: 'ns:PaginationType'

=cut
       
sub setPagination {
   my $self   = shift;
   my $pPagination = shift;
   $self->getRequestDataType()->setPagination($pPagination);
}

=head2 setSortOrder()

Sort order for returned results. Default is CreationDateDescending, which returns the most
recently added wish list items first.

  RequiredInput: No
#    Argument: 'ns:WishListSortCodeType'

=cut
       
sub setSortOrder {
   my $self   = shift;
   my $sSortOrder = shift;
   $self->getRequestDataType()->setSortOrder($sSortOrder);
}

=head2 setUserID()

eBay user ID. Can be used as an alternative to WishListID or to the combination FirstName and LastName.
If WishListID is used, UserID will be ignored. This value is not returned in the response.

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setUserID {
   my $self   = shift;
   my $sUserID = shift;
   $self->getRequestDataType()->setUserID($sUserID);
}

=head2 setWishListID()

Identifies an eBay Express wish list. When used in a request, UserID and FirstName and LastName are ignored.

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setWishListID {
   my $self   = shift;
   my $sWishListID = shift;
   $self->getRequestDataType()->setWishListID($sWishListID);
}



#
# output properties
#

=head2 getPagination()

Child elements control the display pagination of the items and products in retrieved
wish lists.

  Returned: Always
#    Returns: 'ns:PaginationResultType'

=cut
       
sub getPagination {
   my $self = shift;
   return $self->getResponseDataType()->getPagination();
}

=head2 getWishList()

Contains the contents and description of the requested wish list.

  Returned: Always
#    Returns: reference to an array  
                      of 'ns:WishListType'

=cut
       
sub getWishList {
   my $self = shift;
   return $self->getResponseDataType()->getWishList();
}





1;   
