# Generated by default/object.tt
package Paws::Appflow::FlowDefinition;
  use Moose;
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has CreatedBy => (is => 'ro', isa => 'Str', request_name => 'createdBy', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has DestinationConnectorType => (is => 'ro', isa => 'Str', request_name => 'destinationConnectorType', traits => ['NameInRequest']);
  has FlowArn => (is => 'ro', isa => 'Str', request_name => 'flowArn', traits => ['NameInRequest']);
  has FlowName => (is => 'ro', isa => 'Str', request_name => 'flowName', traits => ['NameInRequest']);
  has FlowStatus => (is => 'ro', isa => 'Str', request_name => 'flowStatus', traits => ['NameInRequest']);
  has LastRunExecutionDetails => (is => 'ro', isa => 'Paws::Appflow::ExecutionDetails', request_name => 'lastRunExecutionDetails', traits => ['NameInRequest']);
  has LastUpdatedAt => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedAt', traits => ['NameInRequest']);
  has LastUpdatedBy => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedBy', traits => ['NameInRequest']);
  has SourceConnectorType => (is => 'ro', isa => 'Str', request_name => 'sourceConnectorType', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::Appflow::TagMap', request_name => 'tags', traits => ['NameInRequest']);
  has TriggerType => (is => 'ro', isa => 'Str', request_name => 'triggerType', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::FlowDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::FlowDefinition object:

  $service_obj->Method(Att1 => { CreatedAt => $value, ..., TriggerType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::FlowDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedAt

=head1 DESCRIPTION

The properties of the flow, such as its source, destination, trigger
type, and so on.

=head1 ATTRIBUTES


=head2 CreatedAt => Str

Specifies when the flow was created.


=head2 CreatedBy => Str

The ARN of the user who created the flow.


=head2 Description => Str

A user-entered description of the flow.


=head2 DestinationConnectorType => Str

Specifies the destination connector type, such as Salesforce, Amazon
S3, Amplitude, and so on.


=head2 FlowArn => Str

The flow's Amazon Resource Name (ARN).


=head2 FlowName => Str

The specified name of the flow. Spaces are not allowed. Use underscores
(_) or hyphens (-) only.


=head2 FlowStatus => Str

Indicates the current status of the flow.


=head2 LastRunExecutionDetails => L<Paws::Appflow::ExecutionDetails>

Describes the details of the most recent flow run.


=head2 LastUpdatedAt => Str

Specifies when the flow was last updated.


=head2 LastUpdatedBy => Str

Specifies the account user name that most recently updated the flow.


=head2 SourceConnectorType => Str

Specifies the source connector type, such as Salesforce, Amazon S3,
Amplitude, and so on.


=head2 Tags => L<Paws::Appflow::TagMap>

The tags used to organize, track, or control access for your flow.


=head2 TriggerType => Str

Specifies the type of flow trigger. This can be C<OnDemand>,
C<Scheduled>, or C<Event>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

