# Generated by default/object.tt
package Paws::SSM::DocumentReviews;
  use Moose;
  has Action => (is => 'ro', isa => 'Str', required => 1);
  has Comment => (is => 'ro', isa => 'ArrayRef[Paws::SSM::DocumentReviewCommentSource]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSM::DocumentReviews

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSM::DocumentReviews object:

  $service_obj->Method(Att1 => { Action => $value, ..., Comment => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSM::DocumentReviews object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

Information about a document approval review.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Action => Str

The action to take on a document approval review request.


=head2 Comment => ArrayRef[L<Paws::SSM::DocumentReviewCommentSource>]

A comment entered by a user in your organization about the document
review request.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

