# Generated by default/object.tt
package Paws::TimestreamWrite::RetentionProperties;
  use Moose;
  has MagneticStoreRetentionPeriodInDays => (is => 'ro', isa => 'Int', required => 1);
  has MemoryStoreRetentionPeriodInHours => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::TimestreamWrite::RetentionProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::TimestreamWrite::RetentionProperties object:

  $service_obj->Method(Att1 => { MagneticStoreRetentionPeriodInDays => $value, ..., MemoryStoreRetentionPeriodInHours => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::TimestreamWrite::RetentionProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->MagneticStoreRetentionPeriodInDays

=head1 DESCRIPTION

Retention properties contain the duration for which your time series
data must be stored in the magnetic store and the memory store.

=head1 ATTRIBUTES


=head2 B<REQUIRED> MagneticStoreRetentionPeriodInDays => Int

The duration for which data must be stored in the magnetic store.


=head2 B<REQUIRED> MemoryStoreRetentionPeriodInHours => Int

The duration for which data must be stored in the memory store.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::TimestreamWrite>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

