# Generated by default/object.tt
package Paws::SageMaker::VariantProperty;
  use Moose;
  has VariantPropertyType => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::VariantProperty

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::VariantProperty object:

  $service_obj->Method(Att1 => { VariantPropertyType => $value, ..., VariantPropertyType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::VariantProperty object:

  $result = $service_obj->Method(...);
  $result->Att1->VariantPropertyType

=head1 DESCRIPTION

Specifies a production variant property type for an Endpoint.

If you are updating an endpoint with the
UpdateEndpointInput$RetainAllVariantProperties option set to C<true>,
the C<VariantProperty> objects listed in
UpdateEndpointInput$ExcludeRetainedVariantProperties override the
existing variant properties of the endpoint.

=head1 ATTRIBUTES


=head2 B<REQUIRED> VariantPropertyType => Str

The type of variant property. The supported values are:

=over

=item *

C<DesiredInstanceCount>: Overrides the existing variant instance counts
using the ProductionVariant$InitialInstanceCount values in the
CreateEndpointConfigInput$ProductionVariants.

=item *

C<DesiredWeight>: Overrides the existing variant weights using the
ProductionVariant$InitialVariantWeight values in the
CreateEndpointConfigInput$ProductionVariants.

=item *

C<DataCaptureConfig>: (Not currently supported.)

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

