package Cucumber::Messages;
$Cucumber::Messages::VERSION = '32.0.0';
# DO NOT CHANGE THIS FILE!!

# The code was auto-generated by this script:
# https://github.com/cucumber/messages/blob/main/codegen/codegen.rb

=head1 NAME

Cucumber::Messages - Library of classes to encapsulate Cucumber messages

=head1 SYNOPSIS

  use Cucumber::Messages;

  my $loc = Cucumber::Messages::Location->new(
     line => 12, column => 26
  );
  my $loc_json = $loc->to_json;

  my $envelope = Cucumber::Messages::Envelope->from_json($serialized_envelope);

=head1 DESCRIPTION

L<Cucumber messages|https://github.com/cucumber/messages>
define the central protocol in the Cucumber ecosystem by which the various
components communicate. Messages are serialized to NDJSON.

This library provides both serialization/deserialization to/from NDJSON as
well as the in-memory representation of the messages for Perl applications.

Each serialized message should be wrapped in a C<Cucumber::Messages::Envelope>
and can thereby be deserialized by calling the C<from_json> class message
with the serialized representation as its argument, like shown in the SYNOPSIS.

=cut

use strict;
use warnings;

use Cucumber::Messages::Message;

=head1 MESSAGE CLASSES

=cut



package Cucumber::Messages::Attachment {
$Cucumber::Messages::Attachment::VERSION = '32.0.0';
=head2 Cucumber::Messages::Attachment

=head3 DESCRIPTION

Represents the Attachment message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

Attachments (parse errors, execution errors, screenshots, links...)

An attachment represents any kind of data associated with a line in a
[Source](#io.cucumber.messages.Source) file. It can be used for:

* Syntax errors during parse time
* Screenshots captured and attached during execution
* Logs captured and attached during execution

It is not to be used for runtime errors raised/thrown during execution. This
is captured in `TestResult`.

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   body => 'string',
   content_encoding => '',
   file_name => 'string',
   media_type => 'string',
   source => 'Cucumber::Messages::Source',
   test_case_started_id => 'string',
   test_step_id => 'string',
   url => 'string',
   test_run_started_id => 'string',
   test_run_hook_started_id => 'string',
   timestamp => 'Cucumber::Messages::Timestamp',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 body

The body of the attachment. If `contentEncoding` is `IDENTITY`, the attachment
is simply the string. If it's `BASE64`, the string should be Base64 decoded to
obtain the attachment.
=cut

has body =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 content_encoding

Whether to interpret `body` "as-is" (IDENTITY) or if it needs to be Base64-decoded (BASE64).

Content encoding is *not* determined by the media type, but rather by the type
of the object being attached:

- string: IDENTITY
- byte array: BASE64
- stream: BASE64

Available constants for valid values of this field:

=over

=item * CONTENTENCODING_IDENTITY

=item * CONTENTENCODING_BASE64

=back

=cut


use constant {
   CONTENTENCODING_IDENTITY => 'IDENTITY',
   CONTENTENCODING_BASE64 => 'BASE64',
   };

has content_encoding =>
    (is => 'ro',
     required => 1,
     default => sub { CONTENTENCODING_IDENTITY },
    );


=head4 file_name

Suggested file name of the attachment. (Provided by the user as an argument to `attach`)
=cut

has file_name =>
    (is => 'ro',
    );


=head4 media_type

The media type of the data. This can be any valid
[IANA Media Type](https://www.iana.org/assignments/media-types/media-types.xhtml)
as well as Cucumber-specific media types such as `text/x.cucumber.gherkin+plain`
and `text/x.cucumber.stacktrace+plain`
=cut

has media_type =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 source


=cut

has source =>
    (is => 'ro',
    );


=head4 test_case_started_id

The identifier of the test case attempt if the attachment was created during the execution of a test step
=cut

has test_case_started_id =>
    (is => 'ro',
    );


=head4 test_step_id

The identifier of the test step if the attachment was created during the execution of a test step
=cut

has test_step_id =>
    (is => 'ro',
    );


=head4 url

A URL where the attachment can be retrieved. This field should not be set by Cucumber.
It should be set by a program that reads a message stream and does the following for
each Attachment message:

- Writes the body (after base64 decoding if necessary) to a new file.
- Sets `body` and `contentEncoding` to `null`
- Writes out the new attachment message

This will result in a smaller message stream, which can improve performance and
reduce bandwidth of message consumers. It also makes it easier to process and download attachments
separately from reports.

Deprecated; use ExternalAttachment instead.
=cut

has url =>
    (is => 'ro',
    );


=head4 test_run_started_id

Not used; implementers should instead populate `testRunHookStartedId` if an attachment was created during the execution of a test run hook
=cut

has test_run_started_id =>
    (is => 'ro',
    );


=head4 test_run_hook_started_id

The identifier of the test run hook execution if the attachment was created during the execution of a test run hook
=cut

has test_run_hook_started_id =>
    (is => 'ro',
    );


=head4 timestamp

When the attachment was created
=cut

has timestamp =>
    (is => 'ro',
    );


}

package Cucumber::Messages::Duration {
$Cucumber::Messages::Duration::VERSION = '32.0.0';
=head2 Cucumber::Messages::Duration

=head3 DESCRIPTION

Represents the Duration message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

The structure is pretty close of the Timestamp one. For clarity, a second type
of message is used.

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   seconds => 'number',
   nanos => 'number',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 seconds


=cut

has seconds =>
    (is => 'ro',
     required => 1,
     default => sub { 0 },
    );


=head4 nanos

Non-negative fractions of a second at nanosecond resolution. Negative
second values with fractions must still have non-negative nanos values
that count forward in time. Must be from 0 to 999,999,999
inclusive.
=cut

has nanos =>
    (is => 'ro',
     required => 1,
     default => sub { 0 },
    );


}

package Cucumber::Messages::Envelope {
$Cucumber::Messages::Envelope::VERSION = '32.0.0';
=head2 Cucumber::Messages::Envelope

=head3 DESCRIPTION

Represents the Envelope message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   attachment => 'Cucumber::Messages::Attachment',
   external_attachment => 'Cucumber::Messages::ExternalAttachment',
   gherkin_document => 'Cucumber::Messages::GherkinDocument',
   hook => 'Cucumber::Messages::Hook',
   meta => 'Cucumber::Messages::Meta',
   parameter_type => 'Cucumber::Messages::ParameterType',
   parse_error => 'Cucumber::Messages::ParseError',
   pickle => 'Cucumber::Messages::Pickle',
   suggestion => 'Cucumber::Messages::Suggestion',
   source => 'Cucumber::Messages::Source',
   step_definition => 'Cucumber::Messages::StepDefinition',
   test_case => 'Cucumber::Messages::TestCase',
   test_case_finished => 'Cucumber::Messages::TestCaseFinished',
   test_case_started => 'Cucumber::Messages::TestCaseStarted',
   test_run_finished => 'Cucumber::Messages::TestRunFinished',
   test_run_started => 'Cucumber::Messages::TestRunStarted',
   test_step_finished => 'Cucumber::Messages::TestStepFinished',
   test_step_started => 'Cucumber::Messages::TestStepStarted',
   test_run_hook_started => 'Cucumber::Messages::TestRunHookStarted',
   test_run_hook_finished => 'Cucumber::Messages::TestRunHookFinished',
   undefined_parameter_type => 'Cucumber::Messages::UndefinedParameterType',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 attachment


=cut

has attachment =>
    (is => 'ro',
    );


=head4 external_attachment


=cut

has external_attachment =>
    (is => 'ro',
    );


=head4 gherkin_document


=cut

has gherkin_document =>
    (is => 'ro',
    );


=head4 hook


=cut

has hook =>
    (is => 'ro',
    );


=head4 meta


=cut

has meta =>
    (is => 'ro',
    );


=head4 parameter_type


=cut

has parameter_type =>
    (is => 'ro',
    );


=head4 parse_error


=cut

has parse_error =>
    (is => 'ro',
    );


=head4 pickle


=cut

has pickle =>
    (is => 'ro',
    );


=head4 suggestion


=cut

has suggestion =>
    (is => 'ro',
    );


=head4 source


=cut

has source =>
    (is => 'ro',
    );


=head4 step_definition


=cut

has step_definition =>
    (is => 'ro',
    );


=head4 test_case


=cut

has test_case =>
    (is => 'ro',
    );


=head4 test_case_finished


=cut

has test_case_finished =>
    (is => 'ro',
    );


=head4 test_case_started


=cut

has test_case_started =>
    (is => 'ro',
    );


=head4 test_run_finished


=cut

has test_run_finished =>
    (is => 'ro',
    );


=head4 test_run_started


=cut

has test_run_started =>
    (is => 'ro',
    );


=head4 test_step_finished


=cut

has test_step_finished =>
    (is => 'ro',
    );


=head4 test_step_started


=cut

has test_step_started =>
    (is => 'ro',
    );


=head4 test_run_hook_started


=cut

has test_run_hook_started =>
    (is => 'ro',
    );


=head4 test_run_hook_finished


=cut

has test_run_hook_finished =>
    (is => 'ro',
    );


=head4 undefined_parameter_type


=cut

has undefined_parameter_type =>
    (is => 'ro',
    );


}

package Cucumber::Messages::Exception {
$Cucumber::Messages::Exception::VERSION = '32.0.0';
=head2 Cucumber::Messages::Exception

=head3 DESCRIPTION

Represents the Exception message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A simplified representation of an exception

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   type => 'string',
   message => 'string',
   stack_trace => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 type

The type of the exception that caused this result. E.g. "Error" or "org.opentest4j.AssertionFailedError"
=cut

has type =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 message

The message of exception that caused this result. E.g. expected: "a" but was: "b"
=cut

has message =>
    (is => 'ro',
    );


=head4 stack_trace

The stringified stack trace of the exception that caused this result
=cut

has stack_trace =>
    (is => 'ro',
    );


}

package Cucumber::Messages::ExternalAttachment {
$Cucumber::Messages::ExternalAttachment::VERSION = '32.0.0';
=head2 Cucumber::Messages::ExternalAttachment

=head3 DESCRIPTION

Represents the ExternalAttachment message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

Represents an attachment that is stored externally rather than embedded in the message stream.

This message type is used for large attachments (e.g., video files) that are already
on the filesystem and should not be loaded into memory. Instead of embedding the content,
only a URL reference is stored.

A formatter or other consumer of messages may replace an Attachment with an ExternalAttachment if it makes sense to do so.

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   url => 'string',
   media_type => 'string',
   test_step_id => 'string',
   test_case_started_id => 'string',
   test_run_hook_started_id => 'string',
   timestamp => 'Cucumber::Messages::Timestamp',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 url

A URL where the attachment can be retrieved. This could be a file:// URL for
local filesystem paths, or an http(s):// URL for remote resources.
=cut

has url =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 media_type

The media type of the data. This can be any valid
[IANA Media Type](https://www.iana.org/assignments/media-types/media-types.xhtml)
as well as Cucumber-specific media types such as `text/x.cucumber.gherkin+plain`
and `text/x.cucumber.stacktrace+plain`
=cut

has media_type =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 test_step_id

The identifier of the test step if the attachment was created during the execution of a test step
=cut

has test_step_id =>
    (is => 'ro',
    );


=head4 test_case_started_id

The identifier of the test case attempt if the attachment was created during the execution of a test step
=cut

has test_case_started_id =>
    (is => 'ro',
    );


=head4 test_run_hook_started_id

The identifier of the test run hook execution if the attachment was created during the execution of a test run hook
=cut

has test_run_hook_started_id =>
    (is => 'ro',
    );


=head4 timestamp

When the attachment was created
=cut

has timestamp =>
    (is => 'ro',
    );


}

package Cucumber::Messages::GherkinDocument {
$Cucumber::Messages::GherkinDocument::VERSION = '32.0.0';
=head2 Cucumber::Messages::GherkinDocument

=head3 DESCRIPTION

Represents the GherkinDocument message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

The [AST](https://en.wikipedia.org/wiki/Abstract_syntax_tree) of a Gherkin document.
Cucumber implementations should *not* depend on `GherkinDocument` or any of its
children for execution - use [Pickle](#io.cucumber.messages.Pickle) instead.

The only consumers of `GherkinDocument` should only be formatters that produce
"rich" output, resembling the original Gherkin document.

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   uri => 'string',
   feature => 'Cucumber::Messages::Feature',
   comments => '[]Cucumber::Messages::Comment',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 uri

The [URI](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier)
of the source, typically a file path relative to the root directory
=cut

has uri =>
    (is => 'ro',
    );


=head4 feature


=cut

has feature =>
    (is => 'ro',
    );


=head4 comments

All the comments in the Gherkin document
=cut

has comments =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


}

package Cucumber::Messages::Background {
$Cucumber::Messages::Background::VERSION = '32.0.0';
=head2 Cucumber::Messages::Background

=head3 DESCRIPTION

Represents the Background message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   location => 'Cucumber::Messages::Location',
   keyword => 'string',
   name => 'string',
   description => 'string',
   steps => '[]Cucumber::Messages::Step',
   id => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 location

The location of the `Background` keyword
=cut

has location =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Location->new() },
    );


=head4 keyword


=cut

has keyword =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 name


=cut

has name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 description


=cut

has description =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 steps


=cut

has steps =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 id


=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::Comment {
$Cucumber::Messages::Comment::VERSION = '32.0.0';
=head2 Cucumber::Messages::Comment

=head3 DESCRIPTION

Represents the Comment message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A comment in a Gherkin document

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   location => 'Cucumber::Messages::Location',
   text => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 location

The location of the comment
=cut

has location =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Location->new() },
    );


=head4 text

The text of the comment
=cut

has text =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::DataTable {
$Cucumber::Messages::DataTable::VERSION = '32.0.0';
=head2 Cucumber::Messages::DataTable

=head3 DESCRIPTION

Represents the DataTable message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   location => 'Cucumber::Messages::Location',
   rows => '[]Cucumber::Messages::TableRow',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 location


=cut

has location =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Location->new() },
    );


=head4 rows


=cut

has rows =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


}

package Cucumber::Messages::DocString {
$Cucumber::Messages::DocString::VERSION = '32.0.0';
=head2 Cucumber::Messages::DocString

=head3 DESCRIPTION

Represents the DocString message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   location => 'Cucumber::Messages::Location',
   media_type => 'string',
   content => 'string',
   delimiter => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 location


=cut

has location =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Location->new() },
    );


=head4 media_type


=cut

has media_type =>
    (is => 'ro',
    );


=head4 content


=cut

has content =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 delimiter


=cut

has delimiter =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::Examples {
$Cucumber::Messages::Examples::VERSION = '32.0.0';
=head2 Cucumber::Messages::Examples

=head3 DESCRIPTION

Represents the Examples message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   location => 'Cucumber::Messages::Location',
   tags => '[]Cucumber::Messages::Tag',
   keyword => 'string',
   name => 'string',
   description => 'string',
   table_header => 'Cucumber::Messages::TableRow',
   table_body => '[]Cucumber::Messages::TableRow',
   id => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 location

The location of the `Examples` keyword
=cut

has location =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Location->new() },
    );


=head4 tags


=cut

has tags =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 keyword


=cut

has keyword =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 name


=cut

has name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 description


=cut

has description =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 table_header


=cut

has table_header =>
    (is => 'ro',
    );


=head4 table_body


=cut

has table_body =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 id


=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::Feature {
$Cucumber::Messages::Feature::VERSION = '32.0.0';
=head2 Cucumber::Messages::Feature

=head3 DESCRIPTION

Represents the Feature message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   location => 'Cucumber::Messages::Location',
   tags => '[]Cucumber::Messages::Tag',
   language => 'string',
   keyword => 'string',
   name => 'string',
   description => 'string',
   children => '[]Cucumber::Messages::FeatureChild',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 location

The location of the `Feature` keyword
=cut

has location =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Location->new() },
    );


=head4 tags

All the tags placed above the `Feature` keyword
=cut

has tags =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 language

The [ISO 639-1](https://en.wikipedia.org/wiki/ISO_639-1) language code of the Gherkin document
=cut

has language =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 keyword

The text of the `Feature` keyword (in the language specified by `language`)
=cut

has keyword =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 name

The name of the feature (the text following the `keyword`)
=cut

has name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 description

The line(s) underneath the line with the `keyword` that are used as description
=cut

has description =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 children

Zero or more children
=cut

has children =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


}

package Cucumber::Messages::FeatureChild {
$Cucumber::Messages::FeatureChild::VERSION = '32.0.0';
=head2 Cucumber::Messages::FeatureChild

=head3 DESCRIPTION

Represents the FeatureChild message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A child node of a `Feature` node

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   rule => 'Cucumber::Messages::Rule',
   background => 'Cucumber::Messages::Background',
   scenario => 'Cucumber::Messages::Scenario',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 rule


=cut

has rule =>
    (is => 'ro',
    );


=head4 background


=cut

has background =>
    (is => 'ro',
    );


=head4 scenario


=cut

has scenario =>
    (is => 'ro',
    );


}

package Cucumber::Messages::Rule {
$Cucumber::Messages::Rule::VERSION = '32.0.0';
=head2 Cucumber::Messages::Rule

=head3 DESCRIPTION

Represents the Rule message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   location => 'Cucumber::Messages::Location',
   tags => '[]Cucumber::Messages::Tag',
   keyword => 'string',
   name => 'string',
   description => 'string',
   children => '[]Cucumber::Messages::RuleChild',
   id => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 location

The location of the `Rule` keyword
=cut

has location =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Location->new() },
    );


=head4 tags

All the tags placed above the `Rule` keyword
=cut

has tags =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 keyword


=cut

has keyword =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 name


=cut

has name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 description


=cut

has description =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 children


=cut

has children =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 id


=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::RuleChild {
$Cucumber::Messages::RuleChild::VERSION = '32.0.0';
=head2 Cucumber::Messages::RuleChild

=head3 DESCRIPTION

Represents the RuleChild message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A child node of a `Rule` node

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   background => 'Cucumber::Messages::Background',
   scenario => 'Cucumber::Messages::Scenario',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 background


=cut

has background =>
    (is => 'ro',
    );


=head4 scenario


=cut

has scenario =>
    (is => 'ro',
    );


}

package Cucumber::Messages::Scenario {
$Cucumber::Messages::Scenario::VERSION = '32.0.0';
=head2 Cucumber::Messages::Scenario

=head3 DESCRIPTION

Represents the Scenario message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   location => 'Cucumber::Messages::Location',
   tags => '[]Cucumber::Messages::Tag',
   keyword => 'string',
   name => 'string',
   description => 'string',
   steps => '[]Cucumber::Messages::Step',
   examples => '[]Cucumber::Messages::Examples',
   id => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 location

The location of the `Scenario` keyword
=cut

has location =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Location->new() },
    );


=head4 tags


=cut

has tags =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 keyword


=cut

has keyword =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 name


=cut

has name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 description


=cut

has description =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 steps


=cut

has steps =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 examples


=cut

has examples =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 id


=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::Step {
$Cucumber::Messages::Step::VERSION = '32.0.0';
=head2 Cucumber::Messages::Step

=head3 DESCRIPTION

Represents the Step message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A step

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   location => 'Cucumber::Messages::Location',
   keyword => 'string',
   keyword_type => '',
   text => 'string',
   doc_string => 'Cucumber::Messages::DocString',
   data_table => 'Cucumber::Messages::DataTable',
   id => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 location

The location of the steps' `keyword`
=cut

has location =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Location->new() },
    );


=head4 keyword

The actual keyword as it appeared in the source.
=cut

has keyword =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 keyword_type

The test phase signalled by the keyword: Context definition (Given), Action performance (When), Outcome assertion (Then). Other keywords signal Continuation (And and But) from a prior keyword. Please note that all translations which a dialect maps to multiple keywords (`*` is in this category for all dialects), map to 'Unknown'.

Available constants for valid values of this field:

=over

=item * KEYWORDTYPE_UNKNOWN

=item * KEYWORDTYPE_CONTEXT

=item * KEYWORDTYPE_ACTION

=item * KEYWORDTYPE_OUTCOME

=item * KEYWORDTYPE_CONJUNCTION

=back

=cut


use constant {
   KEYWORDTYPE_UNKNOWN => 'Unknown',
   KEYWORDTYPE_CONTEXT => 'Context',
   KEYWORDTYPE_ACTION => 'Action',
   KEYWORDTYPE_OUTCOME => 'Outcome',
   KEYWORDTYPE_CONJUNCTION => 'Conjunction',
   };

has keyword_type =>
    (is => 'ro',
    );


=head4 text


=cut

has text =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 doc_string


=cut

has doc_string =>
    (is => 'ro',
    );


=head4 data_table


=cut

has data_table =>
    (is => 'ro',
    );


=head4 id

Unique ID to be able to reference the Step from PickleStep
=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::TableCell {
$Cucumber::Messages::TableCell::VERSION = '32.0.0';
=head2 Cucumber::Messages::TableCell

=head3 DESCRIPTION

Represents the TableCell message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A cell in a `TableRow`

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   location => 'Cucumber::Messages::Location',
   value => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 location

The location of the cell
=cut

has location =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Location->new() },
    );


=head4 value

The value of the cell
=cut

has value =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::TableRow {
$Cucumber::Messages::TableRow::VERSION = '32.0.0';
=head2 Cucumber::Messages::TableRow

=head3 DESCRIPTION

Represents the TableRow message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A row in a table

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   location => 'Cucumber::Messages::Location',
   cells => '[]Cucumber::Messages::TableCell',
   id => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 location

The location of the first cell in the row
=cut

has location =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Location->new() },
    );


=head4 cells

Cells in the row
=cut

has cells =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 id


=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::Tag {
$Cucumber::Messages::Tag::VERSION = '32.0.0';
=head2 Cucumber::Messages::Tag

=head3 DESCRIPTION

Represents the Tag message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A tag

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   location => 'Cucumber::Messages::Location',
   name => 'string',
   id => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 location

Location of the tag
=cut

has location =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Location->new() },
    );


=head4 name

The name of the tag (including the leading `@`)
=cut

has name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 id

Unique ID to be able to reference the Tag from PickleTag
=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::Hook {
$Cucumber::Messages::Hook::VERSION = '32.0.0';
=head2 Cucumber::Messages::Hook

=head3 DESCRIPTION

Represents the Hook message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   id => 'string',
   name => 'string',
   source_reference => 'Cucumber::Messages::SourceReference',
   tag_expression => 'string',
   type => '',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 id


=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 name


=cut

has name =>
    (is => 'ro',
    );


=head4 source_reference


=cut

has source_reference =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::SourceReference->new() },
    );


=head4 tag_expression


=cut

has tag_expression =>
    (is => 'ro',
    );


=head4 type



Available constants for valid values of this field:

=over

=item * TYPE_BEFORE_TEST_RUN

=item * TYPE_AFTER_TEST_RUN

=item * TYPE_BEFORE_TEST_CASE

=item * TYPE_AFTER_TEST_CASE

=item * TYPE_BEFORE_TEST_STEP

=item * TYPE_AFTER_TEST_STEP

=back

=cut


use constant {
   TYPE_BEFORE_TEST_RUN => 'BEFORE_TEST_RUN',
   TYPE_AFTER_TEST_RUN => 'AFTER_TEST_RUN',
   TYPE_BEFORE_TEST_CASE => 'BEFORE_TEST_CASE',
   TYPE_AFTER_TEST_CASE => 'AFTER_TEST_CASE',
   TYPE_BEFORE_TEST_STEP => 'BEFORE_TEST_STEP',
   TYPE_AFTER_TEST_STEP => 'AFTER_TEST_STEP',
   };

has type =>
    (is => 'ro',
    );


}

package Cucumber::Messages::Location {
$Cucumber::Messages::Location::VERSION = '32.0.0';
=head2 Cucumber::Messages::Location

=head3 DESCRIPTION

Represents the Location message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

Points to a line and a column in a text file

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   line => 'number',
   column => 'number',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 line


=cut

has line =>
    (is => 'ro',
     required => 1,
     default => sub { 0 },
    );


=head4 column


=cut

has column =>
    (is => 'ro',
    );


}

package Cucumber::Messages::Meta {
$Cucumber::Messages::Meta::VERSION = '32.0.0';
=head2 Cucumber::Messages::Meta

=head3 DESCRIPTION

Represents the Meta message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

This message contains meta information about the environment. Consumers can use
this for various purposes.

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   protocol_version => 'string',
   implementation => 'Cucumber::Messages::Product',
   runtime => 'Cucumber::Messages::Product',
   os => 'Cucumber::Messages::Product',
   cpu => 'Cucumber::Messages::Product',
   ci => 'Cucumber::Messages::Ci',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 protocol_version

The [SEMVER](https://semver.org/) version number of the protocol
=cut

has protocol_version =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 implementation

SpecFlow, Cucumber-JVM, Cucumber.js, Cucumber-Ruby, Behat etc.
=cut

has implementation =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Product->new() },
    );


=head4 runtime

Java, Ruby, Node.js etc
=cut

has runtime =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Product->new() },
    );


=head4 os

Windows, Linux, MacOS etc
=cut

has os =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Product->new() },
    );


=head4 cpu

386, arm, amd64 etc
=cut

has cpu =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Product->new() },
    );


=head4 ci


=cut

has ci =>
    (is => 'ro',
    );


}

package Cucumber::Messages::Ci {
$Cucumber::Messages::Ci::VERSION = '32.0.0';
=head2 Cucumber::Messages::Ci

=head3 DESCRIPTION

Represents the Ci message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

CI environment

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   name => 'string',
   url => 'string',
   build_number => 'string',
   git => 'Cucumber::Messages::Git',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 name

Name of the CI product, e.g. "Jenkins", "CircleCI" etc.
=cut

has name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 url

Link to the build
=cut

has url =>
    (is => 'ro',
    );


=head4 build_number

The build number. Some CI servers use non-numeric build numbers, which is why this is a string
=cut

has build_number =>
    (is => 'ro',
    );


=head4 git


=cut

has git =>
    (is => 'ro',
    );


}

package Cucumber::Messages::Git {
$Cucumber::Messages::Git::VERSION = '32.0.0';
=head2 Cucumber::Messages::Git

=head3 DESCRIPTION

Represents the Git message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

Information about Git, provided by the Build/CI server as environment
variables.

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   remote => 'string',
   revision => 'string',
   branch => 'string',
   tag => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 remote


=cut

has remote =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 revision


=cut

has revision =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 branch


=cut

has branch =>
    (is => 'ro',
    );


=head4 tag


=cut

has tag =>
    (is => 'ro',
    );


}

package Cucumber::Messages::Product {
$Cucumber::Messages::Product::VERSION = '32.0.0';
=head2 Cucumber::Messages::Product

=head3 DESCRIPTION

Represents the Product message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

Used to describe various properties of Meta

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   name => 'string',
   version => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 name

The product name
=cut

has name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 version

The product version
=cut

has version =>
    (is => 'ro',
    );


}

package Cucumber::Messages::ParameterType {
$Cucumber::Messages::ParameterType::VERSION = '32.0.0';
=head2 Cucumber::Messages::ParameterType

=head3 DESCRIPTION

Represents the ParameterType message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   name => 'string',
   regular_expressions => '[]string',
   prefer_for_regular_expression_match => 'boolean',
   use_for_snippets => 'boolean',
   id => 'string',
   source_reference => 'Cucumber::Messages::SourceReference',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 name

The name is unique, so we don't need an id.
=cut

has name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 regular_expressions


=cut

has regular_expressions =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 prefer_for_regular_expression_match


=cut

has prefer_for_regular_expression_match =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 use_for_snippets


=cut

has use_for_snippets =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 id


=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 source_reference


=cut

has source_reference =>
    (is => 'ro',
    );


}

package Cucumber::Messages::ParseError {
$Cucumber::Messages::ParseError::VERSION = '32.0.0';
=head2 Cucumber::Messages::ParseError

=head3 DESCRIPTION

Represents the ParseError message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   source => 'Cucumber::Messages::SourceReference',
   message => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 source


=cut

has source =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::SourceReference->new() },
    );


=head4 message


=cut

has message =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::Pickle {
$Cucumber::Messages::Pickle::VERSION = '32.0.0';
=head2 Cucumber::Messages::Pickle

=head3 DESCRIPTION

Represents the Pickle message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A `Pickle` represents a template for a `TestCase`. It is typically derived
from another format, such as [GherkinDocument](#io.cucumber.messages.GherkinDocument).
In the future a `Pickle` may be derived from other formats such as Markdown or
Excel files.

By making `Pickle` the main data structure Cucumber uses for execution, the
implementation of Cucumber itself becomes simpler, as it doesn't have to deal
with the complex structure of a [GherkinDocument](#io.cucumber.messages.GherkinDocument).

Each `PickleStep` of a `Pickle` is matched with a `StepDefinition` to create a `TestCase`

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   id => 'string',
   uri => 'string',
   location => 'Cucumber::Messages::Location',
   name => 'string',
   language => 'string',
   steps => '[]Cucumber::Messages::PickleStep',
   tags => '[]Cucumber::Messages::PickleTag',
   ast_node_ids => '[]string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 id

A unique id for the pickle
=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 uri

The uri of the source file
=cut

has uri =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 location

The location of this pickle in source file. A pickle constructed from `Examples` will point to the example row.
=cut

has location =>
    (is => 'ro',
    );


=head4 name

The name of the pickle
=cut

has name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 language

The language of the pickle
=cut

has language =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 steps

One or more steps
=cut

has steps =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 tags

One or more tags. If this pickle is constructed from a Gherkin document,
It includes inherited tags from the `Feature` as well.
=cut

has tags =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 ast_node_ids

Points to the AST node locations of the pickle. The last one represents the unique
id of the pickle. A pickle constructed from `Examples` will have the first
id originating from the `Scenario` AST node, and the second from the `TableRow` AST node.
=cut

has ast_node_ids =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


}

package Cucumber::Messages::PickleDocString {
$Cucumber::Messages::PickleDocString::VERSION = '32.0.0';
=head2 Cucumber::Messages::PickleDocString

=head3 DESCRIPTION

Represents the PickleDocString message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   media_type => 'string',
   content => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 media_type


=cut

has media_type =>
    (is => 'ro',
    );


=head4 content


=cut

has content =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::PickleStep {
$Cucumber::Messages::PickleStep::VERSION = '32.0.0';
=head2 Cucumber::Messages::PickleStep

=head3 DESCRIPTION

Represents the PickleStep message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

An executable step

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   argument => 'Cucumber::Messages::PickleStepArgument',
   ast_node_ids => '[]string',
   id => 'string',
   type => '',
   text => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 argument


=cut

has argument =>
    (is => 'ro',
    );


=head4 ast_node_ids

References the IDs of the source of the step. For Gherkin, this can be
the ID of a Step, and possibly also the ID of a TableRow
=cut

has ast_node_ids =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 id

A unique ID for the PickleStep
=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 type

The context in which the step was specified: context (Given), action (When) or outcome (Then).

Note that the keywords `But` and `And` inherit their meaning from prior steps and the `*` 'keyword' doesn't have specific meaning (hence Unknown)

Available constants for valid values of this field:

=over

=item * TYPE_UNKNOWN

=item * TYPE_CONTEXT

=item * TYPE_ACTION

=item * TYPE_OUTCOME

=back

=cut


use constant {
   TYPE_UNKNOWN => 'Unknown',
   TYPE_CONTEXT => 'Context',
   TYPE_ACTION => 'Action',
   TYPE_OUTCOME => 'Outcome',
   };

has type =>
    (is => 'ro',
    );


=head4 text


=cut

has text =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::PickleStepArgument {
$Cucumber::Messages::PickleStepArgument::VERSION = '32.0.0';
=head2 Cucumber::Messages::PickleStepArgument

=head3 DESCRIPTION

Represents the PickleStepArgument message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

An optional argument

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   doc_string => 'Cucumber::Messages::PickleDocString',
   data_table => 'Cucumber::Messages::PickleTable',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 doc_string


=cut

has doc_string =>
    (is => 'ro',
    );


=head4 data_table


=cut

has data_table =>
    (is => 'ro',
    );


}

package Cucumber::Messages::PickleTable {
$Cucumber::Messages::PickleTable::VERSION = '32.0.0';
=head2 Cucumber::Messages::PickleTable

=head3 DESCRIPTION

Represents the PickleTable message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   rows => '[]Cucumber::Messages::PickleTableRow',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 rows


=cut

has rows =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


}

package Cucumber::Messages::PickleTableCell {
$Cucumber::Messages::PickleTableCell::VERSION = '32.0.0';
=head2 Cucumber::Messages::PickleTableCell

=head3 DESCRIPTION

Represents the PickleTableCell message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   value => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 value


=cut

has value =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::PickleTableRow {
$Cucumber::Messages::PickleTableRow::VERSION = '32.0.0';
=head2 Cucumber::Messages::PickleTableRow

=head3 DESCRIPTION

Represents the PickleTableRow message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   cells => '[]Cucumber::Messages::PickleTableCell',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 cells


=cut

has cells =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


}

package Cucumber::Messages::PickleTag {
$Cucumber::Messages::PickleTag::VERSION = '32.0.0';
=head2 Cucumber::Messages::PickleTag

=head3 DESCRIPTION

Represents the PickleTag message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A tag

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   name => 'string',
   ast_node_id => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 name


=cut

has name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 ast_node_id

Points to the AST node this was created from
=cut

has ast_node_id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::Source {
$Cucumber::Messages::Source::VERSION = '32.0.0';
=head2 Cucumber::Messages::Source

=head3 DESCRIPTION

Represents the Source message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A source file, typically a Gherkin document or Java/Ruby/JavaScript source code

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   uri => 'string',
   data => 'string',
   media_type => '',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 uri

The [URI](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier)
of the source, typically a file path relative to the root directory
=cut

has uri =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 data

The contents of the file
=cut

has data =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 media_type

The media type of the file. Can be used to specify custom types, such as
text/x.cucumber.gherkin+plain

Available constants for valid values of this field:

=over

=item * MEDIATYPE_TEXT_X_CUCUMBER_GHERKIN_PLAIN

=item * MEDIATYPE_TEXT_X_CUCUMBER_GHERKIN_MARKDOWN

=back

=cut


use constant {
   MEDIATYPE_TEXT_X_CUCUMBER_GHERKIN_PLAIN => 'text/x.cucumber.gherkin+plain',
   MEDIATYPE_TEXT_X_CUCUMBER_GHERKIN_MARKDOWN => 'text/x.cucumber.gherkin+markdown',
   };

has media_type =>
    (is => 'ro',
     required => 1,
     default => sub { MEDIATYPE_TEXT_X_CUCUMBER_GHERKIN_PLAIN },
    );


}

package Cucumber::Messages::SourceReference {
$Cucumber::Messages::SourceReference::VERSION = '32.0.0';
=head2 Cucumber::Messages::SourceReference

=head3 DESCRIPTION

Represents the SourceReference message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

Points to a [Source](#io.cucumber.messages.Source) identified by `uri` and a
[Location](#io.cucumber.messages.Location) within that file.

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   uri => 'string',
   java_method => 'Cucumber::Messages::JavaMethod',
   java_stack_trace_element => 'Cucumber::Messages::JavaStackTraceElement',
   location => 'Cucumber::Messages::Location',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 uri


=cut

has uri =>
    (is => 'ro',
    );


=head4 java_method


=cut

has java_method =>
    (is => 'ro',
    );


=head4 java_stack_trace_element


=cut

has java_stack_trace_element =>
    (is => 'ro',
    );


=head4 location


=cut

has location =>
    (is => 'ro',
    );


}

package Cucumber::Messages::JavaMethod {
$Cucumber::Messages::JavaMethod::VERSION = '32.0.0';
=head2 Cucumber::Messages::JavaMethod

=head3 DESCRIPTION

Represents the JavaMethod message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   class_name => 'string',
   method_name => 'string',
   method_parameter_types => '[]string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 class_name


=cut

has class_name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 method_name


=cut

has method_name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 method_parameter_types


=cut

has method_parameter_types =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


}

package Cucumber::Messages::JavaStackTraceElement {
$Cucumber::Messages::JavaStackTraceElement::VERSION = '32.0.0';
=head2 Cucumber::Messages::JavaStackTraceElement

=head3 DESCRIPTION

Represents the JavaStackTraceElement message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   class_name => 'string',
   file_name => 'string',
   method_name => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 class_name


=cut

has class_name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 file_name


=cut

has file_name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 method_name


=cut

has method_name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::StepDefinition {
$Cucumber::Messages::StepDefinition::VERSION = '32.0.0';
=head2 Cucumber::Messages::StepDefinition

=head3 DESCRIPTION

Represents the StepDefinition message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   id => 'string',
   pattern => 'Cucumber::Messages::StepDefinitionPattern',
   source_reference => 'Cucumber::Messages::SourceReference',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 id


=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 pattern


=cut

has pattern =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::StepDefinitionPattern->new() },
    );


=head4 source_reference


=cut

has source_reference =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::SourceReference->new() },
    );


}

package Cucumber::Messages::StepDefinitionPattern {
$Cucumber::Messages::StepDefinitionPattern::VERSION = '32.0.0';
=head2 Cucumber::Messages::StepDefinitionPattern

=head3 DESCRIPTION

Represents the StepDefinitionPattern message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   source => 'string',
   type => '',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 source


=cut

has source =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 type



Available constants for valid values of this field:

=over

=item * TYPE_CUCUMBER_EXPRESSION

=item * TYPE_REGULAR_EXPRESSION

=back

=cut


use constant {
   TYPE_CUCUMBER_EXPRESSION => 'CUCUMBER_EXPRESSION',
   TYPE_REGULAR_EXPRESSION => 'REGULAR_EXPRESSION',
   };

has type =>
    (is => 'ro',
     required => 1,
     default => sub { TYPE_CUCUMBER_EXPRESSION },
    );


}

package Cucumber::Messages::Suggestion {
$Cucumber::Messages::Suggestion::VERSION = '32.0.0';
=head2 Cucumber::Messages::Suggestion

=head3 DESCRIPTION

Represents the Suggestion message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A suggested fragment of code to implement an undefined step

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   id => 'string',
   pickle_step_id => 'string',
   snippets => '[]Cucumber::Messages::Snippet',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 id

A unique id for this suggestion
=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 pickle_step_id

The ID of the `PickleStep` this `Suggestion` was created for.
=cut

has pickle_step_id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 snippets

A collection of code snippets that could implement the undefined step
=cut

has snippets =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


}

package Cucumber::Messages::Snippet {
$Cucumber::Messages::Snippet::VERSION = '32.0.0';
=head2 Cucumber::Messages::Snippet

=head3 DESCRIPTION

Represents the Snippet message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   language => 'string',
   code => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 language

The programming language of the code.

This must be formatted as an all lowercase identifier such that syntax highlighters like [Prism](https://prismjs.com/#supported-languages) or [Highlight.js](https://github.com/highlightjs/highlight.js/blob/main/SUPPORTED_LANGUAGES.md) can recognize it.
For example: `cpp`, `cs`, `go`, `java`, `javascript`, `php`, `python`, `ruby`, `scala`.
=cut

has language =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 code

A snippet of code
=cut

has code =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::TestCase {
$Cucumber::Messages::TestCase::VERSION = '32.0.0';
=head2 Cucumber::Messages::TestCase

=head3 DESCRIPTION

Represents the TestCase message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A `TestCase` contains a sequence of `TestStep`s.

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   id => 'string',
   pickle_id => 'string',
   test_steps => '[]Cucumber::Messages::TestStep',
   test_run_started_id => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 id


=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 pickle_id

The ID of the `Pickle` this `TestCase` is derived from.
=cut

has pickle_id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 test_steps


=cut

has test_steps =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


=head4 test_run_started_id

Identifier for the test run that this test case belongs to
=cut

has test_run_started_id =>
    (is => 'ro',
    );


}

package Cucumber::Messages::Group {
$Cucumber::Messages::Group::VERSION = '32.0.0';
=head2 Cucumber::Messages::Group

=head3 DESCRIPTION

Represents the Group message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   children => '[]Cucumber::Messages::Group',
   start => 'number',
   value => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 children

The nested capture groups of an argument.
Absent if the group has no nested capture groups.
=cut

has children =>
    (is => 'ro',
    );


=head4 start


=cut

has start =>
    (is => 'ro',
    );


=head4 value


=cut

has value =>
    (is => 'ro',
    );


}

package Cucumber::Messages::StepMatchArgument {
$Cucumber::Messages::StepMatchArgument::VERSION = '32.0.0';
=head2 Cucumber::Messages::StepMatchArgument

=head3 DESCRIPTION

Represents the StepMatchArgument message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

Represents a single argument extracted from a step match and passed to a step definition.
This is used for the following purposes:
- Construct an argument to pass to a step definition (possibly through a parameter type transform)
- Highlight the matched parameter in rich formatters such as the HTML formatter

This message closely matches the `Argument` class in the `cucumber-expressions` library.

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   group => 'Cucumber::Messages::Group',
   parameter_type_name => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 group

Represents the outermost capture group of an argument. This message closely matches the
`Group` class in the `cucumber-expressions` library.
=cut

has group =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Group->new() },
    );


=head4 parameter_type_name


=cut

has parameter_type_name =>
    (is => 'ro',
    );


}

package Cucumber::Messages::StepMatchArgumentsList {
$Cucumber::Messages::StepMatchArgumentsList::VERSION = '32.0.0';
=head2 Cucumber::Messages::StepMatchArgumentsList

=head3 DESCRIPTION

Represents the StepMatchArgumentsList message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   step_match_arguments => '[]Cucumber::Messages::StepMatchArgument',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 step_match_arguments


=cut

has step_match_arguments =>
    (is => 'ro',
     required => 1,
     default => sub { [] },
    );


}

package Cucumber::Messages::TestStep {
$Cucumber::Messages::TestStep::VERSION = '32.0.0';
=head2 Cucumber::Messages::TestStep

=head3 DESCRIPTION

Represents the TestStep message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.

A `TestStep` is derived from either a `PickleStep` combined with a `StepDefinition`, or from a `Hook`.

When derived from a PickleStep:
 * For `UNDEFINED` steps `stepDefinitionIds` and `stepMatchArgumentsLists` will be empty.
 * For `AMBIGUOUS` steps, there will be multiple entries in `stepDefinitionIds` and `stepMatchArgumentsLists`. The first entry in the stepMatchArgumentsLists holds the list of arguments for the first matching step definition, the second entry for the second, etc

=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   hook_id => 'string',
   id => 'string',
   pickle_step_id => 'string',
   step_definition_ids => '[]string',
   step_match_arguments_lists => '[]Cucumber::Messages::StepMatchArgumentsList',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 hook_id

Pointer to the `Hook` (if derived from a Hook)
=cut

has hook_id =>
    (is => 'ro',
    );


=head4 id


=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 pickle_step_id

Pointer to the `PickleStep` (if derived from a `PickleStep`)
=cut

has pickle_step_id =>
    (is => 'ro',
    );


=head4 step_definition_ids

Pointer to all the matching `StepDefinition`s (if derived from a `PickleStep`).

Each element represents a matching step definition.
=cut

has step_definition_ids =>
    (is => 'ro',
    );


=head4 step_match_arguments_lists

A list of list of StepMatchArgument (if derived from a `PickleStep`).

Each element represents the arguments for a matching step definition.
=cut

has step_match_arguments_lists =>
    (is => 'ro',
    );


}

package Cucumber::Messages::TestCaseFinished {
$Cucumber::Messages::TestCaseFinished::VERSION = '32.0.0';
=head2 Cucumber::Messages::TestCaseFinished

=head3 DESCRIPTION

Represents the TestCaseFinished message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   test_case_started_id => 'string',
   timestamp => 'Cucumber::Messages::Timestamp',
   will_be_retried => 'boolean',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 test_case_started_id


=cut

has test_case_started_id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 timestamp


=cut

has timestamp =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Timestamp->new() },
    );


=head4 will_be_retried


=cut

has will_be_retried =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

package Cucumber::Messages::TestCaseStarted {
$Cucumber::Messages::TestCaseStarted::VERSION = '32.0.0';
=head2 Cucumber::Messages::TestCaseStarted

=head3 DESCRIPTION

Represents the TestCaseStarted message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   attempt => 'number',
   id => 'string',
   test_case_id => 'string',
   worker_id => 'string',
   timestamp => 'Cucumber::Messages::Timestamp',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 attempt

The first attempt should have value 0, and for each retry the value
should increase by 1.
=cut

has attempt =>
    (is => 'ro',
     required => 1,
     default => sub { 0 },
    );


=head4 id

Because a `TestCase` can be run multiple times (in case of a retry),
we use this field to group messages relating to the same attempt.
=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 test_case_id


=cut

has test_case_id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 worker_id

An identifier for the worker process running this test case, if test cases are being run in parallel. The identifier will be unique per worker, but no particular format is defined - it could be an index, uuid, machine name etc - and as such should be assumed that it's not human readable.
=cut

has worker_id =>
    (is => 'ro',
    );


=head4 timestamp


=cut

has timestamp =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Timestamp->new() },
    );


}

package Cucumber::Messages::TestRunFinished {
$Cucumber::Messages::TestRunFinished::VERSION = '32.0.0';
=head2 Cucumber::Messages::TestRunFinished

=head3 DESCRIPTION

Represents the TestRunFinished message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   message => 'string',
   success => 'boolean',
   timestamp => 'Cucumber::Messages::Timestamp',
   exception => 'Cucumber::Messages::Exception',
   test_run_started_id => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 message

An informative message about the test run. Typically additional information about failure, but not necessarily.
=cut

has message =>
    (is => 'ro',
    );


=head4 success

A test run is successful if all steps are either passed or skipped, all before/after hooks passed and no other exceptions where thrown.
=cut

has success =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 timestamp

Timestamp when the TestRun is finished
=cut

has timestamp =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Timestamp->new() },
    );


=head4 exception

Any exception thrown during the test run, if any. Does not include exceptions thrown while executing steps.
=cut

has exception =>
    (is => 'ro',
    );


=head4 test_run_started_id


=cut

has test_run_started_id =>
    (is => 'ro',
    );


}

package Cucumber::Messages::TestRunHookFinished {
$Cucumber::Messages::TestRunHookFinished::VERSION = '32.0.0';
=head2 Cucumber::Messages::TestRunHookFinished

=head3 DESCRIPTION

Represents the TestRunHookFinished message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   test_run_hook_started_id => 'string',
   result => 'Cucumber::Messages::TestStepResult',
   timestamp => 'Cucumber::Messages::Timestamp',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 test_run_hook_started_id

Identifier for the hook execution that has finished
=cut

has test_run_hook_started_id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 result


=cut

has result =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::TestStepResult->new() },
    );


=head4 timestamp


=cut

has timestamp =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Timestamp->new() },
    );


}

package Cucumber::Messages::TestRunHookStarted {
$Cucumber::Messages::TestRunHookStarted::VERSION = '32.0.0';
=head2 Cucumber::Messages::TestRunHookStarted

=head3 DESCRIPTION

Represents the TestRunHookStarted message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   id => 'string',
   test_run_started_id => 'string',
   hook_id => 'string',
   worker_id => 'string',
   timestamp => 'Cucumber::Messages::Timestamp',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 id

Unique identifier for this hook execution
=cut

has id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 test_run_started_id

Identifier for the test run that this hook execution belongs to
=cut

has test_run_started_id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 hook_id

Identifier for the hook that will be executed
=cut

has hook_id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 worker_id

An identifier for the worker process running this hook, if parallel workers are in use. The identifier will be unique per worker, but no particular format is defined - it could be an index, uuid, machine name etc - and as such should be assumed that it's not human readable.
=cut

has worker_id =>
    (is => 'ro',
    );


=head4 timestamp


=cut

has timestamp =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Timestamp->new() },
    );


}

package Cucumber::Messages::TestRunStarted {
$Cucumber::Messages::TestRunStarted::VERSION = '32.0.0';
=head2 Cucumber::Messages::TestRunStarted

=head3 DESCRIPTION

Represents the TestRunStarted message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   timestamp => 'Cucumber::Messages::Timestamp',
   id => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 timestamp


=cut

has timestamp =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Timestamp->new() },
    );


=head4 id


=cut

has id =>
    (is => 'ro',
    );


}

package Cucumber::Messages::TestStepFinished {
$Cucumber::Messages::TestStepFinished::VERSION = '32.0.0';
=head2 Cucumber::Messages::TestStepFinished

=head3 DESCRIPTION

Represents the TestStepFinished message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   test_case_started_id => 'string',
   test_step_id => 'string',
   test_step_result => 'Cucumber::Messages::TestStepResult',
   timestamp => 'Cucumber::Messages::Timestamp',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 test_case_started_id


=cut

has test_case_started_id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 test_step_id


=cut

has test_step_id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 test_step_result


=cut

has test_step_result =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::TestStepResult->new() },
    );


=head4 timestamp


=cut

has timestamp =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Timestamp->new() },
    );


}

package Cucumber::Messages::TestStepResult {
$Cucumber::Messages::TestStepResult::VERSION = '32.0.0';
=head2 Cucumber::Messages::TestStepResult

=head3 DESCRIPTION

Represents the TestStepResult message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   duration => 'Cucumber::Messages::Duration',
   message => 'string',
   status => '',
   exception => 'Cucumber::Messages::Exception',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 duration


=cut

has duration =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Duration->new() },
    );


=head4 message

An arbitrary bit of information that explains this result. If there was an exception, this should include a stringified representation of it including type, message and stack trace (the exact format will vary by platform).
=cut

has message =>
    (is => 'ro',
    );


=head4 status



Available constants for valid values of this field:

=over

=item * STATUS_UNKNOWN

=item * STATUS_PASSED

=item * STATUS_SKIPPED

=item * STATUS_PENDING

=item * STATUS_UNDEFINED

=item * STATUS_AMBIGUOUS

=item * STATUS_FAILED

=back

=cut


use constant {
   STATUS_UNKNOWN => 'UNKNOWN',
   STATUS_PASSED => 'PASSED',
   STATUS_SKIPPED => 'SKIPPED',
   STATUS_PENDING => 'PENDING',
   STATUS_UNDEFINED => 'UNDEFINED',
   STATUS_AMBIGUOUS => 'AMBIGUOUS',
   STATUS_FAILED => 'FAILED',
   };

has status =>
    (is => 'ro',
     required => 1,
     default => sub { STATUS_UNKNOWN },
    );


=head4 exception

Exception thrown while executing this step, if any.
=cut

has exception =>
    (is => 'ro',
    );


}

package Cucumber::Messages::TestStepStarted {
$Cucumber::Messages::TestStepStarted::VERSION = '32.0.0';
=head2 Cucumber::Messages::TestStepStarted

=head3 DESCRIPTION

Represents the TestStepStarted message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   test_case_started_id => 'string',
   test_step_id => 'string',
   timestamp => 'Cucumber::Messages::Timestamp',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 test_case_started_id


=cut

has test_case_started_id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 test_step_id


=cut

has test_step_id =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 timestamp


=cut

has timestamp =>
    (is => 'ro',
     required => 1,
     default => sub { Cucumber::Messages::Timestamp->new() },
    );


}

package Cucumber::Messages::Timestamp {
$Cucumber::Messages::Timestamp::VERSION = '32.0.0';
=head2 Cucumber::Messages::Timestamp

=head3 DESCRIPTION

Represents the Timestamp message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   seconds => 'number',
   nanos => 'number',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 seconds

Represents seconds of UTC time since Unix epoch
1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
9999-12-31T23:59:59Z inclusive.
=cut

has seconds =>
    (is => 'ro',
     required => 1,
     default => sub { 0 },
    );


=head4 nanos

Non-negative fractions of a second at nanosecond resolution. Negative
second values with fractions must still have non-negative nanos values
that count forward in time. Must be from 0 to 999,999,999
inclusive.
=cut

has nanos =>
    (is => 'ro',
     required => 1,
     default => sub { 0 },
    );


}

package Cucumber::Messages::UndefinedParameterType {
$Cucumber::Messages::UndefinedParameterType::VERSION = '32.0.0';
=head2 Cucumber::Messages::UndefinedParameterType

=head3 DESCRIPTION

Represents the UndefinedParameterType message in Cucumber's
L<message protocol|https://github.com/cucumber/messages>.



=head3 ATTRIBUTES

=cut

use Moo;
extends 'Cucumber::Messages::Message';

use Scalar::Util qw( blessed );

my %types = (
   expression => 'string',
   name => 'string',
);

# This is a work-around for the fact that Moo doesn't have introspection
# and Perl doesn't have boolean values...
sub _types {
    return \%types;
}



=head4 expression


=cut

has expression =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


=head4 name


=cut

has name =>
    (is => 'ro',
     required => 1,
     default => sub { '' },
    );


}

1;

__END__

=head1 LICENSE

Please see the included LICENSE for the canonical version. In summary:

The MIT License (MIT)

  Copyright (c) 2021 Erik Huelsmann
  Copyright (c) 2021 Cucumber Ltd

This work is loosely derived from prior work of the same library for Ruby,
called C<cucumber-messages>.

=cut
