package DBIx::QuickORM::Builder::Base;
use strict;
use warnings;

use Carp qw/croak/;

use DBIx::QuickORM::Util::HashBase qw{
    <build_type
    <build_class
    <attributes
};

sub init {
    my $self = shift;

    croak "'build_type' is a required attribute"  unless $self->build_type;
    croak "'build_class' is a required attribute" unless $self->build_class;

    $self->{+ATTRIBUTES} //= {};
}

sub get_attr { $_[0]->{+ATTRIBUTES}->{$_[1]} }
sub set_attr { $_[0]->{+ATTRIBUTES}->{$_[1]} = $_[2] }
sub def_attr { $_[0]->{+ATTRIBUTES}->{$_[1]} //= $_[2] }
sub del_attr { delete $_[0]->{+ATTRIBUTES}->{$_[1]} }
sub has_attr { exists $_[0]->{+ATTRIBUTES}->{$_[1]} }

sub builds {
    my $self = shift;
    my ($type) = @_;

    return 1 if $self->build_type eq $type;

    my $class = $self->build_class;

    return 1 if $class->isa($type);
    return 1 if $class->DOES($type);

    return 0;
}

sub build {
    my $self = shift;
    $self->build_class->new(%{$self->{+ATTRIBUTES}});
}

1;
