/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSOMObjectImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.Locatable;
import com.steadystate.css.userdata.UserDataConstants;
import com.steadystate.css.util.LangUtils;
import com.steadystate.css.util.ThrowCssExceptionErrorHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaListImpl
extends CSSOMObjectImpl
implements MediaList {
    private static final long serialVersionUID = 6662784733573034870L;
    private List<String> media_ = new ArrayList<String>();

    public MediaListImpl(SACMediaList mediaList) {
        Locator locator;
        this.setMediaList(mediaList);
        if (mediaList instanceof Locatable && (locator = ((Locatable)mediaList).getLocator()) != null) {
            this.setUserData(UserDataConstants.KEY_LOCATOR, locator);
        }
    }

    public MediaListImpl() {
    }

    @Override
    public String getMediaText() {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < this.media_.size(); ++i) {
            sb.append(this.media_.get(i));
            if (i >= this.media_.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public void setMediaText(String mediaText) throws DOMException {
        InputSource source = new InputSource((Reader)new StringReader(mediaText));
        try {
            CSSOMParser parser = new CSSOMParser();
            parser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            SACMediaList sml = parser.parseMedia(source);
            this.setMediaList(sml);
        }
        catch (CSSParseException e) {
            throw new DOMException(12, e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new DOMException(8, e.getLocalizedMessage());
        }
    }

    @Override
    public int getLength() {
        return this.media_.size();
    }

    @Override
    public String item(int index) {
        return index < this.media_.size() ? this.media_.get(index) : null;
    }

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        for (int i = 0; i < this.media_.size(); ++i) {
            String str = this.media_.get(i);
            if (!str.equalsIgnoreCase(oldMedium)) continue;
            this.media_.remove(i);
            return;
        }
        throw new DOMExceptionImpl(8, 18);
    }

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        this.media_.add(newMedium);
    }

    public String toString() {
        return this.getMediaText();
    }

    public void setMedia(List<String> media) {
        this.media_ = media;
    }

    private void setMediaList(SACMediaList mediaList) {
        for (int i = 0; i < mediaList.getLength(); ++i) {
            this.media_.add(mediaList.item(i));
        }
    }

    private boolean equalsMedia(MediaList ml) {
        if (ml == null || this.getLength() != ml.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            String m2;
            String m1 = this.item(i);
            if (LangUtils.equals(m1, m2 = ml.item(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MediaList)) {
            return false;
        }
        MediaList ml = (MediaList)obj;
        return super.equals(obj) && this.equalsMedia(ml);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.media_);
        return hash;
    }
}

