# Generated by default/object.tt
package Paws::Macie2::TagValuePair;
  use Moose;
  has Key => (is => 'ro', isa => 'Str', request_name => 'key', traits => ['NameInRequest']);
  has Value => (is => 'ro', isa => 'Str', request_name => 'value', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::TagValuePair

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::TagValuePair object:

  $service_obj->Method(Att1 => { Key => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::TagValuePair object:

  $result = $service_obj->Method(...);
  $result->Att1->Key

=head1 DESCRIPTION

Specifies a tag key or tag key and value pair to use in a tag-based
condition that determines whether an S3 object is included or excluded
from a classification job. Tag keys and values are case sensitive.
Also, Amazon Macie doesn't support use of partial values or wildcard
characters in tag-based conditions.

=head1 ATTRIBUTES


=head2 Key => Str

The value for the tag key to use in the condition.


=head2 Value => Str

The tag value, associated with the specified tag key (key), to use in
the condition. To specify only a tag key for a condition, specify the
tag key for the key property and set this value to an empty string.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

