/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.Formatable;

public final class FormatableBitSet
implements Formatable,
Cloneable {
    private byte[] value;
    private short bitsInLastByte;
    private transient int lengthAsBits;
    private static char[] decodeArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public FormatableBitSet() {
    }

    public FormatableBitSet(int n) {
        this.initializeBits(n);
    }

    private void initializeBits(int n) {
        int n2 = FormatableBitSet.numBytesFromBits(n);
        this.value = new byte[n2];
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n);
        this.lengthAsBits = n;
    }

    public FormatableBitSet(byte[] byArray) {
        this.value = byArray;
        this.bitsInLastByte = (short)8;
        this.lengthAsBits = this.calculateLength(byArray.length);
    }

    public FormatableBitSet(byte[] byArray, int n) {
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n);
        this.lengthAsBits = n;
        int n2 = FormatableBitSet.numBytesFromBits(n);
        if (n2 == byArray.length) {
            this.value = byArray;
        } else {
            this.value = new byte[n2];
            System.arraycopy(byArray, 0, this.value, 0, byArray.length);
        }
    }

    public FormatableBitSet(FormatableBitSet formatableBitSet) {
        this.bitsInLastByte = formatableBitSet.bitsInLastByte;
        this.lengthAsBits = formatableBitSet.lengthAsBits;
        int n = FormatableBitSet.numBytesFromBits(formatableBitSet.lengthAsBits);
        this.value = new byte[n];
        if (n > 0) {
            System.arraycopy(formatableBitSet.value, 0, this.value, 0, n);
        }
    }

    public Object clone() {
        return new FormatableBitSet(this);
    }

    public int getLengthInBytes() {
        if (this.value == null) {
            return 0;
        }
        return FormatableBitSet.numBytesFromBits(this.lengthAsBits);
    }

    public int getLength() {
        return this.lengthAsBits;
    }

    private int calculateLength(int n) {
        if (n == 0) {
            return 0;
        }
        return (n - 1) * 8 + this.bitsInLastByte;
    }

    public int size() {
        return this.getLength();
    }

    public byte[] getByteArray() {
        if (this.value == null) {
            return null;
        }
        int n = this.getLengthInBytes();
        if (this.value.length != n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.value, 0, byArray, 0, n);
            this.value = byArray;
        }
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public void grow(int n) {
        if (n <= this.getLength()) {
            return;
        }
        if (this.value == null) {
            this.initializeBits(n);
            return;
        }
        int n2 = n - this.getLength();
        int n3 = this.getLengthInBytes();
        if (n3 != 0 && 8 - this.bitsInLastByte >= n2) {
            this.bitsInLastByte = (short)(this.bitsInLastByte + n2);
            this.lengthAsBits = n;
            return;
        }
        int n4 = FormatableBitSet.numBytesFromBits(n);
        if (n4 <= this.value.length) {
            for (int i = n3; i < n4; ++i) {
                this.value[i] = 0;
            }
        } else {
            byte[] byArray = new byte[n4];
            System.arraycopy(this.value, 0, byArray, 0, n3);
            this.value = byArray;
        }
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n);
        this.lengthAsBits = n;
    }

    public FormatableBitSet shrink(int n) {
        if (n >= this.getLength()) {
            return this;
        }
        int n2 = FormatableBitSet.numBytesFromBits(n) - 1;
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n);
        this.lengthAsBits = n;
        if (this.bitsInLastByte != 8) {
            int n3 = n2;
            this.value[n3] = (byte)(this.value[n3] & 65280 >> this.bitsInLastByte);
        }
        return this;
    }

    public boolean equals(FormatableBitSet formatableBitSet) {
        if (this.getLength() != formatableBitSet.getLength()) {
            return false;
        }
        return this.compare(formatableBitSet) == 0;
    }

    public int compare(FormatableBitSet formatableBitSet) {
        int n;
        byte[] byArray = formatableBitSet.value;
        if (this.value == null || byArray == null) {
            if (this.value != null) {
                return 1;
            }
            if (byArray != null) {
                return -1;
            }
            return 0;
        }
        int n2 = formatableBitSet.getLengthInBytes();
        int n3 = this.getLengthInBytes();
        int n4 = 0;
        for (n = 0; n4 < n2 && n < n3 && byArray[n4] == this.value[n]; ++n4, ++n) {
        }
        if (n4 == n2 && n == n3) {
            if (this.getLength() == formatableBitSet.getLength()) {
                return 0;
            }
            return formatableBitSet.getLength() < this.getLength() ? 1 : -1;
        }
        if (n4 == n2) {
            return 1;
        }
        if (n == n3) {
            return -1;
        }
        int n5 = byArray[n4];
        int n6 = this.value[n];
        return (n6 &= 0xFF) > (n5 &= 0xFF) ? 1 : -1;
    }

    public FormatableBitSet concatenate(FormatableBitSet formatableBitSet) {
        int n;
        int n2 = this.getLength();
        int n3 = this.getLengthInBytes();
        int n4 = formatableBitSet.getLength();
        byte[] byArray = formatableBitSet.getByteArray();
        int n5 = formatableBitSet.getLengthInBytes();
        int n6 = n2 + n4;
        int n7 = FormatableBitSet.numBytesFromBits(n6);
        byte[] byArray2 = new byte[n7];
        for (n = 0; n < n3; ++n) {
            byArray2[n] = this.value[n];
        }
        int n8 = n2 == 0 ? 8 : (int)this.bitsInLastByte;
        int n9 = 0;
        while (n9 < n5) {
            if (n8 == 8) {
                byArray2[n] = byArray[n9];
            } else {
                int n10 = byArray[n9];
                int n11 = n - 1;
                byArray2[n11] = (byte)(byArray2[n11] | (n10 &= 0xFF) >>> n8);
                if (n < n7) {
                    int n12 = n;
                    byArray2[n12] = (byte)(byArray2[n12] | n10 << 8 - n8);
                }
            }
            ++n9;
            ++n;
        }
        return new FormatableBitSet(byArray2, n6);
    }

    public int hashCode() {
        if (null == this.value) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.getLengthInBytes();
        for (int i = 0; i < n3; ++i) {
            n ^= (this.value[i] & 0xFF) << n2;
            if (32 > (n2 += 8)) continue;
            n2 = 0;
        }
        return n;
    }

    public final boolean isSet(int n) {
        try {
            int n2 = n / 8;
            int n3 = 7 - n % 8;
            return (this.value[n2] & 1 << n3) != 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public final boolean get(int n) {
        return this.isSet(n);
    }

    public void set(int n) {
        if (n >= this.getLength()) {
            this.grow(n);
        }
        int n2 = n / 8;
        int n3 = 7 - n % 8;
        int n4 = n2;
        this.value[n4] = (byte)(this.value[n4] | 1 << n3);
    }

    public void clear(int n) {
        if (n >= this.getLength()) {
            this.grow(n);
        }
        int n2 = n / 8;
        int n3 = 7 - n % 8;
        int n4 = n2;
        this.value[n4] = (byte)(this.value[n4] & ~(1 << n3));
    }

    public void clear() {
        if (this.value == null) {
            return;
        }
        int n = this.getLengthInBytes();
        for (int i = 0; i < n; ++i) {
            this.value[i] = 0;
        }
    }

    protected static int numBytesFromBits(int n) {
        return n == 0 ? 0 : (n - 1) / 8 + 1;
    }

    private static short numBitsInLastByte(int n) {
        int n2 = n % 8;
        return (short)(n2 == 0 ? (n == 0 ? 0 : 8) : n2);
    }

    private static byte hexCharToByte(char c) {
        byte by;
        switch (c) {
            case '0': {
                by = 0;
                break;
            }
            case '1': {
                by = 1;
                break;
            }
            case '2': {
                by = 2;
                break;
            }
            case '3': {
                by = 3;
                break;
            }
            case '4': {
                by = 4;
                break;
            }
            case '5': {
                by = 5;
                break;
            }
            case '6': {
                by = 6;
                break;
            }
            case '7': {
                by = 7;
                break;
            }
            case '8': {
                by = 8;
                break;
            }
            case '9': {
                by = 9;
                break;
            }
            case 'A': 
            case 'a': {
                by = 10;
                break;
            }
            case 'B': 
            case 'b': {
                by = 11;
                break;
            }
            case 'C': 
            case 'c': {
                by = 12;
                break;
            }
            case 'D': 
            case 'd': {
                by = 13;
                break;
            }
            case 'E': 
            case 'e': {
                by = 14;
                break;
            }
            case 'F': 
            case 'f': {
                by = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return by;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.getLength() * 8 * 3);
        stringBuffer.append("{");
        boolean bl = true;
        for (int i = 0; i < this.getLength(); ++i) {
            if (!this.isSet(i)) continue;
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(i);
        }
        stringBuffer.append("}");
        return new String(stringBuffer);
    }

    public static int maxBitsForSpace(int n) {
        return (n - 4) * 8;
    }

    public int anySetBit() {
        int n;
        int n2;
        int n3;
        int n4 = this.getLengthInBytes();
        for (n3 = 0; n3 < n4 - 1; ++n3) {
            if (this.value[n3] == 0) continue;
            for (n2 = 0; n2 < 8; ++n2) {
                n = 7 - n2;
                if ((1 << n & this.value[n3]) == 0) continue;
                return n3 * 8 + n2;
            }
        }
        n3 = (byte)(255 << 8 - this.bitsInLastByte);
        if ((this.value[n4 - 1] & n3) != 0) {
            for (n2 = 0; n2 < this.bitsInLastByte; ++n2) {
                n = 7 - n2;
                if ((1 << n & this.value[n4 - 1]) == 0) continue;
                return (n4 - 1) * 8 + n2;
            }
        }
        return -1;
    }

    public int anySetBit(int n) {
        int n2;
        int n3;
        int n4 = n + 1;
        if (n4 >= this.getLength()) {
            return -1;
        }
        int n5 = this.getLengthInBytes();
        int n6 = n4 / 8;
        int n7 = n4 % 8;
        byte by = (byte)(255 >> n7);
        if (n6 == n5 - 1) {
            by = (byte)(by & (byte)(255 << 8 - this.bitsInLastByte));
        }
        if ((this.value[n6] & by) != 0) {
            for (n3 = n7; n3 < 8; ++n3) {
                n2 = 7 - n3;
                if ((1 << n2 & this.value[n6]) == 0) continue;
                return n6 * 8 + n3;
            }
        }
        for (n3 = n6 + 1; n3 < n5 - 1; ++n3) {
            if (this.value[n3] == 0) continue;
            for (int i = 0; i < 8; ++i) {
                n2 = 7 - i;
                if ((1 << n2 & this.value[n3]) == 0) continue;
                return n3 * 8 + i;
            }
        }
        if (n6 != n5 - 1 && (this.value[n5 - 1] & (by = (byte)(255 << 8 - this.bitsInLastByte))) != 0) {
            for (n3 = 0; n3 < this.bitsInLastByte; ++n3) {
                n2 = 7 - n3;
                if ((1 << n2 & this.value[n5 - 1]) == 0) continue;
                return (n5 - 1) * 8 + n3;
            }
        }
        return -1;
    }

    public void or(FormatableBitSet formatableBitSet) {
        if (formatableBitSet == null || formatableBitSet.getLength() == 0) {
            return;
        }
        int n = formatableBitSet.getLength();
        if (n > this.getLength()) {
            this.grow(n);
        }
        if (formatableBitSet instanceof FormatableBitSet) {
            int n2;
            FormatableBitSet formatableBitSet2 = formatableBitSet;
            int n3 = formatableBitSet2.getLengthInBytes();
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                int n4 = n2;
                this.value[n4] = (byte)(this.value[n4] | formatableBitSet2.value[n2]);
            }
            for (n2 = (n3 - 1) * 8; n2 < n; ++n2) {
                if (!formatableBitSet.isSet(n2)) continue;
                this.set(n2);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!formatableBitSet.isSet(i)) continue;
                this.set(i);
            }
        }
    }

    public void and(FormatableBitSet formatableBitSet) {
        int n;
        int n2;
        int n3 = formatableBitSet.getLength();
        if (n3 > this.getLength()) {
            this.grow(n3);
        }
        if (n3 < this.getLength()) {
            int n4;
            n2 = n3 * 8 + 1;
            n = this.getLengthInBytes();
            for (n4 = n2; n4 < n; ++n4) {
                this.value[n4] = 0;
            }
            for (n4 = n3; n4 < n2 * 8 && n4 < this.getLength(); ++n4) {
                this.clear(n4);
            }
        }
        if (n3 == 0) {
            return;
        }
        n2 = formatableBitSet.getLengthInBytes() < this.getLengthInBytes() ? formatableBitSet.getLengthInBytes() : this.getLengthInBytes();
        for (n = 0; n < n2; ++n) {
            int n5 = n;
            this.value[n5] = (byte)(this.value[n5] & formatableBitSet.value[n]);
        }
    }

    public void xor(FormatableBitSet formatableBitSet) {
        int n;
        int n2 = n = formatableBitSet.getLength();
        while (n2-- > 0) {
            if (this.isSet(n2) && formatableBitSet.isSet(n2)) {
                this.clear(n2);
                continue;
            }
            if (!this.isSet(n2) && !formatableBitSet.isSet(n2)) continue;
            this.set(n2);
        }
    }

    public int getNumBitsSet() {
        int n = 0;
        for (int i = this.getLength() - 1; i >= 0; --i) {
            if (!this.isSet(i)) continue;
            ++n;
        }
        return n;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.getLength());
        int n = this.getLengthInBytes();
        if (n > 0) {
            objectOutput.write(this.value, 0, n);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        int n2 = FormatableBitSet.numBytesFromBits(n);
        this.value = new byte[n2];
        objectInput.readFully(this.value);
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n);
        this.lengthAsBits = n;
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        int n = arrayInputStream.readInt();
        int n2 = FormatableBitSet.numBytesFromBits(n);
        this.value = new byte[n2];
        arrayInputStream.readFully(this.value);
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n);
        this.lengthAsBits = n;
    }

    public int getTypeFormatId() {
        return 269;
    }
}

