/* CleanExit.c
 * This file is part of the LaBrea package
 *
 * Copyright (C) 2001, 2002 Tom Liston <tliston@premmag.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "labrea.h"

static void LogPrint(char *output) {
  extern int oflag;

  if(oflag)
    puts(output);
  else
    syslog(INFOTYPE, output);
}

void CleanExit(int sig) {
  extern struct kotb *nkotbstart;
  extern struct ignore_ip *ignorelist;
  extern int logopen;
  extern pcap_t *pc;
  extern char mybuffer[];
  extern u_int *addr_array;
  extern time_t *time_array;
  extern u_char *exclusion;
  extern struct libnet_link_int *plnk;
  extern char str1[], str3[];
#ifdef WIN32
  extern int boolThread;
  extern int pflag;
#else
  extern char str2[];
#endif
  struct pcap_stat stat;
  struct kotb *p, *t;
  struct ignore_ip *iip, *tempiip;

  /* show 'em some stats... */
  if((logopen) && (pc != NULL)) {
    if(pcap_stats(pc, &stat) >= 0) {
      sprintf(mybuffer, str1, stat.ps_recv, stat.ps_drop);
      LogPrint(mybuffer);
    }
  }
#ifndef WIN32
  if(sig == SIGHUP) {
    FixArrays(1);
    LogPrint(str2);
    return;
  }
#else
  WSACleanup();
  if(pflag && boolThread){
    boolThread = 0;
    while(!boolThread);
  }
#endif
  /* free up our arrays */
  if(addr_array != NULL)
    MYFREE(addr_array);
  if(time_array != NULL)
    MYFREE(time_array);
  if(exclusion != NULL)
    MYFREE(exclusion);
  /* free our list memory */
  for(p = nkotbstart; p; p = t){
    t = p->next;
    MYFREE(p);
  }
  for(iip = ignorelist; iip; iip = tempiip){
    tempiip = iip->next;
    MYFREE(iip);
  }
  /* shut down syslog connection */
  if(logopen)
    closelog();
  /* clean up our pcap stuff */
  if(pc != NULL)
    pcap_close(pc);
  /* clean up our libnet stuff */
  if(plnk != NULL)
    libnet_close_link_interface(plnk);
  LogPrint(str3);
  exit(0);
}
