package Foo::Root; # $Id$
use strict;

=head1 NAME

Foo::Root - Root controller

=head1 VERSION

Version 1.00

=head1 DESCRIPTION

Root controller

=cut

use WWW::MLite::Util;
use CTK::Util qw/ :BASE :FORMAT /;
use CTK::ConfGenUtil;
use Data::Dumper; #$Data::Dumper::Deparse = 1;

sub meta {(
    default => { #  (   )
        handler => {
            access  => sub {1},,
            form    => [ \&Foo::before_view, \&root_form, \&Foo::after_view, ],
            deny    => sub {1},
            chck    => sub {1},
            proc    => sub {1},
        },
        description  => "Root controller, default action",
        #contenttype        => "text/plain; charset=utf-8",
        #tplfile            => 'admin',
        #tplprefix          => 'shtml',
        #tplsuffix          => '.shtml',
        #tpltime            => 0,
        #session_enable     => 1,
        #mysql_mybase_enable=> 1,
        #oracle_prod_enable => 1,
    },
    demo => { #  
        handler => {
            access  => sub {1},
            form    => [ \&Foo::before_view, sub {1}, \&Foo::after_view, ],
            deny    => sub {1},
            chck    => sub {1},
            proc    => sub {1},
        },
        description => "Demo page",
    },
    info => { # Info/Status controller
        handler => {
            access  => \&Foo::access,
            form    => [ \&Foo::before_view, \&info_form, \&Foo::after_view, ],
            deny    => \&Foo::deny,
            chck    => sub {1},
            proc    => sub {1},
        },
        description => "Info/Status controller",
        session_enable => 1,
    },
)}

sub root_form {
    my $self = shift;
    my $template    = $self->template;
    my $h           = $self->h;
    my $records     = $self->get_recs(); #   

    $h->{records} = scalar(keys(%$records));
    
    my $recs_box = $template->start("recs");
    foreach (sort(keys(%$records))) {
        $recs_box->loop(
            name    => $_,
            description => value($records->{$_}, "description"),
            module  => value($records->{$_}, "module"),
        );
    }
    $recs_box->finish;
        
    1;
}
sub info_form {
    my $self = shift;
    my $q = $self->q;
    my $h = $self->h;
    
    $h->{module}    = $self->module;
    $h->{sid}       = $self->config->sid;
    ($h->{object}, $h->{event}) = ($self->actObject(),$self->actEvent());
    $h->{params}    = join("; ", @_) || '';
    
    $h->{self}      = tag(Dumper($self));
    $h->{record}    = tag(Dumper($self->get_rec($self->actObject())));

    1;
}


1;

__END__
sub foo1_access {
    warn ">> Access hook";
    return 1;
}
sub foo1_form1 {
    warn ">> Form hook 1";
    return 1;
}
sub foo1_form2 {
    warn ">> Form hook 2";
    return 302;
}
sub foo1_form3 {
    warn ">> Form hook 3";
    return 1;
}

sub foo1_deny {
    warn ">> Deny hook";
    return 1;
}
sub foo1_chck {
    warn ">> Chck hook";
    return 1;
}
sub foo1_proc {
    warn ">> Proc hook";
    return 1;
}
   
