# UPDATER

The updater tool provides a unified way to update directory structures
containing multiple version-controlled projects (e.g., Git, SVN, etc.).
With a single command, users can synchronize all subdirectories to their
latest state by automatically executing update commands such as git pull
or svn up in each repository. This simplifies and automates the process
of keeping multiple projects up to date.

## CUSTOM UPDATING

If any subdirectory contains a file named `.updater` with a list of commands
to execute, that directory will take priority during processing, even if it
contains system subdirectories such as `.svn`, `.git`, or others.

All commands listed in the `.updater` file must be executed strictly in
the specified order.

If the `.updater` file is empty or contains no commands, the directory will be
skipped. This allows you to explicitly disable processing of certain directories,
even if they contain system subdirectories such as `.git`, `.svn`, or others.

## CLONING WORKING STRUCTURE

If you have a new workstation (desktop, laptop, etc.),
you can clone your working environment by performing the following steps:

1. In the source directory, run:

```bash
make clean
updater -l
```

2. Copy the generated `.updater.yml` file from the source directory -
the one you intend to clone from - to the target directory on the new workstation.
The project structure will be restored from the repositories specified in
`.updater.yml`.

3. Switch to the target directory on the new workstation and run:

```bash
updater restore
```

After completing these steps, the entire project structure identical to the original
will be recreated. This significantly reduces the time required to clone
all your projects onto a new workstation.

Note that if any project contains a custom "updater" (a `.updater` file),
that directory will not be cloned automatically and must be cloned manually.

