/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpMethods;
import org.eclipse.jetty.http.HttpVersions;
import org.eclipse.jetty.http.Parser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.BufferUtil;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.View;
import org.eclipse.jetty.io.bio.StreamEndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpParser
implements Parser {
    private static final Logger LOG = Log.getLogger(HttpParser.class);
    public static final int STATE_START = -14;
    public static final int STATE_FIELD0 = -13;
    public static final int STATE_SPACE1 = -12;
    public static final int STATE_STATUS = -11;
    public static final int STATE_URI = -10;
    public static final int STATE_SPACE2 = -9;
    public static final int STATE_END0 = -8;
    public static final int STATE_END1 = -7;
    public static final int STATE_FIELD2 = -6;
    public static final int STATE_HEADER = -5;
    public static final int STATE_HEADER_NAME = -4;
    public static final int STATE_HEADER_IN_NAME = -3;
    public static final int STATE_HEADER_VALUE = -2;
    public static final int STATE_HEADER_IN_VALUE = -1;
    public static final int STATE_END = 0;
    public static final int STATE_EOF_CONTENT = 1;
    public static final int STATE_CONTENT = 2;
    public static final int STATE_CHUNKED_CONTENT = 3;
    public static final int STATE_CHUNK_SIZE = 4;
    public static final int STATE_CHUNK_PARAMS = 5;
    public static final int STATE_CHUNK = 6;
    public static final int STATE_SEEKING_EOF = 7;
    private final EventHandler _handler;
    private final Buffers _buffers;
    private final EndPoint _endp;
    private Buffer _header;
    private Buffer _body;
    private Buffer _buffer;
    private BufferCache.CachedBuffer _cached;
    private final View.CaseInsensitive _tok0;
    private final View.CaseInsensitive _tok1;
    private String _multiLineValue;
    private int _responseStatus;
    private boolean _forceContentBuffer;
    private boolean _persistent;
    protected final View _contentView = new View();
    protected int _state = -14;
    protected byte _eol;
    protected int _length;
    protected long _contentLength;
    protected long _contentPosition;
    protected int _chunkLength;
    protected int _chunkPosition;
    private boolean _headResponse;

    public HttpParser(Buffer buffer, EventHandler handler) {
        this._endp = null;
        this._buffers = null;
        this._header = buffer;
        this._buffer = buffer;
        this._handler = handler;
        this._tok0 = new View.CaseInsensitive(this._header);
        this._tok1 = new View.CaseInsensitive(this._header);
    }

    public HttpParser(Buffers buffers, EndPoint endp, EventHandler handler) {
        this._buffers = buffers;
        this._endp = endp;
        this._handler = handler;
        this._tok0 = new View.CaseInsensitive();
        this._tok1 = new View.CaseInsensitive();
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public long getContentRead() {
        return this._contentPosition;
    }

    public void setHeadResponse(boolean head) {
        this._headResponse = head;
    }

    public int getState() {
        return this._state;
    }

    public boolean inContentState() {
        return this._state > 0;
    }

    public boolean inHeaderState() {
        return this._state < 0;
    }

    public boolean isChunking() {
        return this._contentLength == -2L;
    }

    @Override
    public boolean isIdle() {
        return this.isState(-14);
    }

    @Override
    public boolean isComplete() {
        return this.isState(0);
    }

    @Override
    public boolean isMoreInBuffer() throws IOException {
        return this._header != null && this._header.hasContent() || this._body != null && this._body.hasContent();
    }

    public boolean isState(int state) {
        return this._state == state;
    }

    @Override
    public boolean isPersistent() {
        return this._persistent;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
        if (!(this._persistent || this._state != 0 && this._state != -14)) {
            this._state = 7;
        }
    }

    public void parse() throws IOException {
        if (this._state == 0) {
            this.reset();
        }
        if (this._state != -14) {
            throw new IllegalStateException("!START");
        }
        while (this._state != 0) {
            if (this.parseNext() >= 0) continue;
            return;
        }
    }

    @Override
    public boolean parseAvailable() throws IOException {
        boolean progress;
        boolean bl = progress = this.parseNext() > 0;
        while (!this.isComplete() && this._buffer != null && this._buffer.length() > 0 && !this._contentView.hasContent()) {
            progress |= this.parseNext() > 0;
        }
        return progress;
    }

    public int parseNext() throws IOException {
        try {
            byte ch;
            int progress = 0;
            if (this._state == 0) {
                return 0;
            }
            if (this._buffer == null) {
                this._buffer = this.getHeaderBuffer();
            }
            if (this._state == 2 && this._contentPosition == this._contentLength) {
                this._state = 0;
                this._handler.messageComplete(this._contentPosition);
                return 1;
            }
            int length = this._buffer.length();
            if (length == 0) {
                int filled = -1;
                IOException ex = null;
                try {
                    filled = this.fill();
                    LOG.debug("filled {}/{}", new Object[]{filled, this._buffer.length()});
                }
                catch (IOException e) {
                    LOG.debug(this.toString(), (Throwable)e);
                    ex = e;
                }
                if (filled > 0) {
                    ++progress;
                } else if (filled < 0) {
                    this._persistent = false;
                    if (this._state > 0 && this._buffer.length() > 0 && !this._headResponse) {
                        Buffer chunk = this._buffer.get(this._buffer.length());
                        this._contentPosition += (long)chunk.length();
                        this._contentView.update(chunk);
                        this._handler.content(chunk);
                    }
                    switch (this._state) {
                        case 0: 
                        case 7: {
                            this._state = 0;
                            break;
                        }
                        case 1: {
                            this._state = 0;
                            this._handler.messageComplete(this._contentPosition);
                            break;
                        }
                        default: {
                            this._state = 0;
                            if (!this._headResponse) {
                                this._handler.earlyEOF();
                            }
                            this._handler.messageComplete(this._contentPosition);
                        }
                    }
                    if (ex != null) {
                        throw ex;
                    }
                    if (!this.isComplete() && !this.isIdle()) {
                        throw new EofException();
                    }
                    return -1;
                }
                length = this._buffer.length();
            }
            byte[] array = this._buffer.array();
            int last = this._state;
            while (this._state < 0 && length-- > 0) {
                if (last != this._state) {
                    ++progress;
                    last = this._state;
                }
                ch = this._buffer.get();
                if (this._eol == 13) {
                    if (ch == 10) {
                        this._eol = (byte)10;
                        continue;
                    }
                    throw new HttpException(400);
                }
                this._eol = 0;
                block7 : switch (this._state) {
                    case -14: {
                        this._contentLength = -3L;
                        this._cached = null;
                        if (ch <= 32 && ch >= 0) break;
                        this._buffer.mark();
                        this._state = -13;
                        break;
                    }
                    case -13: {
                        if (ch == 32) {
                            this._tok0.update(this._buffer.markIndex(), this._buffer.getIndex() - 1);
                            this._responseStatus = HttpVersions.CACHE.get((Buffer)this._tok0) == null ? -1 : 0;
                            this._state = -12;
                            break;
                        }
                        if (ch >= 32 || ch < 0) break;
                        throw new HttpException(400);
                    }
                    case -12: {
                        if (ch > 32 || ch < 0) {
                            this._buffer.mark();
                            if (this._responseStatus >= 0) {
                                this._state = -11;
                                this._responseStatus = ch - 48;
                                break;
                            }
                            this._state = -10;
                            break;
                        }
                        if (ch >= 32) break;
                        throw new HttpException(400);
                    }
                    case -11: {
                        if (ch == 32) {
                            this._tok1.update(this._buffer.markIndex(), this._buffer.getIndex() - 1);
                            this._state = -9;
                            break;
                        }
                        if (ch >= 48 && ch <= 57) {
                            this._responseStatus = this._responseStatus * 10 + (ch - 48);
                            break;
                        }
                        if (ch < 32 && ch >= 0) {
                            this._handler.startResponse(HttpMethods.CACHE.lookup((Buffer)this._tok0), this._responseStatus, null);
                            this._eol = ch;
                            this._state = -5;
                            this._tok0.setPutIndex(this._tok0.getIndex());
                            this._tok1.setPutIndex(this._tok1.getIndex());
                            this._multiLineValue = null;
                            break;
                        }
                        this._state = -10;
                        this._responseStatus = -1;
                        break;
                    }
                    case -10: {
                        if (ch == 32) {
                            this._tok1.update(this._buffer.markIndex(), this._buffer.getIndex() - 1);
                            this._state = -9;
                            break;
                        }
                        if (ch >= 32 || ch < 0) break;
                        this._handler.startRequest(HttpMethods.CACHE.lookup((Buffer)this._tok0), this._buffer.sliceFromMark(), null);
                        this._persistent = false;
                        this._state = 7;
                        this._handler.headerComplete();
                        this._handler.messageComplete(this._contentPosition);
                        return 1;
                    }
                    case -9: {
                        if (ch > 32 || ch < 0) {
                            this._buffer.mark();
                            this._state = -6;
                            break;
                        }
                        if (ch >= 32) break;
                        if (this._responseStatus > 0) {
                            this._handler.startResponse(HttpMethods.CACHE.lookup((Buffer)this._tok0), this._responseStatus, null);
                            this._eol = ch;
                            this._state = -5;
                            this._tok0.setPutIndex(this._tok0.getIndex());
                            this._tok1.setPutIndex(this._tok1.getIndex());
                            this._multiLineValue = null;
                            break;
                        }
                        this._handler.startRequest(HttpMethods.CACHE.lookup((Buffer)this._tok0), (Buffer)this._tok1, null);
                        this._persistent = false;
                        this._state = 7;
                        this._handler.headerComplete();
                        this._handler.messageComplete(this._contentPosition);
                        return 1;
                    }
                    case -6: {
                        Buffer version;
                        if (ch != 13 && ch != 10) break;
                        if (this._responseStatus > 0) {
                            version = HttpVersions.CACHE.lookup((Buffer)this._tok0);
                            this._handler.startResponse(version, this._responseStatus, this._buffer.sliceFromMark());
                        } else {
                            version = HttpVersions.CACHE.lookup(this._buffer.sliceFromMark());
                            this._handler.startRequest(HttpMethods.CACHE.lookup((Buffer)this._tok0), (Buffer)this._tok1, version);
                        }
                        this._eol = ch;
                        this._persistent = HttpVersions.CACHE.getOrdinal(version) >= 11;
                        this._state = -5;
                        this._tok0.setPutIndex(this._tok0.getIndex());
                        this._tok1.setPutIndex(this._tok1.getIndex());
                        this._multiLineValue = null;
                        break;
                    }
                    case -5: {
                        switch (ch) {
                            case 9: 
                            case 32: 
                            case 58: {
                                this._length = -1;
                                this._state = -2;
                                break block7;
                            }
                        }
                        if (this._cached != null || this._tok0.length() > 0 || this._tok1.length() > 0 || this._multiLineValue != null) {
                            BufferCache.CachedBuffer header = this._cached != null ? this._cached : HttpHeaders.CACHE.lookup((Buffer)this._tok0);
                            this._cached = null;
                            View.CaseInsensitive value = this._multiLineValue == null ? this._tok1 : new ByteArrayBuffer(this._multiLineValue);
                            int ho = HttpHeaders.CACHE.getOrdinal((Buffer)header);
                            if (ho >= 0) {
                                block24 : switch (ho) {
                                    case 12: {
                                        if (this._contentLength == -2L) break;
                                        try {
                                            this._contentLength = BufferUtil.toLong((Buffer)value);
                                        }
                                        catch (NumberFormatException e) {
                                            LOG.ignore((Throwable)e);
                                            throw new HttpException(400);
                                        }
                                        if (this._contentLength > 0L) break;
                                        this._contentLength = 0L;
                                        break;
                                    }
                                    case 5: {
                                        value = HttpHeaderValues.CACHE.lookup((Buffer)value);
                                        int vo = HttpHeaderValues.CACHE.getOrdinal((Buffer)value);
                                        if (2 == vo) {
                                            this._contentLength = -2L;
                                            break;
                                        }
                                        String c = value.toString("ISO-8859-1");
                                        if (c.endsWith("chunked")) {
                                            this._contentLength = -2L;
                                            break;
                                        }
                                        if (c.indexOf("chunked") < 0) break;
                                        throw new HttpException(400, null);
                                    }
                                    case 1: {
                                        switch (HttpHeaderValues.CACHE.getOrdinal((Buffer)value)) {
                                            case 1: {
                                                this._persistent = false;
                                                break block24;
                                            }
                                            case 5: {
                                                this._persistent = true;
                                                break block24;
                                            }
                                            case -1: {
                                                block74: for (String v : value.toString().split(",")) {
                                                    switch (HttpHeaderValues.CACHE.getOrdinal(v.trim())) {
                                                        case 1: {
                                                            this._persistent = false;
                                                            continue block74;
                                                        }
                                                        case 5: {
                                                            this._persistent = true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            this._handler.parsedHeader((Buffer)header, (Buffer)value);
                            this._tok0.setPutIndex(this._tok0.getIndex());
                            this._tok1.setPutIndex(this._tok1.getIndex());
                            this._multiLineValue = null;
                        }
                        this._buffer.setMarkIndex(-1);
                        if (ch == 13 || ch == 10) {
                            if (this._responseStatus > 0 && (this._responseStatus == 304 || this._responseStatus == 204 || this._responseStatus < 200)) {
                                this._contentLength = 0L;
                            } else if (this._contentLength == -3L) {
                                this._contentLength = this._responseStatus == 0 || this._responseStatus == 304 || this._responseStatus == 204 || this._responseStatus < 200 ? 0L : -1L;
                            }
                            this._contentPosition = 0L;
                            this._eol = ch;
                            if (this._eol == 13 && this._buffer.hasContent() && this._buffer.peek() == 10) {
                                this._eol = this._buffer.get();
                            }
                            switch (this._contentLength > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._contentLength) {
                                case -1: {
                                    this._state = 1;
                                    this._handler.headerComplete();
                                    break;
                                }
                                case -2: {
                                    this._state = 3;
                                    this._handler.headerComplete();
                                    break;
                                }
                                case 0: {
                                    this._handler.headerComplete();
                                    this._state = this._persistent || this._responseStatus >= 100 && this._responseStatus < 200 ? 0 : 7;
                                    this._handler.messageComplete(this._contentPosition);
                                    return 1;
                                }
                                default: {
                                    this._state = 2;
                                    this._handler.headerComplete();
                                }
                            }
                            return 1;
                        }
                        this._length = 1;
                        this._buffer.mark();
                        this._state = -4;
                        if (array == null) break;
                        this._cached = HttpHeaders.CACHE.getBest(array, this._buffer.markIndex(), length + 1);
                        if (this._cached == null) break;
                        this._length = this._cached.length();
                        this._buffer.setGetIndex(this._buffer.markIndex() + this._length);
                        length = this._buffer.length();
                        break;
                    }
                    case -4: {
                        switch (ch) {
                            case 10: 
                            case 13: {
                                if (this._length > 0) {
                                    this._tok0.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                }
                                this._eol = ch;
                                this._state = -5;
                                break block7;
                            }
                            case 58: {
                                if (this._length > 0 && this._cached == null) {
                                    this._tok0.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                }
                                this._length = -1;
                                this._state = -2;
                                break block7;
                            }
                            case 9: 
                            case 32: {
                                break block7;
                            }
                        }
                        this._cached = null;
                        if (this._length == -1) {
                            this._buffer.mark();
                        }
                        this._length = this._buffer.getIndex() - this._buffer.markIndex();
                        this._state = -3;
                        break;
                    }
                    case -3: {
                        switch (ch) {
                            case 10: 
                            case 13: {
                                if (this._length > 0) {
                                    this._tok0.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                }
                                this._eol = ch;
                                this._state = -5;
                                break block7;
                            }
                            case 58: {
                                if (this._length > 0 && this._cached == null) {
                                    this._tok0.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                }
                                this._length = -1;
                                this._state = -2;
                                break block7;
                            }
                            case 9: 
                            case 32: {
                                this._state = -4;
                                break block7;
                            }
                        }
                        this._cached = null;
                        ++this._length;
                        break;
                    }
                    case -2: {
                        switch (ch) {
                            case 10: 
                            case 13: {
                                if (this._length > 0) {
                                    if (this._tok1.length() == 0) {
                                        this._tok1.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                    } else {
                                        if (this._multiLineValue == null) {
                                            this._multiLineValue = this._tok1.toString("ISO-8859-1");
                                        }
                                        this._tok1.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                        this._multiLineValue = this._multiLineValue + " " + this._tok1.toString("ISO-8859-1");
                                    }
                                }
                                this._eol = ch;
                                this._state = -5;
                                break block7;
                            }
                            case 9: 
                            case 32: {
                                break block7;
                            }
                        }
                        if (this._length == -1) {
                            this._buffer.mark();
                        }
                        this._length = this._buffer.getIndex() - this._buffer.markIndex();
                        this._state = -1;
                        break;
                    }
                    case -1: {
                        switch (ch) {
                            case 10: 
                            case 13: {
                                if (this._length > 0) {
                                    if (this._tok1.length() == 0) {
                                        this._tok1.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                    } else {
                                        if (this._multiLineValue == null) {
                                            this._multiLineValue = this._tok1.toString("ISO-8859-1");
                                        }
                                        this._tok1.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                        this._multiLineValue = this._multiLineValue + " " + this._tok1.toString("ISO-8859-1");
                                    }
                                }
                                this._eol = ch;
                                this._state = -5;
                                break block7;
                            }
                            case 9: 
                            case 32: {
                                this._state = -2;
                                break block7;
                            }
                        }
                        ++this._length;
                    }
                }
            }
            if (this._responseStatus > 0 && this._headResponse) {
                this._state = this._persistent || this._responseStatus >= 100 && this._responseStatus < 200 ? 0 : 7;
                this._handler.messageComplete(this._contentLength);
            }
            length = this._buffer.length();
            last = this._state;
            while (this._state > 0 && length > 0) {
                if (last != this._state) {
                    ++progress;
                    last = this._state;
                }
                if (this._eol == 13 && this._buffer.peek() == 10) {
                    this._eol = this._buffer.get();
                    length = this._buffer.length();
                    continue;
                }
                this._eol = 0;
                switch (this._state) {
                    case 1: {
                        Buffer chunk = this._buffer.get(this._buffer.length());
                        this._contentPosition += (long)chunk.length();
                        this._contentView.update(chunk);
                        this._handler.content(chunk);
                        return 1;
                    }
                    case 2: {
                        long remaining = this._contentLength - this._contentPosition;
                        if (remaining == 0L) {
                            this._state = this._persistent ? 0 : 7;
                            this._handler.messageComplete(this._contentPosition);
                            return 1;
                        }
                        if ((long)length > remaining) {
                            length = (int)remaining;
                        }
                        Buffer chunk = this._buffer.get(length);
                        this._contentPosition += (long)chunk.length();
                        this._contentView.update(chunk);
                        this._handler.content(chunk);
                        if (this._contentPosition == this._contentLength) {
                            this._state = this._persistent ? 0 : 7;
                            this._handler.messageComplete(this._contentPosition);
                        }
                        return 1;
                    }
                    case 3: {
                        ch = this._buffer.peek();
                        if (ch == 13 || ch == 10) {
                            this._eol = this._buffer.get();
                            break;
                        }
                        if (ch <= 32) {
                            this._buffer.get();
                            break;
                        }
                        this._chunkLength = 0;
                        this._chunkPosition = 0;
                        this._state = 4;
                        break;
                    }
                    case 4: {
                        ch = this._buffer.get();
                        if (ch == 13 || ch == 10) {
                            this._eol = ch;
                            if (this._chunkLength == 0) {
                                if (this._eol == 13 && this._buffer.hasContent() && this._buffer.peek() == 10) {
                                    this._eol = this._buffer.get();
                                }
                                this._state = this._persistent ? 0 : 7;
                                this._handler.messageComplete(this._contentPosition);
                                return 1;
                            }
                            this._state = 6;
                            break;
                        }
                        if (ch <= 32 || ch == 59) {
                            this._state = 5;
                            break;
                        }
                        if (ch >= 48 && ch <= 57) {
                            this._chunkLength = this._chunkLength * 16 + (ch - 48);
                            break;
                        }
                        if (ch >= 97 && ch <= 102) {
                            this._chunkLength = this._chunkLength * 16 + (10 + ch - 97);
                            break;
                        }
                        if (ch >= 65 && ch <= 70) {
                            this._chunkLength = this._chunkLength * 16 + (10 + ch - 65);
                            break;
                        }
                        throw new IOException("bad chunk char: " + ch);
                    }
                    case 5: {
                        ch = this._buffer.get();
                        if (ch != 13 && ch != 10) break;
                        this._eol = ch;
                        if (this._chunkLength == 0) {
                            if (this._eol == 13 && this._buffer.hasContent() && this._buffer.peek() == 10) {
                                this._eol = this._buffer.get();
                            }
                            this._state = this._persistent ? 0 : 7;
                            this._handler.messageComplete(this._contentPosition);
                            return 1;
                        }
                        this._state = 6;
                        break;
                    }
                    case 6: {
                        int remaining = this._chunkLength - this._chunkPosition;
                        if (remaining == 0) {
                            this._state = 3;
                            break;
                        }
                        if (length > remaining) {
                            length = remaining;
                        }
                        Buffer chunk = this._buffer.get(length);
                        this._contentPosition += (long)chunk.length();
                        this._chunkPosition += chunk.length();
                        this._contentView.update(chunk);
                        this._handler.content(chunk);
                        return 1;
                    }
                    case 7: {
                        if (this._buffer.length() > 2) {
                            this._state = 0;
                            this._endp.close();
                        } else {
                            while (this._buffer.length() > 0) {
                                if (Character.isWhitespace(this._buffer.get())) continue;
                                this._state = 0;
                                this._endp.close();
                                this._buffer.clear();
                            }
                        }
                        this._buffer.clear();
                    }
                }
                length = this._buffer.length();
            }
            return progress;
        }
        catch (HttpException e) {
            this._persistent = false;
            this._state = 7;
            throw e;
        }
    }

    protected int fill() throws IOException {
        if (this._buffer == null) {
            this._buffer = this.getHeaderBuffer();
        }
        if (this._state > 0 && this._buffer == this._header && this._header != null && !this._header.hasContent() && this._body != null && this._body.hasContent()) {
            this._buffer = this._body;
            return this._buffer.length();
        }
        if (!(this._buffer != this._header || this._state <= 0 || this._header.length() != 0 || !this._forceContentBuffer && this._contentLength - this._contentPosition <= (long)this._header.capacity() || this._body == null && this._buffers == null)) {
            if (this._body == null) {
                this._body = this._buffers.getBuffer();
            }
            this._buffer = this._body;
        }
        if (this._endp != null) {
            if (this._buffer == this._body || this._state > 0) {
                this._buffer.compact();
            }
            if (this._buffer.space() == 0) {
                LOG.warn("HttpParser Full for {} ", new Object[]{this._endp});
                this._buffer.clear();
                throw new HttpException(413, "FULL " + (this._buffer == this._body ? "body" : "head"));
            }
            try {
                int filled = this._endp.fill(this._buffer);
                return filled;
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                throw e instanceof EofException ? e : new EofException((Throwable)e);
            }
        }
        return -1;
    }

    @Override
    public void reset() {
        this._contentView.setGetIndex(this._contentView.putIndex());
        this._state = this._persistent ? -14 : (this._endp.isInputShutdown() ? 0 : 7);
        this._contentLength = -3L;
        this._contentPosition = 0L;
        this._length = 0;
        this._responseStatus = 0;
        if (this._eol == 13 && this._buffer != null && this._buffer.hasContent() && this._buffer.peek() == 10) {
            this._eol = this._buffer.get();
        }
        if (this._body != null && this._body.hasContent()) {
            if (this._header == null) {
                this.getHeaderBuffer();
            } else {
                this._header.setMarkIndex(-1);
                this._header.compact();
            }
            int take = this._header.space();
            if (take > this._body.length()) {
                take = this._body.length();
            }
            this._body.peek(this._body.getIndex(), take);
            this._body.skip(this._header.put(this._body.peek(this._body.getIndex(), take)));
        }
        if (this._header != null) {
            this._header.setMarkIndex(-1);
            this._header.compact();
        }
        if (this._body != null) {
            this._body.setMarkIndex(-1);
        }
        this._buffer = this._header;
        this.returnBuffers();
    }

    @Override
    public void returnBuffers() {
        if (this._body != null && !this._body.hasContent() && this._body.markIndex() == -1 && this._buffers != null) {
            if (this._buffer == this._body) {
                this._buffer = this._header;
            }
            if (this._buffers != null) {
                this._buffers.returnBuffer(this._body);
            }
            this._body = null;
        }
        if (this._header != null && !this._header.hasContent() && this._header.markIndex() == -1 && this._buffers != null) {
            if (this._buffer == this._header) {
                this._buffer = null;
            }
            this._buffers.returnBuffer(this._header);
            this._header = null;
        }
    }

    public void setState(int state) {
        this._state = state;
        this._contentLength = -3L;
    }

    public String toString(Buffer buf) {
        return "state=" + this._state + " length=" + this._length + " buf=" + buf.hashCode();
    }

    public String toString() {
        return String.format("%s{s=%d,l=%d,c=%d}", this.getClass().getSimpleName(), this._state, this._length, this._contentLength);
    }

    public Buffer getHeaderBuffer() {
        if (this._header == null) {
            this._header = this._buffers.getHeader();
            this._tok0.update(this._header);
            this._tok1.update(this._header);
        }
        return this._header;
    }

    public Buffer getBodyBuffer() {
        return this._body;
    }

    public void setForceContentBuffer(boolean force) {
        this._forceContentBuffer = force;
    }

    public Buffer blockForContent(long maxIdleTime) throws IOException {
        if (this._contentView.length() > 0) {
            return this._contentView;
        }
        if (this.getState() <= 0 || this.isState(7)) {
            return null;
        }
        try {
            this.parseNext();
            while (this._contentView.length() == 0 && !this.isState(0) && !this.isState(7) && this._endp != null && this._endp.isOpen()) {
                if (!this._endp.isBlocking()) {
                    if (this.parseNext() > 0) continue;
                    if (!this._endp.blockReadable(maxIdleTime)) {
                        this._endp.close();
                        throw new EofException("timeout");
                    }
                }
                this.parseNext();
            }
        }
        catch (IOException e) {
            this._endp.close();
            throw e;
        }
        return this._contentView.length() > 0 ? this._contentView : null;
    }

    public int available() throws IOException {
        if (this._contentView != null && this._contentView.length() > 0) {
            return this._contentView.length();
        }
        if (this._endp.isBlocking()) {
            if (this._state > 0 && this._endp instanceof StreamEndPoint) {
                return ((StreamEndPoint)this._endp).getInputStream().available() > 0 ? 1 : 0;
            }
            return 0;
        }
        this.parseNext();
        return this._contentView == null ? 0 : this._contentView.length();
    }

    public static abstract class EventHandler {
        public abstract void content(Buffer var1) throws IOException;

        public void headerComplete() throws IOException {
        }

        public void messageComplete(long contentLength) throws IOException {
        }

        public void parsedHeader(Buffer name, Buffer value) throws IOException {
        }

        public abstract void startRequest(Buffer var1, Buffer var2, Buffer var3) throws IOException;

        public abstract void startResponse(Buffer var1, int var2, Buffer var3) throws IOException;

        public void earlyEOF() {
        }
    }
}

