package Sah::SchemaR::perl::colortheme::modname_with_optional_args;

our $DATE = '2021-02-02'; # DATE
our $VERSION = '0.003'; # VERSION

our $rschema = ["str",[{description=>"\nPerl module name with optional arguments which will be used as import arguments,\njust like the `-MMODULE=ARGS` shortcut that `perl` provides. Examples:\n\n    Foo\n    Foo::Bar\n    Foo::Bar=arg1,arg2\n\nSee also: `perl::modname`.\n\n",examples=>[{valid=>0,value=>""},{valid=>1,value=>"Foo::Bar"},{valid=>1,value=>"Foo::Bar=arg1,arg2"},{valid=>1,validated_value=>"Foo::Bar=arg1,arg2",value=>"Foo-Bar=arg1,arg2"}],match=>"[A-Za-z_][A-Za-z_0-9]*(::[A-Za-z_0-9]+)*(?:=.*)?",summary=>"Perl module name (e.g. Foo::Bar) with optional arguments (e.g. Foo::Bar=arg1,arg2)","x.completion"=>"perl_modname","x.perl.coerce_rules"=>["From_str::normalize_perl_modname"]},{summary=>"Perl module in the ColorTheme::* namespace, without the namespace prefix, with optional args e.g. \"Harmony::Analogous=central_h,120\"","x.completion"=>["perl_modname",{ns_prefix=>"ColorTheme",recurse=>1,recurse_matching=>"all-at-once"}],"x.perl.coerce_rules"=>[["From_str::normalize_perl_modname",{ns_prefix=>"ColorTheme"}]]}],["perl::modname_with_optional_args","str"]];

1;
# ABSTRACT: Perl module in the ColorTheme::* namespace, without the namespace prefix, with optional args e.g. "Harmony::Analogous=central_h,120"

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::perl::colortheme::modname_with_optional_args - Perl module in the ColorTheme::* namespace, without the namespace prefix, with optional args e.g. "Harmony::Analogous=central_h,120"

=head1 VERSION

This document describes version 0.003 of Sah::SchemaR::perl::colortheme::modname_with_optional_args (from Perl distribution Sah-Schemas-ColorTheme), released on 2021-02-02.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-ColorTheme>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-ColorTheme>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://github.com/perlancar/perl-Sah-Schemas-ColorTheme/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
