/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemTypeCheckingFunction<T extends Item>
implements ItemMappingFunction<T, T> {
    private XPathContext externalContext;
    private ItemType requiredItemType;
    private SourceLocator locator;
    private RoleLocator role;

    public ItemTypeCheckingFunction(ItemType requiredItemType, RoleLocator role, SourceLocator locator, XPathContext context) {
        this.externalContext = context;
        this.requiredItemType = requiredItemType;
        this.role = role;
        this.locator = locator;
    }

    @Override
    public T mapItem(T item) throws XPathException {
        this.testConformance(item, this.externalContext);
        return item;
    }

    private void testConformance(T item, XPathContext context) throws XPathException {
        if (!this.requiredItemType.matchesItem((Item)item, true, context == null ? null : context.getConfiguration())) {
            XPathException te;
            String message;
            if (context == null) {
                message = "Supplied value of type " + Type.displayTypeName(item) + " does not match the required type of " + this.role.getMessage();
            } else {
                NamePool pool = context.getNamePool();
                TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
                message = this.role.composeErrorMessage(this.requiredItemType, Value.asValue(item).getItemType(th), pool);
            }
            String errorCode = this.role.getErrorCode();
            if ("XPDY0050".equals(errorCode)) {
                te = new XPathException(message, errorCode, context);
                te.setLocator(this.locator);
                te.setIsTypeError(false);
                throw te;
            }
            te = new XPathException(message, errorCode, context);
            te.setLocator(this.locator);
            te.setIsTypeError(true);
            throw te;
        }
    }
}

