/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.IntEmptySet;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.expr.sort.IntSet;
import net.sf.saxon.expr.sort.IntUniversalSet;

public class IntComplementSet
implements IntSet {
    private IntSet exclusions;

    public IntComplementSet(IntSet exclusions) {
        this.exclusions = exclusions.copy();
    }

    public IntSet getExclusions() {
        return this.exclusions;
    }

    public IntSet copy() {
        return new IntComplementSet(this.exclusions);
    }

    public IntSet mutableCopy() {
        return this.copy();
    }

    public void clear() {
        throw new UnsupportedOperationException("IntComplementSet cannot be emptied");
    }

    public int size() {
        return Integer.MAX_VALUE - this.exclusions.size();
    }

    public boolean isEmpty() {
        return this.size() != 0;
    }

    public boolean contains(int value) {
        return !this.exclusions.contains(value);
    }

    public boolean remove(int value) {
        boolean b = this.contains(value);
        if (b) {
            this.exclusions.add(value);
        }
        return b;
    }

    public boolean add(int value) {
        boolean b = this.contains(value);
        if (!b) {
            this.exclusions.remove(value);
        }
        return b;
    }

    public IntIterator iterator() {
        throw new UnsupportedOperationException("Cannot enumerate an infinite set");
    }

    public IntSet union(IntSet other) {
        return new IntComplementSet(this.exclusions.except(other));
    }

    public IntSet intersect(IntSet other) {
        if (other.isEmpty()) {
            return IntEmptySet.getInstance();
        }
        if (other == IntUniversalSet.getInstance()) {
            return this.copy();
        }
        if (other instanceof IntComplementSet) {
            return new IntComplementSet(this.exclusions.union(((IntComplementSet)other).exclusions));
        }
        return other.intersect(this);
    }

    public IntSet except(IntSet other) {
        return new IntComplementSet(this.exclusions.union(other));
    }

    public boolean containsAll(IntSet other) {
        if (other.size() > 1) {
            return false;
        }
        IntIterator ii = other.iterator();
        while (ii.hasNext()) {
            if (!this.exclusions.contains(ii.next())) continue;
            return false;
        }
        return true;
    }
}

