# -*- cperl -*-

use Test::More tests => 1 + 14;

use POSIX qw(locale_h);
setlocale(LC_CTYPE, "pt_PT");
use locale;

BEGIN { use_ok( 'Lingua::PT::PLNbase' ); }


$a = '';

SKIP: {
  skip "not a good locale", 14 unless $a =~ m!^\w{3}$!;


  my @ss = frases(<<"EOT");
O dr. Joo Rato comeu a D. Carochinha.
O Eng. visitou a av. do Marqus.
O Ex. Sr. Antnio foi prof. de Matemtica.
O Pe. Joaquim casou o Arq. Joo com a Prof. Joana.
Os profs. vo ao lg. do Pao.
Os profs. vo ao lgo. do Pao.
As profas. tambm vo ao lgo. do Pao.
No sc. V A.C. j no existiam dinossauros.
Os Exmos. Srs. deputados que...
Os Exmos. Srs. Drs. vo almoar ao Snack-Bar.
Na rua Cel. Antnio virar  esquerda, pela avenida do Sen. Joaquim.
A empresa de Marco Correia e Cia. Lda. fica na Trv. Mrio Soares.
Foi nos E.U.A. que se assaltou qq coisa.
Por ex. Satre afirmava
EOT

  my $i = 0;
  my @sts = (q/O dr. Joo Rato comeu a D. Carochinha./,
	     q/O Eng. visitou a av. do Marqus./,
	     q/O Ex. Sr. Antnio foi prof. de Matemtica./,
	     q/O Pe. Joaquim casou o Arq. Joo com a Prof. Joana./,
	     q/Os profs. vo ao lg. do Pao./,
	     q/Os profs. vo ao lgo. do Pao./,
	     q/As profas. tambm vo ao lgo. do Pao./,
	     q/No sc. V A.C. j no existiam dinossauros./,
	     q/Os Exmos. Srs. deputados que.../,
	     q/Os Exmos. Srs. Drs. vo almoar ao Snack-Bar./,
	     q/Na rua Cel. Antnio virar  esquerda, pela avenida do Sen. Joaquim./,
	     q/A empresa de Marco Correia e Cia. Lda. fica na Trv. Mrio Soares./,
	     q/Foi nos E.U.A. que se assaltou qq coisa./,
	     q/Por ex. Satre afirmava/,
	  );

  for (@sts) {
    is(trim($ss[$i++]),$_)
  }
}


##------
sub trim {
  my $x = shift;
  $x =~ s/^[\n\s]*//;
  $x =~ s![\n\s]*$!!;
  $x
}
