package Yukki::Web::View::Login;
$Yukki::Web::View::Login::VERSION = '0.991_003'; # TRIAL

$Yukki::Web::View::Login::VERSION = '0.991003';use v5.24;
use utf8;
use Moo;

use Type::Utils;

use namespace::clean;

extends 'Yukki::Web::View';

# ABSTRACT: show a login form


has login_template => (
    is          => 'ro',
    isa         => class_type('Template::Pure'),
    lazy        => 1,
    builder     => '_build_login_template',
);

sub _build_login_template {
    shift->prepare_template(
        template   => 'login/page.html',
        directives => [
            'form@action' => 'login_submit_url',
        ],
    );
}

has profile_template => (
    is          => 'ro',
    isa         => class_type('Template::Pure'),
    lazy        => 1,
    builder     => '_build_profile_template',
);

sub _build_profile_template {
    shift->prepare_template(
        template   => 'login/profile.html',
        directives => [
            'form@action'            => 'profile_submit_url',
            'input.login_name@value' => 'user.login_name',
            'div.login_name'         => 'user.login_name',
            '.name@value'            => 'name',
            '.email@value'           => 'email',
        ],
    );
}


sub page {
    my ($self, $ctx) = @_;

    return $self->render_page(
        template   => $self->login_template,
        context    => $ctx,
        vars       => {
            'login_submit_url' => $ctx->rebase_url('login/submit'),
        },
    );
}


sub profile {
    my ($self, $ctx, $name, $email) = @_;

    $ctx->response->page_title('Profile of ' . $ctx->session->{user}{name});

    return $self->render_page(
        template => $self->profile_template,
        context  => $ctx,
        vars     => {
            profile_submit_url => $ctx->rebase_url('profile/update'),
            user               => $ctx->session->{user},
            name               => $name // $ctx->session->{user}{name},
            email              => $email // $ctx->session->{user}{email},
        },
    );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Yukki::Web::View::Login - show a login form

=head1 VERSION

version 0.991_003

=head1 DESCRIPTION

Renders the login form.

=head1 METHODS

=head2 page

Renders the login page.

=head2 profile

Renders the user profile page.

=head1 AUTHOR

Andrew Sterling Hanenkamp <hanenkamp@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Qubling Software LLC.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
