## -*- Mode: CPerl -*-
##
## File: DTA::CAB::Analyzer::Morph::Extra::CDB.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: auxilliary full-form pseudo-morphology, dictionary-based: CDB

##==============================================================================
## Package: Analyzer::Morph::Latin::CDB
##==============================================================================
package DTA::CAB::Analyzer::Morph::Extra::CDB;
use DTA::CAB::Analyzer ':child';
use DTA::CAB::Analyzer::Dict;
use DTA::CAB::Analyzer::Dict::CDB;
use Carp;
use strict;
our @ISA = qw(DTA::CAB::Analyzer::Dict::CDB);

## $obj = CLASS_OR_OBJ->new(%args)
##  + object structure: see DTA::CAB::Analyzer::Dict::CDB
sub new {
  my $that = shift;
  my $aut = $that->SUPER::new(
			      ##-- analysis selection
			      label      => 'mextra',     ##-- local 'morph' key (append)
			      checkLabel => 'mextra.bdb', ##-- local boolean key (avoid re-analysis)
			      morphLabel => 'morph',      ##-- global 'morph' key (append)
			      ##
			      analyzeCode => join("\n",
						  'return if (defined($_->{$checkLab})); ##-- avoid re-analysis',
						  '$_->{$checkLab}=1;',
						  '@vals='._am_tt_fst_list('($dhash->{'._am_xlit.'}||"")').';',
						  'if (@vals) {', # && (!$_->{xlit} || $_->{xlit}{isLatinExt})
						  '  push(@{$_->{$morphLab}},@vals); push(@{$_->{$lab}},@vals);',
						  '}',
						 ),
			      ##-- user args
			      @_
			     );
  return $aut;
}

## @keys = $anl->typeKeys(\%opts)
##  + returns list of type-wise keys to be expanded for this analyzer by expandTypes()
##  + override returns @{$anl->{typeKeys}} if defined, otherwise ($anl->{label},$anl->{morphLabel})
sub typeKeys {
  return $_[0]{typeKeys} ? @{$_[0]{typeKeys}} : grep {defined($_)} @{$_[0]}{qw(label morphLabel)};
}

##------------------------------------------------------------------------
## Methods: Analysis: Utils

## $prefix = $dict->analyzePre()
sub analyzePre {
  my $dic = shift;
  return ($dic->SUPER::analyzePre(@_)
	  .'my ($checkLab,$morphLab) = @$anl{qw(checkLabel morphLabel)};'."\n");
}


1; ##-- be happy

__END__
##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl
=pod

=cut

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Analyzer::Morph::Extra::CDB - auxilliary full-form pseudo-morphology via CDB

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 use DTA::CAB::Analyzer::Morph::Extra::CDB;
 
 $mextra = DTA::CAB::Analyzer::Morph::Extra::CDB->new(%args);
 

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

DTA::CAB::Analyzer::Morph::Extra::CDB
is a just a simplified wrapper for
L<DTA::CAB::Analyzer::Dict::CDB|DTA::CAB::Analyzer::Dict::CDB>
which sets the following default options:

 label       => 'mextra',     ##-- key for local analyses (append)
 checkLabel  => 'mextra.bdb'  ##-- key for local boolean (avoid re-analysis)
 morphLabel  => 'morph',      ##-- key for global anylses (append)
 analyzeCode => ...

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2017-2019 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=cut
