# This Makefile.PL for Package-Stash was generated by
# inc::MMPackageStash <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.47.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.008001;
use ExtUtils::MakeMaker;
check_conflicts();

my %WriteMakefileArgs = (
  "ABSTRACT" => "routines for manipulating stashes",
  "AUTHOR" => "Jesse Luehrs <doy\@tozt.net>",
  "CONFIGURE_REQUIRES" => {
    "Config" => 0,
    "Dist::CheckConflicts" => "0.02",
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "Text::ParseWords" => 0
  },
  "DISTNAME" => "Package-Stash",
  "EXE_FILES" => [
    "bin/package-stash-conflicts"
  ],
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.008001",
  "NAME" => "Package::Stash",
  "PREREQ_PM" => {
    "B" => 0,
    "Carp" => 0,
    "Dist::CheckConflicts" => "0.02",
    "Getopt::Long" => 0,
    "Module::Implementation" => "0.06",
    "Scalar::Util" => 0,
    "Symbol" => 0,
    "constant" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Test::Fatal" => 0,
    "Test::More" => "0.88",
    "Test::Requires" => 0,
    "base" => 0,
    "lib" => 0
  },
  "VERSION" => "0.38",
  "test" => {
    "TESTS" => "t/*.t t/impl-selection/*.t"
  }
);

my %FallbackPrereqs = (
  "B" => 0,
  "Carp" => 0,
  "Dist::CheckConflicts" => "0.02",
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "Getopt::Long" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Module::Implementation" => "0.06",
  "Scalar::Util" => 0,
  "Symbol" => 0,
  "Test::Fatal" => 0,
  "Test::More" => "0.88",
  "Test::Requires" => 0,
  "base" => 0,
  "constant" => 0,
  "lib" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

$WriteMakefileArgs{PREREQ_PM}{'Package::Stash::XS'} = 0.26
    if !parse_args()->{PUREPERL_ONLY} && can_cc();

WriteMakefile(%WriteMakefileArgs);

use Config ();
use File::Spec ();
use Text::ParseWords ();

# check if we can run some command
sub can_run {
        my ($cmd) = @_;

        my $_cmd = $cmd;
        return $_cmd if (-x $_cmd or $_cmd = MM->maybe_command($_cmd));

        for my $dir ((split /$Config::Config{path_sep}/, $ENV{PATH}), '.') {
                next if $dir eq '';
                my $abs = File::Spec->catfile($dir, $_[0]);
                return $abs if (-x $abs or $abs = MM->maybe_command($abs));
        }

        return;
}

# can we locate a (the) C compiler
sub can_cc {
        my @chunks = split(/ /, $Config::Config{cc}) or return;

        # $Config{cc} may contain args; try to find out the program part
        while (@chunks) {
                return can_run("@chunks") || (pop(@chunks), next);
        }

        return;
}

# XXX this is gross, but apparently it's the least gross option?
sub parse_args {
    my $tmp = {};
    # copied from EUMM
    ExtUtils::MakeMaker::parse_args(
        $tmp,
        Text::ParseWords::shellwords($ENV{PERL_MM_OPT} || ''),
        @ARGV,
    );
    return $tmp->{ARGS} || {};
}

sub check_conflicts {
    if ( eval { require './lib/Package/Stash/Conflicts.pm'; 1; } ) {
        if ( eval { Package::Stash::Conflicts->check_conflicts; 1 } ) {
            return;
        }
        else {
            my $err = $@;
            $err =~ s/^/    /mg;
            warn "***\n$err***\n";
        }
    }
    else {
        print <<'EOF';
***
    Your toolchain doesn't support configure_requires, so Dist::CheckConflicts
    hasn't been installed yet. You should check for conflicting modules
    manually using the 'package-stash-conflicts' script that is installed with
    this distribution once the installation finishes.
***
EOF
    }

    return if $ENV{AUTOMATED_TESTING} || $ENV{NONINTERACTIVE_TESTING};

    # More or less copied from Module::Build
    return if $ENV{PERL_MM_USE_DEFAULT};
    return unless -t STDIN && ( -t STDOUT || !( -f STDOUT || -c STDOUT ) );

    sleep 4;
}
