# Generated by default/object.tt
package Paws::LookoutMetrics::AnomalyGroupStatistics;
  use Moose;
  has EvaluationStartDate => (is => 'ro', isa => 'Str');
  has ItemizedMetricStatsList => (is => 'ro', isa => 'ArrayRef[Paws::LookoutMetrics::ItemizedMetricStats]');
  has TotalCount => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::AnomalyGroupStatistics

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::AnomalyGroupStatistics object:

  $service_obj->Method(Att1 => { EvaluationStartDate => $value, ..., TotalCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::AnomalyGroupStatistics object:

  $result = $service_obj->Method(...);
  $result->Att1->EvaluationStartDate

=head1 DESCRIPTION

Aggregated statistics for a group of anomalous metrics.

=head1 ATTRIBUTES


=head2 EvaluationStartDate => Str

The start of the time range that was searched.


=head2 ItemizedMetricStatsList => ArrayRef[L<Paws::LookoutMetrics::ItemizedMetricStats>]

Statistics for individual metrics within the group.


=head2 TotalCount => Int

The number of groups found.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

