/*
 * Decompiled with CFR 0.152.
 */
package be.fivebyfive.lingua.stanfordcorenlp;

import be.fivebyfive.lingua.stanfordcorenlp.PipelineItem;
import be.fivebyfive.lingua.stanfordcorenlp.PipelineToken;

public class PipelineCoreference
extends PipelineItem {
    private int fromSentence;
    private int toSentence;
    private int fromHead;
    private int toHead;
    private PipelineToken fromToken;
    private PipelineToken toToken;

    public int getSourceSentence() {
        return this.fromSentence;
    }

    public int getTargetSentence() {
        return this.toSentence;
    }

    public int getSourceHead() {
        return this.fromHead;
    }

    public int getTargetHead() {
        return this.toHead;
    }

    public PipelineToken getSourceToken() {
        return this.fromToken;
    }

    public PipelineToken getTargetToken() {
        return this.toToken;
    }

    public PipelineCoreference(int n, int n2, int n3, int n4, PipelineToken pipelineToken, PipelineToken pipelineToken2) {
        this.fromSentence = n;
        this.toSentence = n2;
        this.fromHead = n3;
        this.toHead = n4;
        this.fromToken = pipelineToken;
        this.toToken = pipelineToken2;
    }

    public boolean equals(PipelineCoreference pipelineCoreference) {
        return this.fromToken.identicalTo(pipelineCoreference.fromToken) && this.toToken.identicalTo(pipelineCoreference.toToken) || this.fromToken.identicalTo(pipelineCoreference.toToken) && this.toToken.identicalTo(pipelineCoreference.fromToken);
    }

    @Override
    public String toCompactString() {
        return this.fromToken.getWord() + "/" + this.fromSentence + ":" + this.fromHead + " <=> " + this.toToken.getWord() + "/" + this.toSentence + ":" + this.toHead;
    }

    public String toString() {
        return this.fromToken.toCompactString() + " [" + this.fromSentence + "," + this.fromHead + "] <=> " + this.toToken.toCompactString() + " [" + this.toSentence + "," + this.toHead + "]";
    }
}

