/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.analysis;

import at.ac.tuwien.dbai.pdfwrap.analysis.LineProcessor;
import at.ac.tuwien.dbai.pdfwrap.model.document.CompositeSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import at.ac.tuwien.dbai.pdfwrap.utils.SegmentUtils;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class CandidateCluster
extends CompositeSegment<TextSegment> {
    protected boolean constantFont = true;
    protected boolean constantFontSize = true;
    protected float lineSpacing;
    protected int textAlignment;
    protected boolean constantLS;
    protected boolean constantFS;
    protected boolean constantGS;
    protected boolean uniqueLines;
    protected boolean strContainsSuperSubscript = false;
    protected List<CompositeSegment<? extends TextSegment>> foundLines;
    public static final int ALIGN_LCR = 31;
    public static final int ALIGN_LC = 32;
    public static final int ALIGN_CR = 33;
    public static final int ALIGN_L = 34;
    public static final int ALIGN_C = 35;
    public static final int ALIGN_R = 36;
    public static final int ALIGN_NONE = 37;
    public static final int ALIGN_UNSET = 0;

    public CandidateCluster(float x1, float x2, float y1, float y2, String text, String fontName, float fontSize) {
        super(x1, x2, y1, y2, text, fontName, fontSize);
        this.items = new ArrayList();
    }

    public CandidateCluster(float x1, float x2, float y1, float y2) {
        super(x1, x2, y1, y2);
        this.items = new ArrayList();
    }

    public CandidateCluster(float x1, float x2, float y1, float y2, String text, String fontName, float fontSize, List<TextSegment> items) {
        super(x1, x2, y1, y2, text, fontName, fontSize);
        this.items = items;
    }

    public CandidateCluster(float x1, float x2, float y1, float y2, List<TextSegment> items) {
        super(x1, x2, y1, y2);
        this.items = items;
    }

    public CandidateCluster(List<TextSegment> items) {
        this.items = items;
    }

    public CandidateCluster() {
        this.items = new ArrayList();
    }

    public boolean isConstantFont() {
        return this.constantFont;
    }

    public void setConstantFont(boolean constantFont) {
        this.constantFont = constantFont;
    }

    public boolean isConstantFontSize() {
        return this.constantFontSize;
    }

    public void setConstantFontSize(boolean constantFontSize) {
        this.constantFontSize = constantFontSize;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(int textAlignment) {
        this.textAlignment = textAlignment;
    }

    public boolean isConstantLS() {
        return this.constantLS;
    }

    public void setConstantLS(boolean constantLS) {
        this.constantLS = constantLS;
    }

    public boolean isConstantFS() {
        return this.constantFS;
    }

    public void setConstantFS(boolean constantFS) {
        this.constantFS = constantFS;
    }

    public boolean isConstantGS() {
        return this.constantGS;
    }

    public void setConstantGS(boolean constantGS) {
        this.constantGS = constantGS;
    }

    public boolean isUniqueLines() {
        return this.uniqueLines;
    }

    public void setUniqueLines(boolean uniqueLines) {
        this.uniqueLines = uniqueLines;
    }

    public boolean isStrContainsSuperSubscript() {
        return this.strContainsSuperSubscript;
    }

    public void setStrContainsSuperSubscript(boolean strContainsSuperSubscript) {
        this.strContainsSuperSubscript = strContainsSuperSubscript;
    }

    public List<CompositeSegment<? extends TextSegment>> getFoundLines() {
        return this.foundLines;
    }

    public void setFoundLines(List<CompositeSegment<? extends TextSegment>> foundLines) {
        this.foundLines = foundLines;
    }

    public void findLines() {
        this.findLines(0.5f);
    }

    public void findLinesWidth() {
        this.findLines(Float.MAX_VALUE);
    }

    public void findLines(float horizThreshold) {
        this.foundLines = LineProcessor.findLines(this.items, horizThreshold, true, false);
        this.processLines();
    }

    @Override
    public void setCalculatedFields() {
        this.findLinesWidth();
        this.processLines();
        this.findFontSize();
        this.findBoundingBox();
        this.findText();
    }

    protected void processLines() {
        if (this.foundLines.size() > 1) {
            float avgX1 = 0.0f;
            float avgXcen = 0.0f;
            float avgX2 = 0.0f;
            float afs = 0.0f;
            float als = 0.0f;
            boolean clashingLines = false;
            CompositeSegment<? extends TextSegment> prevLine = null;
            for (CompositeSegment<? extends TextSegment> l : this.foundLines) {
                avgX1 += l.getX1();
                avgXcen += l.getXmid();
                avgX2 += l.getX2();
                afs += l.getFontSize();
                if (prevLine != null) {
                    float lineSpacing = prevLine.getY1() - l.getY1();
                    als += lineSpacing;
                    if (SegmentUtils.vertIntersect(prevLine, l.getYmid())) {
                        clashingLines = true;
                    }
                }
                prevLine = l;
            }
            avgX1 /= (float)this.foundLines.size();
            avgXcen /= (float)this.foundLines.size();
            avgX2 /= (float)this.foundLines.size();
            this.fontSize = afs /= (float)this.foundLines.size();
            this.lineSpacing = (als /= (float)(this.foundLines.size() - 1)) / afs;
            boolean constantX1 = true;
            boolean constantXcen = true;
            boolean constantX2 = true;
            boolean constantfs = true;
            boolean constantls = true;
            float tolerance = afs * 0.5f;
            prevLine = null;
            for (CompositeSegment<? extends TextSegment> l : this.foundLines) {
                float lineSpacing;
                if (!Utils.within(l.getX1(), avgX1, tolerance)) {
                    constantX1 = false;
                }
                if (!Utils.within(l.getXmid(), avgXcen, tolerance)) {
                    constantXcen = false;
                }
                if (!Utils.within(l.getX2(), avgX2, tolerance)) {
                    constantX2 = false;
                }
                if (!Utils.within(l.getFontSize(), afs, afs * 0.1f)) {
                    constantfs = false;
                }
                if (prevLine != null && !Utils.within(lineSpacing = prevLine.getY1() - l.getY1(), als, afs * 0.2f)) {
                    constantls = false;
                }
                prevLine = l;
            }
            this.textAlignment = constantX1 && constantX2 ? 31 : (constantX1 && constantXcen ? 32 : (constantXcen && constantX2 ? 33 : (constantX1 ? 34 : (constantXcen ? 35 : (constantX2 ? 36 : 37)))));
            this.constantLS = constantls;
            this.constantFS = constantfs;
            this.uniqueLines = !clashingLines;
        }
    }

    public TextSegment getTopElementMatchingFontsizeAfterSorting() {
        TextSegment retVal = null;
        for (TextSegment s : this.items) {
            for (CompositeSegment<? extends TextSegment> l : this.foundLines) {
                if (!l.getItems().contains(s) || !Utils.within(s.getFontSize(), l.getFontSize(), s.getFontSize() * 0.1f)) continue;
                return s;
            }
        }
        return retVal;
    }

    public TextSegment getBottomElementMatchingFontsizeAfterSorting() {
        TextSegment retVal = null;
        int n = this.items.size() - 1;
        while (n >= 0) {
            TextSegment s = (TextSegment)this.items.get(n);
            for (CompositeSegment<? extends TextSegment> l : this.foundLines) {
                if (!l.getItems().contains(s) || !Utils.within(s.getFontSize(), l.getFontSize(), s.getFontSize() * 0.1f)) continue;
                return s;
            }
            --n;
        }
        return retVal;
    }
}

