/*
 * Decompiled with CFR 0.152.
 */
package opennlp.common.swedish;

import java.util.ArrayList;
import opennlp.common.morph.MorphAnalyzer;

public final class BasicSwedishAffixes
implements MorphAnalyzer {
    private static final byte MIN_WORD_LENGTH = 4;
    private static final String[] twoCharSuffixes = new String[]{"ad", "an", "ar", "as", "at", "da", "dd", "de", "ds", "el", "en", "er", "es", "et", "ft", "gd", "gt", "it", "ja", "js", "la", "ma", ":n", "na", "ns", "on", "or", "ra", "re", "rs", ":s", "st", "ta", "te", "ts", "tt", "um"};
    private static final String[] threeCharSuffixes = new String[]{"ade", "ans", "are", "ars", "ast", "ats", "das", "dda", "dde", "der", "des", "dja", "eln", "els", "elt", "ena", "ens", "ern", "ers", "ert", "ets", "gda", "gen", "get", "git", "gna", "gts", "its", "jas", "jer", "lar", "len", "ler", "let", "lla", "mal", "mar", "mas", "mel", "men", "mer", "mes", "met", "mit", "nar", "nas", "nat", "nde", "nen", "ner", "net", "nit", ":ns", "ons", "ors", "rar", "ren", "rer", "ret", "rna", "sta", "tas", "ten", "ter", "tes", "tet", "tta", "tts", "ums", "ven", "vet", "vit", "vna"};
    private static final String[] fourCharSuffixes = new String[]{"ande", "arna", "aste", "dare", "dast", "djer", "elns", "enas", "ende", "erna", "erns", "erst", "gits", "lare", "lars", "last", "lens", "lers", "lets", "malt", "mare", "mars", "mast", "mels", "mens", "mern", "mers", "mets", "nare", "nars", "nast", "nden", "ndet", "ndna", "nens", "ners", "nets", "ngen", "nget", "ngna", "nits", "onen", "orna", "rare", "rars", "rast", "rens", "rers", "rets", "rnas", "ttre", "umen", "umet"};
    private static final String[] fiveCharSuffixes = new String[]{"arnas", "dande", "daste", "ernas", "ersta", "gande", "larna", "laste", "lerna", "mande", "maren", "mares", "marna", "maste", "merns", "nande", "narna", "naste", "nerna", "onens", "ornas", "rarna", "raste", "rerna", "tande", "umens", "umets", "vande"};
    private static final String[] sixCharSuffixes = new String[]{"djande", "larnas", "lernas", "marens", "marnas", "narnas", "nernas", "rarnas", "rernas"};

    public String analyze(String word) {
        return word;
    }

    public static boolean contains(String[] suffixes, String suffix) {
        int i = 0;
        while (i < suffixes.length) {
            if (suffix.equals(suffixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getPrefixes(String word) {
        return new String[0];
    }

    public String[] getSuffixes(String word) {
        ArrayList<String> suffs = new ArrayList<String>();
        int first = BasicSwedishAffixes.nextSuffix(word);
        if (first != 0) {
            suffs.add(word.substring(first));
            int second = BasicSwedishAffixes.nextSuffix(word.substring(0, first));
            if (second != 0) {
                suffs.add(word.substring(second, first));
            }
        }
        String[] affixes = new String[suffs.size()];
        int i = 0;
        while (i < suffs.size()) {
            affixes[i] = (String)suffs.get(i);
            ++i;
        }
        return affixes;
    }

    public static void main(String[] args) {
        String[] suffs = new BasicSwedishAffixes().getSuffixes(args[0]);
        int i = 0;
        while (i < suffs.length) {
            System.out.println(suffs[i]);
            ++i;
        }
    }

    public static final int nextSuffix(String word) {
        boolean index = false;
        short wordLength = (short)word.length();
        if (wordLength < 4) {
            return 0;
        }
        String end = word.substring(4);
        short len = (short)end.length();
        if (len < 2) {
            return 0;
        }
        if (len > 5 && BasicSwedishAffixes.contains(sixCharSuffixes, end.substring(len - 6))) {
            return wordLength - 6;
        }
        if (len > 4 && BasicSwedishAffixes.contains(fiveCharSuffixes, end.substring(len - 5))) {
            return wordLength - 5;
        }
        if (len > 3 && BasicSwedishAffixes.contains(fourCharSuffixes, end.substring(len - 4))) {
            return wordLength - 4;
        }
        if (len > 2 && BasicSwedishAffixes.contains(threeCharSuffixes, end.substring(len - 3))) {
            return wordLength - 3;
        }
        if (len > 1 && BasicSwedishAffixes.contains(twoCharSuffixes, end.substring(len - 2))) {
            return wordLength - 2;
        }
        return 0;
    }
}

