/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import opennlp.common.generate.Synthesizer;

public class Festival
implements Synthesizer {
    PrintStream utter;
    BufferedReader hear;

    public void clear() {
    }

    public void open() {
        Process festival = null;
        try {
            festival = Runtime.getRuntime().exec("festival");
        }
        catch (IOException IOE) {
            System.out.println(IOE);
        }
        this.utter = new PrintStream(festival.getOutputStream());
        this.utter.println("(voice_us1_mbrola)");
        this.utter.println("(require 'tobi)");
        this.utter.println("(require 'tobi_rules)");
        this.utter.println("(setup_tobi_f0_method)");
        this.utter.println("(Parameter.set 'Default_Topline 200)");
        this.utter.println("(Parameter.set 'Default_Start_Baseline 150)");
        this.utter.println("(Parameter.set 'Current_Topline(Parameter.get 'Default_Topline))");
        this.utter.println("(Parameter.set 'Valley_Dip 130)");
        this.utter.flush();
    }

    public void close() {
        this.utter.println("(exit)");
        this.utter.flush();
    }

    private String getTone(String s) {
        if (s.endsWith("%")) {
            return s.substring(0, 1) + "-" + s.substring(1);
        }
        return null;
    }

    public void speak(String s) {
        StringTokenizer st = new StringTokenizer(s);
        ArrayList<String> words = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            words.add(st.nextToken().trim());
        }
        String sentence = "";
        int i = 0;
        while (i < words.size()) {
            String word = (String)words.get(i);
            int index = word.indexOf("_");
            String accent = null;
            String tone = null;
            if (index != -1) {
                accent = word.substring(index + 1);
                word = word.substring(0, index);
                if (accent.endsWith("2")) {
                    accent = accent.substring(0, accent.length() - 1);
                }
                if (i < words.size() - 1) {
                    tone = this.getTone((String)words.get(i + 1));
                }
                String newWord = "(" + word + "((accent " + accent + ")";
                if (tone != null) {
                    newWord = newWord + "(tone " + tone + ")";
                }
                newWord = newWord + "))";
                sentence = sentence + newWord + " ";
            } else if (!word.endsWith("%")) {
                if (i < words.size() - 1) {
                    tone = this.getTone((String)words.get(i + 1));
                }
                sentence = tone != null ? sentence + "(" + word + "((tone " + tone + ")))" : sentence + word + " ";
            }
            ++i;
        }
        this.utter.println("(set! utt (Utterance Words (" + sentence + ")))");
        this.utter.println("(utt.synth utt)");
        this.utter.println("(utt.play utt)");
        this.utter.flush();
    }

    public static void main(String[] args) {
    }
}

