# Generated by default/object.tt
package Paws::SecurityHub::AwsCorsConfiguration;
  use Moose;
  has AllowCredentials => (is => 'ro', isa => 'Bool');
  has AllowHeaders => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has AllowMethods => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has AllowOrigins => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ExposeHeaders => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has MaxAge => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsCorsConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsCorsConfiguration object:

  $service_obj->Method(Att1 => { AllowCredentials => $value, ..., MaxAge => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsCorsConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AllowCredentials

=head1 DESCRIPTION

Contains the cross-origin resource sharing (CORS) configuration for the
API. CORS is only supported for HTTP APIs.

=head1 ATTRIBUTES


=head2 AllowCredentials => Bool

Indicates whether the CORS request includes credentials.


=head2 AllowHeaders => ArrayRef[Str|Undef]

The allowed headers for CORS requests.


=head2 AllowMethods => ArrayRef[Str|Undef]

The allowed methods for CORS requests.


=head2 AllowOrigins => ArrayRef[Str|Undef]

The allowed origins for CORS requests.


=head2 ExposeHeaders => ArrayRef[Str|Undef]

The exposed headers for CORS requests.


=head2 MaxAge => Int

The number of seconds for which the browser caches preflight request
results.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

