package Shipment::FedEx::WSDL::TrackTypes::TrackSpecialInstruction;
$Shipment::FedEx::WSDL::TrackTypes::TrackSpecialInstruction::VERSION = '2.03';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://fedex.com/ws/track/v9'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %Description_of : ATTR(:get<Description>);
    my %DeliveryOption_of : ATTR(:get<DeliveryOption>);
    my %StatusDetail_of : ATTR(:get<StatusDetail>);
    my %OriginalEstimatedDeliveryTimestamp_of :
      ATTR(:get<OriginalEstimatedDeliveryTimestamp>);
    my %OriginalRequestTime_of : ATTR(:get<OriginalRequestTime>);
    my %RequestedAppointmentTime_of : ATTR(:get<RequestedAppointmentTime>);

    __PACKAGE__->_factory(
        [   qw(        Description
              DeliveryOption
              StatusDetail
              OriginalEstimatedDeliveryTimestamp
              OriginalRequestTime
              RequestedAppointmentTime

              )
        ],
        {   'Description'    => \%Description_of,
            'DeliveryOption' => \%DeliveryOption_of,
            'StatusDetail'   => \%StatusDetail_of,
            'OriginalEstimatedDeliveryTimestamp' =>
              \%OriginalEstimatedDeliveryTimestamp_of,
            'OriginalRequestTime'      => \%OriginalRequestTime_of,
            'RequestedAppointmentTime' => \%RequestedAppointmentTime_of,
        },
        {   'Description' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'DeliveryOption' =>
              'Shipment::FedEx::WSDL::TrackTypes::TrackDeliveryOptionType',
            'StatusDetail' =>
              'Shipment::FedEx::WSDL::TrackTypes::SpecialInstructionStatusDetail',
            'OriginalEstimatedDeliveryTimestamp' =>
              'SOAP::WSDL::XSD::Typelib::Builtin::dateTime',
            'OriginalRequestTime' =>
              'SOAP::WSDL::XSD::Typelib::Builtin::dateTime',
            'RequestedAppointmentTime' =>
              'Shipment::FedEx::WSDL::TrackTypes::AppointmentDetail',
        },
        {

            'Description'    => 'Description',
            'DeliveryOption' => 'DeliveryOption',
            'StatusDetail'   => 'StatusDetail',
            'OriginalEstimatedDeliveryTimestamp' =>
              'OriginalEstimatedDeliveryTimestamp',
            'OriginalRequestTime'      => 'OriginalRequestTime',
            'RequestedAppointmentTime' => 'RequestedAppointmentTime',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackSpecialInstruction

=head1 VERSION

version 2.03

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TrackSpecialInstruction from the namespace http://fedex.com/ws/track/v9.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Description

=item * DeliveryOption

=item * StatusDetail

=item * OriginalEstimatedDeliveryTimestamp

=item * OriginalRequestTime

=item * RequestedAppointmentTime

=back

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackSpecialInstruction

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::TrackTypes::TrackSpecialInstruction
   Description =>  $some_value, # string
   DeliveryOption => $some_value, # TrackDeliveryOptionType
   StatusDetail =>  { # Shipment::FedEx::WSDL::TrackTypes::SpecialInstructionStatusDetail
     Status => $some_value, # SpecialInstructionsStatusCode
     StatusCreateTime =>  $some_value, # dateTime
   },
   OriginalEstimatedDeliveryTimestamp =>  $some_value, # dateTime
   OriginalRequestTime =>  $some_value, # dateTime
   RequestedAppointmentTime =>  { # Shipment::FedEx::WSDL::TrackTypes::AppointmentDetail
     Date =>  $some_value, # date
     WindowDetails =>  { # Shipment::FedEx::WSDL::TrackTypes::AppointmentTimeDetail
       Type => $some_value, # AppointmentWindowType
       Window =>  { # Shipment::FedEx::WSDL::TrackTypes::LocalTimeRange
         Begins =>  $some_value, # string
         Ends =>  $some_value, # string
       },
       Description =>  $some_value, # string
     },
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
