package Shipment::FedEx::WSDL::TrackTypes::TrackSpecialHandling;
$Shipment::FedEx::WSDL::TrackTypes::TrackSpecialHandling::VERSION = '3.02';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://fedex.com/ws/track/v9'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %Type_of : ATTR(:get<Type>);
    my %Description_of : ATTR(:get<Description>);
    my %PaymentType_of : ATTR(:get<PaymentType>);

    __PACKAGE__->_factory(
        [   qw(        Type
              Description
              PaymentType

              )
        ],
        {   'Type'        => \%Type_of,
            'Description' => \%Description_of,
            'PaymentType' => \%PaymentType_of,
        },
        {   'Type' =>
              'Shipment::FedEx::WSDL::TrackTypes::TrackSpecialHandlingType',
            'Description' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'PaymentType' =>
              'Shipment::FedEx::WSDL::TrackTypes::TrackPaymentType',
        },
        {

            'Type'        => 'Type',
            'Description' => 'Description',
            'PaymentType' => 'PaymentType',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackSpecialHandling

=head1 VERSION

version 3.02

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TrackSpecialHandling from the namespace http://fedex.com/ws/track/v9.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Type

=item * Description

=item * PaymentType

=back

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackSpecialHandling

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::TrackTypes::TrackSpecialHandling
   Type => $some_value, # TrackSpecialHandlingType
   Description =>  $some_value, # string
   PaymentType => $some_value, # TrackPaymentType
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
