package Mail::Milter::Authentication::Extra;
use strict;
use warnings;
use Mail::Milter::Authentication 2;
our $VERSION = '2.20180611'; # VERSION
# ABSTRACT: Extra handlers for Authentication Milter

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Mail::Milter::Authentication::Extra - Extra handlers for Authentication Milter

=head1 VERSION

version 2.20180611

=head1 SYNOPSIS

This is a collection of additional handler modules for Authentication Milter.

Please see the output of 'authentication_milter --help' for usage help.

=head1 DESCRIPTION

Additional handlers for Authentication Milter which did not fit within the core functionality, or
are not yet 100% production ready.

=head1 DEPENDENCIES

  Mail::Milter::Authentication
  Mail::SpamAssassin
  Mail::SpamAssassin::Client
  DB_File

=head1 AUTHOR

Marc Bradshaw <marc@marcbradshaw.net>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Marc Bradshaw.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
