unit class Curlie::Response;

use JSON::Fast;
use LibCurl::Easy:ver<1.4>;
use Log::Async;

has $.lc handles <statusline content success>;
has %!status;
method headers { $!lc.receiveheaders }
method raw-headers { $!lc.raw-headers };
method json {
  return Nil unless self.content && self.content.chars > 0;
  from-json(self.content);
}
method status {
  self.parse-status<status>
}
method parse-status {
  %!status = %( <http-version status status-reason> Z=> self.statusline.split(' ') ) unless %!status;
  %!status;
}
method gist {
    self.raw-headers
  ~ self.lc.buf.decode
}
method Str {
  self.statusline
}
