# Generated by default/object.tt
package Paws::IoTSiteWise::CompositeModelProperty;
  use Moose;
  has AssetProperty => (is => 'ro', isa => 'Paws::IoTSiteWise::Property', request_name => 'assetProperty', traits => ['NameInRequest'], required => 1);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::CompositeModelProperty

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::CompositeModelProperty object:

  $service_obj->Method(Att1 => { AssetProperty => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::CompositeModelProperty object:

  $result = $service_obj->Method(...);
  $result->Att1->AssetProperty

=head1 DESCRIPTION

Contains information about a composite model property on an asset.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AssetProperty => L<Paws::IoTSiteWise::Property>




=head2 B<REQUIRED> Name => Str

The name of the property.


=head2 B<REQUIRED> Type => Str

The type of the composite model that defines this property.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

