use strict;
use warnings;

use Test::More;
use PDL;
use PDL::IO::Image;
use Test::Number::Delta within => 0.0000001;

my $expected = [
[
 [32768, 8192,32768, 8192,32768,32768,32768,57344,32768, 8192,57344,57344, 8192,32768,32768,32768,32768,32768, 8192,57344,32768,57344,32768, 8192,32768,32768, 8192,32768,32768, 8192, 8192,57344, 8192, 8192, 8192,57344, 8192, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768, 8192,57344,32768,32768,32768, 8192, 8192, 8192,57344,57344,57344,57344, 8192,57344,57344, 8192,32768,57344,32768,57344,57344, 8192,57344,57344],
 [57344, 8192,32768,32768,32768,32768,32768,32768,57344, 8192,57344,57344, 8192,57344,32768,32768,57344,32768,32768, 8192, 8192,32768,57344,57344, 8192, 8192,32768,32768,32768,32768, 8192,32768,32768,57344,32768,32768,32768,32768, 8192,57344,32768,32768, 8192, 8192, 8192,57344,32768, 8192,32768,32768,32768, 8192, 8192,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768,57344, 8192,32768, 8192,32768, 8192, 8192, 8192],
 [32768, 8192,57344,32768,57344,32768,32768, 8192,32768, 8192,57344,57344, 8192, 8192,57344,32768, 8192,32768,57344,32768,32768,32768, 8192, 8192,32768,57344,57344,57344, 8192,32768, 8192,57344, 8192, 8192, 8192,32768,32768,32768,32768,32768,32768,57344, 8192, 8192,57344,32768, 8192,57344,32768,32768, 8192,57344,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768,32768,32768,57344,57344, 8192,32768, 8192,32768,32768],
 [32768,57344,57344,32768,32768,32768, 8192,32768,57344,32768,57344,32768,57344,32768, 8192,32768,32768,57344,57344,32768,32768,57344,32768, 8192, 8192,32768,32768,32768,32768, 8192, 8192,32768,32768, 8192,57344,32768,32768, 8192, 8192,32768,32768, 8192, 8192,32768, 8192,32768,32768,32768,57344,32768, 8192, 8192,32768, 8192,57344, 8192,57344,57344,32768, 8192,32768,32768,32768,32768,32768,57344,57344,57344,57344,57344, 8192],
 [32768,32768,32768, 8192, 8192, 8192,57344,32768,32768,57344,32768, 8192,32768,57344,32768,32768,32768, 8192,32768, 8192,57344, 8192, 8192,32768,32768,32768,32768,32768, 8192,57344,57344,32768,32768,57344,32768,57344,57344,57344,32768,57344,32768,32768,32768, 8192,57344,32768, 8192,32768, 8192,57344,57344,32768,32768,57344,57344,57344,32768,32768,32768,32768,57344, 8192,32768, 8192,57344, 8192,32768, 8192,57344,57344,32768],
 [32768, 8192,32768,32768,32768,32768,32768, 8192,32768,57344, 8192,32768,57344,32768,57344, 8192, 8192, 8192,57344,32768,57344,32768, 8192,32768,32768,32768, 8192,57344,32768,32768,57344,32768,57344,32768, 8192,32768,57344,32768,32768,32768,32768,32768,32768,57344,57344,32768,57344,32768,32768,32768, 8192,57344,32768,32768,57344,32768, 8192,32768, 8192,57344,32768, 8192,32768, 8192,32768,57344,32768, 8192,32768, 8192, 8192],
 [32768,32768,32768,32768, 8192,32768, 8192,57344, 8192,57344, 8192,32768,32768,57344,32768,32768,57344,32768, 8192,32768,57344, 8192,32768, 8192,57344, 8192, 8192,57344, 8192, 8192, 8192,32768, 8192,32768,57344,32768,57344,57344, 8192,57344, 8192,32768,57344,32768, 8192,32768,57344,57344,57344,57344,57344,57344,32768, 8192,32768, 8192, 8192,32768, 8192,57344,32768,32768,32768,32768, 8192,57344,57344,57344,32768,32768, 8192],
 [57344, 8192,32768,32768,32768,32768,32768,32768,32768,32768, 8192,57344,32768, 8192,57344,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,32768,32768,32768, 8192,32768,32768,57344,57344,32768,32768,32768,32768,57344, 8192, 8192, 8192,32768, 8192,57344,32768,32768,57344,32768,57344, 8192, 8192,32768,57344,32768,32768,32768,32768, 8192,32768,57344,32768,32768, 8192, 8192,57344,57344, 8192,32768],
 [57344,57344,57344,32768,32768,57344,32768, 8192,57344, 8192,57344,32768,32768,57344,57344,32768,32768,32768, 8192,32768,32768, 8192,57344, 8192,32768,32768,57344,32768,32768,57344,57344,57344,32768,57344, 8192, 8192,32768,32768, 8192,32768, 8192, 8192,32768, 8192, 8192,32768,32768,57344,57344, 8192,32768,57344,57344,57344, 8192,57344,32768,32768,32768,57344,32768,57344,32768,32768,32768,57344,32768,57344,32768, 8192, 8192],
 [32768,57344,57344,57344,32768,32768,32768,32768,57344, 8192,57344,32768,57344,32768,32768,32768, 8192, 8192,32768,32768,32768,32768,32768,32768,32768,57344, 8192,32768,57344, 8192, 8192, 8192, 8192,32768,57344,32768,57344,32768, 8192, 8192,32768,57344, 8192,32768,32768,57344,57344,57344,57344,57344,57344,32768,32768,32768,57344,57344,57344,32768, 8192,32768,57344,32768,32768,32768,32768, 8192,57344,32768,57344,32768,57344],
 [57344,32768,32768, 8192,32768,57344,32768,57344,32768,32768, 8192,32768,32768,32768,32768, 8192,57344,57344,32768,57344, 8192,32768,32768,57344,32768,32768, 8192,57344,32768, 8192,57344, 8192,57344,32768, 8192,32768,32768, 8192,32768,57344,32768,32768,32768,57344, 8192,32768,57344,32768,32768,57344, 8192,32768,57344,32768,32768,57344, 8192,32768, 8192,32768, 8192,32768, 8192,57344,57344,32768,32768,57344, 8192,32768, 8192],
 [57344,32768,57344,32768, 8192, 8192,32768,57344,32768,57344,32768, 8192,57344,32768,57344,57344, 8192,32768, 8192,57344, 8192,32768,57344,32768,57344,32768, 8192,32768, 8192, 8192, 8192,32768, 8192,32768,57344, 8192,32768, 8192,57344,32768, 8192,32768,32768,32768,32768,32768, 8192,32768, 8192,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768,57344, 8192,57344,57344, 8192,57344,32768,32768,57344,32768, 8192,32768],
 [ 8192, 8192, 8192, 8192,32768,32768,32768,32768,32768,57344, 8192,32768,32768,32768,57344,32768,32768,57344,32768,32768,32768, 8192, 8192, 8192,32768, 8192,32768, 8192, 8192, 8192, 8192,32768,32768,32768,32768,57344,57344,57344, 8192,32768,57344, 8192,57344,32768,32768,32768, 8192, 8192,32768,32768, 8192,32768, 8192, 8192,32768,32768,57344,32768,32768, 8192,57344,32768,57344,57344, 8192,57344,57344,32768,57344,57344,32768],
 [ 8192,32768,32768,32768, 8192,57344,32768,32768,32768, 8192,57344,32768,57344,32768,57344,32768,32768,32768,32768,57344, 8192, 8192,57344,32768,57344, 8192,32768,32768,57344, 8192,32768,32768,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,57344, 8192, 8192,32768,32768,57344, 8192,32768,32768, 8192,32768, 8192,32768,32768,57344, 8192,57344,32768,57344,32768,32768,32768,32768, 8192, 8192, 8192, 8192,57344,57344],
 [32768,57344,57344, 8192,32768,32768,32768,32768,32768,32768,32768, 8192,32768,57344, 8192, 8192,32768,32768,32768,32768,57344,32768, 8192,57344,57344,32768, 8192,57344, 8192,32768, 8192,32768,57344,32768,57344,57344,32768,32768,32768,32768,32768, 8192,57344,32768, 8192, 8192,32768,32768, 8192,32768,32768,32768, 8192,57344,32768,32768,57344,32768,57344, 8192,32768,57344, 8192, 8192,32768,32768,32768,32768, 8192,32768,32768],
 [ 8192,57344,32768,32768, 8192, 8192,32768,57344,32768,32768, 8192,32768,57344, 8192,57344, 8192,32768,57344, 8192,32768, 8192,32768,32768,32768,57344,57344,32768,32768,32768,57344, 8192,32768, 8192,57344,32768,32768,57344,57344,32768,32768, 8192,57344,57344,32768, 8192,32768,32768, 8192,32768,32768,57344,57344, 8192,32768,32768,32768,57344,32768, 8192,32768,32768, 8192,57344, 8192,32768,32768,32768, 8192,57344, 8192,32768],
 [57344,32768, 8192,32768,32768,57344,32768,57344,32768, 8192,32768, 8192,32768, 8192,32768,32768,32768,32768,32768, 8192, 8192,57344,32768,57344,57344,57344,57344, 8192,32768,57344,32768,32768, 8192,32768,57344, 8192,57344, 8192,32768, 8192,32768, 8192,32768, 8192,32768,32768,57344,57344,57344,32768,32768,32768,57344,57344,32768, 8192,32768,32768,32768,57344, 8192,32768,57344,32768,32768,32768,57344,57344,32768,32768,32768],
 [32768,32768, 8192,57344, 8192, 8192, 8192,57344,32768,57344, 8192, 8192,32768,57344, 8192,32768,32768,32768, 8192,57344, 8192,57344,32768,32768,32768,57344, 8192,32768,32768,32768,57344,32768, 8192, 8192, 8192,32768, 8192, 8192,57344,32768, 8192, 8192,32768,32768,32768,32768,32768, 8192,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,57344,32768, 8192,32768, 8192,32768,57344],
 [ 8192,32768,57344,57344,32768, 8192,57344, 8192, 8192,32768,57344, 8192,32768,32768,57344, 8192,32768,57344, 8192,57344, 8192,57344,57344,57344,32768,32768, 8192,32768,32768,32768,57344, 8192,57344,32768,57344, 8192,57344,32768,32768,32768, 8192, 8192,57344,32768, 8192,32768, 8192,32768, 8192,57344,32768,32768, 8192,57344,57344,57344, 8192,57344,57344,32768, 8192, 8192, 8192,32768,32768,32768, 8192,32768,32768,57344,32768],
 [32768,57344,32768,32768,32768, 8192,57344,32768,32768, 8192, 8192,57344,57344,57344,32768,57344,57344, 8192,32768,57344,57344, 8192,32768,57344, 8192,32768,32768,57344,32768,32768,32768, 8192,57344,57344, 8192, 8192,32768, 8192, 8192,32768,57344,32768, 8192, 8192, 8192,57344,32768, 8192,57344,32768,32768,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768, 8192,57344,57344,32768,57344,32768, 8192,32768,32768,57344],
 [32768,32768,32768,57344,57344,32768,32768,32768,32768, 8192,32768,32768,32768, 8192,57344,32768,57344,32768,32768,32768, 8192,57344,57344, 8192,32768, 8192,57344,57344,32768,32768,57344, 8192,32768,32768,32768,32768, 8192,32768,32768,32768,32768, 8192,32768,32768,32768,57344,32768, 8192,32768,32768,32768,32768,57344,57344,57344,32768, 8192,32768,32768,32768,32768,57344,32768,32768,57344,32768,32768,57344,32768,32768,32768],
 [32768,32768, 8192,57344,57344,57344,32768,57344,57344,32768, 8192,57344,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768, 8192,32768,32768,32768,32768,32768, 8192,57344, 8192,32768, 8192,32768,32768,57344,32768, 8192,32768,57344,32768,32768,32768, 8192, 8192,32768,57344,32768,32768,57344, 8192, 8192,32768,32768, 8192,57344,32768,32768,32768,32768,32768,32768, 8192, 8192,32768,57344, 8192,57344,32768,57344,32768],
 [ 8192, 8192,32768,32768,32768,57344,32768, 8192, 8192,32768, 8192,57344,57344,57344,32768,32768,32768,32768,32768,32768,57344,32768,32768,57344,32768,32768,57344, 8192,32768, 8192,32768, 8192,57344,32768,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768,57344,32768,57344,32768, 8192,32768,57344,32768,32768,32768, 8192,57344,57344,57344,32768,57344, 8192, 8192,32768,32768, 8192, 8192,57344,32768,32768, 8192, 8192],
 [ 8192,57344, 8192,57344, 8192,57344, 8192, 8192,32768,32768, 8192,32768,57344,57344, 8192, 8192,57344, 8192,57344,32768,57344,57344,32768,32768,32768, 8192,32768,32768,32768, 8192, 8192,32768,32768,32768,32768,32768,57344, 8192,32768,32768,32768,57344,32768,32768,32768,57344,57344, 8192,32768,32768,32768,32768,57344,32768,32768,57344,32768,57344,32768,32768, 8192,32768,57344, 8192,57344,57344,32768,32768, 8192,32768,32768],
 [32768, 8192,57344,32768, 8192, 8192,32768,57344,32768,32768,57344,32768,32768,32768,57344,32768,32768,32768,32768,32768,32768,57344, 8192,32768, 8192, 8192,32768, 8192,57344,32768, 8192,32768, 8192,32768,57344, 8192,57344,32768,32768,32768, 8192,32768,32768,32768,57344,32768,57344,32768,32768, 8192,32768,32768,32768, 8192,57344,32768,32768,32768,57344, 8192,32768, 8192,57344,32768,57344,57344, 8192, 8192,32768,32768,32768],
 [32768, 8192,32768,57344,57344, 8192,32768,57344,57344, 8192,32768, 8192,32768,32768,32768,32768, 8192, 8192,32768,32768, 8192,32768,32768, 8192,32768,32768,32768,32768, 8192,57344,57344,32768,32768,57344,32768,32768,57344, 8192, 8192,32768,32768, 8192, 8192,32768,32768,32768, 8192, 8192,32768,57344,32768,32768,57344, 8192, 8192, 8192,32768,57344,57344,32768,32768, 8192,32768,32768,32768,57344,57344,32768, 8192,32768,32768],
 [32768,32768,32768,57344,57344, 8192,32768,32768, 8192,32768,32768,57344,57344,32768,57344, 8192,32768,32768, 8192,32768, 8192,32768,57344, 8192,57344, 8192,57344,32768, 8192,32768,32768,57344, 8192,32768,32768, 8192,57344, 8192,32768,32768, 8192,32768, 8192,32768,32768,57344,32768,57344, 8192, 8192,57344,32768,57344,32768, 8192,57344,32768,32768,57344,32768,32768,32768,32768, 8192,57344, 8192,57344,32768,32768, 8192,57344],
 [ 8192,32768,32768,32768,32768,32768,32768,57344,57344,32768, 8192,32768, 8192,57344,32768,57344, 8192, 8192, 8192, 8192,32768,57344,57344,32768,32768,32768,32768,57344, 8192,32768,32768,57344,57344,57344,32768,32768,32768,32768,32768, 8192,32768,57344,32768, 8192,57344,57344,57344,32768,32768,57344,32768,32768,57344,32768,57344,32768,32768,32768,57344,57344,57344,32768, 8192,57344,57344, 8192,32768,32768,32768,57344,32768],
 [ 8192,57344,32768,32768,32768,32768,57344,57344,32768,57344, 8192, 8192,57344,32768,32768,57344,32768, 8192,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768, 8192, 8192,32768,32768, 8192, 8192,32768,32768, 8192,57344, 8192, 8192,32768,32768,57344,32768,32768,57344,57344, 8192,57344,32768,32768, 8192,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768,57344,57344,32768, 8192,57344, 8192,32768,32768,57344],
 [32768, 8192,32768, 8192, 8192,32768, 8192,32768,32768,32768,32768,32768, 8192,32768,57344, 8192,32768, 8192,32768,32768,57344,32768,57344,32768, 8192, 8192,32768, 8192,32768,57344, 8192,32768,57344,32768,32768,57344, 8192,57344,32768,32768,32768, 8192, 8192, 8192, 8192, 8192,32768,57344,32768,32768, 8192,32768,57344,32768,57344, 8192,32768,32768, 8192,32768,32768,32768, 8192, 8192,32768,32768,57344, 8192,57344,32768,32768],
 [32768, 8192,32768, 8192,57344,32768,57344, 8192,57344, 8192,32768,32768, 8192,57344, 8192,32768,32768,32768,32768,57344,57344, 8192, 8192, 8192,32768,57344,32768, 8192,32768,57344,32768,32768,32768,57344,32768,32768,57344,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768,57344, 8192,32768, 8192,57344,32768, 8192,32768,57344,57344,57344,32768,32768, 8192,32768, 8192,57344, 8192,57344, 8192,32768, 8192,57344,57344],
 [32768, 8192,32768, 8192,32768,32768,57344,32768, 8192, 8192,57344, 8192,57344,32768, 8192, 8192, 8192,32768,32768,57344,32768, 8192,32768,32768,57344,32768,32768,57344,57344,32768, 8192,32768,32768,32768,32768, 8192,32768,32768,32768, 8192,32768, 8192,32768, 8192,57344,57344,57344, 8192,32768,57344, 8192, 8192,32768, 8192,57344,57344,57344,32768, 8192,32768,57344,32768,32768,57344,32768, 8192,32768,57344, 8192,32768,32768],
 [32768,32768,32768, 8192,57344,57344, 8192,32768, 8192,57344, 8192, 8192,32768,32768,32768,57344, 8192,32768,32768,57344,32768,57344,32768, 8192,57344,57344,32768,57344, 8192,57344, 8192, 8192,32768, 8192,57344,32768,32768, 8192, 8192, 8192,32768,32768,32768, 8192,57344, 8192,32768, 8192,57344, 8192, 8192,57344, 8192,32768,32768,57344, 8192,32768,32768,32768,32768,32768,32768,32768,57344,57344,57344,32768,57344,32768,57344],
 [32768,57344, 8192,57344,32768, 8192,32768,32768,32768,32768,32768,57344,32768,32768,32768,57344, 8192,32768,32768,32768, 8192,32768,57344, 8192,32768, 8192,57344,57344, 8192,57344, 8192,32768,32768, 8192,57344,32768,32768,32768,32768,32768,57344,32768,57344,57344,32768,32768,57344, 8192,32768,57344, 8192, 8192,57344,32768,32768,32768,32768,57344,57344,32768, 8192,32768,57344,57344,32768,32768, 8192,32768, 8192, 8192,57344],
 [ 8192,57344, 8192,57344,32768,57344, 8192,57344,32768,32768,32768,57344,32768, 8192, 8192,32768,32768, 8192,32768,32768,32768,32768, 8192,57344,32768, 8192,57344, 8192,32768, 8192, 8192, 8192,32768,32768,57344,57344,32768,57344, 8192,32768,32768,32768,32768, 8192,57344,32768,57344,32768,32768,57344,32768,32768,32768,57344,32768, 8192, 8192, 8192,57344,32768,32768, 8192,57344, 8192,32768,32768,32768, 8192,57344,57344, 8192],
 [ 8192, 8192,32768,32768,32768,32768,32768,57344,32768,32768,32768,57344,57344, 8192, 8192, 8192,32768,32768, 8192,32768,32768, 8192, 8192,32768, 8192,57344, 8192,32768, 8192, 8192,32768,57344,32768,32768,57344, 8192,57344, 8192,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768, 8192,32768, 8192, 8192,32768,32768,57344,32768,57344,57344,32768, 8192,32768, 8192,32768,32768, 8192,32768,32768,32768,57344,57344,32768],
 [ 8192,32768, 8192, 8192,32768,57344,57344,57344, 8192,57344, 8192,32768,32768,32768,32768,32768,57344, 8192,32768,32768,57344,32768, 8192,32768,57344, 8192,32768,32768,57344,32768,32768,57344,32768,32768,32768,57344, 8192, 8192,32768, 8192,32768,32768, 8192,32768,32768,32768,32768, 8192,32768,57344, 8192,57344,57344,32768,32768,32768,57344,32768, 8192,57344, 8192,32768,57344,57344,32768,57344, 8192,32768,32768, 8192,32768],
 [32768, 8192,32768,32768,32768, 8192,32768,32768, 8192,57344,32768,32768,32768,32768, 8192,32768,32768,32768, 8192,32768,57344,32768, 8192, 8192,32768,57344, 8192,57344,32768, 8192,32768,32768,32768,57344, 8192, 8192,57344, 8192,32768,32768,57344,32768, 8192,57344,57344,57344,32768, 8192,32768,57344,57344,57344, 8192,57344,57344, 8192,32768,32768,32768,57344,32768,32768,32768, 8192,32768,32768, 8192,57344,32768,32768,32768],
 [32768,32768,57344, 8192,32768,32768, 8192,57344, 8192,57344, 8192,32768,32768,32768,32768, 8192,32768, 8192, 8192,57344,32768, 8192,32768,32768, 8192,32768,32768, 8192, 8192,32768,32768,32768,32768,32768, 8192, 8192,32768,57344, 8192, 8192,32768,32768, 8192,32768,32768, 8192,32768,57344,57344, 8192,32768, 8192,57344, 8192,32768, 8192,32768, 8192,57344,32768,57344,57344, 8192,32768,32768,32768,32768, 8192,32768,57344, 8192],
 [57344,32768,57344,32768, 8192,32768, 8192,32768,57344, 8192,57344, 8192,32768,57344,57344,57344,57344,57344,57344,32768, 8192,57344,57344,32768,57344,32768,32768,57344,57344,32768,57344,32768,57344,32768,57344,32768,32768,32768,32768,32768,32768,57344, 8192,32768,57344, 8192, 8192,32768,32768, 8192,32768,32768, 8192,32768,57344, 8192, 8192,32768,32768,57344,32768,32768,32768, 8192,32768,57344, 8192,32768,32768, 8192, 8192],
 [57344,32768,57344, 8192,32768,57344,32768,32768, 8192,32768,32768,57344,32768,32768, 8192, 8192,32768,32768,32768,32768, 8192,32768, 8192, 8192,57344,57344,32768,32768,57344, 8192,32768, 8192,32768,32768, 8192,32768,32768, 8192,32768, 8192,32768,32768,57344, 8192,57344,32768,32768,32768,32768,57344,57344,32768,32768,32768,57344, 8192, 8192,32768, 8192, 8192,57344, 8192,32768,32768,57344, 8192,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,57344,32768,57344,32768,57344, 8192,32768,32768, 8192,32768,57344, 8192,57344, 8192,32768,32768,32768,32768,32768,57344, 8192,32768,32768,32768,32768, 8192,32768, 8192,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768, 8192,32768, 8192,32768, 8192, 8192, 8192,32768,32768, 8192, 8192,32768,32768,32768,32768,32768,32768, 8192, 8192,57344, 8192,32768, 8192,32768,32768],
 [32768,32768,57344,32768,57344,32768, 8192,32768,57344, 8192,32768,57344,32768, 8192, 8192,32768,57344,57344,32768,57344, 8192,57344,32768,32768, 8192,57344,57344,32768, 8192,57344,57344, 8192,57344,32768, 8192, 8192, 8192, 8192,57344, 8192, 8192,57344,57344,57344,32768,32768,32768, 8192, 8192,32768,57344,32768,32768,32768,32768,32768,57344,32768, 8192,32768, 8192,32768,32768, 8192,32768, 8192, 8192, 8192,32768,32768,57344],
 [32768,32768,32768,32768, 8192,32768,32768,57344, 8192,32768, 8192,32768,57344,57344,32768,57344,32768,57344,32768,32768,32768,57344,57344,57344,32768,32768, 8192,32768, 8192,32768,57344,32768,32768,32768,57344, 8192,32768, 8192, 8192,32768,32768,57344,32768,32768,32768,57344, 8192, 8192,32768, 8192,57344, 8192,32768,32768,57344,32768, 8192,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768, 8192,32768,32768,32768],
 [57344,57344, 8192,32768, 8192,32768,32768,57344, 8192,57344,32768,57344,32768,32768,32768,57344,57344,57344, 8192,57344,57344,32768,57344,32768,32768, 8192,32768,32768, 8192,32768,32768, 8192,32768,57344,32768,57344,57344,32768,32768,57344,32768,57344,32768,32768,32768, 8192,32768, 8192,32768,57344,32768,32768,57344,32768,32768, 8192,57344,32768,57344,57344,32768,32768,57344,57344,32768,32768,32768,32768,32768, 8192,32768],
 [57344,57344, 8192, 8192, 8192,32768,57344,32768,32768,32768, 8192, 8192, 8192, 8192,57344,57344,57344, 8192, 8192,32768,32768, 8192,32768,57344,32768,32768,32768,32768,32768,57344, 8192,32768,32768,32768, 8192,32768,57344, 8192,32768,57344, 8192, 8192, 8192,57344, 8192, 8192, 8192,32768,57344,57344,32768, 8192,32768,32768,32768, 8192, 8192,32768,32768,32768,57344, 8192,32768,32768,32768, 8192,32768,32768,57344, 8192,32768],
 [32768,57344, 8192, 8192, 8192, 8192,57344,57344,32768,32768,57344,57344,32768,57344, 8192,32768,32768,32768,57344,32768,32768,32768,32768,32768,32768,57344,57344,32768,32768,32768,57344,57344,32768,32768,32768, 8192, 8192, 8192,32768,32768,57344,32768,32768,57344,57344, 8192,32768,32768, 8192,57344,57344,32768,32768, 8192,32768,32768,57344,32768,32768,32768,57344,57344,32768,57344, 8192,57344,32768,32768, 8192, 8192,32768],
 [32768,57344,32768,57344,32768,57344, 8192,32768,57344,32768, 8192,32768, 8192,32768,57344,32768, 8192,32768, 8192,32768,32768,57344,57344,32768, 8192,32768,32768,57344,32768, 8192,32768,57344, 8192,57344, 8192,57344, 8192,32768, 8192,32768,32768, 8192, 8192,32768,32768, 8192,32768,57344, 8192,32768,32768,57344,32768,32768, 8192,32768,32768,32768,57344,32768,57344, 8192, 8192,57344,32768,57344,32768,32768, 8192,32768, 8192],
 [32768, 8192,32768,32768,57344,32768,32768, 8192, 8192, 8192,32768,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768,32768,57344,57344,32768,32768, 8192,32768,32768, 8192,32768,32768,57344,57344,32768,57344,32768,32768,32768, 8192,32768,32768,32768,57344, 8192,32768,32768, 8192,57344, 8192,32768, 8192,32768,32768, 8192,32768,32768,32768,32768,32768,57344,32768,57344,32768, 8192,32768,57344,32768,57344,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768, 8192, 8192,32768, 8192, 8192,57344,32768, 8192,32768,32768,32768,32768,32768, 8192,32768,32768, 8192,32768,32768,32768,32768,32768,57344,32768,57344,32768,57344,32768,32768,57344, 8192, 8192,32768, 8192,57344,32768,32768,32768,57344,32768,57344,57344,57344,57344,32768, 8192, 8192,57344,32768,32768,32768,57344,32768,57344,32768, 8192,57344,57344,32768,57344,32768, 8192,32768,32768],
 [ 8192,32768,32768, 8192,57344,57344,32768, 8192, 8192,57344,57344,32768,57344,57344,57344, 8192,32768, 8192,32768,32768,32768,32768,32768,57344,57344,32768,57344,32768, 8192, 8192, 8192,57344,32768,32768, 8192,32768,57344,57344,32768,32768, 8192,32768,57344,57344,57344,57344,32768, 8192,32768,32768, 8192,32768,32768, 8192,57344, 8192,32768,57344,32768,32768,57344,57344,32768,32768, 8192,32768,57344,57344,32768,57344,57344],
 [57344,32768, 8192,32768,32768, 8192,32768,32768,57344, 8192,32768,57344,32768,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768, 8192,32768,32768, 8192,32768, 8192,32768,32768,57344,32768,32768, 8192,32768,32768, 8192, 8192,32768,32768,57344,32768,32768, 8192,57344,57344,32768,32768,32768,57344,57344, 8192,32768,32768,57344,32768,32768,57344,57344,57344, 8192, 8192,32768,32768,57344,32768],
 [57344,32768,57344, 8192,32768,32768,57344, 8192,32768,32768, 8192,32768,32768,32768,32768,57344,57344,57344,32768,32768,32768,32768, 8192,57344,32768, 8192,57344,32768,32768, 8192, 8192, 8192, 8192, 8192,57344,32768,57344, 8192, 8192,57344,57344,32768,32768,57344,32768,57344,57344,57344,57344,32768,57344,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,32768, 8192,57344,32768,57344,57344,32768,57344],
 [ 8192,32768,57344,32768,57344,32768,57344,57344, 8192,57344, 8192,57344,57344, 8192,32768,57344, 8192,32768,57344,32768,32768,57344,57344,57344,57344, 8192,57344,32768,32768,32768,57344, 8192,57344, 8192,32768, 8192, 8192, 8192,32768,32768,57344,32768,57344,32768,32768, 8192, 8192, 8192, 8192,32768,32768,57344,32768, 8192,32768,32768,57344,32768,57344,57344,32768,32768,57344,32768,57344, 8192,32768,32768,57344,32768,32768],
 [32768,57344,57344,32768, 8192,57344,57344,32768,57344,57344,57344,57344, 8192,32768,57344,57344,57344, 8192,57344,57344,32768,32768, 8192, 8192,57344, 8192,32768,32768,32768,32768,32768,57344, 8192,57344,57344,32768, 8192,32768, 8192, 8192, 8192,57344,32768, 8192,32768,32768, 8192,32768,32768,32768,32768, 8192,32768,57344,57344,57344,57344,32768,32768,32768,32768,57344,32768,32768, 8192,57344,32768, 8192,32768,32768,57344],
 [32768,57344, 8192,57344,57344,32768,32768,32768, 8192,32768,32768,32768, 8192,57344,32768,32768,32768,57344,57344,32768,57344,32768,32768, 8192, 8192, 8192,32768, 8192,32768,57344,32768,32768, 8192,32768,32768, 8192,32768, 8192, 8192,57344,57344,32768, 8192, 8192, 8192,32768,32768, 8192,57344, 8192,32768,57344,32768,32768,32768, 8192,57344,32768,32768, 8192,32768,32768,57344,32768,32768, 8192,32768,32768,32768, 8192,32768],
 [32768,57344,57344,32768,57344,32768, 8192,57344, 8192, 8192,57344,32768,57344, 8192,32768,57344,32768,57344, 8192,32768,32768,32768,32768,57344,32768,32768,57344,32768,57344,32768,57344,32768,32768, 8192,57344, 8192, 8192,32768,32768,32768, 8192,32768,57344,32768, 8192, 8192,32768,57344, 8192, 8192,57344, 8192,32768,32768,32768,32768, 8192, 8192,32768,32768,32768, 8192,32768, 8192,32768, 8192, 8192,57344, 8192,32768,57344],
 [ 8192, 8192, 8192,32768,32768,57344,32768,57344,57344,57344,32768, 8192,32768,32768, 8192, 8192,32768, 8192, 8192, 8192,32768,57344,32768,57344, 8192, 8192, 8192,32768,32768,57344, 8192,57344,57344,57344,57344,57344,32768,32768,32768,57344,57344,32768,32768,57344,32768, 8192, 8192,57344,57344,32768,32768,32768,57344,32768,32768,57344,57344,32768,32768,57344, 8192,32768,32768, 8192,32768,32768,57344, 8192,32768,32768,32768],
 [32768,32768, 8192,57344,32768, 8192,57344,32768,57344,32768,32768,32768,32768,57344,32768,57344, 8192,32768, 8192,32768,57344, 8192,32768,32768,57344,57344,32768, 8192,32768,57344,57344,32768, 8192,57344,57344,32768,32768,57344,32768,57344,57344,32768, 8192,32768,32768,32768,32768, 8192,57344,32768,57344,32768, 8192,57344,32768,32768,57344,57344,32768, 8192,32768,32768,32768, 8192, 8192,32768, 8192,32768,32768,32768,57344],
 [32768,32768,57344,32768, 8192,57344,32768,32768,32768,57344,32768,32768,32768,57344, 8192,57344, 8192,32768,32768,32768,32768,32768,57344, 8192,32768,32768,32768,32768,32768, 8192,32768, 8192, 8192,32768,32768,32768, 8192,32768,32768, 8192, 8192, 8192,32768,57344,32768,57344,32768, 8192,32768,57344, 8192,32768, 8192,57344, 8192,32768,57344,32768,57344,32768,57344,57344,57344,32768,32768, 8192,32768,32768,32768,32768,32768],
 [32768,32768,32768,57344,32768, 8192,32768,32768, 8192,57344,57344, 8192,57344,32768, 8192, 8192,57344,32768,32768,32768,57344,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,57344,57344,57344,32768,57344, 8192, 8192,32768,32768, 8192, 8192,57344, 8192,32768, 8192,57344, 8192,57344,32768,32768,32768,32768,32768,32768,32768,32768, 8192,57344,57344,57344,32768,32768,57344,32768, 8192, 8192,57344, 8192, 8192,32768],
 [32768,32768,32768, 8192,32768,57344,32768, 8192,32768, 8192,32768,57344,32768,32768,32768,32768,57344,57344, 8192,32768,32768,32768,57344, 8192, 8192, 8192,32768, 8192,32768,32768,57344, 8192, 8192, 8192,32768,32768,57344,57344, 8192, 8192,32768,32768,57344,32768,57344,57344,32768,57344,57344,32768,32768,32768,32768,32768, 8192,32768,57344,32768,32768,32768,32768, 8192,32768, 8192, 8192,57344,57344, 8192,57344,32768,32768],
 [57344, 8192,32768,32768,32768,32768, 8192,57344,32768,32768,32768,32768,57344,32768,57344,32768,57344,57344,57344,32768,32768,57344, 8192, 8192,32768,32768,57344,32768,32768,32768,32768, 8192,32768,32768,57344,32768,57344,57344,32768,57344,32768,57344, 8192,32768,57344,32768,32768,32768,32768, 8192, 8192,57344,57344,57344, 8192,32768,32768, 8192, 8192,32768,32768, 8192, 8192,32768,32768,32768, 8192, 8192,32768, 8192,57344],
 [57344,57344,32768,57344,32768,57344,57344,32768,57344,57344,32768, 8192,32768,57344, 8192, 8192,57344,32768,57344,57344, 8192,57344,32768,57344,57344,32768,32768,32768,57344, 8192,57344,57344, 8192,57344, 8192,57344,32768, 8192,32768, 8192,32768,57344,57344, 8192,32768,32768,32768,57344,57344,57344,32768,57344,32768,32768,32768,57344,32768,32768,57344,57344,57344,32768,32768,32768, 8192,32768,32768,32768,57344, 8192, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
],
[
 [ 8192,57344,32768, 8192,32768,32768,57344,32768,57344, 8192,32768, 8192, 8192, 8192,32768, 8192,57344,32768,57344, 8192,32768, 8192, 8192, 8192,32768,32768, 8192,57344,32768,32768,32768,32768,32768,57344, 8192,57344,32768,57344,32768,57344,32768,32768, 8192,32768,57344, 8192, 8192,57344,57344,32768,32768,32768,57344,32768,32768,32768,32768,32768, 8192,57344,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,57344,57344,57344,32768,32768,32768,32768,32768,57344,32768,32768,32768,32768,32768,57344,32768,32768,32768,57344,32768,57344,57344, 8192,32768,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768,57344,32768, 8192, 8192, 8192,32768,57344,32768,32768, 8192, 8192, 8192, 8192, 8192,57344,32768,32768,57344,32768,32768,32768, 8192, 8192,57344,57344, 8192, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768, 8192,57344,32768,57344,32768,32768,32768,57344,57344,32768,32768,32768, 8192, 8192,32768,32768,57344, 8192,57344,57344, 8192,32768,32768, 8192,32768,32768,32768, 8192, 8192,32768,57344, 8192,32768,32768,57344,57344, 8192,32768,57344,32768, 8192,57344, 8192, 8192,32768, 8192,57344,32768,57344,32768,32768,32768,32768,57344,32768,32768,57344,32768,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,32768,32768, 8192,32768,32768,32768,32768,32768, 8192, 8192, 8192,57344,57344,32768,32768, 8192,32768,32768,32768,32768,32768, 8192, 8192, 8192,32768, 8192, 8192,32768,57344, 8192,57344,32768,57344,32768,32768,32768, 8192,57344,32768,32768, 8192,57344,57344,32768,57344,57344,32768,32768,32768, 8192, 8192,32768,32768,32768,57344,57344, 8192,32768,32768, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,32768,32768, 8192,32768,32768,32768,32768, 8192, 8192,32768,57344, 8192, 8192,57344,57344,57344,32768, 8192,57344, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,32768, 8192,32768, 8192, 8192,57344, 8192,32768,57344, 8192,57344,32768,32768, 8192, 8192,32768,32768,32768,32768,57344,32768,57344,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,57344,32768,32768,32768,57344,32768, 8192,57344,32768, 8192,57344, 8192,32768, 8192,57344,32768,32768, 8192,32768, 8192,32768,32768,32768, 8192,32768,32768,32768,32768, 8192,57344,32768,57344, 8192,32768,57344,57344,32768,32768,57344,57344,57344,32768, 8192, 8192, 8192,57344,57344,57344,32768,32768,57344,57344,32768,57344, 8192,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [57344,32768,32768,32768, 8192, 8192,57344,32768,32768,32768,57344,32768,32768,32768,32768,32768, 8192,32768, 8192,32768,32768,32768,57344,32768, 8192, 8192,32768,32768,57344,57344,32768,57344,32768, 8192,32768,57344,32768, 8192,32768,32768, 8192,32768,57344,57344,32768,57344,32768,32768, 8192, 8192,32768, 8192,32768,32768,57344,57344, 8192,32768,32768,32768,32768,57344,32768,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192, 8192,57344,32768,32768, 8192,32768,32768, 8192,32768,32768,32768,32768, 8192,32768,32768, 8192, 8192,57344, 8192,32768,57344, 8192,32768,57344, 8192,32768,57344, 8192,32768, 8192, 8192,32768,32768,57344,57344,57344, 8192,32768, 8192,32768,57344,32768,57344, 8192,32768,32768,32768,57344,32768,32768,57344, 8192,32768,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768, 8192,57344,32768,57344,57344,57344,32768, 8192,32768,32768,32768,57344, 8192, 8192, 8192, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,57344,32768,32768, 8192,32768,57344,32768,32768,57344,32768,57344,32768,57344, 8192,57344,32768,32768,32768,32768, 8192,32768, 8192, 8192,32768,32768,57344,32768, 8192,32768,32768, 8192, 8192,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,57344,32768,32768,32768,57344,32768,57344,57344,32768,57344,32768,32768,57344, 8192,32768,32768, 8192,32768,32768, 8192,32768,32768,57344,32768,57344, 8192,32768,57344,32768,32768,32768, 8192, 8192,57344,57344,57344,57344,32768, 8192,57344,57344,32768,32768,57344,32768,57344, 8192,57344,32768,57344,32768,32768,32768, 8192,32768,57344, 8192,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,32768,32768,32768, 8192,32768, 8192,32768,32768,57344,32768,32768,32768, 8192, 8192,57344, 8192,57344, 8192,32768,32768,57344,57344,32768,57344, 8192,32768,32768,32768, 8192,32768, 8192, 8192,32768,32768,32768,32768,57344,57344,32768,32768,57344,32768,32768,57344,57344,32768, 8192,32768, 8192,32768,32768,57344,57344, 8192,57344,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [57344,57344,32768, 8192, 8192,32768, 8192,32768,57344, 8192,32768, 8192, 8192,32768,32768,32768,57344, 8192,32768,32768, 8192, 8192,57344,57344, 8192,57344, 8192,57344,32768,32768,57344, 8192,32768,57344,32768, 8192,32768,32768,32768, 8192, 8192, 8192,32768, 8192,32768,32768,32768,32768, 8192,32768,57344,32768,32768,57344,57344,32768, 8192, 8192,32768,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768,57344,32768,57344,32768,57344,32768,57344, 8192, 8192,32768,57344,32768,32768,57344, 8192, 8192, 8192, 8192, 8192, 8192,32768,32768, 8192,32768, 8192, 8192,32768,32768,32768,57344, 8192, 8192,32768,32768,32768,32768,32768,32768,57344,32768, 8192,57344, 8192,32768, 8192,57344,32768,32768,32768, 8192, 8192,57344, 8192,32768,32768, 8192, 8192,57344, 8192,57344, 8192, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,57344,32768,32768, 8192,32768,32768,57344,32768, 8192,32768, 8192,32768, 8192,32768,57344, 8192,32768,32768, 8192,32768,57344,32768, 8192,32768,32768, 8192,57344,32768,32768, 8192,57344,32768, 8192,57344,32768, 8192, 8192,32768,57344, 8192,57344,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768,57344,32768,57344,32768,57344,32768,57344,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768],
 [57344,32768, 8192, 8192,32768,32768,57344,57344, 8192,57344, 8192,32768, 8192,32768, 8192, 8192,57344,57344,32768,32768,32768,32768, 8192, 8192, 8192,32768, 8192,32768,32768,57344,32768,32768, 8192,32768, 8192,57344,57344,57344,57344,32768,32768,32768,57344, 8192,32768,32768,32768,32768,32768,32768, 8192, 8192,32768, 8192,32768,32768,57344,32768,57344,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,57344, 8192,32768, 8192,57344,57344,32768,32768, 8192,57344,32768,32768, 8192, 8192, 8192,32768,32768,57344,32768, 8192,32768,57344,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768, 8192, 8192,32768, 8192,57344,57344,32768,32768,32768,32768,32768,32768,57344, 8192,57344,32768, 8192,57344,57344,57344, 8192,57344, 8192,32768, 8192,32768,57344,32768, 8192, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768, 8192,32768,57344,32768, 8192,32768, 8192, 8192,57344,57344,32768,32768,32768,57344,57344, 8192,57344,32768,32768, 8192,32768,32768,57344,32768,32768,32768, 8192,57344,32768,32768, 8192, 8192,32768, 8192,57344,32768,32768, 8192,57344, 8192,32768,32768,32768,32768,32768,57344, 8192,57344,32768,57344,32768,32768,57344,32768, 8192,32768,57344, 8192, 8192,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [57344,32768,32768, 8192, 8192,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768,57344,32768,32768,32768,57344,57344,32768,57344,57344,32768, 8192,32768,32768,32768, 8192,32768,57344, 8192,32768, 8192,57344,32768,32768, 8192,32768,32768,32768,57344,32768, 8192,57344,32768, 8192,32768,32768, 8192,57344, 8192,32768, 8192,32768,32768,32768,32768, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768, 8192, 8192,57344, 8192,32768, 8192,32768, 8192, 8192,32768,57344,32768, 8192,32768,32768, 8192,32768, 8192,32768, 8192,32768, 8192,32768, 8192,57344,32768,32768,57344,57344,32768,57344,57344,57344,57344, 8192,32768,32768, 8192,57344,57344,32768, 8192, 8192,57344,32768,32768,32768,32768,32768, 8192,57344,57344, 8192, 8192,57344, 8192,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [57344,32768, 8192,57344, 8192,32768,32768,57344,32768, 8192, 8192, 8192, 8192,32768,57344,57344,32768,57344, 8192, 8192,32768,57344, 8192,57344,32768,32768,32768,32768, 8192,32768,57344,32768, 8192,57344, 8192,32768,32768,32768,57344,32768,32768, 8192, 8192,32768, 8192,32768,57344,57344,57344,57344,32768,32768,32768,32768, 8192,32768,32768, 8192,32768,32768,32768,57344, 8192, 8192,32768,32768,32768,32768,32768,32768,32768],
 [57344,57344, 8192,32768, 8192, 8192,32768, 8192,32768,32768,57344, 8192, 8192, 8192,57344,32768,32768,32768,32768,57344,32768, 8192,32768,32768,57344,32768, 8192,57344,57344,32768, 8192, 8192,32768, 8192,32768,57344, 8192, 8192,57344, 8192,57344, 8192, 8192,57344, 8192,57344,57344,32768,32768,32768, 8192, 8192,57344,32768,32768,57344,32768,32768, 8192,57344,32768,57344,57344, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,57344,32768,32768,32768,57344, 8192,32768, 8192,32768,57344, 8192, 8192,32768,57344, 8192,57344,32768,32768,32768,32768,32768,57344,32768,32768,57344,32768, 8192,32768,57344,32768,57344,32768,32768,32768,32768, 8192, 8192,57344,32768, 8192,32768,32768,32768, 8192,57344,32768,32768, 8192,57344,32768, 8192,32768,32768, 8192,32768, 8192,57344,32768,32768,57344,32768,57344,32768,32768,32768,32768,32768,32768,32768],
 [57344, 8192, 8192, 8192,32768,32768, 8192,32768,57344,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768,32768,57344,32768, 8192,32768,57344,57344,57344,32768,32768, 8192,32768, 8192, 8192,32768, 8192,57344,32768, 8192,32768,32768, 8192, 8192,32768,57344,32768, 8192,57344,32768,57344,32768,32768,57344,32768,32768,32768,32768,57344, 8192,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,57344,32768,32768,57344,32768,32768,57344, 8192,57344, 8192,32768,32768,32768,32768,32768,32768, 8192,57344,32768,57344,32768,32768,57344,32768, 8192,32768,57344,32768,32768, 8192,57344,32768,57344,32768,57344,57344,32768,32768,32768,57344, 8192, 8192,32768,32768,57344, 8192, 8192,32768,32768,32768,57344,32768,32768,57344,32768,32768,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,32768,57344, 8192, 8192,57344, 8192,32768,32768,57344,32768,57344, 8192, 8192,32768, 8192,32768,32768, 8192,57344, 8192,32768,32768,57344, 8192,57344,32768,32768, 8192,32768,57344,32768,57344, 8192,57344,32768, 8192,32768, 8192,32768,32768, 8192,32768, 8192,32768,32768, 8192,32768,57344,32768,32768,32768,32768,32768, 8192,57344,32768,32768, 8192,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,32768,57344,57344,57344,57344,32768, 8192,32768,32768,32768,32768, 8192, 8192,32768,32768, 8192, 8192,57344,32768,57344,32768, 8192, 8192, 8192,32768,32768,32768,32768,32768, 8192, 8192, 8192, 8192, 8192,32768, 8192, 8192, 8192,32768,57344, 8192,57344,57344,32768,32768, 8192,57344,57344,57344,32768,32768, 8192,32768,32768,57344, 8192,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [57344, 8192, 8192,57344,57344,32768, 8192,57344,57344,32768,32768,32768,57344,57344,57344,57344,57344,32768, 8192, 8192,32768,57344,32768,32768,32768,32768,32768,57344, 8192,32768,32768,32768, 8192,32768,32768,57344,32768,32768,32768,32768,32768, 8192, 8192,32768,57344, 8192, 8192,32768, 8192,32768,57344, 8192,32768,32768,32768,57344,32768, 8192, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,57344,32768, 8192,32768,57344,32768,32768,32768,32768, 8192,32768,32768,32768, 8192,57344,57344,32768,57344,32768, 8192,32768,32768, 8192,57344,57344,32768,32768,32768,32768,32768,32768,32768, 8192,32768,57344,57344,32768, 8192,32768,32768,57344, 8192, 8192, 8192,32768,32768,32768,57344,32768,32768,32768,57344,32768, 8192,32768,32768, 8192,32768,32768,32768,57344,57344,32768,32768,32768,32768,32768,32768,32768],
 [57344,57344,57344,32768,57344,32768,32768, 8192,57344,57344,32768,32768,57344,57344, 8192,57344,32768,57344,32768, 8192,32768,57344,32768, 8192,57344,32768, 8192,57344,32768,32768, 8192,32768, 8192,32768,32768,57344,32768,32768, 8192,32768,32768,57344,32768,32768,32768, 8192,57344,57344,32768,32768,32768, 8192,32768,57344,32768,57344,32768, 8192,57344,32768,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [57344,32768,32768,57344,57344, 8192,32768,32768,32768,32768,57344,32768,57344, 8192, 8192,57344,57344,32768, 8192,32768,57344, 8192,32768,57344,57344,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,32768,32768,57344, 8192,32768,32768,32768,57344,32768,32768, 8192,32768,32768,32768,32768,57344,57344,57344, 8192,32768, 8192, 8192, 8192,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192, 8192,57344,32768, 8192,57344,32768,32768,32768,57344, 8192,57344,32768,57344,32768, 8192,57344, 8192,57344,57344,57344,32768,57344,57344,32768,57344,32768,32768,32768,32768,57344,32768,32768,32768,32768,32768,32768,57344, 8192, 8192, 8192,32768,57344,57344, 8192,32768,57344,57344,57344, 8192,32768, 8192,57344,57344,32768, 8192,32768, 8192,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [57344, 8192,32768,57344,32768,32768,32768,32768,57344,32768, 8192,32768,32768,32768, 8192, 8192,32768,57344, 8192, 8192,57344,32768, 8192,57344,32768,57344,32768,57344, 8192,32768,32768,32768, 8192, 8192, 8192,57344,32768,32768, 8192,32768, 8192,57344,32768,57344,57344,32768,57344,32768, 8192,57344,32768,32768,32768, 8192,32768,32768,32768,57344, 8192, 8192,57344,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768, 8192,32768,32768,57344,57344,32768, 8192,32768,32768,57344, 8192,57344, 8192,32768, 8192, 8192,57344, 8192, 8192, 8192,32768,32768,32768, 8192,57344, 8192, 8192,32768, 8192, 8192,57344,32768,32768,32768, 8192, 8192,32768,32768,57344,32768,57344,57344,57344, 8192,57344, 8192, 8192,32768,32768,57344,32768,32768, 8192,32768, 8192,57344,32768, 8192,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768,32768,32768,57344,32768,32768,57344,32768,32768,32768,57344,32768, 8192,32768, 8192, 8192,32768,32768, 8192, 8192,32768,32768, 8192,32768, 8192, 8192,32768,57344,57344,57344,32768,32768,57344,57344,32768,57344,32768,32768,32768,32768,32768,32768, 8192,32768,57344, 8192,32768,57344,32768,57344, 8192,32768,32768,57344,32768, 8192,32768,32768,57344,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,57344,32768,32768,57344,32768,32768,32768,32768,32768, 8192,32768,32768,32768,32768,32768,57344,57344,32768,57344,32768, 8192,57344,32768,32768,32768,32768,57344,57344,32768, 8192, 8192, 8192,32768,32768, 8192, 8192,32768, 8192, 8192, 8192,32768,57344, 8192, 8192, 8192,57344, 8192, 8192, 8192, 8192,57344,32768,57344,57344,32768,32768,32768, 8192, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,57344,32768,32768,32768,57344,32768,32768,32768,57344, 8192,32768,32768,32768,32768,32768,57344,32768,32768,32768,57344,32768,32768, 8192,57344,57344,32768, 8192,32768,32768,32768, 8192,32768, 8192, 8192,57344,32768, 8192,32768,57344,57344,32768, 8192, 8192,32768,32768,32768,32768,32768, 8192, 8192,32768,32768, 8192,32768,57344, 8192,57344,57344,32768,57344, 8192,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768, 8192,32768,57344,32768,32768,57344,32768,57344, 8192,57344, 8192, 8192,57344,32768,32768,32768,32768,32768,32768,32768,57344,32768, 8192,32768,32768,32768,32768,32768, 8192, 8192, 8192,32768, 8192, 8192, 8192, 8192,57344,57344,57344,32768, 8192, 8192,32768,32768,32768,32768,32768,32768, 8192,57344,32768,32768,32768, 8192,32768,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,57344,32768,57344, 8192,32768,57344, 8192,32768,32768,57344,32768,32768,57344, 8192,32768,57344, 8192,57344, 8192, 8192,57344,32768, 8192,32768,57344,32768,32768,32768, 8192,57344,32768,57344,57344, 8192,57344,32768, 8192,32768,57344, 8192,57344, 8192,32768,57344,32768,32768,57344,32768, 8192, 8192,32768, 8192,32768,57344,32768,57344,57344,32768,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,57344,57344,32768, 8192,32768,57344,32768, 8192,32768, 8192,32768,32768,32768,32768,32768,57344,32768,32768, 8192,32768,32768,32768,32768,32768,57344,32768,57344,57344, 8192,32768,57344, 8192,57344,57344,32768,32768,57344,32768,32768, 8192,32768,32768,57344,57344,57344, 8192, 8192,57344,32768, 8192,32768, 8192,57344,32768,32768,57344,32768,32768,32768,57344,32768,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,32768, 8192,57344, 8192,32768,57344,32768,57344,32768,32768,32768,57344, 8192, 8192,32768, 8192,32768,32768, 8192,32768, 8192,32768,32768,57344,32768, 8192,57344,32768,32768,57344,32768,32768,32768,57344,32768,32768,32768, 8192, 8192, 8192, 8192,57344,32768,32768,32768,32768,32768,32768, 8192,32768, 8192, 8192,32768,32768,32768,32768,32768,32768,57344,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768,57344, 8192, 8192, 8192,32768,32768,32768,32768,32768,57344,57344,32768,57344,57344, 8192,32768,32768,32768, 8192,32768,32768,32768, 8192,32768,32768,57344,32768, 8192,32768,32768,32768, 8192,57344,57344, 8192,57344,32768,32768,57344,32768,57344,32768, 8192,57344,32768, 8192,32768,32768, 8192,32768,32768,32768,32768,32768, 8192,32768,57344, 8192, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,57344,57344, 8192,32768,32768,32768, 8192,57344,57344,32768,57344,32768,32768,57344,57344,32768, 8192,57344,57344, 8192,32768,32768,32768,32768,32768,57344,57344,32768,57344,32768, 8192,32768,57344,32768,32768,57344,32768,32768,57344,57344, 8192,32768,32768,32768,57344,57344,32768,32768,32768,32768, 8192, 8192,57344,32768,57344,32768,57344,57344,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344, 8192,32768,32768,32768,32768,57344,32768,32768, 8192, 8192,32768,32768,32768,32768,32768,32768,57344,57344,32768, 8192,32768,57344,57344,32768, 8192,32768,32768,32768,32768,57344,32768,32768,57344,32768,32768, 8192,57344,32768,32768,32768, 8192, 8192,32768,57344,32768, 8192,57344,32768,32768,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,57344,32768, 8192,57344,32768,32768, 8192,32768,57344, 8192, 8192,57344,32768, 8192,32768,32768,32768,32768,32768,57344,57344,32768, 8192, 8192, 8192, 8192,57344,57344,32768,32768,57344,57344,57344,32768, 8192,32768,32768, 8192, 8192, 8192, 8192, 8192, 8192,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768, 8192,57344, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [57344,57344,32768, 8192, 8192,32768, 8192, 8192,32768, 8192, 8192,32768,57344, 8192, 8192,57344, 8192,57344,57344,32768,32768, 8192,32768,32768,32768, 8192, 8192,32768,32768,32768,57344, 8192,57344,32768,32768, 8192,57344, 8192,32768, 8192, 8192,32768,57344,32768, 8192,32768,32768,57344,32768,32768, 8192,32768,57344,57344,57344,57344, 8192,32768,57344,32768,32768,32768,57344,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,57344,32768,57344,57344, 8192, 8192,57344,57344,57344,32768, 8192,57344,32768,32768,32768, 8192,32768,32768,32768,32768, 8192,32768,57344,32768,57344,57344,32768,32768, 8192, 8192, 8192,32768,32768, 8192,32768,32768,32768,32768,57344, 8192,32768, 8192,57344,32768,57344,32768,32768,32768, 8192, 8192,32768,32768,32768,57344,57344,32768, 8192, 8192, 8192,57344,32768,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,32768,57344,32768,57344, 8192, 8192,57344,32768, 8192,32768,57344,32768,32768, 8192,32768, 8192, 8192,32768,57344,32768,32768,32768, 8192,32768,57344,57344,32768,32768,32768, 8192,32768,32768, 8192,57344,32768,57344,57344,57344,57344,32768,32768, 8192, 8192, 8192,32768,32768, 8192,57344,32768,32768,32768,57344,32768,32768,32768,57344,32768,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768],
 [57344,32768,32768,32768, 8192,57344, 8192,57344, 8192, 8192,32768,32768,32768, 8192,32768,32768, 8192,32768,32768,32768,32768,57344, 8192,32768, 8192,57344,32768, 8192,32768, 8192,32768,32768,32768,32768,32768,57344,57344,32768,32768,32768,32768,32768,32768, 8192,57344,32768, 8192,57344, 8192, 8192,32768, 8192,32768,32768, 8192,57344,32768, 8192,57344,57344, 8192, 8192,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,57344, 8192,57344,32768,57344,57344, 8192,32768,32768,32768,32768,32768, 8192,57344, 8192,32768, 8192,57344,57344,32768,32768, 8192,32768,57344,32768, 8192,32768, 8192,57344, 8192, 8192,32768, 8192,32768,57344,32768, 8192, 8192,32768,57344,57344, 8192,57344,57344,32768,57344,57344, 8192,32768,57344, 8192,32768,32768, 8192,32768, 8192,32768,32768,57344,57344, 8192, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768, 8192,32768, 8192,32768,57344, 8192,32768,32768, 8192,32768,32768, 8192,32768,32768,32768,32768,32768,57344, 8192,32768,57344,57344,57344,32768,32768, 8192,32768,32768,57344,57344,32768,32768,57344,32768,57344, 8192, 8192, 8192,32768,32768,57344,32768,32768,32768,32768, 8192,32768,32768,32768,32768, 8192,57344,32768,57344, 8192,57344,32768,32768,32768,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768],
 [57344,32768,57344,32768,32768,32768,32768,57344, 8192, 8192, 8192,32768, 8192,57344,32768,57344,57344, 8192,57344,57344,32768,57344,32768,32768,57344,32768,32768,32768,57344,57344,57344,57344, 8192,32768, 8192,32768,32768, 8192,57344, 8192,57344, 8192,57344,32768, 8192,32768,57344, 8192,57344,32768,57344, 8192,32768,57344,32768,32768, 8192,32768,32768, 8192, 8192,57344,57344, 8192,32768,32768,32768,32768,32768,32768,32768],
 [ 8192, 8192, 8192,32768,32768,32768, 8192, 8192,32768,32768,57344,32768, 8192,57344, 8192,57344,32768, 8192,32768,32768, 8192,57344,32768,32768,32768,32768,57344,32768,32768,57344,32768,32768,32768,32768,57344,32768, 8192,57344,32768,57344,57344,32768,57344, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768, 8192,32768, 8192, 8192,32768,32768,32768,32768,32768,32768,32768],
 [57344,57344,32768,32768, 8192,32768,32768, 8192,32768,32768, 8192, 8192,32768, 8192,32768, 8192,32768, 8192, 8192,57344, 8192, 8192,32768,32768, 8192,57344, 8192,32768, 8192, 8192, 8192,32768,32768,32768,32768,32768,32768,57344,57344,32768,32768,32768,32768,32768,32768, 8192,57344,57344,57344,32768,32768, 8192,32768,57344,32768,32768,57344,32768,32768,32768,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,57344, 8192,32768,32768,32768, 8192,57344,32768, 8192, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768, 8192, 8192,57344,32768,32768,32768,57344,57344,32768, 8192, 8192,32768, 8192,32768,32768,32768, 8192, 8192,57344,32768,32768,32768,32768,57344, 8192, 8192,32768,32768,32768,32768, 8192,32768,32768, 8192,57344, 8192,57344,32768,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,57344,32768,32768,57344,57344,57344,57344,32768, 8192, 8192,32768,32768,57344,32768,57344,57344,32768,32768,57344,32768,32768,57344,57344,32768,32768,32768, 8192, 8192,32768,32768,57344, 8192,32768,32768,32768,57344,57344, 8192,32768, 8192, 8192,32768,57344,32768, 8192,32768,32768,32768,57344, 8192,32768,32768, 8192, 8192, 8192,32768, 8192, 8192,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768, 8192, 8192,32768, 8192,57344,57344,32768,57344,32768, 8192,32768,32768,57344, 8192,32768,32768, 8192,32768,32768,57344, 8192,32768,32768,57344, 8192,32768,32768,32768,32768, 8192,32768, 8192,32768,32768,32768, 8192,57344,57344, 8192,32768,57344,57344,32768, 8192,57344,32768,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768, 8192, 8192,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,57344,32768,57344,32768,57344,32768,32768, 8192, 8192,32768,32768,32768, 8192,57344,32768,32768,32768, 8192, 8192, 8192, 8192,32768,32768, 8192, 8192,32768, 8192,57344,32768,57344,32768,57344, 8192,32768,57344,32768,32768,32768,32768, 8192,32768, 8192,57344,32768,57344,57344,32768, 8192, 8192,32768,32768, 8192,32768, 8192, 8192, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192, 8192,32768,32768, 8192,57344,32768, 8192,32768,32768, 8192,32768,32768,32768,32768,57344, 8192,57344,57344,57344,57344,32768,32768, 8192,57344,32768, 8192,32768,32768,32768,57344,32768,57344,32768, 8192,57344,32768,32768, 8192, 8192, 8192, 8192,32768,32768,32768,57344, 8192,32768,57344,32768,32768,32768,57344, 8192,57344,32768, 8192,32768, 8192,32768, 8192,57344,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [57344,57344,32768,57344,32768, 8192,57344, 8192,57344, 8192, 8192,32768,32768, 8192,57344, 8192,57344,32768,32768,32768,32768,32768, 8192,32768, 8192, 8192,57344,32768,57344,32768,57344,57344,32768,57344,32768,32768,32768,32768, 8192,32768, 8192, 8192, 8192, 8192, 8192, 8192,57344,32768, 8192,32768, 8192,32768,32768, 8192, 8192, 8192,32768, 8192, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,32768,32768, 8192,57344,32768,32768,32768,57344,32768,57344,32768,32768,32768, 8192,32768,32768,57344, 8192,32768,32768,57344,32768,57344,57344,57344, 8192,57344,32768,57344,57344,32768,32768,32768,32768,57344,32768, 8192,32768,57344,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768,57344,32768, 8192,57344, 8192,57344,32768, 8192,57344,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,57344, 8192,32768,57344, 8192,32768,32768, 8192,32768,32768,32768,32768, 8192,32768,32768,57344,32768,32768,32768,32768,32768,57344, 8192,32768,32768, 8192,32768,32768,32768, 8192,57344,57344,32768,32768, 8192,57344, 8192,32768, 8192,32768, 8192,32768, 8192,57344,32768, 8192, 8192,32768,32768,32768,57344,32768,57344, 8192,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,32768, 8192,32768,32768, 8192,32768,32768,57344,57344,57344,32768, 8192, 8192,32768,32768,32768,32768, 8192, 8192,57344,32768, 8192,57344,57344,57344, 8192,57344,57344,57344,57344,32768,57344,57344,57344,32768,32768,32768,57344,32768,32768,32768,32768, 8192, 8192,57344,32768, 8192,57344,32768, 8192,32768,32768,57344, 8192, 8192, 8192,57344,32768,32768,32768, 8192, 8192,32768,32768,32768,32768,32768,32768,32768],
 [57344,32768,32768, 8192,32768,32768, 8192,32768,32768,32768, 8192,32768,32768,32768, 8192,32768,32768,32768,57344,57344,32768,57344,32768,57344,32768,57344,57344,57344,57344,32768,32768,32768,32768, 8192,57344, 8192,57344,32768,57344,32768,32768,32768, 8192,32768,32768,32768, 8192,57344,32768, 8192, 8192, 8192, 8192,32768, 8192,32768,57344, 8192,32768,57344, 8192,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344, 8192,32768,57344,57344, 8192,57344,57344,57344, 8192, 8192,57344,57344,57344, 8192,32768,32768, 8192,32768,57344, 8192,57344,32768,32768, 8192,32768, 8192, 8192,57344, 8192,32768, 8192, 8192,57344, 8192,32768,32768,32768,57344,57344, 8192,32768,32768, 8192,57344,32768, 8192,32768,57344,32768,57344,57344, 8192,32768, 8192,32768, 8192,32768,32768, 8192, 8192, 8192,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
],
[
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,57344,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768, 8192,32768, 8192,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,57344,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,57344,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344, 8192,32768,32768, 8192,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768, 8192,57344],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192, 8192,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,57344,32768,57344,57344,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768, 8192,32768,57344,32768, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,57344,32768,32768, 8192, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768, 8192,57344,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,57344,57344,57344, 8192, 8192,57344],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,32768,57344,32768,32768,57344],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,57344,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344, 8192,32768,57344,57344, 8192,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344, 8192,57344,57344,57344,57344, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344, 8192,57344,32768, 8192,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192, 8192,32768, 8192, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,57344, 8192,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344, 8192, 8192,32768,57344, 8192,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,57344,57344,57344,57344,32768, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768,57344,57344],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,57344,57344,57344],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,57344,32768, 8192,57344,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768, 8192,57344,57344,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192, 8192,57344,32768, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344, 8192,32768,32768, 8192, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768, 8192,32768, 8192,57344, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,57344,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,32768,32768, 8192,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,32768,32768,32768,57344],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768, 8192,57344],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,57344,32768,32768,32768, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344, 8192,32768, 8192, 8192,57344,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768, 8192,57344,32768,57344],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,57344, 8192,57344,32768, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768,32768, 8192, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,57344,57344,32768,57344,57344, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192, 8192,32768, 8192,32768,32768, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192, 8192,32768,57344,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,32768, 8192,32768, 8192,57344],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192, 8192,32768, 8192,57344, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344, 8192, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,57344,32768],
 [32768,32768,32768,32768,32768,32768,32768, 8192,57344,32768,57344, 8192,32768,32768, 8192,32768,57344, 8192,32768, 8192, 8192,32768, 8192, 8192,32768, 8192,57344,32768,57344,32768,32768,57344, 8192,32768,32768,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768,57344],
 [32768,32768,32768,32768,32768, 8192,57344,57344,32768, 8192, 8192,57344,32768, 8192, 8192,57344, 8192, 8192, 8192, 8192,32768, 8192, 8192,57344, 8192,32768,57344,57344,32768,32768, 8192, 8192,57344,32768,57344,57344,57344, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344, 8192, 8192,57344, 8192,32768,32768],
 [32768,32768,32768,32768,32768,    0,57344, 8192,57344,32768, 8192,32768,57344, 8192, 8192, 8192,32768, 8192,32768,32768, 8192, 8192,32768,32768, 8192,57344,32768,57344,57344, 8192,32768,57344,57344,57344, 8192, 8192,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,57344, 8192, 8192,32768,32768, 8192],
 [32768,32768,32768,32768,32768,57344,32768,32768,32768,32768, 8192,32768,32768,57344, 8192,57344,32768,57344,32768,32768,32768,57344,32768,32768,57344,32768,32768,32768, 8192,57344,32768,32768,32768,32768, 8192,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,32768,32768, 8192,32768],
 [32768,32768,32768,32768, 8192, 8192,32768,32768,32768,32768, 8192, 8192,32768,32768,32768,57344,32768,57344,32768, 8192,32768,57344,32768,32768,57344,32768,32768,32768,32768,32768, 8192,32768,32768,32768,32768,32768, 8192,57344,57344,32768,32768,32768,57344,57344, 8192,32768,32768,57344,32768,32768,57344,57344, 8192,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,57344,57344,32768,32768],
 [32768,32768,32768,32768,57344,57344,57344,32768,32768,32768, 8192, 8192, 8192,57344,32768, 8192,57344,32768,57344, 8192,57344,32768, 8192,32768, 8192, 8192,32768,57344,57344,32768,32768, 8192,32768,32768,32768,32768,57344,32768, 8192,57344, 8192,57344,57344,32768,57344,32768,57344,32768, 8192,57344,32768,32768, 8192, 8192,57344,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,57344,57344,57344,32768],
 [32768,32768,32768,32768, 8192,32768,57344,32768,32768,32768, 8192,57344,32768,32768,32768,57344,32768,32768, 8192,32768,57344,32768,32768,32768,57344, 8192,57344,32768,32768, 8192,57344,57344,57344,32768,32768,32768,57344,32768,32768,32768,32768, 8192,32768,57344,57344, 8192,57344,32768,57344, 8192,32768,32768,32768,32768,32768,57344,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,57344, 8192],
 [32768,32768,32768,32768, 8192,32768, 8192,32768,32768,32768,57344,57344,32768,32768,32768,57344,32768,32768,32768,32768,32768,57344,57344, 8192,32768,32768,32768,32768,32768, 8192, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768, 8192,57344,32768,57344,32768,32768,32768,32768,32768,32768,32768,57344, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344, 8192,32768,32768],
 [32768,32768,32768,57344,32768,57344, 8192,32768,32768,32768,57344, 8192,57344, 8192, 8192,32768, 8192,32768,32768,32768,57344,57344, 8192,32768,32768,57344,32768,32768,32768, 8192,32768, 8192, 8192,32768,32768,32768,32768, 8192, 8192, 8192, 8192, 8192, 8192,57344,32768,57344,57344, 8192,32768,32768,32768,32768,32768, 8192, 8192,32768, 8192,32768,57344,57344,57344,32768,32768,32768, 8192, 8192,32768, 8192,57344,57344,57344],
 [32768,32768,32768,32768, 8192, 8192,32768,32768, 8192,32768, 8192,57344, 8192, 8192, 8192,32768,32768,32768,32768,32768,32768,57344,32768,57344,57344, 8192,32768,32768,32768,32768, 8192,32768,32768,32768,57344,57344,57344,32768,32768,32768,32768, 8192,57344,57344,32768,32768, 8192,57344,32768,32768,32768, 8192, 8192,32768,57344,32768,57344, 8192, 8192,32768,32768,32768,32768,32768,32768,57344,57344,57344,32768, 8192,32768],
 [32768,32768,32768,32768,57344,57344, 8192, 8192,57344,32768, 8192,32768,57344, 8192,32768, 8192,32768,32768,32768,32768,32768,57344, 8192,32768, 8192, 8192,32768,32768,32768,32768,57344,32768,32768, 8192,32768,32768,57344,57344,57344,32768, 8192, 8192,32768,57344,32768,57344,32768,32768, 8192,57344, 8192,57344, 8192, 8192,32768,57344,57344, 8192, 8192, 8192,57344,32768,32768,32768,32768,32768, 8192,32768, 8192,32768,32768],
 [32768,32768,32768,32768,57344,32768,32768, 8192, 8192,32768,32768, 8192,32768,57344,32768,32768,32768,32768,32768,32768,32768,57344, 8192, 8192,32768,57344,32768,32768,32768,32768, 8192, 8192, 8192,32768,32768,32768, 8192,57344,32768,57344,57344, 8192,57344,57344, 8192,32768, 8192,32768, 8192,57344,32768, 8192,57344,57344,32768, 8192,32768, 8192,57344,57344,32768,32768,32768,32768,57344,32768, 8192, 8192, 8192, 8192,32768],
 [32768,32768,32768,32768,32768, 8192,32768,32768, 8192, 8192,57344,57344,32768, 8192,32768, 8192, 8192,32768,32768,32768, 8192,57344,32768,32768,57344,32768,57344,32768,32768, 8192,32768,32768,32768, 8192, 8192,32768,32768,57344,32768, 8192, 8192,32768, 8192,32768, 8192,32768,57344,57344,32768,32768,32768,57344, 8192, 8192,32768,32768, 8192,57344, 8192,32768,32768,32768,32768,32768,32768,57344,57344,57344,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,57344,32768,57344,32768, 8192,32768, 8192,32768,57344,32768,32768,32768,32768,32768,32768, 8192,57344,32768,32768, 8192, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344, 8192,32768,57344,32768, 8192,32768,32768, 8192,32768,32768,57344, 8192,57344,32768,32768,57344,57344,57344, 8192, 8192,32768,57344,57344,32768,32768,32768,32768,32768,32768, 8192,57344, 8192,57344],
 [32768,32768,32768,32768,32768,32768,57344,32768,32768,32768,32768, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768,57344,32768, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,32768,57344,32768, 8192,57344, 8192,32768,32768,32768,57344, 8192,57344, 8192, 8192,32768,57344,32768, 8192, 8192, 8192,32768,32768,32768,32768,32768,57344,32768,32768,32768,32768,57344,32768],
 [32768,32768,32768,32768,32768,32768, 8192,32768,32768,32768,32768,32768, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,57344, 8192,32768,57344,57344,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,32768,32768,57344,57344, 8192, 8192,32768,32768,32768, 8192,57344,32768,32768,57344, 8192,32768,57344,57344,32768,32768,32768,32768,32768,32768, 8192,32768,57344,32768,32768, 8192, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,32768,32768,32768,32768, 8192, 8192,57344, 8192,32768,32768,32768, 8192, 8192,32768,57344,32768,57344, 8192,32768,57344,32768,32768,32768,32768,32768,57344,57344,57344,57344,57344,57344,32768, 8192, 8192,32768,32768, 8192,32768,57344,32768,57344, 8192,32768,32768,32768,32768,32768,32768, 8192,32768,32768,32768,57344,57344,57344],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768,32768,32768, 8192,32768, 8192,57344,32768,32768,32768,32768,32768, 8192, 8192,57344,57344, 8192,57344, 8192,32768,57344,57344,32768,32768,32768, 8192,57344, 8192,32768, 8192,32768,32768, 8192, 8192, 8192,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768, 8192,57344, 8192, 8192,57344, 8192],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768,57344,32768,57344,32768,32768,32768,32768,32768,32768,57344, 8192, 8192,57344,32768,32768,32768,32768, 8192,32768,32768,32768,32768,32768, 8192, 8192,57344,57344,32768,32768,32768, 8192,32768,57344,57344, 8192,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,57344,32768,32768,32768,32768,32768,32768,57344,57344, 8192,57344,32768,32768, 8192, 8192,32768,32768,32768,32768, 8192,57344,57344,32768,32768,32768,32768,32768,32768, 8192,32768,32768,32768,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768,57344],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
],
[
 [32768,57344,32768,32768,32768, 8192,32768,32768,57344,32768,32768, 8192,32768, 8192,32768,32768,32768,32768,32768,57344, 8192,32768,32768, 8192,57344,57344, 8192,32768,32768,32768,32768, 8192, 8192,32768,32768,32768, 8192, 8192, 8192,32768,32768,57344, 8192,32768,32768,32768,32768,57344,32768, 8192,32768,32768,32768,32768,57344, 8192,32768,57344,32768,32768, 8192,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,57344, 8192,32768,57344, 8192, 8192,32768,32768, 8192,57344,32768,57344, 8192, 8192,57344,32768,32768, 8192,32768, 8192, 8192, 8192,57344, 8192,32768, 8192,57344, 8192,32768,32768, 8192,57344,57344,32768, 8192,32768, 8192,32768, 8192,57344,32768, 8192,32768,57344,32768,32768,32768,32768,32768, 8192, 8192,57344,32768,32768,32768,32768,57344,57344,57344,32768,57344, 8192,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768,57344,57344, 8192,57344,32768,32768,32768, 8192,57344,32768,57344,57344,32768,32768,57344,57344,32768,32768,57344, 8192,32768, 8192, 8192, 8192, 8192, 8192,32768, 8192, 8192, 8192,32768,32768,32768, 8192, 8192, 8192, 8192,32768,32768,57344,57344, 8192,57344,32768,57344,57344, 8192,32768,57344,32768, 8192,57344,32768,32768,57344,32768,32768,32768,32768, 8192,32768,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,32768,32768, 8192,32768, 8192, 8192,57344,57344,57344, 8192,32768,57344,32768,32768,32768,32768,57344,57344,32768, 8192, 8192, 8192,32768,32768,57344,32768,32768,57344,32768,57344,57344,57344,32768, 8192,57344,32768,32768,32768,57344, 8192,57344,57344,57344,32768,32768, 8192,57344,57344,32768, 8192, 8192,57344,57344,32768,32768,32768,32768, 8192,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768,32768, 8192,57344,32768, 8192, 8192,57344, 8192,32768,32768,57344,32768,32768,32768,32768,32768,32768, 8192,32768,32768, 8192,57344,57344, 8192, 8192,32768, 8192, 8192, 8192, 8192,32768,32768,32768,57344,32768,32768,57344,32768, 8192,32768,32768, 8192,32768,57344,57344,57344,32768,57344, 8192,57344,32768, 8192, 8192, 8192,32768, 8192,32768, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192, 8192,32768,57344, 8192,32768, 8192,57344,32768, 8192,32768,57344,32768,32768, 8192,32768,32768,32768,32768,32768, 8192,57344,32768,32768, 8192,32768,32768,32768,32768,57344,32768,32768,32768, 8192, 8192,32768, 8192,32768,57344, 8192,57344,57344,57344,32768,32768,32768, 8192,32768, 8192,57344,32768,57344,32768, 8192,32768, 8192, 8192,57344, 8192,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [57344, 8192,32768,32768,32768,32768,57344,32768,32768, 8192,32768,32768,57344,57344,32768, 8192,32768,32768,32768, 8192, 8192,32768,32768,32768, 8192,32768, 8192,32768, 8192,32768, 8192,32768, 8192,32768,32768,32768,32768, 8192,57344,57344,32768,57344, 8192,57344,32768,57344,57344,32768, 8192,57344, 8192,32768,32768,57344,57344,32768, 8192,57344, 8192,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,57344,32768,32768,57344, 8192, 8192,57344,57344,32768, 8192,57344,32768,32768, 8192,57344,32768,32768,32768,57344,32768,32768,57344, 8192,57344,57344,32768,57344, 8192,32768,32768, 8192,32768,57344, 8192,57344,32768,32768,57344,57344,57344,32768,32768,32768, 8192,57344,32768, 8192,32768,57344, 8192,57344,32768,32768,57344,32768,32768,32768,32768, 8192,57344,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192, 8192,32768,32768,32768,57344,57344,32768,32768,32768,32768, 8192,32768,32768,32768,57344,32768,32768,32768,32768, 8192,32768,32768,32768,32768, 8192, 8192, 8192,57344,57344, 8192,32768,57344,57344,57344,32768, 8192, 8192, 8192,32768, 8192,32768,32768,32768,57344,57344,32768, 8192, 8192,57344,32768,57344, 8192,32768,32768,57344, 8192,57344,57344,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,57344,32768,32768,32768,32768, 8192,57344,32768,32768,32768,57344,57344,32768,32768,57344,32768,32768,57344,57344,57344,57344, 8192,32768, 8192,32768,32768, 8192,32768, 8192, 8192,32768,57344,32768, 8192,57344,32768,32768, 8192,57344,57344, 8192,32768, 8192, 8192,32768,32768,32768,32768, 8192, 8192,57344,57344, 8192,32768, 8192,32768,32768,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,57344, 8192,57344,32768,32768,32768, 8192, 8192, 8192,57344, 8192, 8192,32768, 8192,32768,32768,32768,32768,32768, 8192, 8192,32768,32768, 8192,32768,57344,32768,32768,57344, 8192,57344,32768,32768,32768,57344,32768,57344, 8192,32768,32768,32768,32768,57344,57344,57344,32768, 8192,32768, 8192, 8192,32768,57344,57344, 8192,32768,32768, 8192,57344, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [57344,32768, 8192,57344,32768,57344,32768,32768,57344,57344, 8192, 8192,32768,32768,32768,32768,57344, 8192,32768, 8192, 8192,32768,32768,32768,57344,32768,57344,32768, 8192, 8192,32768,57344,32768,57344,32768, 8192,32768, 8192, 8192,32768, 8192,57344,32768,32768, 8192,57344, 8192, 8192,57344,32768,32768,57344, 8192,57344,32768,32768, 8192, 8192,57344,57344,57344, 8192, 8192,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,57344,32768,32768,57344,32768,32768,32768,32768, 8192,57344, 8192,32768, 8192,32768, 8192, 8192,32768, 8192,57344,57344,32768,32768,57344,32768,57344,32768,57344,32768,32768,32768,32768,57344,32768,57344, 8192,57344,32768, 8192, 8192, 8192, 8192,57344,57344,32768,32768,57344, 8192,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,32768,32768,32768, 8192, 8192,32768,32768,32768,57344,32768,57344,32768,57344, 8192,32768, 8192,32768,57344,32768,32768,32768, 8192,57344,57344,32768,57344,32768,32768,32768,57344,57344,32768,32768,57344, 8192,57344, 8192,57344,57344,32768,32768,32768,32768,32768,57344, 8192,32768,32768,32768,57344,57344, 8192,32768,32768,32768,57344,32768,57344,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,57344,57344,57344, 8192,32768,32768,32768,57344, 8192,57344, 8192,32768, 8192,32768,57344, 8192,57344,32768,32768,32768,57344,57344, 8192,32768,32768, 8192,57344,32768,57344,57344, 8192,32768,32768, 8192,32768,32768,32768,57344,32768,32768,57344,32768,32768,57344,32768,32768,57344,32768,32768,32768,32768, 8192, 8192, 8192, 8192,57344, 8192,57344,57344,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768, 8192, 8192, 8192,32768,32768, 8192, 8192,32768,57344,57344,32768,57344,57344,32768,57344, 8192,57344, 8192,32768,57344,57344,57344,32768,32768, 8192,57344, 8192,57344, 8192,32768, 8192,57344,57344,32768,32768,32768,32768,32768,32768, 8192,32768, 8192,57344,57344,32768,57344,32768,57344,32768,32768,57344,57344, 8192,32768,57344,32768,32768, 8192,32768,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768, 8192,32768,57344,32768,32768,32768,57344,32768,57344,32768, 8192, 8192, 8192,32768, 8192,57344,32768,57344,32768,32768,57344, 8192,32768,57344, 8192,32768,57344,32768,32768,32768,57344, 8192,57344,32768,57344,32768, 8192,32768,57344,32768,57344,32768,32768, 8192, 8192, 8192,32768, 8192,57344,32768,57344, 8192,57344,32768, 8192,57344, 8192,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,57344,32768,32768,32768,57344,57344, 8192,57344, 8192,32768,32768,32768, 8192,32768,32768,32768,32768,32768,57344,57344,57344,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768,57344, 8192,57344,57344, 8192, 8192, 8192,32768,32768,57344,32768,57344,32768, 8192,32768,32768,32768,32768,32768,57344,57344,57344, 8192,57344,57344, 8192,32768,32768,32768,57344, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,32768,32768,32768, 8192,32768,57344,57344,57344,57344,32768,32768, 8192,32768,57344,57344, 8192,32768,57344, 8192,32768, 8192, 8192, 8192,32768,32768,32768,57344,32768, 8192,32768,32768, 8192, 8192,57344, 8192,57344,32768,32768,32768, 8192,32768,32768, 8192,32768, 8192,32768,32768,32768,57344,32768,57344, 8192,32768, 8192,57344, 8192,32768, 8192,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,32768,57344,32768, 8192,32768,57344,32768, 8192,32768,32768,32768,32768,57344,32768,57344,57344,57344, 8192,32768,32768,32768,32768,57344,32768,32768, 8192, 8192,57344, 8192,32768,32768,32768,32768, 8192,32768,32768,32768,32768,57344,32768,32768, 8192,57344,32768, 8192, 8192,57344, 8192,32768,57344,32768,32768,32768,32768, 8192,32768,32768,57344,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [57344,32768,32768,57344,32768,57344,32768, 8192,57344,57344, 8192,32768, 8192,57344,32768, 8192, 8192, 8192,32768,32768,32768,57344, 8192,32768,57344,32768,32768, 8192,32768,32768,57344,57344, 8192,32768,32768,32768,32768,32768,32768, 8192,32768,57344,57344, 8192,57344,32768, 8192, 8192,32768,32768,32768, 8192, 8192,57344,32768,57344,57344,57344,32768, 8192,57344, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,57344,57344, 8192,32768,32768,32768, 8192,32768,32768,57344,32768,57344,57344,32768,57344, 8192, 8192,32768,32768,32768,32768,32768,32768,32768, 8192,32768, 8192,57344,57344,32768,32768,57344,32768,32768,32768,32768,32768,57344,57344, 8192,32768,57344,32768,57344, 8192,32768, 8192,32768,32768,32768,32768, 8192,32768,32768,32768,57344, 8192,32768,32768,57344, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768, 8192,57344,32768, 8192,32768,32768, 8192,32768,32768,32768,57344,32768, 8192,32768,32768,32768,57344,32768,32768,32768, 8192, 8192,32768,32768,32768,57344,57344,57344,32768,32768,57344,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,57344,57344,32768,32768, 8192,32768,32768, 8192, 8192,57344,32768, 8192,32768,57344,32768, 8192, 8192,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,57344,32768, 8192,57344,32768,32768,32768, 8192, 8192,32768,57344,57344,32768,32768,57344, 8192,32768, 8192,32768, 8192,32768, 8192, 8192,57344,32768, 8192,32768,57344, 8192,32768, 8192,32768, 8192,57344,32768,32768,57344,57344,57344, 8192,32768,32768,32768,32768,32768,57344, 8192, 8192,57344, 8192, 8192, 8192,32768,57344,32768,57344,32768,32768,32768,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,57344,32768, 8192, 8192,32768,32768,32768,32768,32768, 8192,32768, 8192,57344, 8192,32768, 8192,32768,32768,32768,32768,57344,32768, 8192, 8192, 8192, 8192,32768,32768,32768, 8192,57344,32768,57344, 8192,57344,32768, 8192,32768, 8192, 8192,32768,32768,32768,57344,32768, 8192,32768, 8192, 8192,57344,32768,32768,57344,32768, 8192,32768, 8192,32768,32768,57344,57344, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,57344,57344, 8192,32768,32768,57344,57344,32768, 8192,57344,32768,32768,32768,32768,57344,32768,32768,32768,57344,32768,32768,32768,57344, 8192,32768,57344,32768,32768,32768, 8192,32768,32768,32768,32768,57344,32768,32768, 8192,32768, 8192,32768,57344,32768,57344,57344,32768,32768,32768,32768,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192, 8192, 8192,32768,32768,32768, 8192,57344,57344,57344,32768,57344,32768,32768,32768,32768,32768,57344,32768,32768, 8192,57344, 8192, 8192,32768,57344,32768,32768,32768,57344,32768,57344,32768,57344,57344,57344,32768, 8192, 8192,32768,32768,57344, 8192,32768,32768,32768,32768,32768,57344, 8192,32768,32768,32768,32768, 8192, 8192, 8192,32768,32768,32768, 8192,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768],
 [57344,32768,32768,57344,32768,32768, 8192,57344, 8192,57344,57344,57344,57344, 8192,57344,32768,32768,32768,32768,57344,32768, 8192,32768,32768,57344,32768, 8192,32768,57344, 8192, 8192,32768,32768, 8192, 8192,57344,32768,32768,32768,57344, 8192,32768,32768,32768,32768,57344,32768,32768,57344,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,57344,57344,57344,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768,57344, 8192,57344,32768,32768,32768,57344,57344,32768, 8192,32768,32768,32768,57344, 8192,32768,32768,32768,32768,32768, 8192,57344,32768, 8192,32768,32768, 8192,32768,32768,32768,32768,32768, 8192,32768,57344,32768, 8192,32768,32768,32768,32768, 8192, 8192, 8192, 8192, 8192,57344, 8192, 8192,57344,57344, 8192, 8192, 8192,57344,57344,32768,57344,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,57344, 8192, 8192, 8192,32768,32768,32768, 8192,32768,57344, 8192,32768,32768,57344,57344,32768,32768,32768,57344,32768, 8192, 8192, 8192,57344,57344,32768,32768,32768,32768, 8192,57344, 8192,32768,32768, 8192,57344, 8192, 8192, 8192, 8192,57344,32768,57344,32768,32768,57344,57344, 8192,32768,32768,32768,32768, 8192,57344,32768,57344, 8192,32768,32768,57344,32768,57344,32768,32768,32768,32768,32768,32768,32768],
 [57344, 8192,57344,32768, 8192,32768,57344,57344,32768, 8192, 8192, 8192, 8192,32768,57344,32768,32768, 8192,32768,32768,32768,32768,32768, 8192, 8192,32768,32768,32768,32768,32768, 8192, 8192,57344,32768,32768,57344, 8192, 8192, 8192, 8192, 8192,57344,32768,57344,32768,32768,32768,32768,32768,32768,32768,57344,57344, 8192,32768, 8192, 8192,32768,32768,57344,57344,57344, 8192, 8192,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768,57344,57344,32768,32768, 8192, 8192,57344,32768, 8192,32768, 8192,57344,32768,32768,32768,32768, 8192,32768,57344,32768,57344,32768,32768,32768,57344, 8192,32768, 8192,57344,32768, 8192,57344, 8192,57344,32768, 8192,32768,32768, 8192,57344, 8192,32768,32768, 8192,57344,32768,57344,32768,32768,32768,32768,32768, 8192,57344,57344,32768, 8192,32768, 8192,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,57344,57344,32768, 8192,32768, 8192,57344,57344,32768,57344,32768,57344,32768,32768,32768,32768, 8192, 8192,32768,57344, 8192,32768, 8192,32768,32768, 8192,32768,57344, 8192,32768, 8192,57344,57344,32768,32768,57344,32768,57344,32768,57344,32768,57344,32768, 8192,57344,57344,32768,32768,32768,32768,57344,57344, 8192,57344, 8192,57344,32768,57344,32768,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,57344,57344, 8192,32768,32768,32768,32768, 8192, 8192,32768,32768,32768, 8192,32768,32768, 8192,57344, 8192,32768,32768,32768,57344, 8192,32768,57344,32768, 8192, 8192,32768,32768,32768,32768,32768,32768, 8192,32768,57344,32768,32768,32768,32768,57344, 8192,32768,32768, 8192,32768,57344,32768,32768,57344,32768, 8192,57344, 8192,57344,32768,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,32768, 8192,57344,32768,32768,32768, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768, 8192,32768,57344,32768,32768,57344,32768,57344,57344,57344,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768, 8192,32768,32768, 8192,32768,57344,57344,32768,32768, 8192, 8192,57344,32768, 8192,32768, 8192,32768,57344,57344,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768, 8192,32768,32768,57344,32768,32768, 8192,57344,32768,32768, 8192, 8192,32768,32768,32768, 8192,32768, 8192, 8192,57344,57344, 8192,32768,57344,57344,57344, 8192,32768, 8192,32768,32768,32768, 8192,32768,32768, 8192, 8192, 8192,57344, 8192,32768,32768,57344,32768,57344,32768,32768,57344, 8192,57344, 8192,32768,32768,32768, 8192,32768,57344,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,57344,32768,32768,32768, 8192,57344,32768,57344,32768,57344,32768,32768,32768, 8192, 8192,32768,32768, 8192,57344,57344,32768, 8192,32768,32768, 8192,32768,32768, 8192, 8192, 8192,32768,32768,57344,32768,32768, 8192,57344,32768,32768, 8192,32768, 8192,57344,32768,32768,57344,57344,32768,57344, 8192,32768,32768, 8192,32768, 8192,32768,32768,32768, 8192,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,32768,57344,32768,57344,32768,32768,57344,32768, 8192,57344,32768,32768,32768,32768,32768,32768, 8192,32768,32768,32768,32768,57344,32768,57344,32768,32768,57344,57344,57344,32768, 8192, 8192, 8192,32768, 8192,57344,57344, 8192,57344,32768,57344, 8192,32768, 8192,32768,32768,32768,57344,57344,57344,32768,32768,57344, 8192,32768,57344, 8192,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,57344,32768,32768,32768, 8192,57344,32768,57344,32768, 8192,32768,57344,32768,32768,32768,57344,57344, 8192,32768,32768, 8192,32768, 8192,32768,57344,32768,32768,32768, 8192,32768,57344,32768,32768,32768,32768,32768,57344,57344, 8192,57344,32768,57344,32768, 8192,32768,32768,57344,57344, 8192, 8192, 8192,32768,32768,32768,32768,57344,32768,32768,57344,57344,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768, 8192,57344, 8192,32768,32768,32768,32768, 8192,57344,57344,32768, 8192,57344,57344,57344,32768,32768,32768, 8192,57344,57344,32768, 8192,57344,57344,32768,32768,32768,57344,32768, 8192, 8192,57344, 8192,32768, 8192,32768, 8192,32768,32768,32768, 8192,32768,32768,57344,57344,32768,57344, 8192,57344, 8192,57344, 8192, 8192, 8192,32768, 8192,57344,32768,32768, 8192, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,32768,32768,57344, 8192,32768,32768,32768,57344, 8192,57344,57344,32768,32768,32768,32768,57344,32768,32768, 8192,32768,57344, 8192,32768, 8192,32768,57344,57344,57344,57344, 8192,32768, 8192,57344,32768, 8192, 8192,57344, 8192,32768, 8192,32768, 8192,32768,32768, 8192, 8192,32768,32768, 8192,32768, 8192, 8192,32768, 8192,32768,57344,32768, 8192,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [57344, 8192,32768,32768,32768,32768,32768,32768,57344,57344,32768,32768,32768,32768,57344,57344,32768,32768,32768,57344,57344,32768, 8192,32768,57344, 8192,57344,32768,32768, 8192,57344,32768, 8192,32768,32768,32768,32768,32768,32768, 8192, 8192,32768,32768,32768,57344,32768,32768,32768,57344,57344,57344,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,32768,57344,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192, 8192, 8192,32768,32768,32768,57344, 8192,32768, 8192, 8192,32768,32768,32768, 8192,57344, 8192,57344,32768,57344,32768,32768,57344,57344, 8192,32768,32768,32768,32768,32768,32768,57344,57344,57344,57344, 8192,32768,32768,32768,32768, 8192,32768,57344, 8192,57344,32768,32768,32768,32768,32768,32768,57344,32768, 8192,57344,32768,32768,32768, 8192, 8192,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768],
 [57344,32768,32768,32768, 8192,32768,32768,32768, 8192,32768,32768,32768,32768,32768, 8192,57344, 8192, 8192,32768,32768,32768, 8192,57344,57344,57344,32768, 8192,57344, 8192,57344,32768,57344,57344,32768,32768,32768,32768,57344,57344,32768,32768,32768,32768,32768,32768,32768,57344,57344,32768,32768,32768,57344,32768,57344,57344, 8192, 8192,32768, 8192,32768, 8192,32768,57344, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,32768,32768, 8192,57344,57344,57344,32768, 8192,32768,57344,32768, 8192, 8192, 8192,57344, 8192, 8192,32768,57344,32768, 8192, 8192,57344,32768,32768,32768,57344,57344,32768,32768,57344, 8192,32768,32768,32768, 8192,57344,32768,32768,57344,32768, 8192,57344, 8192, 8192,32768,32768,32768, 8192, 8192, 8192,32768,32768, 8192,32768,32768,32768, 8192,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192, 8192, 8192,32768,57344,32768,32768,32768,32768,57344, 8192,32768, 8192,32768,32768,32768,32768,32768,57344,32768,32768,32768,57344,32768,57344, 8192, 8192,57344,32768,57344,32768,57344, 8192,32768,32768,32768, 8192,57344,57344,32768,57344, 8192,32768,32768, 8192,32768, 8192,32768,32768,32768, 8192,32768,57344,57344,57344,32768, 8192,32768,57344, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,32768,57344, 8192, 8192,32768,32768,32768,32768,57344,32768,32768,32768,32768,32768,57344,57344, 8192,32768,32768,32768,32768,32768,32768,32768,57344,32768,32768,57344,57344,57344, 8192,57344,32768,57344,32768,32768, 8192, 8192,57344,32768,32768, 8192, 8192, 8192,57344,32768,57344,32768, 8192, 8192,57344,57344,57344, 8192,32768, 8192,32768, 8192,57344,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768, 8192,57344, 8192,32768, 8192, 8192,57344,32768,32768,32768,32768,32768,57344, 8192,32768,57344, 8192,32768,57344,57344,32768,32768,57344, 8192,32768,32768,57344,32768,32768, 8192,32768, 8192,32768,32768,32768,32768, 8192,32768, 8192,57344,32768,32768,32768,32768,32768, 8192,57344,32768, 8192,32768,32768,57344,32768, 8192,32768,57344, 8192,32768, 8192,32768, 8192, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192, 8192,57344,32768, 8192, 8192,32768,57344, 8192,32768,32768,32768,32768,57344,32768, 8192,57344,57344,32768, 8192,32768,32768, 8192,32768,32768,32768, 8192,32768,32768,32768,32768, 8192,32768,32768, 8192,32768,32768,57344,57344, 8192,57344, 8192, 8192,32768,32768,32768, 8192,32768, 8192,57344,32768, 8192,32768, 8192,32768, 8192,32768, 8192,32768,32768, 8192, 8192,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,32768, 8192,32768,32768,32768,32768, 8192,32768, 8192,32768,57344,32768,57344,32768, 8192,32768,57344, 8192, 8192,32768,32768,57344,32768,32768, 8192,32768, 8192,57344, 8192,32768,32768,32768,57344,32768,32768,57344, 8192,32768,57344,32768,32768,32768,57344,57344, 8192,32768,32768,57344,32768,32768,57344,32768,57344,32768,32768,57344,57344,32768,57344,57344,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768,57344, 8192,57344, 8192,32768,32768,32768,32768,57344, 8192,57344,32768,32768,57344,57344,57344, 8192,57344,57344,57344,32768,32768,32768,32768, 8192,32768, 8192, 8192,32768,57344, 8192,57344,57344, 8192, 8192,32768,32768,57344,57344,32768, 8192,32768,32768,32768,57344,32768, 8192,32768, 8192,57344,57344,57344,32768,32768,32768,32768,32768,57344,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768, 8192, 8192,32768,32768,57344,32768, 8192,32768,57344,57344,57344, 8192, 8192, 8192, 8192, 8192,57344,57344,32768,57344, 8192,32768,32768, 8192,57344,57344,57344, 8192,32768,32768, 8192,57344, 8192,32768, 8192,57344,57344, 8192,32768,32768, 8192,32768,57344,32768,32768,32768, 8192,32768,32768,32768, 8192,57344,32768,32768, 8192, 8192, 8192,32768,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192, 8192,57344,57344,57344,32768,32768, 8192,32768, 8192,32768, 8192, 8192,32768, 8192, 8192,32768,57344,57344,57344, 8192, 8192, 8192,57344,32768, 8192,57344,32768,32768,32768,32768,57344, 8192,32768, 8192,57344, 8192, 8192,32768,57344,57344,32768,32768,32768,32768,57344,32768,57344,32768,57344,32768, 8192,32768, 8192,32768,57344,32768, 8192,32768,57344,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [57344, 8192,32768,32768,32768,32768, 8192,57344,32768,57344,57344,57344, 8192,32768, 8192,32768, 8192, 8192, 8192, 8192,57344, 8192,57344,32768, 8192, 8192,32768,32768, 8192,57344,32768,32768,32768, 8192,57344,57344,57344,57344,32768,32768,    0,57344,32768,32768,32768,32768, 8192,32768, 8192,57344,57344,57344, 8192,32768, 8192, 8192,32768,57344,32768,32768,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,57344,57344, 8192,32768, 8192,32768,57344, 8192,32768,32768, 8192,32768,57344, 8192,57344,32768,32768,32768,32768,32768,32768, 8192,32768, 8192,32768, 8192, 8192,57344, 8192, 8192,57344,32768,57344, 8192, 8192, 8192,32768,32768,32768, 8192, 8192,32768,57344,57344,57344, 8192,32768, 8192,32768, 8192,32768, 8192, 8192,57344,32768, 8192, 8192,32768, 8192,57344,57344, 8192,32768,32768,32768,32768,32768,32768,32768,32768],
 [57344,32768,32768,57344,32768,32768,32768, 8192, 8192,32768,32768,32768, 8192,32768, 8192, 8192,32768, 8192,57344,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768, 8192,57344, 8192,57344,57344, 8192,57344,57344,57344, 8192,32768,32768,57344, 8192,32768,57344,57344, 8192, 8192,32768,32768,32768, 8192,32768,32768,32768,32768,32768, 8192, 8192, 8192,57344, 8192,57344,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,57344,32768,57344,32768,32768,57344,32768,57344, 8192, 8192, 8192, 8192,32768,32768,32768,57344, 8192, 8192,32768,57344,32768, 8192,32768, 8192, 8192,57344,57344,32768, 8192,57344,32768, 8192,32768, 8192,57344,57344,32768, 8192,57344, 8192,32768,57344,57344,32768,32768,32768, 8192,32768,57344, 8192,32768,32768,57344,57344,57344, 8192,57344,32768,57344,32768,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768, 8192,32768,32768,32768,32768,32768, 8192,32768,57344,57344,32768, 8192,32768, 8192,32768,57344,57344,32768,57344,32768,32768, 8192,32768,32768,32768,57344,32768,32768, 8192,57344,57344, 8192,32768,32768,32768,57344,57344, 8192,57344,32768,57344,57344,32768,32768,32768,57344, 8192,57344, 8192, 8192, 8192,32768,32768,57344,57344,32768, 8192,57344,57344,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768, 8192, 8192,57344,32768, 8192,32768,32768,32768,32768,32768, 8192,57344,32768, 8192,32768,32768,57344,32768, 8192,32768, 8192,32768,32768,32768,57344,32768,57344,32768, 8192,32768, 8192,32768, 8192,57344,32768,57344,32768,32768,32768,57344, 8192,57344,57344, 8192,32768,32768, 8192, 8192,32768,32768,32768,32768,32768, 8192,32768,32768,57344,32768,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768,32768,32768,32768,57344, 8192,57344,57344,32768, 8192,32768,32768,32768,32768,57344,57344,32768,32768,57344, 8192,32768,32768,32768,32768,57344,32768, 8192,32768,32768,32768,32768,32768,32768, 8192, 8192,32768,57344,32768,57344,32768, 8192,32768, 8192, 8192,57344,32768,57344,57344,32768,57344,57344,32768, 8192, 8192,32768,57344,32768,57344,32768,57344,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768, 8192,32768,32768,32768, 8192,32768,57344, 8192,32768, 8192,32768,32768,32768, 8192,32768,57344,57344,32768, 8192,57344,32768,57344, 8192, 8192,32768,32768,57344,32768,32768,57344,32768,57344, 8192,32768,32768,57344,32768,32768,32768,32768, 8192,32768, 8192,32768,32768,57344,32768, 8192, 8192,32768,32768,57344,32768,32768,32768,32768,32768,32768, 8192,57344,32768,32768,32768,32768,32768,32768,32768],
 [32768, 8192,57344,32768, 8192, 8192,32768,32768,32768,57344,32768, 8192,32768,32768, 8192,57344,32768, 8192,57344,57344,57344, 8192, 8192, 8192,32768,32768,57344,32768,32768,57344,32768, 8192,32768,32768,57344,57344,32768, 8192,57344, 8192,32768,32768,57344,32768, 8192,57344,57344,32768,32768,32768, 8192,32768, 8192,32768, 8192, 8192, 8192, 8192,57344,57344,57344,57344,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768,32768,57344,32768,32768, 8192,32768, 8192, 8192,57344,32768, 8192,32768, 8192,32768,57344,32768,32768, 8192,57344,57344,57344, 8192,32768,32768, 8192,57344,32768,32768,32768,32768,32768, 8192,32768, 8192,32768,32768, 8192, 8192, 8192,57344, 8192,57344,32768,32768,32768,32768,32768,57344,32768,32768,57344,32768,32768,32768,32768,32768,57344,32768,32768, 8192,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [ 8192,32768, 8192,57344,32768,32768, 8192,32768,57344,32768,57344,32768,32768,32768,32768,32768,32768, 8192, 8192, 8192,57344,32768,57344,32768,32768,32768,57344,57344, 8192,57344,32768,57344, 8192,57344,32768,32768,32768, 8192,57344,32768, 8192,32768,32768,57344,57344,32768, 8192, 8192,32768,32768,57344,32768,32768,57344, 8192, 8192,32768,32768,57344, 8192,57344, 8192, 8192, 8192,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
 [32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768,32768],
]
];

for my $file (<t/img-rgba16/*.*>) {
  my $pimage = PDL::IO::Image->new_from_file($file);
  is($pimage->get_image_type , "RGBA16", "get_image_type: $file");
  is($pimage->get_color_type , "RGBALPHA", "get_color_type: $file");
  is($pimage->get_colors_used,  0, "get_colors_used: $file");
  is($pimage->get_width      , 71, "get_width: $file");
  is($pimage->get_height     , 71, "get_height: $file");
  is($pimage->get_bpp        , 64, "get_bpp: $file");
  my $pix = $pimage->pixels_to_pdl;
  is($pix->info, 'PDL: Ushort D [71,71,4]', "info: $file");
  unless ($file =~ /\.(jxr)$/i) {
    delta_ok($pix->double->sum, 659218432, "sum: $file");
    delta_ok($pix->unpdl, $expected, "pixels: $file");
  }
}

done_testing();