\\ Copyright 2018, 2019 Kevin Ryde
\\ 
\\ This file is part of Graph-Maker-Other.
\\ 
\\ This file is free software; you can redistribute it and/or modify it
\\ under the terms of the GNU General Public License as published by the Free
\\ Software Foundation; either version 3, or (at your option) any later
\\ version.
\\ 
\\ This file is distributed in the hope that it will be useful, but
\\ WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
\\ or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
\\ for more details.
\\ 
\\ You should have received a copy of the GNU General Public License along
\\ with Graph-Maker-Other.  See the file COPYING.  If not, see
\\ <http://www.gnu.org/licenses/>.

\\ Usage: gp <Catalans-vpar.gp
\\
\\ Print sample data for Catalan.t vertex name types checks.
\\

default(recover,0);
default(strictargs,1);
\\ read("vpar.gp")
\\ read("vpar-wip.gp")

to_balanced_binary_postorder(vpar,v=vpar_root(vpar)) =
{
  if(!v, [],
     my(c=vpar_minmax_child_of_vertex(vpar,v,min),
        s=vpar_next_sibling_of_vertex(vpar,v));
     concat([to_balanced_binary_postorder(vpar,c),
             [1],
             to_balanced_binary_postorder(vpar,s),
             [0]]));

  \\ return(0);
  \\ print("to_balanced_binary_postorder() "vpar);
  \\ 
  \\ my(seq=vpar_seq_postorder(vpar),
  \\    ret=vector(#vpar << 1),
  \\    pos=0,
  \\    prev=0);
  \\ for(i=1,#seq,
  \\    my(v=seq[i]);
  \\    print(" i="i" v="v" prev="prev" pos="pos);
  \\    while(vpar[v]!=prev,
  \\          pos++;
  \\          prev=vpar[prev];
  \\          print("  step up to prev="prev);
  \\         );
  \\    ret[pos++] = 1;
  \\    prev=v);
  \\ 
  \\ \\ print(" final pos="pos" "ret);
  \\ fromdigits(ret,2);
}

Rweights_by_siblings(vpar) =
{
  my(next_sibling=vpar_next_sibling_vector(vpar),
     subtree_sizes=vpar_subtree_sizes_vector(vpar));
  vector(#vpar,v,
         my(Rweight=1, s=v);
         while(s=next_sibling[s], Rweight += subtree_sizes[s]);
         Rweight);
}

join_str(vec) = if(#vec, concat(apply(n->Str(n),vec)), "");
join_comma(vec) = if(#vec, concat(vector(2*#vec-1,i,if(i%2,Str(vec[i\2+1]),","))), "");
{

  print("     # generated by Catalans-vpar.gp");
  my(seen_horizpos=Map());
  for(n=0,6,
     print("     [  # count ",vpar_count_ordered(n,1));
     my(vpar=vpar_preorder_last(n,1));
     until((vpar=vpar_preorder_prev(vpar,1))=='none,  \\ forests
           my(seq_postorder=vpar_seq_postorder(vpar),
              vpar_postorder=vpar_relabel_postorder(vpar));
           vpar_relabel_seq(vpar,seq_postorder) == vpar_postorder || error();

           my(b=vpar_to_balanced_binary(vpar),
              postorder_b=to_balanced_binary_postorder(vpar));
           print("      { balanced=>'",join_comma(binary(b)),"',",);
           print("          balanced_postorder=>'",join_comma(postorder_b),"',",);

           my(depths=vpar_depths_vector(vpar),
              horizpos=vpar_horizpos_vector(vpar),
              seq_diagpost=vpar_seq_diagpost(vpar),
              diagpost_horizpos=vecextract(horizpos,seq_diagpost));
           print1("        Ldepths=>'",join_comma(depths),"',",);
           print(" Rdepths_postorder=>'",join_comma(diagpost_horizpos),"',",);
           \\ if(mapisdefined(seen_horizpos,horizpos), error("oops: "horizpos));
           \\ mapput(seen_horizpos,horizpos,1);

           my(postorder_depths=vpar_depths_vector(vpar_postorder),
              postorder_horizpos=vpar_horizpos_vector(vpar_postorder),
              postorder_diagdepths=vpar_diagdepths_vector(vpar_postorder));
           print1("        Bdepths_inorder=>'",join_comma(postorder_diagdepths),"',",);
           print(" Ldepths_inorder=>'",join_comma(postorder_depths),"',",);
           print("          Rdepths_inorder=>'",join_comma(postorder_horizpos),"',",);
           postorder_depths == vecextract(depths,seq_postorder) || error();
           postorder_horizpos == vecextract(horizpos,seq_postorder) || error();
           my(diagdepths=vpar_diagdepths_vector(vpar));
           postorder_diagdepths == vecextract(diagdepths,seq_postorder) || error();

           print1("        vpar=>'",join_comma(vpar),"',",);
           print(" vpar_postorder=>'",join_comma(vpar_postorder),"',",);

           my(flip_vpar=vpar_diagonal_flip(vpar),
              flip_sizes=vpar_subtree_sizes_vector(flip_vpar),
              postorder_sizes=vpar_subtree_sizes_vector(vpar_postorder),
              Rweights=Rweights_by_siblings(vpar_postorder));
           print1("        Lweights=>'",join_comma(postorder_sizes),"',",);
           print(" Rweights=>'",join_comma(Rweights),"',",);

           \\ my(subtree_heights=vpar_subtree_heights_vector(vpar),
           \\    siblingpos=vpar_siblingpos_vector(vpar,1));
           \\ print1("        Lheights=>'",join_comma(subtree_heights),"',",);
           \\ print(" Rheights=>'",join_comma(siblingpos),"',",);

           print("      },");
          );
     print("     ],");
     );
  print("     # end generated");
}
     