package WordList::EN::PersonName::PopularBabyName::US::SSA::2017::FemaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-22'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyName-US-SSA'; # DIST
our $VERSION = '0.003'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contain_nonword_chars",0,"longest_word_len",10,"num_words_contains_whitespace",0,"num_words_contain_whitespace",0,"num_words",1000,"avg_word_len",6.014,"num_words_contain_unicode",0,"num_words_contains_nonword_chars",0,"num_words_contains_unicode",0,"shortest_word_len",3); # STATS

1;
# ABSTRACT: Top 1000 most popular names for female babies born in the USA in 2017 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyName::US::SSA::2017::FemaleTop1000 - Top 1000 most popular names for female babies born in the USA in 2017 (from Social Security Administration)

=head1 VERSION

This document describes version 0.003 of WordList::EN::PersonName::PopularBabyName::US::SSA::2017::FemaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyName-US-SSA), released on 2020-05-22.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyName::US::SSA::2017::FemaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyName::US::SSA::2017::FemaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Iterate
 my $first_word = $wl->first_word;
 while (defined(my $word = $wl->next_word)) { ... }

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 6.014 |
 | longest_word_len                 | 10    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 3     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyName-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Emma
Olivia
Ava
Isabella
Sophia
Mia
Charlotte
Amelia
Evelyn
Abigail
Harper
Emily
Elizabeth
Avery
Sofia
Ella
Madison
Scarlett
Victoria
Aria
Grace
Chloe
Camila
Penelope
Riley
Layla
Lillian
Nora
Zoey
Mila
Aubrey
Hannah
Lily
Addison
Eleanor
Natalie
Luna
Savannah
Brooklyn
Leah
Zoe
Stella
Hazel
Ellie
Paisley
Audrey
Violet
Skylar
Claire
Bella
Aurora
Lucy
Anna
Samantha
Caroline
Genesis
Aaliyah
Kennedy
Kinsley
Maya
Allison
Sarah
Madelyn
Adeline
Alexa
Gabriella
Ariana
Elena
Naomi
Alice
Sadie
Hailey
Eva
Autumn
Emilia
Quinn
Nevaeh
Ruby
Serenity
Piper
Willow
Everly
Cora
Kaylee
Lydia
Aubree
Arianna
Eliana
Peyton
Melanie
Gianna
Isabelle
Julia
Valentina
Nova
Clara
Vivian
Reagan
Madeline
Mackenzie
Brielle
Delilah
Isla
Katherine
Rylee
Sophie
Josephine
Ivy
Liliana
Jade
Maria
Hadley
Taylor
Kylie
Emery
Adalynn
Faith
Annabelle
Natalia
Alexandra
Ximena
Ashley
Brianna
Raelynn
Bailey
Mary
Athena
Andrea
Leilani
Lyla
Jasmine
Margaret
Alyssa
Adalyn
Arya
Norah
Khloe
Kayla
Eden
Eliza
Rose
Ariel
Melody
Alexis
Isabel
Sydney
Juliana
Iris
Lauren
Emerson
London
Morgan
Lilly
Charlie
Aliyah
Valeria
Sara
Arabella
Finley
Trinity
Ryleigh
Jordyn
Jocelyn
Kimberly
Esther
Molly
Valerie
Cecilia
Anastasia
Daisy
Reese
Laila
Mya
Amy
Teagan
Elise
Amaya
Harmony
Paige
Fiona
Adaline
Alaina
Genevieve
Nicole
Lucia
Alina
Mckenzie
Callie
Payton
Eloise
Brooke
Londyn
Rachel
Mariah
Gracie
Julianna
Daniela
Catherine
Angelina
Josie
Presley
Harley
Adelyn
Vanessa
Makayla
Amara
Juliette
Parker
Marley
Lila
Ana
Rowan
Alana
Michelle
Malia
Rebecca
Brooklynn
Brynlee
Summer
Sloane
Leila
Sienna
Adriana
Kendall
Sawyer
Destiny
Juliet
Elliana
Alayna
Diana
Ayla
Dakota
Hayden
Angela
Rosalie
Joanna
Noelle
Jayla
Alivia
Emersyn
Lola
Georgia
Selena
June
Tessa
Daleyza
Maggie
Jessica
Remi
Delaney
Vivienne
Camille
Hope
Olive
Mckenna
Alexandria
Gemma
Blakely
Izabella
Catalina
Journee
Raegan
Gabrielle
Ruth
Lucille
Amiyah
Evangeline
Thea
Blake
River
Amina
Giselle
Lilah
Melissa
Kate
Adelaide
Vera
Charlee
Jane
Journey
Gabriela
Leia
Zara
Miriam
Elaina
Stephanie
Briella
Cali
Ember
Aniyah
Lilliana
Kamila
Logan
Ariella
Brynn
Makenzie
Annie
Haven
Elsie
Kali
Mariana
Paris
Lena
Nyla
Freya
Adelynn
Lyric
Camilla
Jennifer
Sage
Paislee
Juniper
Talia
Alessandra
Fatima
Raelyn
Amira
Phoebe
Ada
Arielle
Kinley
Nina
Ariah
Samara
Myla
Brinley
Cassidy
Maci
Aspen
Allie
Keira
Kaia
Makenna
Heaven
Joy
Amanda
Lia
Madilyn
Laura
Gracelyn
Evelynn
Lexi
Haley
Miranda
Felicity
Kaitlyn
Daniella
Evie
Jacqueline
Angel
Danielle
Ainsley
Dylan
Kiara
Millie
Jordan
Rylie
Maddison
Alicia
Maeve
Margot
Kylee
Phoenix
Heidi
Zuri
Madeleine
Alondra
Lana
Gracelynn
Kenzie
Miracle
Shelby
Adrianna
Elle
Bianca
Addilyn
Esmeralda
Kira
Veronica
Gwendolyn
Chelsea
Skyler
Alison
Magnolia
Daphne
Everleigh
Jenna
Kyla
Braelynn
Harlow
Annalise
Mikayla
Dahlia
Maliyah
Kayleigh
Averie
Kelsey
Scarlet
Luciana
Gia
Nadia
Amber
Christina
Erin
Kamryn
Yaretzi
Jimena
Katie
Carmen
Ryan
Viviana
Alexia
Anaya
Serena
Katelyn
Ophelia
Regina
Helen
Remington
Camryn
Royalty
Cadence
Amari
Jada
Kathryn
Skye
Ariyah
Emely
Cheyenne
Saylor
Aylin
Francesca
Sabrina
Kendra
Fernanda
Eve
Mckinley
Frances
Sarai
Carolina
Nylah
Kennedi
Tatum
Winter
Zariah
Lennon
Raven
Alani
Leslie
Mabel
Sierra
Abby
Willa
April
Selah
Carly
Rosemary
Jolene
Madelynn
Aviana
Lorelei
Renata
Briana
Celeste
Wren
Charleigh
Annabella
Leighton
Braelyn
Jayleen
Ashlyn
Jazlyn
Mira
Oakley
Malaysia
Edith
Hattie
Avianna
Emmalyn
Kensley
Maryam
Sylvia
Marlee
Macie
Cataleya
Demi
Maia
Allyson
Bristol
Lilith
Itzel
Kaydence
Melany
Holly
Nia
Nayeli
Liana
Meredith
Megan
Bethany
Justice
Janelle
Alejandra
Ashlynn
Elianna
Adelina
Elisa
Myra
Aleah
Lainey
Blair
Kassidy
Charley
Virginia
Kara
Helena
Michaela
Sasha
Julie
Carter
Henley
Matilda
Kehlani
Maisie
Hallie
Jazmin
Priscilla
Cecelia
Colette
Marilyn
Danna
Elliott
Baylee
Ivanna
Alayah
Cameron
Celine
Hanna
Imani
Angelica
Emelia
Kalani
Addyson
Macy
Alanna
Lorelai
Karina
Aleena
Johanna
Leona
Aisha
Mallory
Kynlee
Madilynn
Mariam
Karla
Karen
Beatrice
Skyla
Dayana
Gloria
Milani
Savanna
Karsyn
Giuliana
Rory
Lauryn
Liberty
Galilea
Charli
Aubrie
Brylee
Kyleigh
Jillian
Anne
Azalea
Dallas
Haylee
Jayda
Avah
Tiffany
Shiloh
Bailee
Esme
Jazmine
Coraline
Madisyn
Elaine
Kyra
Lilian
Irene
Kaliyah
Octavia
Dorothy
Kora
Kelly
Laurel
Remy
Lacey
Adley
Anika
Sutton
Janiyah
Kimber
Rebekah
Cassandra
Julieta
Sloan
Amalia
Collins
Elliot
Jamie
Jemma
Emmy
Hayley
Jaylah
Melina
Leyla
Kailani
Anahi
Jaliyah
Harlee
Saige
Wynter
Alessia
Monica
Anya
Emberly
Antonella
Ivory
Khaleesi
Emory
Greta
Alena
Maren
Cynthia
Addisyn
Alaia
Alia
Mae
Angie
Ariya
Lylah
Aileen
Alma
Crystal
Jayde
Kinslee
Zahra
Zelda
Katalina
Reyna
Siena
Kailey
Marie
Pearl
Jessie
Tiana
Amirah
Madalyn
Alaya
Lilyana
Julissa
Armani
Lennox
Lillie
Rosa
Laney
Mara
Jolie
Roselyn
Joelle
Kaylani
Liv
Aurelia
Bridget
Oaklyn
Clarissa
Marissa
Rosie
Elyse
Monroe
Kori
Aliza
Poppy
Elsa
Emmie
Amelie
Aitana
Eileen
Chaya
Braylee
Milana
Royal
Addilynn
Frida
Bonnie
Amora
Stevie
Emerie
Malaya
Mina
Tatiana
Reign
Annika
Zaylee
Kenia
Linda
Kenna
Faye
Jaelyn
Kadence
Reina
Astrid
Brittany
Marina
Mikaela
Kaylie
Bria
Briar
Lyra
Teresa
Hadassah
Lilianna
Noa
Guadalupe
Rayna
Chanel
Laylah
Zariyah
Meadow
Aubrielle
Aniya
Livia
Ellen
Elora
Clementine
Hunter
Leanna
Milan
Amiya
Ellis
Princess
Nathalie
Nola
Tenley
Lina
Martha
Simone
Louisa
Sariah
Marianna
Emmeline
Noemi
Belen
Kenley
Myah
Erika
Everlee
Lara
Maleah
Amani
Ansley
Salma
Dulce
Elisabeth
Jaelynn
Kiera
Nala
Penny
Mercy
Averi
Deborah
Natasha
Raina
Ariadne
Yareli
Zaria
Hana
Kairi
Aya
Lexie
Ryann
Thalia
Christine
Estella
Karter
Annabel
Keyla
Tori
Adele
Landry
Estelle
Miah
Perla
Rylan
Lailah
Rivka
Angelique
Avalynn
Romina
Mavis
Scarlette
Ari
Louise
Jaycee
Jaylene
Kai
Belle
Lea
Zaniyah
Ayleen
Calliope
Nalani
Dalary
Sky
Isabela
Joselyn
Kaelyn
Giovanna
Jewel
Paola
Dream
Karlee
Madalynn
Aubriella
Tinley
Whitney
Aliana
Azariah
Corinne
Erica
Claudia
Joyce
Milena
Alyson
Carolyn
Celia
Kallie
Emilee
Paisleigh
Tinsley
Zoie
Frankie
Jaylee
Opal
Aiyana
Judith
Amayah
Amia
Analia
Andi
Chana
Paula
Xiomara
Audrina
Cara
Hadlee
Lyanna
Rayne
Amaris
Gwen
Rhea
Clare
Veda
Giana
Sariyah
Alisha
Davina
Lindsey
Danica
Kathleen
Nancy
Noor
Lillianna
Paulina
Hailee
Harleigh
Maxine
Raylee
Jessa
Raquel
Zainab
Lisa
Heavenly
Aminah
Patricia
Oaklynn
Emmalynn
India
Janessa
Paloma
Ramona
Sandra
Abril
Emmaline
Kassandra
Vienna
Itzayana
Marleigh
Rosalyn
Barbara
Kailyn
Novalee
Taliyah
Avalyn
Meilani
Hadleigh
Iliana
Luella
Blaire
Brenda
Casey
Jana
Aadhya
Alannah
Annalee
Malani
Selene
Lizbeth
Miley
Adrienne
Aliya
Bexley
Nataly
Zion
Joslyn
Maliah
Breanna
Estrella
Jayden
Kiana
Melania
Kaya
Harmoni
Ingrid
Jazlynn
Kaylin
Arely
Jurnee
Marjorie
Mylah
Paityn
Dana
Ellianna
Kailee
Legacy
Oaklee
Ailani
Courtney
Holland
Magdalena
Carla
Evalyn
Halle
Karlie
Kenya
Saoirse
Susan
Kaiya
Aryanna
Esperanza
Naya
Desiree
Kimora
Renee
Ensley
Treasure
Ellison
Adilynn
Anabelle
Caylee
Kristina
Aranza
Egypt
Spencer
Tegan
Emerald
Florence
Micah
Sonia
Vada
Tara
Marlowe
Sunny
Yara
Alisa
Riya
Sylvie
Carlee
Nathalia
Samira
Yamileth
Etta
Jenny
Saanvi
Brenna
Bryleigh
Miya
Monserrat
