#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

OPŠTA DEKLARACIJA O PRAVIMA ČOVEKA
UVOD
Pošto je priznavanje urodjenog dostojanstva i jednakih i neotudjivih prava svih članova ljudske porodice temelj slobode, pravde i mira u svetu;

pošto je nepoštovanje i preziranje prava čoveka vodilo varvarskim postupcima, koji su vredjali savest čovečanstva, i pošto je stvaranje sveta u kojem će ljudska bića uživati slobodu govora i verovanja i biti slobodna od straha i nemaštine proglašeno kao najviša težnja svakog čoveka;

pošto je bitno da prava čoveka budu zaštićena pravnim sistemom kako čovek ne bi bio primoran da kao krajnjem izlazu pribegne pobuni protiv tiranije i ugnjetavanja;

pošto je bitno da se podstiče razvoj prijateljskih odnosa medju narodima;

pošto su narodi Ujedinjenih nacija u Povelji ponovo proglasili svoju veru u osnovna prava čoveka, u dostojanstvo i vrednost čovekove ličnosti i ravnopravnost muškaraca i žena i pošto su odlučili da podstiču društveni napredak i poboljšaju životni standard u većoj slobodi;

pošto su se države članice obavezale da u saradnji s Ujedinjenim nacijama obezbede opšte poštovanje i primenu ljudskih prava i osnovnih sloboda;

pošto je opšte shvatanje ovih prava i sloboda od najveće važnosti za puno ostvarenje ove obaveze,

GENERALNA SKUPŠTINA PROGLAŠAVA

OVU OPŠTU DEKLARACIJU O PRAVIMA ČOVEKA kao zajednički domet koji treba da postignu svi narodi i sve nacije da bi svaki pojedinac i svaki organ društva, imajući ovu Deklaraciju stalno na umu, težio da učenjem i vaspitavanjem doprinese poštovanju ovih prava i sloboda da bi se postupnim unutrašnjim i medjunarodnim merama obezbedilo njihovo opšte i stvarno priznanje i poštovanje kako medju narodima samih država članica, tako i medju narodima onih teritorija koje su pod njihovom upravom.

Član 1.
Sva ljudska bića radjaju se slobodna i jednaka u dostojanstvu i pravima. Ona su obdarena razumom i svešću i treba jedni prema drugima da postupaju u duhu bratstva.

Član 2.
Svakom pripadaju sva prava i slobode proglašene u ovoj Deklaraciji bez ikakvih razlika u pogledu rase, boje, pola, jezika, veroispovesti, političkog ili drugog mišljenja, nacionalnog ili društvenog porekla, imovine, rodjenja ili drugih okolnosti.

Dalje, neće se praviti nikakva razlika na osnovu političkog, pravnog ili medjunarodnog statusa zemlje ili teritorije kojoj neko lice pripada, bilo da je ona nezavisna, pod starateljstvom, nesamoupravna, ili da joj je suverenost na ma koji drugi način ograničena.

Član 3.
Svako ima pravo na život, slobodu i bezbednost ličnosti.

Član 4.
Niko se ne sme držati u ropstvu ili potčinjenosti: ropstvo i trgovina robljem zabranjeni

su u svim oblicima.

Član 5.
Niko ne sme biti podvrgnut mučenju ili svirepom, nečovečnom ili ponižavajućem postupku ili kazni.

Član 6.
Svako ima pravo da svuda bude priznat kao pravni subjekt.

Član 7.
Svi su pred zakonom jednaki i imaju pravo bez ikakve razlike na podjednaku zakonsku zaštitu. Svi imaju pravo na jednaku zaštitu protiv bilo kakve diskriminacije kojom se krši ova Deklaracija i protiv svakog podsticanja na ovakvu diskriminaciju.

Član 8.
Svako ima pravo da ga nadležni nacionalni sudovi efikasno štite od dela kršenja osnovnih prava koja su mu priznata ustavom ili zakonom.

Član 9.
Niko ne sme biti proizvoljno uhapšen, pritvoren, niti proteran.

Član 10.
Svako ima potpuno jednako pravo na pravično javno sudjenje pred nezavisnim i nepristrasnim sudom koji će odlučiti o njegovim pravima i obavezama, i o osnovanosti svake krivične optužbe protiv njega.

Član 11.
Svako ko je optužen za krivično delo ima pravo da bude smatran nevinim dok se na osnovu zakona krivica ne dokaže na javnom sudjenju na kojem su mu obezbedjene sve garantije potrebne za njegovu odbranu.
Niko ne sme biti osudjen za dela ili propuste koji nisu predstavljali krivično delo po nacionalnom ili medjunarodnom pravu u vreme kada su izvršeni. Isto tako ne sme se izricati teža kazna od one koja se mogla primeniti u vreme kada je krivično delo izvršeno.
Član 12.
Niko ne sme biti izložen proizvoljnom mešanju u privatni život, porodicu, stan ili prepisku, niti napadima na čast i ugled. Svako ima pravo na zakonsku zaštitu protiv ovakvog mešanja ili napada.

Član 13.
Svako ima pravo na slobodu kretanja i izbora stanovanja u granicama pojedine države.
Svako ima pravo da napusti bilo koju zemlju, uključujući svoju vlastitu, i da se vrati u svoju zemlju.
Član 14.
Svako ima pravo da traži i uživa u drugim zemljama utočište od proganjanja.
Na ovo pravo se niko ne može pozvati u slučaju gonjenja za krivična dela koja nisu političkog karaktera ili progona zbog dela koja su u suprotnosti sa ciljevima i načelima Ujedinjenih nacija.
Član 15.
Svako ima pravo na državljanstvo.
Niko ne sme samovoljno biti lišen svog državljanstva niti prava da promeni državljanstvo.
Član 16.
Punoletni muškarci i žene, bez ikakvih ograničenja u pogledu rase, državljanstva ili vere, imaju pravo da sklope brak i da osnuju porodicu. Oni su ravnopravni prilikom sklapanja braka, za vreme njegovog trajanja i prilikom njegovog razvoda.
Brak se zaključuje samo slobodnim i potpunim pristankom lica koja stupaju u brak.
Porodica je prirodna i osnovna ćelija društva i ima pravo na zaštitu društva i države.
Član 17.
Svako ima pravo da poseduje imovinu, sam kao i u zajednici s drugima.
Niko ne sme biti samovoljno lišen imovine.
Član 18.
Svako ima pravo na slobodu misli, savesti i vere; ovo pravo uključuje slobodu promene vere ili ubedjenja i slobodu da čovek, bilo sam ili u zajednici s drugima, javno ili privatno, upražnjava svoju veru ili ubedjenje putem nastave, vršenja kulta i obavljanja obreda.

Član 19.
Svako ima pravo na slobodu mišljenja i izražavanja, što obuhvata i pravo da ne bude uznemiravan zbog svog mišljenja, kao i pravo da traži, prima i širi obaveštenja i ideje bilo kojim sredstvima i bez obzira na granice.

Član 20.
Svako ima pravo na slobodu mirnog okupljanja i udruživanja.
Niko ne može biti primoran da pripada nekom udruženju.
Član 21.
Svako ima pravo da učestvuje u upravljanju svojom zemljom, neposredno ili preko slobodno izabranih predstavnika.
Svako ima pravo da na ravnopravnoj osnovi stupa u javnu službu u svojoj zemlji.
Volja naroda je osnova državne vlasti: ova volja treba da se izražava na povremenim i slobodnim izborima, koji će se sprovoditi opštim i jednakim pravom glasa, tajnim glasanjem ili odgovarajućim postupkom kojim se obezbedjuje sloboda glasanja.
Član 22.
Svako, kao član društva, ima pravo na socijalno osiguranje i pravo da ostvaruje privredna, društvena i kulturna prava neophodna za svojе dostojanstvo i za slobodan razvoj svoje ličnosti, uz pomoćdržave i medjunarodne saradnje, a u skladu s organizacijom i sredstvima svake države.

Član 23.
Svako ima pravo na rad, na slobodan izbor zaposlenja, na pravične i zadovoljavajuće uslove rada i na zaštitu od nezaposlenosti.
Svako, bez ikakve razlike, ima pravo na jednaku platu za jednaki rad.
Svako ko radi ima pravo na pravednu i zadovoljavajuću naknadu koja njemu i njegovoj porodici obezbedjuje egzistenciju koja odgovara ljudskom dostojanstvu i koja će, ako bude potrebno, biti upotpunjena drugim sredstvima socijalne zaštite.
Svako ima pravo da obrazuje i da stupi u sindikate radi zaštite svojih interesa.
Član 24.
Svako ima pravo na odmor i razonodu, uključujući razumno ograničenje radnog vremena i povremeni plaćeni odmor.

Član 25.
Svako ima pravo na životni standard koji obezbedjuje zdravlje i blagostanje, njegovo i njegove porodice, uključujući hranu, odeću, stan i lekarsku negu i potrebne socijalne službe, kao i pravo na osiguranje u slučaju nezaposlenosti, bolesti, invalidnosti, udovištva, starosti, ili drugih slučajeva gubljenja sredstava za izdržavanje usled okolnosti nezavisnih od njegove volje.
Majke i deca imaju pravo na naročito staranje i pomoć. Sva deca, rodjena u braku ili van njega, uživaju jednaku socijalnu zaštitu.
Član 26.
Svako ima pravo na školovanje. Školovanje treba da bude besplatno bar u osnovnim i nižim školama. Osnovna nastava je obavezna. Tehnička i stručna nastava treba da bude opšte dostupna, a viša nastava treba da bude svima podjednako pristupačna na osnovu utvrdjenih kriterijuma.
Školovanje treba da bude usmereno punom razvoju ljudske ličnosti i jačanju poštovanja ljudskih prava i osnovnih sloboda. Ono treba da unapredjuje razumevanje, trpeljivost i prijateljstvo medju svim narodima, rasnim i verskim grupacijama, kao i delatnost Ujedinjenih nacija za održavanje mira.
Roditelji imaju prvenstveno pravo da biraju vrstu školovanja za svoju decu.
Član 27.
Svako ima pravo da slobodno učestvuje u kulturnom životu zajednice, da uživa u umetnosti i da učestvuje u naučnom napretku i u dobrobiti koja otuda proističe.
Svako ima pravo na zaštitu moralnih i materijalnih interesa koji proističu iz bilo kog naučnog, književnog ili umetničkog dela   čiji je on tvorac.
Član 28.
Svako ima pravo na društveni i medjunarodni poredak u kojem prava i slobode objavljeni u ovoj Deklaraciji mogu biti potpuno ostvareni.

Član 29.
Svako ima dužnost prema zajednici koja jedina omogućava slobodno i puno razvijanje njegove ličnosti.
U vršenju svojih prava i ostvarivanju sloboda svako može biti podvrgnut samo onim ograničenjima koja su predvidjena zakonom u cilju obezbedjenja nužnog priznanja i poštovanja prava i sloboda drugih i u cilju zadovoljenja pravičnih zahteva morala, javnog poretka i opšteg blagostanja u demokratskom društvu.
Ova prava i slobode ni u kom slučaju ne mogu se izvršavati protivno ciljevima i načelima Ujedinjenih nacija.
Član 30.
Nijedna odredba ove Deklaracije ne može se tumačiti kao pravo za ma koju državu, grupu ili lice da preduzima bilo koju aktivnost ili da vrši bilo kakvu radnju usmerenu na poništenje prava i sloboda koji su u njoj sadržani.
TEXT

#is(Text::Guess::Language->guess($text),'sr','is sr');

done_testing;
