use v5.36;
use Object::Pad;

package Chrome::Policy::Strict;
role Chrome::Policy::Strict;
use experimental qw( builtin );
use builtin qw( true false );
use JSON::PP;
use Data::Printer;
use Path::Tiny;

# @formatter:off
field %policy = (
# @formatter:on
  ForceGoogleSafeSearch   => true ,
  ForceYouTubeRestrict    => 1 ,
  SafeSitesFilterBehavior => 1 ,
);

method set_strict_policy ( $name = 'strict.json' , $type = 'managed' ) {
  my $policy = encode_json \%policy;
  # p $policy;
  my $file;
  if ( $type eq 'managed' ) {
    $file = path( $self -> managed_policy_path , $name ) -> touchpath -> openw;
  }
  $file -> print( $policy );
  $file -> close;
}

1;

=pod

=encoding UTF-8

=head1 NAME

Chrome::Policy::Strict

=head1 VERSION

version 0.230350

=head1 AUTHOR

Elvin Aslanov <rwp.primary@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by Elvin Aslanov.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__

{
  "ForceGoogleSafeSearch": true,
  "ForceYouTubeRestrict": 1,
  "SafeSitesFilterBehavior": 1,
}
