# Copyright (C) 2017 Koha-Suomi
#
# This file is part of Pootle-Client.

package t::Mock::Resource::Languages;

use Modern::Perl '2015';
use utf8;
binmode STDOUT, ':encoding(UTF-8)';
binmode STDERR, ':encoding(UTF-8)';
use feature 'signatures'; no warnings "experimental::signatures";
use Carp::Always;
use Try::Tiny;
use Scalar::Util qw(blessed);


use base('t::Mock::Resource');


use Pootle::Resource::Language;

my $objects;
my $lookup;
my $responseDump;

sub one($papi, $endpoint) {
  ($objects, $lookup) = __PACKAGE__->init($responseDump, 'Pootle::Resource::Language') unless ($objects && $lookup);
  return $lookup->{$endpoint};
}

sub all($papi) {
  ($objects, $lookup) = __PACKAGE__->init($responseDump, 'Pootle::Resource::Language') unless ($objects && $lookup);
  return $objects if $objects;
}

$responseDump = [
  {
    'code' => 'am',
    'description' => '',
    'fullname' => 'Amharic',
    'nplurals' => 2,
    'pluralequation' => 'n > 1',
    'resource_uri' => '/api/v1/languages/88/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/39/',
      '/api/v1/translation-projects/293/',
      '/api/v1/translation-projects/84/',
      '/api/v1/translation-projects/127/',
      '/api/v1/translation-projects/175/',
      '/api/v1/translation-projects/274/',
      '/api/v1/translation-projects/454/',
      '/api/v1/translation-projects/511/',
      '/api/v1/translation-projects/604/',
      '/api/v1/translation-projects/692/',
      '/api/v1/translation-projects/831/',
      '/api/v1/translation-projects/893/',
      '/api/v1/translation-projects/989/',
      '/api/v1/translation-projects/1083/',
      '/api/v1/translation-projects/1165/'
    ]
  },
  {
    'code' => 'an',
    'description' => '',
    'fullname' => 'Aragonese',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/90/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'ar',
    'description' => '',
    'fullname' => 'Arabic',
    'nplurals' => 6,
    'pluralequation' => 'n==0 ? 0 : n==1 ? 1 : n==2 ? 2 : n%100>=3 && n%100<=10 ? 3 : n%100>=11 ? 4 : 5',
    'resource_uri' => '/api/v1/languages/91/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/294/',
      '/api/v1/translation-projects/85/',
      '/api/v1/translation-projects/132/',
      '/api/v1/translation-projects/177/',
      '/api/v1/translation-projects/40/',
      '/api/v1/translation-projects/228/',
      '/api/v1/translation-projects/453/',
      '/api/v1/translation-projects/512/',
      '/api/v1/translation-projects/605/',
      '/api/v1/translation-projects/693/',
      '/api/v1/translation-projects/790/',
      '/api/v1/translation-projects/792/',
      '/api/v1/translation-projects/806/',
      '/api/v1/translation-projects/817/',
      '/api/v1/translation-projects/894/',
      '/api/v1/translation-projects/970/',
      '/api/v1/translation-projects/978/',
      '/api/v1/translation-projects/990/',
      '/api/v1/translation-projects/1074/',
      '/api/v1/translation-projects/1084/',
      '/api/v1/translation-projects/1166/',
      '/api/v1/translation-projects/1257/',
      '/api/v1/translation-projects/1258/'
    ]
  },
  {
    'code' => 'arn',
    'description' => '',
    'fullname' => 'Mapudungun; Mapuche',
    'nplurals' => 2,
    'pluralequation' => 'n > 1',
    'resource_uri' => '/api/v1/languages/44/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'as',
    'description' => '',
    'fullname' => 'Assamese',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/152/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/1071/',
      '/api/v1/translation-projects/1085/',
      '/api/v1/translation-projects/1167/'
    ]
  },
  {
    'code' => 'ast',
    'description' => '',
    'fullname' => 'Asturian; Bable; Leonese; Asturleonese',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/53/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/295/'
    ]
  },
  {
    'code' => 'az',
    'description' => '',
    'fullname' => 'Azerbaijani',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/95/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/41/',
      '/api/v1/translation-projects/296/',
      '/api/v1/translation-projects/86/',
      '/api/v1/translation-projects/134/',
      '/api/v1/translation-projects/179/',
      '/api/v1/translation-projects/264/',
      '/api/v1/translation-projects/403/',
      '/api/v1/translation-projects/513/',
      '/api/v1/translation-projects/606/',
      '/api/v1/translation-projects/694/',
      '/api/v1/translation-projects/832/',
      '/api/v1/translation-projects/895/',
      '/api/v1/translation-projects/991/',
      '/api/v1/translation-projects/1086/',
      '/api/v1/translation-projects/1168/'
    ]
  },
  {
    'code' => 'be',
    'description' => '',
    'fullname' => 'Belarusian',
    'nplurals' => 3,
    'pluralequation' => 'n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2',
    'resource_uri' => '/api/v1/languages/49/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/679/',
      '/api/v1/translation-projects/688/',
      '/api/v1/translation-projects/675/',
      '/api/v1/translation-projects/598/',
      '/api/v1/translation-projects/607/',
      '/api/v1/translation-projects/695/',
      '/api/v1/translation-projects/833/',
      '/api/v1/translation-projects/896/',
      '/api/v1/translation-projects/992/',
      '/api/v1/translation-projects/1087/',
      '/api/v1/translation-projects/1169/'
    ]
  },
  {
    'code' => 'bg',
    'description' => '',
    'fullname' => 'Bulgarian',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/50/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/297/',
      '/api/v1/translation-projects/459/',
      '/api/v1/translation-projects/474/',
      '/api/v1/translation-projects/490/',
      '/api/v1/translation-projects/514/',
      '/api/v1/translation-projects/608/',
      '/api/v1/translation-projects/696/',
      '/api/v1/translation-projects/835/',
      '/api/v1/translation-projects/897/',
      '/api/v1/translation-projects/993/',
      '/api/v1/translation-projects/1088/',
      '/api/v1/translation-projects/1170/'
    ]
  },
  {
    'code' => 'bn',
    'description' => '',
    'fullname' => 'Bengali',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/48/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/281/',
      '/api/v1/translation-projects/136/',
      '/api/v1/translation-projects/181/',
      '/api/v1/translation-projects/263/',
      '/api/v1/translation-projects/404/',
      '/api/v1/translation-projects/888/',
      '/api/v1/translation-projects/515/',
      '/api/v1/translation-projects/609/',
      '/api/v1/translation-projects/697/',
      '/api/v1/translation-projects/834/',
      '/api/v1/translation-projects/898/',
      '/api/v1/translation-projects/994/',
      '/api/v1/translation-projects/1089/',
      '/api/v1/translation-projects/1171/'
    ]
  },
  {
    'code' => 'bn_IN',
    'description' => '',
    'fullname' => 'Bengali (India)',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/97/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/81/',
      '/api/v1/translation-projects/87/',
      '/api/v1/translation-projects/285/'
    ]
  },
  {
    'code' => 'bo',
    'description' => '',
    'fullname' => 'Tibetan',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/55/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'br',
    'description' => '',
    'fullname' => 'Breton',
    'nplurals' => 2,
    'pluralequation' => 'n > 1',
    'resource_uri' => '/api/v1/languages/56/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'bs',
    'description' => '',
    'fullname' => 'Bosnian',
    'nplurals' => 3,
    'pluralequation' => 'n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2',
    'resource_uri' => '/api/v1/languages/57/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'ca',
    'description' => '',
    'fullname' => 'Catalan; Valencian',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/61/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/42/',
      '/api/v1/translation-projects/298/',
      '/api/v1/translation-projects/88/',
      '/api/v1/translation-projects/286/'
    ]
  },
  {
    'code' => 'ca_ES',
    'description' => '',
    'fullname' => 'Catalan (Spain)',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/136/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/505/',
      '/api/v1/translation-projects/273/',
      '/api/v1/translation-projects/406/',
      '/api/v1/translation-projects/516/',
      '/api/v1/translation-projects/610/',
      '/api/v1/translation-projects/698/',
      '/api/v1/translation-projects/836/',
      '/api/v1/translation-projects/899/',
      '/api/v1/translation-projects/995/',
      '/api/v1/translation-projects/1090/',
      '/api/v1/translation-projects/1172/'
    ]
  },
  {
    'code' => 'cs',
    'description' => '',
    'fullname' => 'Czech',
    'nplurals' => 3,
    'pluralequation' => '(n==1) ? 0 : (n>=2 && n<=4) ? 1 : 2',
    'resource_uri' => '/api/v1/languages/63/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/299/',
      '/api/v1/translation-projects/282/',
      '/api/v1/translation-projects/172/',
      '/api/v1/translation-projects/213/',
      '/api/v1/translation-projects/250/',
      '/api/v1/translation-projects/458/',
      '/api/v1/translation-projects/588/',
      '/api/v1/translation-projects/517/',
      '/api/v1/translation-projects/611/',
      '/api/v1/translation-projects/699/',
      '/api/v1/translation-projects/789/',
      '/api/v1/translation-projects/793/',
      '/api/v1/translation-projects/807/',
      '/api/v1/translation-projects/824/',
      '/api/v1/translation-projects/900/',
      '/api/v1/translation-projects/971/',
      '/api/v1/translation-projects/979/',
      '/api/v1/translation-projects/996/',
      '/api/v1/translation-projects/1075/',
      '/api/v1/translation-projects/1091/',
      '/api/v1/translation-projects/1173/',
      '/api/v1/translation-projects/1248/',
      '/api/v1/translation-projects/1259/'
    ]
  },
  {
    'code' => 'csb',
    'description' => '',
    'fullname' => 'Kashubian',
    'nplurals' => 3,
    'pluralequation' => 'n==1 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2',
    'resource_uri' => '/api/v1/languages/103/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'cy',
    'description' => '',
    'fullname' => 'Welsh',
    'nplurals' => 2,
    'pluralequation' => '(n==2) ? 1 : 0',
    'resource_uri' => '/api/v1/languages/62/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/988/',
      '/api/v1/translation-projects/997/',
      '/api/v1/translation-projects/1092/',
      '/api/v1/translation-projects/1174/'
    ]
  },
  {
    'code' => 'da',
    'description' => '',
    'fullname' => 'Danish',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/35/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/76/',
      '/api/v1/translation-projects/121/',
      '/api/v1/translation-projects/141/',
      '/api/v1/translation-projects/187/',
      '/api/v1/translation-projects/235/',
      '/api/v1/translation-projects/300/',
      '/api/v1/translation-projects/407/',
      '/api/v1/translation-projects/518/',
      '/api/v1/translation-projects/612/',
      '/api/v1/translation-projects/700/',
      '/api/v1/translation-projects/837/',
      '/api/v1/translation-projects/901/',
      '/api/v1/translation-projects/998/',
      '/api/v1/translation-projects/1093/',
      '/api/v1/translation-projects/1175/'
    ]
  },
  {
    'code' => 'de',
    'description' => '',
    'fullname' => 'German',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/34/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/89/',
      '/api/v1/translation-projects/43/',
      '/api/v1/translation-projects/128/',
      '/api/v1/translation-projects/174/',
      '/api/v1/translation-projects/222/',
      '/api/v1/translation-projects/301/',
      '/api/v1/translation-projects/583/',
      '/api/v1/translation-projects/400/',
      '/api/v1/translation-projects/519/',
      '/api/v1/translation-projects/613/',
      '/api/v1/translation-projects/701/',
      '/api/v1/translation-projects/816/',
      '/api/v1/translation-projects/902/',
      '/api/v1/translation-projects/999/',
      '/api/v1/translation-projects/1094/',
      '/api/v1/translation-projects/1176/'
    ]
  },
  {
    'code' => 'de_CH',
    'description' => '',
    'fullname' => 'German (Switzerland)',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/134/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/287/',
      '/api/v1/translation-projects/221/',
      '/api/v1/translation-projects/223/',
      '/api/v1/translation-projects/408/',
      '/api/v1/translation-projects/508/',
      '/api/v1/translation-projects/520/',
      '/api/v1/translation-projects/614/',
      '/api/v1/translation-projects/702/',
      '/api/v1/translation-projects/819/',
      '/api/v1/translation-projects/903/',
      '/api/v1/translation-projects/1000/',
      '/api/v1/translation-projects/1095/',
      '/api/v1/translation-projects/1177/'
    ]
  },
  {
    'code' => 'dz',
    'description' => '',
    'fullname' => 'Dzongkha',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/36/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'el',
    'description' => '',
    'fullname' => 'Greek, Modern (1453-)',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/39/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/90/',
      '/api/v1/translation-projects/44/',
      '/api/v1/translation-projects/144/',
      '/api/v1/translation-projects/189/',
      '/api/v1/translation-projects/270/',
      '/api/v1/translation-projects/409/',
      '/api/v1/translation-projects/521/',
      '/api/v1/translation-projects/615/',
      '/api/v1/translation-projects/703/',
      '/api/v1/translation-projects/838/',
      '/api/v1/translation-projects/904/',
      '/api/v1/translation-projects/1001/',
      '/api/v1/translation-projects/1096/',
      '/api/v1/translation-projects/1164/',
      '/api/v1/translation-projects/1178/'
    ]
  },
  {
    'code' => 'en',
    'description' => '',
    'fullname' => 'English',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/2/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'en_GB',
    'description' => '',
    'fullname' => 'English (United Kingdom)',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/69/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/45/',
      '/api/v1/translation-projects/91/',
      '/api/v1/translation-projects/131/',
      '/api/v1/translation-projects/218/',
      '/api/v1/translation-projects/225/',
      '/api/v1/translation-projects/410/',
      '/api/v1/translation-projects/523/',
      '/api/v1/translation-projects/616/',
      '/api/v1/translation-projects/704/',
      '/api/v1/translation-projects/839/',
      '/api/v1/translation-projects/905/',
      '/api/v1/translation-projects/1002/',
      '/api/v1/translation-projects/1097/',
      '/api/v1/translation-projects/1179/'
    ]
  },
  {
    'code' => 'en_NZ',
    'description' => '',
    'fullname' => 'English (New Zealand)',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/130/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/92/',
      '/api/v1/translation-projects/73/',
      '/api/v1/translation-projects/130/',
      '/api/v1/translation-projects/176/',
      '/api/v1/translation-projects/224/',
      '/api/v1/translation-projects/411/',
      '/api/v1/translation-projects/524/',
      '/api/v1/translation-projects/617/',
      '/api/v1/translation-projects/705/',
      '/api/v1/translation-projects/827/',
      '/api/v1/translation-projects/906/',
      '/api/v1/translation-projects/1003/',
      '/api/v1/translation-projects/1098/',
      '/api/v1/translation-projects/1180/'
    ]
  },
  {
    'code' => 'en_ZA',
    'description' => '',
    'fullname' => 'English (South Africa)',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/38/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'en-USACADEMIC',
    'description' => '',
    'fullname' => 'English (US Academic)',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/142/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/969/'
    ]
  },
  {
    'code' => 'eo',
    'description' => '',
    'fullname' => 'Esperanto',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/147/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/799/',
      '/api/v1/translation-projects/803/',
      '/api/v1/translation-projects/800/',
      '/api/v1/translation-projects/801/',
      '/api/v1/translation-projects/840/',
      '/api/v1/translation-projects/907/',
      '/api/v1/translation-projects/1004/',
      '/api/v1/translation-projects/1099/',
      '/api/v1/translation-projects/1181/'
    ]
  },
  {
    'code' => 'es',
    'description' => '',
    'fullname' => 'Spanish; Castilian',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/105/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/303/',
      '/api/v1/translation-projects/93/',
      '/api/v1/translation-projects/137/',
      '/api/v1/translation-projects/182/',
      '/api/v1/translation-projects/46/',
      '/api/v1/translation-projects/231/',
      '/api/v1/translation-projects/412/',
      '/api/v1/translation-projects/507/',
      '/api/v1/translation-projects/510/',
      '/api/v1/translation-projects/618/',
      '/api/v1/translation-projects/706/',
      '/api/v1/translation-projects/788/',
      '/api/v1/translation-projects/794/',
      '/api/v1/translation-projects/808/',
      '/api/v1/translation-projects/815/',
      '/api/v1/translation-projects/908/',
      '/api/v1/translation-projects/972/',
      '/api/v1/translation-projects/980/',
      '/api/v1/translation-projects/1005/',
      '/api/v1/translation-projects/1073/',
      '/api/v1/translation-projects/1100/',
      '/api/v1/translation-projects/1182/',
      '/api/v1/translation-projects/1247/',
      '/api/v1/translation-projects/1260/'
    ]
  },
  {
    'code' => 'et',
    'description' => '',
    'fullname' => 'Estonian',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/43/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'eu',
    'description' => '',
    'fullname' => 'Basque',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/42/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/77/',
      '/api/v1/translation-projects/304/',
      '/api/v1/translation-projects/94/',
      '/api/v1/translation-projects/135/',
      '/api/v1/translation-projects/180/',
      '/api/v1/translation-projects/230/',
      '/api/v1/translation-projects/413/',
      '/api/v1/translation-projects/526/',
      '/api/v1/translation-projects/619/',
      '/api/v1/translation-projects/707/',
      '/api/v1/translation-projects/841/',
      '/api/v1/translation-projects/909/',
      '/api/v1/translation-projects/1006/',
      '/api/v1/translation-projects/1101/',
      '/api/v1/translation-projects/1183/'
    ]
  },
  {
    'code' => 'fa',
    'description' => '',
    'fullname' => 'Persian',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/110/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/305/',
      '/api/v1/translation-projects/492/',
      '/api/v1/translation-projects/476/',
      '/api/v1/translation-projects/460/',
      '/api/v1/translation-projects/527/',
      '/api/v1/translation-projects/620/',
      '/api/v1/translation-projects/708/',
      '/api/v1/translation-projects/842/',
      '/api/v1/translation-projects/910/',
      '/api/v1/translation-projects/1007/',
      '/api/v1/translation-projects/1102/',
      '/api/v1/translation-projects/1184/'
    ]
  },
  {
    'code' => 'fi',
    'description' => '',
    'fullname' => 'Finnish',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/111/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/124/',
      '/api/v1/translation-projects/142/',
      '/api/v1/translation-projects/220/',
      '/api/v1/translation-projects/236/',
      '/api/v1/translation-projects/277/',
      '/api/v1/translation-projects/414/',
      '/api/v1/translation-projects/528/',
      '/api/v1/translation-projects/592/',
      '/api/v1/translation-projects/621/',
      '/api/v1/translation-projects/709/',
      '/api/v1/translation-projects/843/',
      '/api/v1/translation-projects/911/',
      '/api/v1/translation-projects/1008/',
      '/api/v1/translation-projects/1103/',
      '/api/v1/translation-projects/1185/'
    ]
  },
  {
    'code' => 'fil',
    'description' => '',
    'fullname' => 'Filipino; Pilipino',
    'nplurals' => 2,
    'pluralequation' => '(n > 1)',
    'resource_uri' => '/api/v1/languages/31/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/468/',
      '/api/v1/translation-projects/477/',
      '/api/v1/translation-projects/493/',
      '/api/v1/translation-projects/529/',
      '/api/v1/translation-projects/622/',
      '/api/v1/translation-projects/710/',
      '/api/v1/translation-projects/884/',
      '/api/v1/translation-projects/912/',
      '/api/v1/translation-projects/1009/',
      '/api/v1/translation-projects/1104/',
      '/api/v1/translation-projects/1186/'
    ]
  },
  {
    'code' => 'fo',
    'description' => '',
    'fullname' => 'Faroese',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/112/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/599/',
      '/api/v1/translation-projects/623/',
      '/api/v1/translation-projects/676/',
      '/api/v1/translation-projects/680/',
      '/api/v1/translation-projects/689/',
      '/api/v1/translation-projects/778/',
      '/api/v1/translation-projects/844/',
      '/api/v1/translation-projects/913/',
      '/api/v1/translation-projects/1010/',
      '/api/v1/translation-projects/1105/',
      '/api/v1/translation-projects/1187/'
    ]
  },
  {
    'code' => 'fr',
    'description' => "<p>Bienvenue sur le projet francophone de traduction de Koha.<br>Pour traduire choisissez la version de koha sur laquelle vous voulez travailler.<br>Vous pouvez travailler en mode anonyme pour sugg\x{e9}rer des traductions ou des corrections, ou bien vous cr\x{e9}er un compte pour traduire ou valider des suggestions<br><br>Les cha\x{ee}nes des pr\x{e9}f\x{e9}rences syst\x{e8}me doivent \x{ea}tre traduites sp\x{e9}cifiquement. Vous devez omettre dans la cha\x{ee}ne traduite la partie de commentaire de la cha\x{ee}ne originale. Le commentaire doit ici vous aider en localisant chaque pr\x{e9}f\x{e9}rence dans son contexte.<br><br></p>",
    'fullname' => 'French',
    'nplurals' => 2,
    'pluralequation' => '(n > 1)',
    'resource_uri' => '/api/v1/languages/107/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/306/',
      '/api/v1/translation-projects/82/',
      '/api/v1/translation-projects/129/',
      '/api/v1/translation-projects/173/',
      '/api/v1/translation-projects/47/',
      '/api/v1/translation-projects/238/',
      '/api/v1/translation-projects/415/',
      '/api/v1/translation-projects/530/',
      '/api/v1/translation-projects/624/',
      '/api/v1/translation-projects/782/',
      '/api/v1/translation-projects/805/',
      '/api/v1/translation-projects/813/',
      '/api/v1/translation-projects/826/',
      '/api/v1/translation-projects/914/',
      '/api/v1/translation-projects/973/',
      '/api/v1/translation-projects/981/',
      '/api/v1/translation-projects/1011/',
      '/api/v1/translation-projects/1077/',
      '/api/v1/translation-projects/1106/',
      '/api/v1/translation-projects/1188/',
      '/api/v1/translation-projects/1249/',
      '/api/v1/translation-projects/1261/'
    ]
  },
  {
    'code' => 'fr_CA',
    'description' => '',
    'fullname' => 'French (Canada)',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/131/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/74/',
      '/api/v1/translation-projects/95/',
      '/api/v1/translation-projects/143/',
      '/api/v1/translation-projects/188/',
      '/api/v1/translation-projects/237/',
      '/api/v1/translation-projects/416/',
      '/api/v1/translation-projects/591/',
      '/api/v1/translation-projects/531/',
      '/api/v1/translation-projects/625/',
      '/api/v1/translation-projects/783/',
      '/api/v1/translation-projects/829/',
      '/api/v1/translation-projects/915/',
      '/api/v1/translation-projects/1012/',
      '/api/v1/translation-projects/1107/',
      '/api/v1/translation-projects/1189/',
      '/api/v1/translation-projects/1255/',
      '/api/v1/translation-projects/1262/'
    ]
  },
  {
    'code' => 'fr-CA',
    'description' => '',
    'fullname' => 'French (Canada)',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/153/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/1072/'
    ]
  },
  {
    'code' => 'fur',
    'description' => '',
    'fullname' => 'Friulian',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/77/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'fy',
    'description' => '',
    'fullname' => 'Frisian',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/108/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'ga',
    'description' => '',
    'fullname' => 'Irish',
    'nplurals' => 3,
    'pluralequation' => 'n==1 ? 0 : n==2 ? 1 : 2',
    'resource_uri' => '/api/v1/languages/17/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/307/'
    ]
  },
  {
    'code' => 'gl',
    'description' => '',
    'fullname' => 'Galician',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/18/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/308/',
      '/api/v1/translation-projects/461/',
      '/api/v1/translation-projects/478/',
      '/api/v1/translation-projects/494/',
      '/api/v1/translation-projects/532/',
      '/api/v1/translation-projects/626/',
      '/api/v1/translation-projects/714/',
      '/api/v1/translation-projects/845/',
      '/api/v1/translation-projects/916/',
      '/api/v1/translation-projects/1013/',
      '/api/v1/translation-projects/1108/',
      '/api/v1/translation-projects/1190/'
    ]
  },
  {
    'code' => 'gu',
    'description' => '',
    'fullname' => 'Gujarati',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/15/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'gun',
    'description' => '',
    'fullname' => 'Gun',
    'nplurals' => 2,
    'pluralequation' => '(n > 1)',
    'resource_uri' => '/api/v1/languages/37/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'ha',
    'description' => '',
    'fullname' => 'Hausa',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/74/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'he',
    'description' => '',
    'fullname' => 'Hebrew',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/75/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/463/',
      '/api/v1/translation-projects/479/',
      '/api/v1/translation-projects/495/',
      '/api/v1/translation-projects/533/',
      '/api/v1/translation-projects/627/',
      '/api/v1/translation-projects/767/',
      '/api/v1/translation-projects/846/',
      '/api/v1/translation-projects/917/',
      '/api/v1/translation-projects/1014/',
      '/api/v1/translation-projects/1109/',
      '/api/v1/translation-projects/1191/'
    ]
  },
  {
    'code' => 'hi',
    'description' => '',
    'fullname' => 'Hindi',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/73/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/96/',
      '/api/v1/translation-projects/48/',
      '/api/v1/translation-projects/145/',
      '/api/v1/translation-projects/190/',
      '/api/v1/translation-projects/261/',
      '/api/v1/translation-projects/309/',
      '/api/v1/translation-projects/417/',
      '/api/v1/translation-projects/534/',
      '/api/v1/translation-projects/628/',
      '/api/v1/translation-projects/771/',
      '/api/v1/translation-projects/847/',
      '/api/v1/translation-projects/918/',
      '/api/v1/translation-projects/1015/',
      '/api/v1/translation-projects/1081/',
      '/api/v1/translation-projects/1110/',
      '/api/v1/translation-projects/1192/'
    ]
  },
  {
    'code' => 'hr',
    'description' => '',
    'fullname' => 'Croatian',
    'nplurals' => 3,
    'pluralequation' => '(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)',
    'resource_uri' => '/api/v1/languages/71/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/49/',
      '/api/v1/translation-projects/97/',
      '/api/v1/translation-projects/140/',
      '/api/v1/translation-projects/186/',
      '/api/v1/translation-projects/234/',
      '/api/v1/translation-projects/418/',
      '/api/v1/translation-projects/535/',
      '/api/v1/translation-projects/629/',
      '/api/v1/translation-projects/775/',
      '/api/v1/translation-projects/848/',
      '/api/v1/translation-projects/919/',
      '/api/v1/translation-projects/1016/',
      '/api/v1/translation-projects/1111/',
      '/api/v1/translation-projects/1193/'
    ]
  },
  {
    'code' => 'ht',
    'description' => '',
    'fullname' => 'Haitian; Haitian Creole',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/5/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'hu',
    'description' => '',
    'fullname' => 'Hungarian',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/72/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/98/',
      '/api/v1/translation-projects/50/',
      '/api/v1/translation-projects/146/',
      '/api/v1/translation-projects/191/',
      '/api/v1/translation-projects/260/',
      '/api/v1/translation-projects/310/',
      '/api/v1/translation-projects/419/',
      '/api/v1/translation-projects/536/',
      '/api/v1/translation-projects/630/',
      '/api/v1/translation-projects/772/',
      '/api/v1/translation-projects/849/',
      '/api/v1/translation-projects/920/',
      '/api/v1/translation-projects/1017/',
      '/api/v1/translation-projects/1112/',
      '/api/v1/translation-projects/1194/'
    ]
  },
  {
    'code' => 'hy',
    'description' => '',
    'fullname' => 'Armenian',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/70/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/278/',
      '/api/v1/translation-projects/125/',
      '/api/v1/translation-projects/133/',
      '/api/v1/translation-projects/178/',
      '/api/v1/translation-projects/229/',
      '/api/v1/translation-projects/420/',
      '/api/v1/translation-projects/509/',
      '/api/v1/translation-projects/537/',
      '/api/v1/translation-projects/631/',
      '/api/v1/translation-projects/784/',
      '/api/v1/translation-projects/818/',
      '/api/v1/translation-projects/921/',
      '/api/v1/translation-projects/1018/',
      '/api/v1/translation-projects/1113/',
      '/api/v1/translation-projects/1195/'
    ]
  },
  {
    'code' => 'ia',
    'description' => '',
    'fullname' => 'Interlingua',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/94/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/968/',
      '/api/v1/translation-projects/1019/',
      '/api/v1/translation-projects/1114/',
      '/api/v1/translation-projects/1196/'
    ]
  },
  {
    'code' => 'id',
    'description' => '',
    'fullname' => 'Indonesian',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/96/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/279/',
      '/api/v1/translation-projects/126/',
      '/api/v1/translation-projects/147/',
      '/api/v1/translation-projects/192/',
      '/api/v1/translation-projects/239/',
      '/api/v1/translation-projects/421/',
      '/api/v1/translation-projects/538/',
      '/api/v1/translation-projects/632/',
      '/api/v1/translation-projects/777/',
      '/api/v1/translation-projects/850/',
      '/api/v1/translation-projects/922/',
      '/api/v1/translation-projects/1020/',
      '/api/v1/translation-projects/1115/',
      '/api/v1/translation-projects/1197/'
    ]
  },
  {
    'code' => 'iq',
    'description' => '',
    'fullname' => 'Inuinnaqtun',
    'nplurals' => 0,
    'pluralequation' => '',
    'resource_uri' => '/api/v1/languages/150/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/986/',
      '/api/v1/translation-projects/1021/',
      '/api/v1/translation-projects/1116/',
      '/api/v1/translation-projects/1198/'
    ]
  },
  {
    'code' => 'is',
    'description' => '',
    'fullname' => 'Icelandic',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/68/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/80/',
      '/api/v1/translation-projects/311/',
      '/api/v1/translation-projects/99/',
      '/api/v1/translation-projects/148/',
      '/api/v1/translation-projects/193/',
      '/api/v1/translation-projects/259/',
      '/api/v1/translation-projects/422/',
      '/api/v1/translation-projects/539/',
      '/api/v1/translation-projects/633/',
      '/api/v1/translation-projects/721/',
      '/api/v1/translation-projects/851/',
      '/api/v1/translation-projects/923/',
      '/api/v1/translation-projects/1022/',
      '/api/v1/translation-projects/1117/',
      '/api/v1/translation-projects/1199/'
    ]
  },
  {
    'code' => 'it',
    'description' => '',
    'fullname' => 'Italian',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/89/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/312/',
      '/api/v1/translation-projects/100/',
      '/api/v1/translation-projects/149/',
      '/api/v1/translation-projects/194/',
      '/api/v1/translation-projects/51/',
      '/api/v1/translation-projects/240/',
      '/api/v1/translation-projects/455/',
      '/api/v1/translation-projects/603/',
      '/api/v1/translation-projects/540/',
      '/api/v1/translation-projects/634/',
      '/api/v1/translation-projects/769/',
      '/api/v1/translation-projects/787/',
      '/api/v1/translation-projects/795/',
      '/api/v1/translation-projects/809/',
      '/api/v1/translation-projects/820/',
      '/api/v1/translation-projects/924/',
      '/api/v1/translation-projects/974/',
      '/api/v1/translation-projects/982/',
      '/api/v1/translation-projects/1023/',
      '/api/v1/translation-projects/1078/',
      '/api/v1/translation-projects/1118/',
      '/api/v1/translation-projects/1200/',
      '/api/v1/translation-projects/1251/',
      '/api/v1/translation-projects/1263/'
    ]
  },
  {
    'code' => 'iu',
    'description' => '',
    'fullname' => 'Inuktitut',
    'nplurals' => 0,
    'pluralequation' => '',
    'resource_uri' => '/api/v1/languages/149/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/987/',
      '/api/v1/translation-projects/1024/',
      '/api/v1/translation-projects/1119/',
      '/api/v1/translation-projects/1201/'
    ]
  },
  {
    'code' => 'ja',
    'description' => '',
    'fullname' => 'Japanese',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/58/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/52/',
      '/api/v1/translation-projects/313/',
      '/api/v1/translation-projects/101/',
      '/api/v1/translation-projects/150/',
      '/api/v1/translation-projects/195/',
      '/api/v1/translation-projects/241/',
      '/api/v1/translation-projects/424/',
      '/api/v1/translation-projects/541/',
      '/api/v1/translation-projects/635/',
      '/api/v1/translation-projects/723/',
      '/api/v1/translation-projects/852/',
      '/api/v1/translation-projects/925/',
      '/api/v1/translation-projects/1025/',
      '/api/v1/translation-projects/1120/',
      '/api/v1/translation-projects/1202/'
    ]
  },
  {
    'code' => 'jv',
    'description' => '',
    'fullname' => 'Javanese',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/54/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'ka',
    'description' => '',
    'fullname' => 'Georgian',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/113/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/814/',
      '/api/v1/translation-projects/853/',
      '/api/v1/translation-projects/926/',
      '/api/v1/translation-projects/1026/',
      '/api/v1/translation-projects/1121/',
      '/api/v1/translation-projects/1203/'
    ]
  },
  {
    'code' => 'kk',
    'description' => '',
    'fullname' => 'Kazakh',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/114/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'km',
    'description' => '',
    'fullname' => 'Khmer',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/145/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/684/',
      '/api/v1/translation-projects/687/',
      '/api/v1/translation-projects/685/',
      '/api/v1/translation-projects/686/',
      '/api/v1/translation-projects/724/',
      '/api/v1/translation-projects/854/',
      '/api/v1/translation-projects/927/',
      '/api/v1/translation-projects/1027/',
      '/api/v1/translation-projects/1122/',
      '/api/v1/translation-projects/1204/'
    ]
  },
  {
    'code' => 'kn',
    'description' => '',
    'fullname' => 'Kannada',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/118/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/315/',
      '/api/v1/translation-projects/496/',
      '/api/v1/translation-projects/480/',
      '/api/v1/translation-projects/469/',
      '/api/v1/translation-projects/580/',
      '/api/v1/translation-projects/636/',
      '/api/v1/translation-projects/725/',
      '/api/v1/translation-projects/855/',
      '/api/v1/translation-projects/928/',
      '/api/v1/translation-projects/1028/',
      '/api/v1/translation-projects/1123/',
      '/api/v1/translation-projects/1205/'
    ]
  },
  {
    'code' => 'ko',
    'description' => '',
    'fullname' => 'Korean',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/117/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/316/',
      '/api/v1/translation-projects/497/',
      '/api/v1/translation-projects/481/',
      '/api/v1/translation-projects/464/',
      '/api/v1/translation-projects/543/',
      '/api/v1/translation-projects/637/',
      '/api/v1/translation-projects/763/',
      '/api/v1/translation-projects/856/',
      '/api/v1/translation-projects/929/',
      '/api/v1/translation-projects/1029/',
      '/api/v1/translation-projects/1124/',
      '/api/v1/translation-projects/1206/'
    ]
  },
  {
    'code' => 'ku',
    'description' => '',
    'fullname' => 'Kurdish',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/124/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/317/',
      '/api/v1/translation-projects/498/',
      '/api/v1/translation-projects/486/',
      '/api/v1/translation-projects/489/',
      '/api/v1/translation-projects/804/',
      '/api/v1/translation-projects/638/',
      '/api/v1/translation-projects/727/',
      '/api/v1/translation-projects/857/',
      '/api/v1/translation-projects/930/',
      '/api/v1/translation-projects/1030/',
      '/api/v1/translation-projects/1125/',
      '/api/v1/translation-projects/1207/'
    ]
  },
  {
    'code' => 'ku_SOR',
    'description' => '',
    'fullname' => 'Kurdish Sorani',
    'nplurals' => 0,
    'pluralequation' => '',
    'resource_uri' => '/api/v1/languages/138/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'kw',
    'description' => '',
    'fullname' => 'Cornish',
    'nplurals' => 4,
    'pluralequation' => '(n==1) ? 0 : (n==2) ? 1 : (n == 3) ? 2 : 3',
    'resource_uri' => '/api/v1/languages/123/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'ky',
    'description' => '',
    'fullname' => 'Kirghiz; Kyrgyz',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/126/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'lb',
    'description' => '',
    'fullname' => 'Luxembourgish; Letzeburgesch',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/19/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'ln',
    'description' => '',
    'fullname' => 'Lingala',
    'nplurals' => 2,
    'pluralequation' => '(n > 1)',
    'resource_uri' => '/api/v1/languages/20/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/319/'
    ]
  },
  {
    'code' => 'lo',
    'description' => '',
    'fullname' => 'Lao',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/21/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/170/',
      '/api/v1/translation-projects/196/',
      '/api/v1/translation-projects/242/',
      '/api/v1/translation-projects/283/',
      '/api/v1/translation-projects/425/',
      '/api/v1/translation-projects/545/',
      '/api/v1/translation-projects/639/',
      '/api/v1/translation-projects/728/',
      '/api/v1/translation-projects/858/',
      '/api/v1/translation-projects/931/',
      '/api/v1/translation-projects/1031/',
      '/api/v1/translation-projects/1126/',
      '/api/v1/translation-projects/1208/'
    ]
  },
  {
    'code' => 'lv',
    'description' => '',
    'fullname' => 'Latvian',
    'nplurals' => 3,
    'pluralequation' => '(n%10==1 && n%100!=11 ? 0 : n != 0 ? 1 : 2)',
    'resource_uri' => '/api/v1/languages/24/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'mg',
    'description' => '',
    'fullname' => 'Malagasy',
    'nplurals' => 2,
    'pluralequation' => '(n > 1)',
    'resource_uri' => '/api/v1/languages/76/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'mi',
    'description' => '',
    'fullname' => 'Maori',
    'nplurals' => 2,
    'pluralequation' => '(n > 1)',
    'resource_uri' => '/api/v1/languages/80/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/102/',
      '/api/v1/translation-projects/53/',
      '/api/v1/translation-projects/152/',
      '/api/v1/translation-projects/198/',
      '/api/v1/translation-projects/256/',
      '/api/v1/translation-projects/426/',
      '/api/v1/translation-projects/546/',
      '/api/v1/translation-projects/640/',
      '/api/v1/translation-projects/729/',
      '/api/v1/translation-projects/859/',
      '/api/v1/translation-projects/932/',
      '/api/v1/translation-projects/1032/',
      '/api/v1/translation-projects/1127/',
      '/api/v1/translation-projects/1209/'
    ]
  },
  {
    'code' => 'mk',
    'description' => '',
    'fullname' => 'Macedonian',
    'nplurals' => 2,
    'pluralequation' => 'n==1 || n%10==1 ? 0 : 1',
    'resource_uri' => '/api/v1/languages/81/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/321/'
    ]
  },
  {
    'code' => 'ml',
    'description' => '',
    'fullname' => 'Malayalam',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/78/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/892/',
      '/api/v1/translation-projects/933/',
      '/api/v1/translation-projects/1033/',
      '/api/v1/translation-projects/1128/',
      '/api/v1/translation-projects/1210/'
    ]
  },
  {
    'code' => 'mn',
    'description' => '',
    'fullname' => 'Mongolian',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/79/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/103/',
      '/api/v1/translation-projects/54/',
      '/api/v1/translation-projects/153/',
      '/api/v1/translation-projects/200/',
      '/api/v1/translation-projects/257/',
      '/api/v1/translation-projects/427/',
      '/api/v1/translation-projects/547/',
      '/api/v1/translation-projects/641/',
      '/api/v1/translation-projects/730/',
      '/api/v1/translation-projects/860/',
      '/api/v1/translation-projects/934/',
      '/api/v1/translation-projects/1034/',
      '/api/v1/translation-projects/1129/',
      '/api/v1/translation-projects/1211/'
    ]
  },
  {
    'code' => 'mr',
    'description' => '',
    'fullname' => 'Marathi',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/85/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/322/',
      '/api/v1/translation-projects/284/',
      '/api/v1/translation-projects/171/',
      '/api/v1/translation-projects/199/',
      '/api/v1/translation-projects/258/',
      '/api/v1/translation-projects/428/',
      '/api/v1/translation-projects/548/',
      '/api/v1/translation-projects/642/',
      '/api/v1/translation-projects/774/',
      '/api/v1/translation-projects/861/',
      '/api/v1/translation-projects/935/',
      '/api/v1/translation-projects/1035/',
      '/api/v1/translation-projects/1130/',
      '/api/v1/translation-projects/1212/'
    ]
  },
  {
    'code' => 'ms',
    'description' => '',
    'fullname' => 'Malay',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/84/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/280/',
      '/api/v1/translation-projects/323/',
      '/api/v1/translation-projects/123/',
      '/api/v1/translation-projects/151/',
      '/api/v1/translation-projects/197/',
      '/api/v1/translation-projects/275/',
      '/api/v1/translation-projects/429/',
      '/api/v1/translation-projects/579/',
      '/api/v1/translation-projects/643/',
      '/api/v1/translation-projects/779/',
      '/api/v1/translation-projects/862/',
      '/api/v1/translation-projects/936/',
      '/api/v1/translation-projects/1036/',
      '/api/v1/translation-projects/1131/',
      '/api/v1/translation-projects/1213/'
    ]
  },
  {
    'code' => 'mt',
    'description' => '',
    'fullname' => 'Maltese',
    'nplurals' => 4,
    'pluralequation' => '(n==1 ? 0 : n==0 || ( n%100>1 && n%100<11) ? 1 : (n%100>10 && n%100<20 ) ? 2 : 3)',
    'resource_uri' => '/api/v1/languages/82/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'my',
    'description' => '',
    'fullname' => 'Myanmar',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/151/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/1070/',
      '/api/v1/translation-projects/1069/',
      '/api/v1/translation-projects/1068/',
      '/api/v1/translation-projects/1132/',
      '/api/v1/translation-projects/1214/'
    ]
  },
  {
    'code' => 'nah',
    'description' => '',
    'fullname' => 'Nahuatl languages',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/101/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'nap',
    'description' => '',
    'fullname' => 'Neapolitan',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/104/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'nb',
    'description' => '',
    'fullname' => "Bokm\x{e5}l, Norwegian; Norwegian Bokm\x{e5}l",
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/127/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/104/',
      '/api/v1/translation-projects/55/',
      '/api/v1/translation-projects/156/',
      '/api/v1/translation-projects/203/',
      '/api/v1/translation-projects/265/',
      '/api/v1/translation-projects/324/',
      '/api/v1/translation-projects/430/',
      '/api/v1/translation-projects/550/',
      '/api/v1/translation-projects/644/',
      '/api/v1/translation-projects/766/',
      '/api/v1/translation-projects/830/',
      '/api/v1/translation-projects/937/',
      '/api/v1/translation-projects/1037/',
      '/api/v1/translation-projects/1133/',
      '/api/v1/translation-projects/1215/'
    ]
  },
  {
    'code' => 'ne',
    'description' => '',
    'fullname' => 'Nepali',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/102/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/499/',
      '/api/v1/translation-projects/482/',
      '/api/v1/translation-projects/467/',
      '/api/v1/translation-projects/582/',
      '/api/v1/translation-projects/645/',
      '/api/v1/translation-projects/734/',
      '/api/v1/translation-projects/863/',
      '/api/v1/translation-projects/938/',
      '/api/v1/translation-projects/1038/',
      '/api/v1/translation-projects/1134/',
      '/api/v1/translation-projects/1216/'
    ]
  },
  {
    'code' => 'nl',
    'description' => '',
    'fullname' => "Nederlands-Belgi\x{eb} (Dutch-Belgium)",
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/99/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/56/',
      '/api/v1/translation-projects/325/',
      '/api/v1/translation-projects/105/',
      '/api/v1/translation-projects/154/',
      '/api/v1/translation-projects/201/',
      '/api/v1/translation-projects/227/',
      '/api/v1/translation-projects/431/',
      '/api/v1/translation-projects/552/',
      '/api/v1/translation-projects/646/',
      '/api/v1/translation-projects/785/',
      '/api/v1/translation-projects/864/',
      '/api/v1/translation-projects/939/',
      '/api/v1/translation-projects/1039/',
      '/api/v1/translation-projects/1135/',
      '/api/v1/translation-projects/1217/'
    ]
  },
  {
    'code' => 'nl_NL',
    'description' => '',
    'fullname' => 'Nederlands-Nederland (Dutch-The Netherlands)',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/132/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/75/',
      '/api/v1/translation-projects/106/',
      '/api/v1/translation-projects/155/',
      '/api/v1/translation-projects/202/',
      '/api/v1/translation-projects/226/',
      '/api/v1/translation-projects/432/',
      '/api/v1/translation-projects/553/',
      '/api/v1/translation-projects/647/',
      '/api/v1/translation-projects/736/',
      '/api/v1/translation-projects/865/',
      '/api/v1/translation-projects/940/',
      '/api/v1/translation-projects/1040/',
      '/api/v1/translation-projects/1136/',
      '/api/v1/translation-projects/1218/'
    ]
  },
  {
    'code' => 'nn',
    'description' => '',
    'fullname' => 'Norwegian Nynorsk; Nynorsk, Norwegian',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/100/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/57/',
      '/api/v1/translation-projects/326/',
      '/api/v1/translation-projects/107/',
      '/api/v1/translation-projects/157/',
      '/api/v1/translation-projects/204/',
      '/api/v1/translation-projects/266/',
      '/api/v1/translation-projects/433/',
      '/api/v1/translation-projects/554/',
      '/api/v1/translation-projects/648/',
      '/api/v1/translation-projects/768/',
      '/api/v1/translation-projects/866/',
      '/api/v1/translation-projects/941/',
      '/api/v1/translation-projects/1041/',
      '/api/v1/translation-projects/1137/',
      '/api/v1/translation-projects/1219/'
    ]
  },
  {
    'code' => 'nso',
    'description' => '',
    'fullname' => 'Pedi; Sepedi; Northern Sotho',
    'nplurals' => 2,
    'pluralequation' => '(n > 1)',
    'resource_uri' => '/api/v1/languages/6/',
    'specialchars' => "\x{161}\x{160}",
    'translation_projects' => [
      '/api/v1/translation-projects/327/'
    ]
  },
  {
    'code' => 'oc',
    'description' => '',
    'fullname' => 'Occitan',
    'nplurals' => 2,
    'pluralequation' => '(n > 1)',
    'resource_uri' => '/api/v1/languages/59/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/891/',
      '/api/v1/translation-projects/890/',
      '/api/v1/translation-projects/942/',
      '/api/v1/translation-projects/1042/',
      '/api/v1/translation-projects/1138/',
      '/api/v1/translation-projects/1220/'
    ]
  },
  {
    'code' => 'pap',
    'description' => '',
    'fullname' => 'Papiamento',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/98/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/330/'
    ]
  },
  {
    'code' => 'pbr',
    'description' => '',
    'fullname' => 'Pangwa',
    'nplurals' => 0,
    'pluralequation' => '',
    'resource_uri' => '/api/v1/languages/139/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/500/',
      '/api/v1/translation-projects/483/',
      '/api/v1/translation-projects/470/',
      '/api/v1/translation-projects/555/',
      '/api/v1/translation-projects/649/',
      '/api/v1/translation-projects/738/',
      '/api/v1/translation-projects/867/',
      '/api/v1/translation-projects/943/',
      '/api/v1/translation-projects/1043/',
      '/api/v1/translation-projects/1139/',
      '/api/v1/translation-projects/1221/'
    ]
  },
  {
    'code' => 'pl',
    'description' => '',
    'fullname' => 'Polish',
    'nplurals' => 3,
    'pluralequation' => '(n==1 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)',
    'resource_uri' => '/api/v1/languages/83/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/58/',
      '/api/v1/translation-projects/108/',
      '/api/v1/translation-projects/159/',
      '/api/v1/translation-projects/206/',
      '/api/v1/translation-projects/245/',
      '/api/v1/translation-projects/331/',
      '/api/v1/translation-projects/434/',
      '/api/v1/translation-projects/556/',
      '/api/v1/translation-projects/589/',
      '/api/v1/translation-projects/650/',
      '/api/v1/translation-projects/739/',
      '/api/v1/translation-projects/868/',
      '/api/v1/translation-projects/944/',
      '/api/v1/translation-projects/1044/',
      '/api/v1/translation-projects/1140/',
      '/api/v1/translation-projects/1222/'
    ]
  },
  {
    'code' => 'pms',
    'description' => '',
    'fullname' => 'Piemontese',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/41/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'prs',
    'description' => '',
    'fullname' => 'Dari (Persian dialect)',
    'nplurals' => 0,
    'pluralequation' => '',
    'resource_uri' => '/api/v1/languages/140/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/501/',
      '/api/v1/translation-projects/487/',
      '/api/v1/translation-projects/471/',
      '/api/v1/translation-projects/557/',
      '/api/v1/translation-projects/651/',
      '/api/v1/translation-projects/740/',
      '/api/v1/translation-projects/869/',
      '/api/v1/translation-projects/945/',
      '/api/v1/translation-projects/1045/',
      '/api/v1/translation-projects/1141/',
      '/api/v1/translation-projects/1223/'
    ]
  },
  {
    'code' => 'ps',
    'description' => '',
    'fullname' => 'Pushto; Pashto',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/64/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'pt',
    'description' => '',
    'fullname' => 'Portuguese',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/65/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/59/',
      '/api/v1/translation-projects/332/',
      '/api/v1/translation-projects/109/',
      '/api/v1/translation-projects/160/',
      '/api/v1/translation-projects/207/',
      '/api/v1/translation-projects/244/',
      '/api/v1/translation-projects/435/',
      '/api/v1/translation-projects/558/',
      '/api/v1/translation-projects/652/',
      '/api/v1/translation-projects/741/',
      '/api/v1/translation-projects/825/',
      '/api/v1/translation-projects/946/',
      '/api/v1/translation-projects/1046/',
      '/api/v1/translation-projects/1142/',
      '/api/v1/translation-projects/1224/'
    ]
  },
  {
    'code' => 'pt_BR',
    'description' => '',
    'fullname' => 'Portuguese (Brazil)',
    'nplurals' => 2,
    'pluralequation' => '(n > 1)',
    'resource_uri' => '/api/v1/languages/33/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/60/',
      '/api/v1/translation-projects/110/',
      '/api/v1/translation-projects/161/',
      '/api/v1/translation-projects/208/',
      '/api/v1/translation-projects/254/',
      '/api/v1/translation-projects/333/',
      '/api/v1/translation-projects/436/',
      '/api/v1/translation-projects/559/',
      '/api/v1/translation-projects/597/',
      '/api/v1/translation-projects/653/',
      '/api/v1/translation-projects/742/',
      '/api/v1/translation-projects/870/',
      '/api/v1/translation-projects/947/',
      '/api/v1/translation-projects/1047/',
      '/api/v1/translation-projects/1143/',
      '/api/v1/translation-projects/1225/',
      '/api/v1/translation-projects/1256/',
      '/api/v1/translation-projects/1264/'
    ]
  },
  {
    'code' => 'pt-BR',
    'description' => '',
    'fullname' => 'Portuguese (Brazil)',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/148/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/1082/',
      '/api/v1/translation-projects/889/',
      '/api/v1/translation-projects/975/',
      '/api/v1/translation-projects/983/',
      '/api/v1/translation-projects/1079/'
    ]
  },
  {
    'code' => 'rm',
    'description' => '',
    'fullname' => 'Romansh',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/46/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'ro',
    'description' => '',
    'fullname' => 'Romanian',
    'nplurals' => 3,
    'pluralequation' => '(n==1 ? 0 : (n==0 || (n%100 > 0 && n%100 < 20)) ? 1 : 2);',
    'resource_uri' => '/api/v1/languages/47/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/61/',
      '/api/v1/translation-projects/111/',
      '/api/v1/translation-projects/162/',
      '/api/v1/translation-projects/209/',
      '/api/v1/translation-projects/253/',
      '/api/v1/translation-projects/437/',
      '/api/v1/translation-projects/560/',
      '/api/v1/translation-projects/654/',
      '/api/v1/translation-projects/743/',
      '/api/v1/translation-projects/871/',
      '/api/v1/translation-projects/948/',
      '/api/v1/translation-projects/1048/',
      '/api/v1/translation-projects/1144/',
      '/api/v1/translation-projects/1226/'
    ]
  },
  {
    'code' => 'ru',
    'description' => '',
    'fullname' => 'Russian',
    'nplurals' => 3,
    'pluralequation' => '(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)',
    'resource_uri' => '/api/v1/languages/45/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/62/',
      '/api/v1/translation-projects/69/',
      '/api/v1/translation-projects/112/',
      '/api/v1/translation-projects/163/',
      '/api/v1/translation-projects/210/',
      '/api/v1/translation-projects/243/',
      '/api/v1/translation-projects/438/',
      '/api/v1/translation-projects/561/',
      '/api/v1/translation-projects/655/',
      '/api/v1/translation-projects/744/',
      '/api/v1/translation-projects/872/',
      '/api/v1/translation-projects/949/',
      '/api/v1/translation-projects/1049/',
      '/api/v1/translation-projects/1145/',
      '/api/v1/translation-projects/1227/'
    ]
  },
  {
    'code' => 'rw',
    'description' => '',
    'fullname' => 'Kinyarwanda ',
    'nplurals' => 0,
    'pluralequation' => '',
    'resource_uri' => '/api/v1/languages/144/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/600/',
      '/api/v1/translation-projects/681/',
      '/api/v1/translation-projects/690/',
      '/api/v1/translation-projects/677/',
      '/api/v1/translation-projects/601/',
      '/api/v1/translation-projects/656/',
      '/api/v1/translation-projects/745/',
      '/api/v1/translation-projects/873/',
      '/api/v1/translation-projects/950/',
      '/api/v1/translation-projects/1050/',
      '/api/v1/translation-projects/1146/',
      '/api/v1/translation-projects/1228/'
    ]
  },
  {
    'code' => 'sco',
    'description' => '',
    'fullname' => 'Scots',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/16/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'sd',
    'description' => '',
    'fullname' => 'Sindhi',
    'nplurals' => 6,
    'pluralequation' => 'n==0 ? 0 : n==1 ? 1 : n==2 ? 2 : n%100>=3 && n%100<=10 ? 3 : n%100>=11 ? 4 : 5',
    'resource_uri' => '/api/v1/languages/133/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/79/',
      '/api/v1/translation-projects/113/',
      '/api/v1/translation-projects/164/',
      '/api/v1/translation-projects/211/',
      '/api/v1/translation-projects/252/',
      '/api/v1/translation-projects/439/',
      '/api/v1/translation-projects/562/',
      '/api/v1/translation-projects/657/',
      '/api/v1/translation-projects/746/',
      '/api/v1/translation-projects/874/',
      '/api/v1/translation-projects/951/',
      '/api/v1/translation-projects/1051/',
      '/api/v1/translation-projects/1147/',
      '/api/v1/translation-projects/1229/'
    ]
  },
  {
    'code' => 'si',
    'description' => '',
    'fullname' => 'Sinhala; Sinhalese',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/122/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/83/'
    ]
  },
  {
    'code' => 'sk',
    'description' => '',
    'fullname' => 'Slovak',
    'nplurals' => 3,
    'pluralequation' => '(n==1) ? 0 : (n>=2 && n<=4) ? 1 : 2',
    'resource_uri' => '/api/v1/languages/121/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/334/',
      '/api/v1/translation-projects/267/',
      '/api/v1/translation-projects/268/',
      '/api/v1/translation-projects/269/',
      '/api/v1/translation-projects/440/',
      '/api/v1/translation-projects/563/',
      '/api/v1/translation-projects/658/',
      '/api/v1/translation-projects/747/',
      '/api/v1/translation-projects/821/',
      '/api/v1/translation-projects/952/',
      '/api/v1/translation-projects/1052/',
      '/api/v1/translation-projects/1148/',
      '/api/v1/translation-projects/1230/'
    ]
  },
  {
    'code' => 'sl',
    'description' => '',
    'fullname' => 'Slovenian',
    'nplurals' => 4,
    'pluralequation' => '(n%100==1 ? 0 : n%100==2 ? 1 : n%100==3 || n%100==4 ? 2 : 3)',
    'resource_uri' => '/api/v1/languages/125/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/503/',
      '/api/v1/translation-projects/484/',
      '/api/v1/translation-projects/466/',
      '/api/v1/translation-projects/564/',
      '/api/v1/translation-projects/659/',
      '/api/v1/translation-projects/776/',
      '/api/v1/translation-projects/875/',
      '/api/v1/translation-projects/953/',
      '/api/v1/translation-projects/1053/',
      '/api/v1/translation-projects/1149/',
      '/api/v1/translation-projects/1231/'
    ]
  },
  {
    'code' => 'so',
    'description' => '',
    'fullname' => 'Somali',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/106/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'sq',
    'description' => '',
    'fullname' => 'Albanian',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/116/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/336/',
      '/api/v1/translation-projects/602/',
      '/api/v1/translation-projects/502/',
      '/api/v1/translation-projects/488/',
      '/api/v1/translation-projects/465/',
      '/api/v1/translation-projects/565/',
      '/api/v1/translation-projects/660/',
      '/api/v1/translation-projects/770/',
      '/api/v1/translation-projects/876/',
      '/api/v1/translation-projects/954/',
      '/api/v1/translation-projects/1054/',
      '/api/v1/translation-projects/1150/',
      '/api/v1/translation-projects/1232/'
    ]
  },
  {
    'code' => 'sr',
    'description' => '',
    'fullname' => 'Serbian',
    'nplurals' => 3,
    'pluralequation' => '(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)',
    'resource_uri' => '/api/v1/languages/115/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/462/',
      '/api/v1/translation-projects/485/',
      '/api/v1/translation-projects/504/',
      '/api/v1/translation-projects/566/',
      '/api/v1/translation-projects/661/',
      '/api/v1/translation-projects/781/',
      '/api/v1/translation-projects/877/',
      '/api/v1/translation-projects/955/',
      '/api/v1/translation-projects/1055/',
      '/api/v1/translation-projects/1151/',
      '/api/v1/translation-projects/1233/'
    ]
  },
  {
    'code' => 'st',
    'description' => '',
    'fullname' => 'Sotho, Southern',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/120/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'su',
    'description' => '',
    'fullname' => 'Sundanese',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/92/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'sv',
    'description' => '',
    'fullname' => 'Swedish',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/109/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/63/',
      '/api/v1/translation-projects/337/',
      '/api/v1/translation-projects/114/',
      '/api/v1/translation-projects/165/',
      '/api/v1/translation-projects/212/',
      '/api/v1/translation-projects/251/',
      '/api/v1/translation-projects/441/',
      '/api/v1/translation-projects/567/',
      '/api/v1/translation-projects/662/',
      '/api/v1/translation-projects/764/',
      '/api/v1/translation-projects/878/',
      '/api/v1/translation-projects/956/',
      '/api/v1/translation-projects/1056/',
      '/api/v1/translation-projects/1152/',
      '/api/v1/translation-projects/1234/'
    ]
  },
  {
    'code' => 'sw',
    'description' => '',
    'fullname' => 'Swahili',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/143/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/593/',
      '/api/v1/translation-projects/682/',
      '/api/v1/translation-projects/691/',
      '/api/v1/translation-projects/678/',
      '/api/v1/translation-projects/594/',
      '/api/v1/translation-projects/674/',
      '/api/v1/translation-projects/752/',
      '/api/v1/translation-projects/879/',
      '/api/v1/translation-projects/957/',
      '/api/v1/translation-projects/1057/',
      '/api/v1/translation-projects/1153/',
      '/api/v1/translation-projects/1235/'
    ]
  },
  {
    'code' => 'ta',
    'description' => '',
    'fullname' => 'Tamil',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/32/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/271/',
      '/api/v1/translation-projects/289/',
      '/api/v1/translation-projects/442/',
      '/api/v1/translation-projects/568/',
      '/api/v1/translation-projects/664/',
      '/api/v1/translation-projects/753/',
      '/api/v1/translation-projects/880/',
      '/api/v1/translation-projects/958/',
      '/api/v1/translation-projects/1058/',
      '/api/v1/translation-projects/1154/',
      '/api/v1/translation-projects/1236/'
    ]
  },
  {
    'code' => 'ta_LK',
    'description' => '',
    'fullname' => 'Tamil (Sri Lanka)',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/135/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/290/',
      '/api/v1/translation-projects/272/',
      '/api/v1/translation-projects/443/',
      '/api/v1/translation-projects/569/',
      '/api/v1/translation-projects/665/',
      '/api/v1/translation-projects/765/',
      '/api/v1/translation-projects/881/',
      '/api/v1/translation-projects/959/',
      '/api/v1/translation-projects/1059/',
      '/api/v1/translation-projects/1155/',
      '/api/v1/translation-projects/1237/'
    ]
  },
  {
    'code' => 'te',
    'description' => '',
    'fullname' => 'Telugu',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/30/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'templates',
    'description' => '',
    'fullname' => 'Templates',
    'nplurals' => 0,
    'pluralequation' => '',
    'resource_uri' => '/api/v1/languages/1/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'tet',
    'description' => '',
    'fullname' => 'Tetun',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/128/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/71/',
      '/api/v1/translation-projects/115/',
      '/api/v1/translation-projects/166/',
      '/api/v1/translation-projects/214/',
      '/api/v1/translation-projects/276/',
      '/api/v1/translation-projects/444/',
      '/api/v1/translation-projects/570/',
      '/api/v1/translation-projects/666/',
      '/api/v1/translation-projects/780/',
      '/api/v1/translation-projects/882/',
      '/api/v1/translation-projects/960/',
      '/api/v1/translation-projects/1060/',
      '/api/v1/translation-projects/1156/',
      '/api/v1/translation-projects/1238/'
    ]
  },
  {
    'code' => 'tg',
    'description' => '',
    'fullname' => 'Tajik',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/29/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'th',
    'description' => '',
    'fullname' => 'Thai',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/27/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/64/',
      '/api/v1/translation-projects/116/',
      '/api/v1/translation-projects/167/',
      '/api/v1/translation-projects/215/',
      '/api/v1/translation-projects/249/',
      '/api/v1/translation-projects/339/',
      '/api/v1/translation-projects/445/',
      '/api/v1/translation-projects/571/',
      '/api/v1/translation-projects/667/',
      '/api/v1/translation-projects/756/',
      '/api/v1/translation-projects/883/',
      '/api/v1/translation-projects/961/',
      '/api/v1/translation-projects/1061/',
      '/api/v1/translation-projects/1157/',
      '/api/v1/translation-projects/1239/'
    ]
  },
  {
    'code' => 'ti',
    'description' => '',
    'fullname' => 'Tigrinya',
    'nplurals' => 2,
    'pluralequation' => '(n > 1)',
    'resource_uri' => '/api/v1/languages/28/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'tk',
    'description' => '',
    'fullname' => 'Turkmen',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/26/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'tl',
    'description' => '',
    'fullname' => 'Tagalog',
    'nplurals' => 2,
    'pluralequation' => '(n > 1)',
    'resource_uri' => '/api/v1/languages/154/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/1246/'
    ]
  },
  {
    'code' => 'tr',
    'description' => '',
    'fullname' => 'Turkish',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/23/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/340/',
      '/api/v1/translation-projects/117/',
      '/api/v1/translation-projects/168/',
      '/api/v1/translation-projects/216/',
      '/api/v1/translation-projects/65/',
      '/api/v1/translation-projects/248/',
      '/api/v1/translation-projects/446/',
      '/api/v1/translation-projects/590/',
      '/api/v1/translation-projects/572/',
      '/api/v1/translation-projects/668/',
      '/api/v1/translation-projects/757/',
      '/api/v1/translation-projects/791/',
      '/api/v1/translation-projects/796/',
      '/api/v1/translation-projects/811/',
      '/api/v1/translation-projects/822/',
      '/api/v1/translation-projects/962/',
      '/api/v1/translation-projects/976/',
      '/api/v1/translation-projects/984/',
      '/api/v1/translation-projects/1062/',
      '/api/v1/translation-projects/1080/',
      '/api/v1/translation-projects/1158/',
      '/api/v1/translation-projects/1240/',
      '/api/v1/translation-projects/1253/',
      '/api/v1/translation-projects/1265/'
    ]
  },
  {
    'code' => 'tt',
    'description' => '',
    'fullname' => 'Tatar',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/22/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'ug',
    'description' => '',
    'fullname' => 'Uighur; Uyghur',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/86/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'uk',
    'description' => "<p>\x{41b}\x{430}\x{441}\x{43a}\x{430}\x{432}\x{43e} \x{43f}\x{440}\x{43e}\x{441}\x{438}\x{43c}\x{43e} \x{434}\x{43e} \x{443}\x{43a}\x{440}\x{430}\x{457}\x{43d}\x{441}\x{44c}\x{43a}\x{43e}\x{433}\x{43e} \x{43f}\x{440}\x{43e}\x{435}\x{43a}\x{442}\x{443} \x{43f}\x{435}\x{440}\x{435}\x{43a}\x{43b}\x{430}\x{434}\x{456}\x{432} Koha.
\x{414}\x{43b}\x{44f} \x{43f}\x{435}\x{440}\x{435}\x{43a}\x{43b}\x{430}\x{434}\x{443} \x{432}\x{438}\x{431}\x{438}\x{440}\x{430}\x{439}\x{442}\x{435} \x{432}\x{435}\x{440}\x{441}\x{456}\x{44e} Koha, \x{43d}\x{430}\x{434} \x{44f}\x{43a}\x{43e}\x{44e} \x{445}\x{43e}\x{447}\x{435}\x{442}\x{435} \x{43f}\x{440}\x{430}\x{446}\x{44e}\x{432}\x{430}\x{442}\x{438}.
\x{412}\x{438} \x{43c}\x{43e}\x{436}\x{435}\x{442}\x{435} \x{43f}\x{440}\x{430}\x{446}\x{44e}\x{432}\x{430}\x{442}\x{438} \x{432} \x{430}\x{43d}\x{43e}\x{43d}\x{456}\x{43c}\x{43d}\x{43e}\x{43c}\x{443} \x{440}\x{435}\x{436}\x{438}\x{43c}\x{456}, \x{449}\x{43e}\x{431} \x{437}\x{430}\x{43f}\x{440}\x{43e}\x{43f}\x{43e}\x{43d}\x{443}\x{432}\x{430}\x{442}\x{438} \x{43f}\x{435}\x{440}\x{435}\x{43a}\x{43b}\x{430}\x{434}\x{438} \x{447}\x{438} \x{432}\x{438}\x{43f}\x{440}\x{430}\x{432}\x{43b}\x{435}\x{43d}\x{43d}\x{44f}, \x{430}\x{431}\x{43e} \x{432}\x{438} \x{43c}\x{43e}\x{436}\x{435}\x{442}\x{435} \x{441}\x{442}\x{432}\x{43e}\x{440}\x{438}\x{442}\x{438} \x{43e}\x{431}\x{43b}\x{456}\x{43a}\x{43e}\x{432}\x{438}\x{439} \x{437}\x{430}\x{43f}\x{438}\x{441} \x{434}\x{43b}\x{44f} \x{43f}\x{440}\x{43e}\x{43f}\x{43e}\x{437}\x{438}\x{446}\x{456}\x{439}, \x{43f}\x{435}\x{440}\x{435}\x{43a}\x{43b}\x{430}\x{434}\x{456}\x{432} \x{447}\x{438} \x{43f}\x{456}\x{434}\x{442}\x{432}\x{435}\x{440}\x{434}\x{436}\x{435}\x{43d}\x{43d}\x{44f} \x{43f}\x{440}\x{43e}\x{43f}\x{43e}\x{437}\x{438}\x{446}\x{456}\x{439}.

\x{420}\x{44f}\x{434}\x{43a}\x{438} \x{441}\x{438}\x{441}\x{442}\x{435}\x{43c}\x{43d}\x{438}\x{445} \x{443}\x{43f}\x{43e}\x{434}\x{43e}\x{431}\x{430}\x{43d}\x{44c} \x{43c}\x{430}\x{44e}\x{442}\x{44c} \x{431}\x{443}\x{442}\x{438} \x{43f}\x{435}\x{440}\x{435}\x{432}\x{435}\x{434}\x{435}\x{43d}\x{456} \x{43e}\x{441}\x{43e}\x{431}\x{43b}\x{438}\x{432}\x{43e}. \x{41d}\x{435}\x{43e}\x{431}\x{445}\x{456}\x{434}\x{43d}\x{43e} \x{43e}\x{43f}\x{443}\x{441}\x{442}\x{438}\x{442}\x{438} \x{43a}\x{43e}\x{43c}\x{435}\x{43d}\x{442}\x{430}\x{440} \x{434}\x{43e} \x{447}\x{430}\x{441}\x{442}\x{438}\x{43d}\x{438} \x{432}\x{438}\x{445}\x{456}\x{434}\x{43d}\x{43e}\x{433}\x{43e} \x{440}\x{44f}\x{434}\x{43a}\x{430} \x{432} \x{43f}\x{435}\x{440}\x{435}\x{43a}\x{43b}\x{430}\x{434}\x{435}\x{43d}\x{43e}\x{43c}\x{443} \x{440}\x{44f}\x{434}\x{43a}\x{443}.

\x{41a}\x{43e}\x{43c}\x{435}\x{43d}\x{442}\x{430}\x{440}\x{456} \x{43f}\x{43e}\x{432}\x{438}\x{43d}\x{43d}\x{456} \x{434}\x{43e}\x{43f}\x{43e}\x{43c}\x{43e}\x{433}\x{442}\x{438} \x{432}\x{438}\x{437}\x{43d}\x{430}\x{447}\x{430}\x{442}\x{438} \x{43a}\x{43e}\x{43d}\x{442}\x{435}\x{43a}\x{441}\x{442} \x{43f}\x{430}\x{440}\x{430}\x{43c}\x{435}\x{442}\x{440}\x{456}\x{432}.

\x{417}\x{430}\x{445}\x{43e}\x{434}\x{44c}\x{442}\x{435} \x{43d}\x{430} \x{432}\x{456}\x{43a}\x{456}-\x{441}\x{430}\x{439}\x{442} \x{443}\x{43a}\x{440}\x{430}\x{457}\x{43d}\x{441}\x{44c}\x{43a}\x{43e}\x{457} \x{441}\x{43f}\x{456}\x{43b}\x{44c}\x{43d}\x{43e}\x{442}\x{438} \x{43a}\x{43e}\x{440}\x{438}\x{441}\x{442}\x{443}\x{432}\x{430}\x{447}\x{456}\x{432} \x{410}\x{411}\x{406}\x{421} Koha: http://koha.org.ua/wiki</p>",
    'fullname' => 'Ukrainian',
    'nplurals' => 3,
    'pluralequation' => '(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)',
    'resource_uri' => '/api/v1/languages/51/',
    'specialchars' => "'\x{2026}\x{2014}\x{2013}\x{201e}\x{201c}\x{a9}\x{ae}\x{2022}\x{2122}",
    'translation_projects' => [
      '/api/v1/translation-projects/66/',
      '/api/v1/translation-projects/70/',
      '/api/v1/translation-projects/118/',
      '/api/v1/translation-projects/169/',
      '/api/v1/translation-projects/217/',
      '/api/v1/translation-projects/246/',
      '/api/v1/translation-projects/447/',
      '/api/v1/translation-projects/573/',
      '/api/v1/translation-projects/669/',
      '/api/v1/translation-projects/758/',
      '/api/v1/translation-projects/885/',
      '/api/v1/translation-projects/963/',
      '/api/v1/translation-projects/1063/',
      '/api/v1/translation-projects/1159/',
      '/api/v1/translation-projects/1241/'
    ]
  },
  {
    'code' => 'ur',
    'description' => '',
    'fullname' => 'Urdu',
    'nplurals' => 6,
    'pluralequation' => 'n==0 ? 0 : n==1 ? 1 : n==2 ? 2 : n%100>=3 && n%100<=10 ? 3 : n%100>=11 ? 4 : 5',
    'resource_uri' => '/api/v1/languages/129/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/72/',
      '/api/v1/translation-projects/119/',
      '/api/v1/translation-projects/158/',
      '/api/v1/translation-projects/205/',
      '/api/v1/translation-projects/255/',
      '/api/v1/translation-projects/341/',
      '/api/v1/translation-projects/448/',
      '/api/v1/translation-projects/574/',
      '/api/v1/translation-projects/670/',
      '/api/v1/translation-projects/773/',
      '/api/v1/translation-projects/886/',
      '/api/v1/translation-projects/964/',
      '/api/v1/translation-projects/1064/',
      '/api/v1/translation-projects/1160/',
      '/api/v1/translation-projects/1242/'
    ]
  },
  {
    'code' => 've',
    'description' => '',
    'fullname' => 'Venda',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/7/',
    'specialchars' => "\x{1e13}\x{1e4b}\x{1e3d}\x{1e71} \x{1e12}\x{1e4a}\x{1e3c}\x{1e70} \x{1e45}\x{1e44}",
    'translation_projects' => []
  },
  {
    'code' => 'vi',
    'description' => '',
    'fullname' => 'Vietnamese',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/67/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/342/',
      '/api/v1/translation-projects/288/',
      '/api/v1/translation-projects/219/',
      '/api/v1/translation-projects/247/',
      '/api/v1/translation-projects/683/',
      '/api/v1/translation-projects/575/',
      '/api/v1/translation-projects/671/',
      '/api/v1/translation-projects/760/',
      '/api/v1/translation-projects/887/',
      '/api/v1/translation-projects/965/',
      '/api/v1/translation-projects/1065/',
      '/api/v1/translation-projects/1161/',
      '/api/v1/translation-projects/1243/'
    ]
  },
  {
    'code' => 'wa',
    'description' => '',
    'fullname' => 'Walloon',
    'nplurals' => 2,
    'pluralequation' => '(n > 1)',
    'resource_uri' => '/api/v1/languages/52/',
    'specialchars' => '',
    'translation_projects' => [
      '/api/v1/translation-projects/343/'
    ]
  },
  {
    'code' => 'wo',
    'description' => '',
    'fullname' => 'Wolof',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/8/',
    'specialchars' => '',
    'translation_projects' => []
  },
  {
    'code' => 'zh_CN',
    'description' => '',
    'fullname' => 'Chinese (China)',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/9/',
    'specialchars' => "\x{2190}\x{2192}\x{2194}\x{d7}\x{f7}\x{a9}\x{2026}\x{2014}\x{2018}\x{2019}\x{201c}\x{201d}\x{3010}\x{3011}\x{300a}\x{300b}",
    'translation_projects' => [
      '/api/v1/translation-projects/67/',
      '/api/v1/translation-projects/120/',
      '/api/v1/translation-projects/138/',
      '/api/v1/translation-projects/184/',
      '/api/v1/translation-projects/233/',
      '/api/v1/translation-projects/344/',
      '/api/v1/translation-projects/585/',
      '/api/v1/translation-projects/576/',
      '/api/v1/translation-projects/672/',
      '/api/v1/translation-projects/761/',
      '/api/v1/translation-projects/828/',
      '/api/v1/translation-projects/966/',
      '/api/v1/translation-projects/1066/',
      '/api/v1/translation-projects/1162/',
      '/api/v1/translation-projects/1244/'
    ]
  },
  {
    'code' => 'zh_HK',
    'description' => '',
    'fullname' => 'Chinese (Hong Kong)',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/10/',
    'specialchars' => "\x{2190}\x{2192}\x{2194}\x{d7}\x{f7}\x{a9}\x{2026}\x{2014}\x{2018}\x{2019}\x{201c}\x{201d}\x{300c}\x{300d}\x{300e}\x{300f}\x{3010}\x{3011}\x{300a}\x{300b}",
    'translation_projects' => [
      '/api/v1/translation-projects/345/'
    ]
  },
  {
    'code' => 'zh_TW',
    'description' => '',
    'fullname' => 'Chinese (Taiwan)',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/11/',
    'specialchars' => "\x{2190}\x{2192}\x{2194}\x{d7}\x{f7}\x{a9}\x{2026}\x{2014}\x{2018}\x{2019}\x{201c}\x{201d}\x{300c}\x{300d}\x{300e}\x{300f}\x{3010}\x{3011}\x{300a}\x{300b}",
    'translation_projects' => [
      '/api/v1/translation-projects/68/',
      '/api/v1/translation-projects/122/',
      '/api/v1/translation-projects/139/',
      '/api/v1/translation-projects/185/',
      '/api/v1/translation-projects/232/',
      '/api/v1/translation-projects/346/',
      '/api/v1/translation-projects/451/',
      '/api/v1/translation-projects/587/',
      '/api/v1/translation-projects/577/',
      '/api/v1/translation-projects/673/',
      '/api/v1/translation-projects/762/',
      '/api/v1/translation-projects/823/',
      '/api/v1/translation-projects/967/',
      '/api/v1/translation-projects/1067/',
      '/api/v1/translation-projects/1163/',
      '/api/v1/translation-projects/1245/',
      '/api/v1/translation-projects/1254/',
      '/api/v1/translation-projects/1266/'
    ]
  },
  {
    'code' => 'zh-Hans-TW',
    'description' => '',
    'fullname' => 'Chinese (Taiwan)',
    'nplurals' => 1,
    'pluralequation' => '0',
    'resource_uri' => '/api/v1/languages/146/',
    'specialchars' => "\x{2190}\x{2192}\x{2194}\x{d7}\x{f7}\x{a9}\x{2026}\x{2014}\x{2018}\x{2019}\x{201c}\x{201d}\x{300c}\x{300d}\x{300e}\x{300f}\x{3010}\x{3011}\x{300a}\x{300b}",
    'translation_projects' => [
      '/api/v1/translation-projects/798/',
      '/api/v1/translation-projects/812/',
      '/api/v1/translation-projects/977/',
      '/api/v1/translation-projects/985/',
      '/api/v1/translation-projects/1076/'
    ]
  },
  {
    'code' => 'zu',
    'description' => '',
    'fullname' => 'Zulu',
    'nplurals' => 2,
    'pluralequation' => '(n != 1)',
    'resource_uri' => '/api/v1/languages/93/',
    'specialchars' => '',
    'translation_projects' => []
  }
];

1;
