#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::ExpressItemSortCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ExpressItemSortCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::ExpressItemSortCodeType

=head1 DESCRIPTION

Sorts the items in the ItemArray.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 LowestTotalCost

(in) Sort the items by the lowest total cost, including shipping.
The item with the lowest total cost is returned first.
To calculate the total cost, PostalCode must also be specified in the request.



=cut


use constant LowestTotalCost => scalar('LowestTotalCost');


=head2 HighestTotalCost

(in) Sort the items by the highest total cost, including shipping.
The item with the highest total cost is returned first.
To calculate the total cost, PostalCode must also be specified in the request.



=cut


use constant HighestTotalCost => scalar('HighestTotalCost');


=head2 Relevance

(in) Sort the items by relevance. This is the default.
The item with the highest relevance is returned first.
The relevance is determined by various factors, such as matching item details
and historical buyer behavior.



=cut


use constant Relevance => scalar('Relevance');


=head2 CustomCode

(out) Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
