#!/usr/bin/perl

package eBay::API::XML::Call::SetUserNotes;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetUserNotes.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetUserNotes

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetUserNotes inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::SetUserNotes::SetUserNotesRequestType;
use eBay::API::XML::Call::SetUserNotes::SetUserNotesResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'SetUserNotes';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetUserNotes::SetUserNotesRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetUserNotes::SetUserNotesResponseType';
}

#
# input properties
#

=head2 setAction()

Specifies whether to add/update the note or delete.

  RequiredInput: Yes
#    Argument: 'ns:SetUserNotesActionCodeType'

=cut
       
sub setAction {
   my $self   = shift;
   my $sAction = shift;
   $self->getRequestDataType()->setAction($sAction);
}

=head2 setItemID()

ID of the item to which the My eBay note will be
attached. Notes can only be added to items that are
currently being tracked in My eBay.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setNoteText()

Text of the note. Maximum 250 characters. Required only
if the Action is AddOrUpdate. This note text will
completely replace any existing My eBay note for the
specified item.

MaxLength: 250

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setNoteText {
   my $self   = shift;
   my $sNoteText = shift;
   $self->getRequestDataType()->setNoteText($sNoteText);
}

=head2 setTransactionID()

ID of the transaction to which the My eBay note will be
attached. Notes can only be added to transactions that are
currently being tracked in My eBay.
You can see it in the Won list of GetMyeBayBuying if you are the buyer.
You can see it from Sold list of GetMyeBaySelling if you are the seller.

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setTransactionID {
   my $self   = shift;
   my $sTransactionID = shift;
   $self->getRequestDataType()->setTransactionID($sTransactionID);
}



#
# output properties
#





1;   
