/*
**  mod_twepl.c -- Apache sample twepl module
**  [Autogenerated via ``apxs -n twepl -g'']
**
**  To play with this sample module first compile it into a
**  DSO file and install it into Apache's modules directory
**  by running:
**
**    $ apxs -c -i mod_twepl.c
**
**  Then activate it in Apache's httpd.conf file for instance
**  for the URL /twepl in as follows:
**
**    #   httpd.conf
**    LoadModule twepl_module modules/mod_twepl.so
**    <Location /twepl>
**    SetHandler twepl
**    </Location>
**
**  Then after restarting Apache via
**
**    $ apachectl restart
**
**  you immediately can request the URL /twepl and watch for the
**  output of this module. This can be achieved for instance via:
**
**    $ lynx -mime_header http://localhost/twepl
**
**  The output should be similar to the following one:
**
**    HTTP/1.1 200 OK
**    Date: Tue, 31 Mar 1998 14:42:22 GMT
**    Server: Apache/1.3.4 (Unix)
**    Connection: close
**    Content-Type: text/html
**
**    The sample page from mod_twepl.c
*/

#include "mod_twepl.h"

/* Another Sources */
#include "twepl_xcore.c"

static const char *twepl_set_option(cmd_parms *cmd, void *_conf, const char *value){
  TWEPL_CONFIG *conf;
  conf = (TWEPL_CONFIG *)_conf;
  conf->TWEPL_OPTIONS = (unsigned char *)apr_pstrdup(cmd->pool,value);
  NULL;
}

static const command_rec twepl_config_options[] ={
  AP_INIT_TAKE1("TWEPL_OPTIONS",
               twepl_set_option,
               NULL,
               (EXEC_ON_READ | RSRC_CONF | ACCESS_CONF | OR_OPTIONS),
               "module options(see &quot;man 1 twepl&quot): [ccdDsSxX]{1,4}"
               ),
  {NULL}
};

static void *twepl_create_dir_config(apr_pool_t *p,char *dir){
  TWEPL_CONFIG *conf = (TWEPL_CONFIG *)apr_palloc(p,sizeof(TWEPL_CONFIG));
  conf->TWEPL_OPTIONS = NULL;
  conf->TWEPL_RDFLINE = 0;
  return (void *)conf;
}

static void *twepl_create_svr_config(apr_pool_t *p,server_rec *s){
  TWEPL_CONFIG *conf = (TWEPL_CONFIG *)apr_palloc(p,sizeof(TWEPL_CONFIG));
  conf->TWEPL_OPTIONS = NULL;
  conf->TWEPL_RDFLINE = 0;
  return (void *)conf;
}

/* The sample content handler */
static int twepl_handler(request_rec *r)
{
        TWEPL_CONFIG  *conf;
                char  *twepl_option;

                char **twepl_envp;
                char  *twepl_args[] = { "mod_" EPL_XS_NAME "\0", r->filename, NULL };
                char **twepl_argv = (char **)twepl_args;
                 int   twepl_argc = 2;

          apr_proc_t   twepl_proc;
                 int   twepl_stat;
                 int   twepl_apst;
                 int   twepl_awst;
                 int   twepl_pret;
                 int   twepl_pwhy;

  apr_bucket_brigade  *obr;
          apr_bucket  *obk;

  if(strcmp(r->handler, "twepl-script") != 0) {
    return DECLINED;
  }
  ap_set_content_type(r, "text/html");

  conf = (TWEPL_CONFIG *)ap_get_module_config(r->server->module_config, &twepl_module);
  twepl_option = conf->TWEPL_OPTIONS;

  ap_add_common_vars(r);
  ap_add_cgi_vars(r);

  apr_table_set(r->subprocess_env, "PERL_SELF", apr_table_get(r->subprocess_env, "SCRIPT_NAME"));

  apr_table_set(r->headers_out, EPL_POW_KEY, EPL_POW_VAL);

  twepl_envp = ap_create_environment(r->pool, r->subprocess_env);

  switch(twepl_apst = apr_proc_fork(&twepl_proc , r->pool)){
    case APR_INCHILD:
      twepl_stat = twepl_script_handler(r, r->filename, twepl_argc, twepl_argv, twepl_envp);
      exit(twepl_stat);
    case APR_INPARENT:
      twepl_awst = apr_proc_wait(&twepl_proc, &twepl_pret, NULL, APR_WAIT);
      break;
    default:
      ap_log_rerror(APLOG_MARK, APLOG_ERR, twepl_apst, r, "%s: apr_proc_fork() failed.", EPL_XS_NAME "\0");
      return HTTP_INTERNAL_SERVER_ERROR;
  }

  /*  Apple  */
  if(r->chunked){
    obr = apr_brigade_create(r->pool, r->output_filters->c->bucket_alloc);
    obk = apr_bucket_immortal_create(ASCII_CRLF, 2, r->output_filters->c->bucket_alloc);
    APR_BRIGADE_INSERT_TAIL(obr, obk);
  }

  return twepl_stat;

}

static int twepl_first(apr_pool_t *pconf, apr_pool_t *plog, apr_pool_t *ptemp, server_rec *s){
  ap_add_version_component(pconf, " mod_twepl/" EPL_VERSION "\0");
  return OK;
}

static void twepl_register_hooks(apr_pool_t *p){
  ap_hook_handler(twepl_handler, NULL, NULL, APR_HOOK_MIDDLE);
  ap_hook_post_config(twepl_first, NULL,NULL, APR_HOOK_LAST);
}

/* Dispatch list for API hooks */
module AP_MODULE_DECLARE_DATA twepl_module = {
  STANDARD20_MODULE_STUFF,
  twepl_create_dir_config, /* create per-dir    config structures */
  NULL,                    /* merge  per-dir    config structures */
  twepl_create_svr_config, /* create per-server config structures */
  NULL,                    /* merge  per-server config structures */
  twepl_config_options,    /* table of config file commands       */
  twepl_register_hooks     /* register hooks                      */
};
